/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.db.components;

import com.compomics.util.db.DBMetaData;
import org.apache.log4j.Logger;

public class InstanceVariables {
    Logger logger = Logger.getLogger(InstanceVariables.class);
    private String[] iVars = null;

    public InstanceVariables(DBMetaData aMeta) {
        this.generateVars(aMeta);
    }

    private void generateVars(DBMetaData aMeta) {
        int lCount = aMeta.getColumnCount();
        this.iVars = new String[lCount * 2];
        for (int i = 0; i < lCount; ++i) {
            String type = aMeta.getConvertedColumnType(i);
            String name = aMeta.getColumnName(i);
            name = name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
            this.iVars[i + lCount] = "\t/**\n\t * This variable represents the key for the '" + aMeta.getColumnName(i) + "' column.\n\t */\n\tpublic static final String " + (Character.isDigit(name.charAt(0)) ? "i" + name.toUpperCase() : name.toUpperCase()) + " = \"" + name.toUpperCase() + "\";";
            StringBuffer lsb = new StringBuffer("\t/**\n\t * This variable represents the contents for the '" + aMeta.getColumnName(i) + "' column.\n\t */\n\tprotected " + type + " i" + name + " = ");
            if (Character.isUpperCase(type.charAt(0)) || type.endsWith("[]") || type.indexOf(".") >= 0) {
                lsb.append("null;\n");
            } else if (type.equals("int")) {
                lsb.append("Integer.MIN_VALUE;\n");
            } else if (type.equals("long")) {
                lsb.append("Long.MIN_VALUE;\n");
            } else if (type.equals("double")) {
                lsb.append("Double.MIN_VALUE;\n");
            } else if (type.equals("char")) {
                lsb.append("Character.MIN_VALUE;\n");
            } else if (type.equals("boolean")) {
                lsb.append("false;\n");
            }
            this.iVars[i] = lsb.toString();
        }
    }

    public String toString() {
        StringBuffer lsb = new StringBuffer("\n\t/**\n\t * This variable tracks changes to the object.\n\t */\n\tprotected boolean iUpdated = false;\n\n");
        lsb.append("\t/**\n\t * This variable can hold generated primary key columns.\n\t */\n\tprotected Object[] iKeys = null;\n\n");
        for (int i = 0; i < this.iVars.length; ++i) {
            lsb.append(this.iVars[i] + "\n\n");
        }
        return lsb.toString() + "\n";
    }
}

