/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.atoms.Carbon;
import com.compomics.util.experiment.biology.atoms.Fluorine;
import com.compomics.util.experiment.biology.atoms.Helium;
import com.compomics.util.experiment.biology.atoms.Hydrogen;
import com.compomics.util.experiment.biology.atoms.Iodine;
import com.compomics.util.experiment.biology.atoms.Lithium;
import com.compomics.util.experiment.biology.atoms.Nitrogen;
import com.compomics.util.experiment.biology.atoms.Oxygen;
import com.compomics.util.experiment.biology.atoms.Phosphorus;
import com.compomics.util.experiment.biology.atoms.Selenium;
import com.compomics.util.experiment.biology.atoms.Sodium;
import com.compomics.util.experiment.biology.atoms.Sulfur;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class Atom
extends ExperimentObject {
    static final long serialVersionUID = 1059024301538472131L;
    public static final Atom H = new Hydrogen();
    public static final Atom N = new Nitrogen();
    public static final Atom O = new Oxygen();
    public static final Atom C = new Carbon();
    public static final Atom S = new Sulfur();
    public static final Atom P = new Phosphorus();
    public static final Atom He = new Helium();
    public static final Atom Li = new Lithium();
    public static final Atom Na = new Sodium();
    public static final Atom Se = new Selenium();
    public static final Atom I = new Iodine();
    public static final Atom F = new Fluorine();
    protected Double monoisotopicMass;
    protected HashMap<Integer, Double> isotopeMap;
    protected HashMap<Integer, Double> representativeComposition;
    protected String name;
    protected String letter;

    public static String[] getImplementedAtoms(boolean includeSelect) {
        if (includeSelect) {
            return new String[]{"- Select -", "C", "H", "I", "N", "O", "S", "P", "He", "Li", "Na", "Se", "F"};
        }
        return new String[]{"C", "H", "I", "N", "O", "S", "P", "He", "Li", "Na", "Se", "F"};
    }

    public static Atom getAtom(String shortName) {
        if (shortName.equals("H")) {
            return H;
        }
        if (shortName.equals("I")) {
            return I;
        }
        if (shortName.equals("N")) {
            return N;
        }
        if (shortName.equals("O")) {
            return O;
        }
        if (shortName.equals("C")) {
            return C;
        }
        if (shortName.equals("S")) {
            return S;
        }
        if (shortName.equals("P")) {
            return P;
        }
        if (shortName.equals("He")) {
            return He;
        }
        if (shortName.equals("Li")) {
            return Li;
        }
        if (shortName.equals("Na")) {
            return Na;
        }
        if (shortName.equals("Se")) {
            return Se;
        }
        if (shortName.equals("F")) {
            return F;
        }
        throw new UnsupportedOperationException("Atom " + shortName + " not implemented.");
    }

    public Double getMonoisotopicMass() {
        return this.monoisotopicMass;
    }

    public String getName() {
        return this.name;
    }

    public String getLetter() {
        return this.letter;
    }

    public ArrayList<Integer> getImplementedIsotopes() {
        if (this.isotopeMap != null) {
            return new ArrayList<Integer>(this.isotopeMap.keySet());
        }
        return new ArrayList<Integer>();
    }

    public Double getIsotopeMass(int isotopeNumber) {
        if (this.isotopeMap != null) {
            return this.isotopeMap.get(isotopeNumber);
        }
        return null;
    }

    public Double getDifferenceToMonoisotopic(int isotopeNumber) {
        Double isotopeMass = null;
        if (this.isotopeMap != null) {
            isotopeMass = this.isotopeMap.get(isotopeNumber);
        }
        if (isotopeMass == null) {
            throw new IllegalArgumentException("No isotope mass found for isotope " + isotopeNumber + " of atom " + this.name + ".");
        }
        return isotopeMass - this.getMonoisotopicMass();
    }

    public String toString() {
        return this.getLetter();
    }
}

