/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.AtomChain;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.ions.ReporterIon;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import com.compomics.util.pride.CvTerm;
import java.util.ArrayList;

public class PTM
extends ExperimentObject {
    static final long serialVersionUID = -545472596243822505L;
    public static final int MODAA = 0;
    public static final int MODN = 1;
    public static final int MODNAA = 2;
    public static final int MODC = 3;
    public static final int MODCAA = 4;
    public static final int MODNP = 5;
    public static final int MODNPAA = 6;
    public static final int MODCP = 7;
    public static final int MODCPAA = 8;
    public static final int MODMAX = 9;
    private int type;
    private String name;
    private String shortName;
    private Double mass = null;
    private String massAsString = null;
    private ArrayList<NeutralLoss> neutralLosses = new ArrayList(0);
    private ArrayList<ReporterIon> reporterIons = new ArrayList(0);
    private AminoAcidPattern pattern = new AminoAcidPattern();
    private AtomChain atomChainAdded = new AtomChain();
    private AtomChain atomChainRemoved = new AtomChain();
    private CvTerm cvTerm = null;
    private static final int NUMBER_OF_ROUNDED_DECIMALS = 6;

    public PTM() {
    }

    public PTM(int type, String name, String shortName, AtomChain atomChainAdded, AtomChain atomChainRemoved, AminoAcidPattern aminoAcidPattern) {
        this.type = type;
        this.name = name;
        this.shortName = shortName;
        this.atomChainAdded = atomChainAdded;
        this.atomChainRemoved = atomChainRemoved;
        this.pattern = aminoAcidPattern;
        this.cvTerm = null;
    }

    public PTM(int type, String name, String shortName, AtomChain atomChainAdded, AtomChain atomChainRemoved, AminoAcidPattern aminoAcidPattern, CvTerm cvTerm) {
        this.type = type;
        this.name = name;
        this.shortName = shortName;
        this.atomChainAdded = atomChainAdded;
        this.atomChainRemoved = atomChainRemoved;
        this.pattern = aminoAcidPattern;
        this.cvTerm = cvTerm;
    }

    public PTM(int type, String name, Double mass, ArrayList<String> residues) {
        this.type = type;
        this.name = name;
        this.mass = mass;
        if (residues != null) {
            this.pattern = new AminoAcidPattern(residues);
        }
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public double getMass() {
        if (this.mass == null) {
            this.estimateMass();
        }
        return this.mass;
    }

    private synchronized void estimateMass() {
        if (this.mass == null) {
            Double tempMass = 0.0;
            if (this.atomChainAdded != null) {
                tempMass = tempMass + this.atomChainAdded.getMass();
            }
            if (this.atomChainRemoved != null) {
                tempMass = tempMass - this.atomChainRemoved.getMass();
            }
            this.mass = tempMass;
        }
    }

    public double getRoundedMass(int numberOfDecimals) {
        double roundedMass = this.getMass();
        return Util.roundDouble(roundedMass, numberOfDecimals);
    }

    public double getRoundedMass() {
        return this.getRoundedMass(6);
    }

    public AtomChain getAtomChainAdded() {
        return this.atomChainAdded;
    }

    public void setAtomChainAdded(AtomChain atomChainAdded) {
        this.atomChainAdded = atomChainAdded;
        this.mass = null;
        this.massAsString = null;
    }

    public AtomChain getAtomChainRemoved() {
        return this.atomChainRemoved;
    }

    public void setAtomChainRemoved(AtomChain atomChainRemoved) {
        this.atomChainRemoved = atomChainRemoved;
        this.mass = null;
        this.massAsString = null;
    }

    public boolean isSameAtomicComposition(PTM anotherPTM) {
        if (this.atomChainAdded != null && !this.atomChainAdded.isSameCompositionAs(anotherPTM.getAtomChainAdded()) || this.atomChainRemoved != null && !this.atomChainRemoved.isSameCompositionAs(anotherPTM.getAtomChainRemoved())) {
            return false;
        }
        return (this.atomChainAdded != null || anotherPTM.getAtomChainAdded() == null || anotherPTM.getAtomChainAdded().getAtomChain().isEmpty()) && (this.atomChainRemoved != null || anotherPTM.getAtomChainRemoved() == null || anotherPTM.getAtomChainRemoved().getAtomChain().isEmpty());
    }

    public boolean isSamePattern(PTM anotherPTM) {
        if (this.pattern != null && this.pattern.length() == 0 && anotherPTM.getPattern() == null) {
            return true;
        }
        if (this.pattern == null && anotherPTM.getPattern() != null && anotherPTM.getPattern().length() > 0) {
            return false;
        }
        return this.pattern == null || this.pattern.isSameAs(anotherPTM.getPattern(), SequenceMatchingPreferences.defaultStringMatching);
    }

    public boolean isSameAs(PTM anotherPTM) {
        if (this.type != anotherPTM.getType()) {
            return false;
        }
        if (!this.isSamePattern(anotherPTM)) {
            return false;
        }
        return this.isSameAtomicComposition(anotherPTM);
    }

    public ArrayList<NeutralLoss> getNeutralLosses() {
        return this.neutralLosses;
    }

    public void setNeutralLosses(ArrayList<NeutralLoss> neutralLosses) {
        this.neutralLosses = neutralLosses;
    }

    public void addNeutralLoss(NeutralLoss neutralLoss) {
        this.neutralLosses.add(neutralLoss);
    }

    public ArrayList<ReporterIon> getReporterIons() {
        return this.reporterIons;
    }

    public void setReporterIons(ArrayList<ReporterIon> reporterIons) {
        this.reporterIons = reporterIons;
    }

    public void addReporterIon(ReporterIon reporterIon) {
        this.reporterIons.add(reporterIon);
    }

    public AminoAcidPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(AminoAcidPattern pattern) {
        this.pattern = pattern;
    }

    public boolean isStandardSearch() {
        return this.pattern == null || this.pattern.length() == 1;
    }

    public boolean isNTerm() {
        return this.type == 1 || this.type == 2 || this.type == 5 || this.type == 6;
    }

    public boolean isCTerm() {
        return this.type == 3 || this.type == 4 || this.type == 7 || this.type == 8;
    }

    public String getHtmlTooltip() {
        String tooltip = "<html>";
        tooltip = tooltip + "Name: " + this.name + "<br>";
        tooltip = tooltip + "Mass: " + this.getRoundedMass(4) + "<br>";
        tooltip = tooltip + "Type: ";
        switch (this.type) {
            case 0: {
                tooltip = tooltip + "Particular amino acid(s)";
                break;
            }
            case 1: 
            case 2: {
                tooltip = tooltip + "Protein N terminus";
                break;
            }
            case 3: 
            case 4: {
                tooltip = tooltip + "Protein C terminus";
                break;
            }
            case 5: 
            case 6: {
                tooltip = tooltip + "Peptide N terminus";
                break;
            }
            case 7: 
            case 8: {
                tooltip = tooltip + "Peptide C terminus";
                break;
            }
        }
        tooltip = tooltip + "<br>";
        tooltip = tooltip + "Target: ";
        if (this.pattern != null && !this.pattern.getAminoAcidsAtTarget().isEmpty()) {
            String patternAsString = this.pattern.toString();
            tooltip = tooltip + patternAsString;
        } else {
            tooltip = tooltip + "All";
        }
        tooltip = tooltip + "</html>";
        return tooltip;
    }

    public CvTerm getCvTerm() {
        return this.cvTerm;
    }

    public void setCvTerm(CvTerm cvTerm) {
        this.cvTerm = cvTerm;
    }

    public String getMassAsString() {
        if (this.massAsString == null) {
            this.massAsString = "" + this.getMass();
        }
        return this.massAsString;
    }

    public String toString() {
        double ptmMass;
        String target = "";
        switch (this.getType()) {
            case 0: {
                target = this.getPattern().toString();
                break;
            }
            case 3: {
                target = "Protein C-terminus";
                break;
            }
            case 4: {
                target = "Protein C-terminus ending with " + this.getPattern().toString();
                break;
            }
            case 7: {
                target = "Peptide C-terminus";
                break;
            }
            case 8: {
                target = "Peptide C-terminus ending with " + this.getPattern().toString();
                break;
            }
            case 1: {
                target = "Protein N-terminus";
                break;
            }
            case 2: {
                target = "Protein N-terminus starting with " + this.getPattern().toString();
                break;
            }
            case 5: {
                target = "Peptide N-terminus";
                break;
            }
            case 6: {
                target = "Peptide N-terminus starting with " + this.getPattern().toString();
            }
        }
        StringBuilder description = new StringBuilder();
        description.append(this.name);
        if (this.shortName != null && !this.shortName.equals("")) {
            description.append("(").append(this.shortName).append(")");
        }
        description.append("\t");
        if (this.atomChainAdded != null) {
            description.append("+{").append(this.atomChainAdded).append("}");
        }
        if (this.atomChainRemoved != null) {
            description.append("-{").append(this.atomChainRemoved).append("}");
        }
        String sign = (ptmMass = this.getRoundedMass()) > 0.0 ? "+" : "-";
        description.append(" (").append(sign).append(ptmMass).append(")");
        description.append(" targeting ").append(target);
        return description.toString();
    }
}

