/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.taxonomy;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.taxonomy.mappings.BiomartMapping;
import com.compomics.util.experiment.biology.taxonomy.mappings.EnsemblGenomesSpecies;
import com.compomics.util.experiment.biology.taxonomy.mappings.EnsemblSpecies;
import com.compomics.util.experiment.biology.taxonomy.mappings.UniprotTaxonomy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

public class SpeciesFactory {
    private static SpeciesFactory instance = null;
    public static final String UNKNOWN = "Unknown";
    private static final String TOOL_SPECIES_MAPPING_SUBFOLDER = "resources/conf/taxonomy/";
    public static final String UNIPROT_TAXONOMY_FILENAME = "uniprot_taxonomy";
    public static final String ENSEMBL_SPECIES = "ensembl_species";
    public static final String ENSEMBL_GENOME_SPECIES = "ensembl-genome_species";
    public static final String BIOMART_ENSEMBL_FILENAME = "ensembl_biomart";
    public static final String BIOMART_ENSEMBL_GENOME_FILENAME = "ensembl-genome_biomart";
    private EnsemblSpecies ensemblSpecies;
    private EnsemblGenomesSpecies ensemblGenomesSpecies;
    private UniprotTaxonomy uniprotTaxonomy;
    private BiomartMapping biomartMapping;

    public static SpeciesFactory getInstance() {
        if (instance == null) {
            instance = new SpeciesFactory();
        }
        return instance;
    }

    private SpeciesFactory() {
    }

    public void initiate(String jarFilePath) throws IOException {
        this.ensemblSpecies = new EnsemblSpecies();
        this.ensemblSpecies.loadMapping(SpeciesFactory.getEnsemblSpeciesFile(jarFilePath));
        this.ensemblGenomesSpecies = new EnsemblGenomesSpecies();
        this.ensemblGenomesSpecies.loadMapping(SpeciesFactory.getEnsemblGenomesSpeciesFile(jarFilePath));
        this.uniprotTaxonomy = new UniprotTaxonomy();
        this.uniprotTaxonomy.loadMapping(SpeciesFactory.getUniprotTaxonomyFile(jarFilePath));
        this.biomartMapping = new BiomartMapping();
        this.biomartMapping.loadMapping(SpeciesFactory.getBiomartEnsemblMappingFile(jarFilePath), SpeciesFactory.getBiomartEnsemblGenomeMappingFile(jarFilePath));
    }

    public static String getSpeciesDescription(HashMap<String, Integer> speciesOccurrence) {
        HashMap<Integer, ArrayList<String>> occurrenceToSpecies = new HashMap<Integer, ArrayList<String>>(speciesOccurrence.size());
        double total = 0.0;
        for (String taxonomy : speciesOccurrence.keySet()) {
            Integer occurrence = speciesOccurrence.get(taxonomy);
            total += (double)occurrence.intValue();
            ArrayList<String> species = (ArrayList<String>)occurrenceToSpecies.get(occurrence);
            if (species == null) {
                species = new ArrayList<String>(1);
                occurrenceToSpecies.put(occurrence, species);
            }
            species.add(taxonomy);
        }
        StringBuilder description = new StringBuilder();
        ArrayList occurrences = new ArrayList(occurrenceToSpecies.keySet());
        Collections.sort(occurrences, Collections.reverseOrder());
        for (Integer occurrence : occurrences) {
            ArrayList species = (ArrayList)occurrenceToSpecies.get(occurrence);
            Collections.sort(species);
            for (String taxonomy : species) {
                String occurrencePercentage;
                double percentage = 100.0 * (double)occurrence.intValue() / total;
                if (description.length() > 0) {
                    description.append(", ");
                }
                description.append(taxonomy);
                if (speciesOccurrence.size() <= 1) continue;
                if (percentage > 99.9) {
                    occurrencePercentage = ">99.9";
                } else if (percentage < 0.1) {
                    occurrencePercentage = "<0.1";
                } else {
                    double roundedDouble = Util.roundDouble(percentage, 1);
                    occurrencePercentage = roundedDouble + "";
                }
                description.append(" (").append(occurrence).append(", ").append(occurrencePercentage).append("%)");
            }
        }
        return description.toString();
    }

    public static File getEnsemblSpeciesFile(String jarFilePath) {
        return new File(jarFilePath, "resources/conf/taxonomy/ensembl_species");
    }

    public static File getEnsemblGenomesSpeciesFile(String jarFilePath) {
        return new File(jarFilePath, "resources/conf/taxonomy/ensembl-genome_species");
    }

    public static File getUniprotTaxonomyFile(String jarFilePath) {
        return new File(jarFilePath, "resources/conf/taxonomy/uniprot_taxonomy");
    }

    public static File getBiomartEnsemblMappingFile(String jarFilePath) {
        return new File(jarFilePath, "resources/conf/taxonomy/ensembl_biomart");
    }

    public static File getBiomartEnsemblGenomeMappingFile(String jarFilePath) {
        return new File(jarFilePath, "resources/conf/taxonomy/ensembl-genome_biomart");
    }

    public String getLatinName(Integer taxon) {
        return this.uniprotTaxonomy.getLatinName(taxon);
    }

    public String getName(Integer taxon) {
        EnsemblGenomesSpecies.EnsemblGenomeDivision division;
        if (this.uniprotTaxonomy == null || this.uniprotTaxonomy.getLatinName(taxon) == null) {
            return null;
        }
        boolean plant = false;
        if (this.ensemblGenomesSpecies != null && (division = this.ensemblGenomesSpecies.getDivision(taxon)) != null && division == EnsemblGenomesSpecies.EnsemblGenomeDivision.plants) {
            plant = true;
        }
        String latinName = this.uniprotTaxonomy.getLatinName(taxon);
        String commonName = this.uniprotTaxonomy.getCommonName(taxon);
        StringBuilder name = new StringBuilder();
        if (plant) {
            name.append(latinName);
            if (commonName != null) {
                name.append(" (").append(commonName).append(")");
            }
        } else {
            if (commonName != null) {
                name.append(commonName).append(" (");
            }
            name.append(latinName);
            if (commonName != null) {
                name.append(")");
            }
        }
        return name.toString();
    }

    public String getEnsemblAssembly(Integer taxon) {
        EnsemblGenomesSpecies.EnsemblGenomeDivision ensemblGenomeDivision = this.ensemblGenomesSpecies.getDivision(taxon);
        if (ensemblGenomeDivision == null) {
            return this.ensemblSpecies.getAssembly(taxon);
        }
        return this.ensemblGenomesSpecies.getAssembly(taxon);
    }

    public String getEnsemblDataset(Integer taxon) {
        String assembly = this.getEnsemblAssembly(taxon);
        if (assembly == null) {
            return null;
        }
        return this.biomartMapping.getDataset(assembly);
    }

    public EnsemblSpecies getEnsemblSpecies() {
        return this.ensemblSpecies;
    }

    public EnsemblGenomesSpecies getEnsemblGenomesSpecies() {
        return this.ensemblGenomesSpecies;
    }

    public UniprotTaxonomy getUniprotTaxonomy() {
        return this.uniprotTaxonomy;
    }

    public BiomartMapping getBiomartMapping() {
        return this.biomartMapping;
    }

    public HashMap<String, HashSet<Integer>> getEnsembleSpecies() {
        HashMap<String, HashSet<Integer>> speciesMap = new HashMap<String, HashSet<Integer>>(EnsemblGenomesSpecies.EnsemblGenomeDivision.values().length + 1);
        for (Integer taxon : this.ensemblGenomesSpecies.getTaxons()) {
            String divisionName = this.ensemblGenomesSpecies.getDivision((Integer)taxon).ensemblType;
            HashSet<Integer> taxons = speciesMap.get(divisionName);
            if (taxons == null) {
                taxons = new HashSet();
                speciesMap.put(divisionName, taxons);
            }
            taxons.add(taxon);
        }
        speciesMap.put("vertebrates", this.ensemblSpecies.getTaxons());
        return speciesMap;
    }
}

