/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.amino_acid_tags;

import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.AminoAcidSequence;
import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.biology.MassGap;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.amino_acid_tags.TagComponent;
import com.compomics.util.experiment.identification.identification_parameters.PtmSettings;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import no.uib.jsparklines.renderers.util.Util;

public class Tag
extends ExperimentObject {
    static final long serialVersionUID = 1625541843008045218L;
    private ArrayList<TagComponent> content = new ArrayList();

    public Tag() {
    }

    public Tag(Tag tag) {
        for (TagComponent tagComponent : tag.getContent()) {
            if (tagComponent instanceof MassGap) {
                MassGap massGap = (MassGap)tagComponent;
                this.addMassGap(massGap.getMass());
                continue;
            }
            if (tagComponent instanceof AminoAcidPattern) {
                AminoAcidPattern aminoAcidPattern = new AminoAcidPattern((AminoAcidPattern)tagComponent);
                this.addAminoAcidPattern(aminoAcidPattern);
                continue;
            }
            if (tagComponent instanceof AminoAcidSequence) {
                AminoAcidSequence aminoAcidSequence = new AminoAcidSequence((AminoAcidSequence)tagComponent);
                this.addAminoAcidSequence(aminoAcidSequence);
                continue;
            }
            throw new UnsupportedOperationException("Tag constructor not implemeted for tag component " + tagComponent.getClass() + ".");
        }
    }

    public Tag(double nTermGap, AminoAcidPattern sequenceTag, double cTermGap) {
        this.addMassGap(nTermGap);
        this.addAminoAcidPattern(sequenceTag);
        this.addMassGap(cTermGap);
    }

    public Tag(double nTermGap, AminoAcidSequence sequenceTag, double cTermGap) {
        this.addMassGap(nTermGap);
        this.addAminoAcidSequence(sequenceTag);
        this.addMassGap(cTermGap);
    }

    public ArrayList<TagComponent> getContent() {
        return this.content;
    }

    public void addMassGap(double massGap) {
        if (massGap != 0.0) {
            this.content.add(new MassGap(massGap));
        }
    }

    public void addAminoAcidPattern(AminoAcidPattern aminoAcidPattern) {
        if (aminoAcidPattern.length() > 0) {
            TagComponent lastComponent;
            if (!this.content.isEmpty() && (lastComponent = this.content.get(this.content.size() - 1)) instanceof AminoAcidPattern) {
                AminoAcidPattern pattern = (AminoAcidPattern)lastComponent;
                pattern.append(aminoAcidPattern);
                return;
            }
            this.content.add(aminoAcidPattern);
        }
    }

    public void addAminoAcidSequence(AminoAcidSequence aminoAcidSequence) {
        if (aminoAcidSequence.length() > 0) {
            TagComponent lastComponent;
            if (!this.content.isEmpty() && (lastComponent = this.content.get(this.content.size() - 1)) instanceof AminoAcidSequence) {
                AminoAcidSequence sequence = (AminoAcidSequence)lastComponent;
                sequence.appendCTerm(aminoAcidSequence);
                return;
            }
            this.content.add(aminoAcidSequence);
        }
    }

    public String asSequence() {
        StringBuilder result = new StringBuilder(this.content.size() * 4);
        for (TagComponent tagComponent : this.content) {
            result.append(tagComponent.asSequence());
        }
        return result.toString();
    }

    public String getLongestAminoAcidSequence() {
        String result = "";
        AminoAcidPattern lastAminoAcidPattern = null;
        AminoAcidSequence lastAminoAcidSequence = null;
        for (TagComponent tagComponent : this.content) {
            if (tagComponent instanceof MassGap) {
                if (lastAminoAcidPattern != null && lastAminoAcidPattern.length() > result.length()) {
                    result = lastAminoAcidPattern.asSequence();
                }
                lastAminoAcidPattern = null;
                if (lastAminoAcidSequence != null && lastAminoAcidSequence.length() > result.length()) {
                    result = lastAminoAcidSequence.asSequence();
                }
                lastAminoAcidSequence = null;
                continue;
            }
            if (tagComponent instanceof AminoAcidPattern) {
                AminoAcidPattern currentPattern = (AminoAcidPattern)tagComponent;
                if (lastAminoAcidPattern == null) {
                    if (lastAminoAcidSequence == null) {
                        lastAminoAcidPattern = currentPattern;
                        continue;
                    }
                    lastAminoAcidPattern = new AminoAcidPattern(lastAminoAcidSequence);
                    lastAminoAcidPattern.append(currentPattern);
                    lastAminoAcidSequence = null;
                    continue;
                }
                lastAminoAcidPattern.append(currentPattern);
                continue;
            }
            if (tagComponent instanceof AminoAcidSequence) {
                AminoAcidSequence currentSequence = (AminoAcidSequence)tagComponent;
                if (lastAminoAcidSequence == null) {
                    if (lastAminoAcidPattern == null) {
                        lastAminoAcidSequence = currentSequence;
                        continue;
                    }
                    lastAminoAcidPattern.append(new AminoAcidPattern(currentSequence));
                    continue;
                }
                lastAminoAcidSequence.appendCTerm(currentSequence);
                continue;
            }
            throw new UnsupportedOperationException("Longest amino acid sequence not implemented for tag component " + tagComponent.getClass() + ".");
        }
        if (lastAminoAcidPattern != null && lastAminoAcidPattern.length() > result.length()) {
            result = lastAminoAcidPattern.asSequence();
        }
        if (lastAminoAcidSequence != null && lastAminoAcidSequence.length() > result.length()) {
            result = lastAminoAcidSequence.asSequence();
        }
        return result;
    }

    public double getMass() {
        double mass = Atom.H.getMonoisotopicMass();
        for (TagComponent tagComponent : this.content) {
            mass += tagComponent.getMass().doubleValue();
        }
        return mass += Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass();
    }

    public double getMass(boolean includeCTermGap, boolean includeNTermGap) {
        double mass = this.getMass();
        if (!includeCTermGap) {
            mass -= this.getCTerminalGap();
        }
        if (!includeNTermGap) {
            mass -= this.getNTerminalGap();
        }
        return mass;
    }

    public double getNTerminalGap() {
        if (this.content.isEmpty()) {
            return 0.0;
        }
        TagComponent tagComponent = this.content.get(0);
        if (tagComponent instanceof MassGap) {
            return tagComponent.getMass();
        }
        return 0.0;
    }

    public double getCTerminalGap() {
        if (this.content.isEmpty()) {
            return 0.0;
        }
        TagComponent tagComponent = this.content.get(this.content.size() - 1);
        if (tagComponent instanceof MassGap) {
            return tagComponent.getMass();
        }
        return 0.0;
    }

    public String getTaggedModifiedSequence(PtmSettings modificationProfile, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName, boolean excludeAllFixedModifications, boolean includeTerminalGaps) {
        return Tag.getTaggedModifiedSequence(modificationProfile, this, useHtmlColorCoding, includeHtmlStartEndTags, useShortName, excludeAllFixedModifications, includeTerminalGaps);
    }

    public String getTaggedModifiedSequence(PtmSettings modificationProfile, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName, boolean includeTerminalGaps) {
        return Tag.getTaggedModifiedSequence(modificationProfile, this, useHtmlColorCoding, includeHtmlStartEndTags, useShortName, false, includeTerminalGaps);
    }

    public static String getTaggedModifiedSequence(PtmSettings modificationProfile, Tag tag, boolean useHtmlColorCoding, boolean includeHtmlStartEndTags, boolean useShortName, boolean excludeAllFixedPtms, boolean includeTerminalGaps) {
        String modifiedSequence = "";
        if (useHtmlColorCoding && includeHtmlStartEndTags) {
            modifiedSequence = modifiedSequence + "<html>";
        }
        modifiedSequence = modifiedSequence + tag.getNTerminal(includeTerminalGaps);
        for (int i = 0; i < tag.getContent().size(); ++i) {
            TagComponent tagComponent = tag.getContent().get(i);
            if (tagComponent instanceof AminoAcidPattern) {
                AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                modifiedSequence = modifiedSequence + aminoAcidPattern.getTaggedModifiedSequence(modificationProfile, useHtmlColorCoding, useShortName, excludeAllFixedPtms);
                continue;
            }
            if (tagComponent instanceof AminoAcidSequence) {
                AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
                modifiedSequence = modifiedSequence + aminoAcidSequence.getTaggedModifiedSequence(modificationProfile, useHtmlColorCoding, useShortName, excludeAllFixedPtms);
                continue;
            }
            if (tagComponent instanceof MassGap) {
                if (!includeTerminalGaps && (i <= 0 || i >= tag.getContent().size() - 1)) continue;
                modifiedSequence = modifiedSequence + tagComponent.asSequence();
                continue;
            }
            throw new UnsupportedOperationException("Tagged sequence not implemented for tag component " + tagComponent.getClass() + ".");
        }
        modifiedSequence = modifiedSequence + tag.getCTerminal(includeTerminalGaps);
        if (useHtmlColorCoding && includeHtmlStartEndTags) {
            modifiedSequence = modifiedSequence + "</html>";
        }
        return modifiedSequence;
    }

    public String getNTerminal(boolean includeTerminalGaps) {
        if (this.content.isEmpty()) {
            return "";
        }
        TagComponent firstComponent = this.content.get(0);
        if (firstComponent instanceof AminoAcidPattern) {
            AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)firstComponent;
            String nTerm = "NH2";
            PTMFactory ptmFactory = PTMFactory.getInstance();
            for (ModificationMatch modificationMatch : aminoAcidPattern.getModificationsAt(1)) {
                PTM ptm = ptmFactory.getPTM(modificationMatch.getTheoreticPtm());
                if (ptm.getType() == 0 || ptm.getType() == 9) continue;
                nTerm = ptm.getShortName();
            }
            nTerm = nTerm.replaceAll("-", " ");
            return nTerm + "-";
        }
        if (firstComponent instanceof AminoAcidSequence) {
            AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)firstComponent;
            String nTerm = "NH2";
            PTMFactory ptmFactory = PTMFactory.getInstance();
            for (ModificationMatch modificationMatch : aminoAcidSequence.getModificationsAt(1)) {
                PTM ptm = ptmFactory.getPTM(modificationMatch.getTheoreticPtm());
                if (ptm.getType() == 0 || ptm.getType() == 9) continue;
                nTerm = ptm.getShortName();
            }
            nTerm = nTerm.replaceAll("-", " ");
            return nTerm + "-";
        }
        if (firstComponent instanceof MassGap) {
            if (includeTerminalGaps) {
                return firstComponent.asSequence();
            }
            return Util.roundDouble((double)firstComponent.getMass(), (int)2) + "-";
        }
        throw new UnsupportedOperationException("N-terminal tag not implemented for tag component " + firstComponent.getClass() + ".");
    }

    public String getCTerminal(boolean includeTerminalGaps) {
        if (this.content.isEmpty()) {
            return "";
        }
        TagComponent lastComponent = this.content.get(this.content.size() - 1);
        if (lastComponent instanceof AminoAcidPattern) {
            AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)lastComponent;
            String cTerm = "COOH";
            PTMFactory ptmFactory = PTMFactory.getInstance();
            for (ModificationMatch modificationMatch : aminoAcidPattern.getModificationsAt(aminoAcidPattern.length())) {
                PTM ptm = ptmFactory.getPTM(modificationMatch.getTheoreticPtm());
                if (ptm.getType() == 0 || ptm.getType() == 9) continue;
                cTerm = ptm.getShortName();
            }
            cTerm = cTerm.replaceAll("-", " ");
            return "-" + cTerm;
        }
        if (lastComponent instanceof AminoAcidSequence) {
            AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)lastComponent;
            String cTerm = "COOH";
            PTMFactory ptmFactory = PTMFactory.getInstance();
            for (ModificationMatch modificationMatch : aminoAcidSequence.getModificationsAt(aminoAcidSequence.length())) {
                PTM ptm = ptmFactory.getPTM(modificationMatch.getTheoreticPtm());
                if (ptm.getType() == 0 || ptm.getType() == 9) continue;
                cTerm = ptm.getShortName();
            }
            cTerm = cTerm.replaceAll("-", " ");
            return "-" + cTerm;
        }
        if (lastComponent instanceof MassGap) {
            if (includeTerminalGaps) {
                return lastComponent.asSequence();
            }
            return "-" + Util.roundDouble((double)lastComponent.getMass(), (int)2);
        }
        throw new UnsupportedOperationException("C-terminal tag not implemented for tag component " + lastComponent.getClass() + ".");
    }

    public int getLengthInAminoAcid() {
        int length = 0;
        for (TagComponent tagComponent : this.content) {
            if (tagComponent instanceof AminoAcidPattern) {
                AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                length += aminoAcidPattern.length();
                continue;
            }
            if (tagComponent instanceof AminoAcidSequence) {
                AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
                length += aminoAcidSequence.length();
                continue;
            }
            if (tagComponent instanceof MassGap) {
                ++length;
                continue;
            }
            throw new UnsupportedOperationException("Tag length in amino acid not implemented for tag component " + tagComponent.getClass() + ".");
        }
        return length;
    }

    public ArrayList<Integer> getPotentialModificationSites(PTM ptm, SequenceMatchingPreferences ptmSequenceMatchingPreferences) throws IOException, IllegalArgumentException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        ArrayList<Integer> possibleSites = new ArrayList<Integer>();
        AminoAcidPattern ptmPattern = ptm.getPattern();
        int patternLength = ptmPattern.length();
        switch (ptm.getType()) {
            case 0: {
                int offset = 0;
                for (TagComponent tagComponent : this.content) {
                    if (tagComponent instanceof AminoAcidPattern) {
                        AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                        for (int i : ptmPattern.getIndexes(aminoAcidPattern, ptmSequenceMatchingPreferences)) {
                            possibleSites.add(i + offset);
                        }
                        offset += aminoAcidPattern.length();
                        continue;
                    }
                    if (tagComponent instanceof AminoAcidSequence) {
                        AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
                        for (int i : ptmPattern.getIndexes(aminoAcidSequence.getSequence(), ptmSequenceMatchingPreferences)) {
                            possibleSites.add(i + offset);
                        }
                        offset += aminoAcidSequence.length();
                        continue;
                    }
                    ++offset;
                }
                return possibleSites;
            }
            case 3: 
            case 7: {
                possibleSites.add(patternLength);
                return possibleSites;
            }
            case 1: 
            case 5: {
                possibleSites.add(1);
                return possibleSites;
            }
            case 4: 
            case 8: {
                if (this.content.isEmpty()) {
                    return new ArrayList<Integer>();
                }
                TagComponent component = this.content.get(this.content.size() - 1);
                if (component instanceof AminoAcidPattern) {
                    AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)component;
                    if (ptmPattern.isEnding(aminoAcidPattern, ptmSequenceMatchingPreferences)) {
                        possibleSites.add(patternLength);
                    }
                } else if (component instanceof AminoAcidSequence) {
                    AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)component;
                    if (ptmPattern.isEnding(aminoAcidSequence.getSequence(), ptmSequenceMatchingPreferences)) {
                        possibleSites.add(patternLength);
                    }
                } else if (component instanceof MassGap) {
                    possibleSites.add(patternLength);
                } else {
                    throw new UnsupportedOperationException("Possible modifications not implemnted for tag component " + component.getClass() + ".");
                }
                return possibleSites;
            }
            case 2: 
            case 6: {
                if (this.content.isEmpty()) {
                    return new ArrayList<Integer>();
                }
                TagComponent component = this.content.get(0);
                if (component instanceof AminoAcidPattern) {
                    AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)component;
                    if (ptmPattern.isStarting(aminoAcidPattern, ptmSequenceMatchingPreferences)) {
                        possibleSites.add(patternLength);
                    }
                } else if (component instanceof AminoAcidSequence) {
                    AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)component;
                    if (ptmPattern.isStarting(aminoAcidSequence.getSequence(), ptmSequenceMatchingPreferences)) {
                        possibleSites.add(patternLength);
                    }
                } else if (component instanceof MassGap) {
                    possibleSites.add(patternLength);
                } else {
                    throw new UnsupportedOperationException("Possible modifications not implemnted for tag component " + component.getClass() + ".");
                }
                return possibleSites;
            }
        }
        throw new IllegalArgumentException("PTM type " + ptm.getType() + " not recognized.");
    }

    public boolean isSameAs(Tag anotherTag, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (this.content.size() != anotherTag.getContent().size()) {
            return false;
        }
        for (int i = 0; i < this.content.size(); ++i) {
            TagComponent component2;
            TagComponent component1 = this.content.get(i);
            if (component1.isSameAs(component2 = anotherTag.getContent().get(i), sequenceMatchingPreferences)) continue;
            return false;
        }
        return true;
    }

    public boolean isSameSequenceAndModificationStatusAs(Tag anotherTag, SequenceMatchingPreferences sequenceMatchingPreferences) {
        if (this.content.size() != anotherTag.getContent().size()) {
            return false;
        }
        for (int i = 0; i < this.content.size(); ++i) {
            TagComponent component2;
            TagComponent component1 = this.content.get(i);
            if (component1.isSameSequenceAndModificationStatusAs(component2 = anotherTag.getContent().get(i), sequenceMatchingPreferences)) continue;
            return false;
        }
        return true;
    }

    public static String getTagModificationsAsString(Tag tag) {
        HashMap modMap = new HashMap();
        int offset = 0;
        for (TagComponent tagComponent : tag.getContent()) {
            int i;
            if (tagComponent instanceof MassGap) {
                ++offset;
                continue;
            }
            if (tagComponent instanceof AminoAcidPattern) {
                AminoAcidPattern aminoAcidPattern = (AminoAcidPattern)tagComponent;
                for (i = 1; i <= aminoAcidPattern.length(); ++i) {
                    for (ModificationMatch modificationMatch : aminoAcidPattern.getModificationsAt(i)) {
                        if (!modificationMatch.isVariable()) continue;
                        if (!modMap.containsKey(modificationMatch.getTheoreticPtm())) {
                            modMap.put(modificationMatch.getTheoreticPtm(), new ArrayList());
                        }
                        ((ArrayList)modMap.get(modificationMatch.getTheoreticPtm())).add(i + offset);
                    }
                }
                offset += aminoAcidPattern.length();
                continue;
            }
            if (tagComponent instanceof AminoAcidSequence) {
                AminoAcidSequence aminoAcidSequence = (AminoAcidSequence)tagComponent;
                for (i = 1; i <= aminoAcidSequence.length(); ++i) {
                    for (ModificationMatch modificationMatch : aminoAcidSequence.getModificationsAt(i)) {
                        if (!modificationMatch.isVariable()) continue;
                        if (!modMap.containsKey(modificationMatch.getTheoreticPtm())) {
                            modMap.put(modificationMatch.getTheoreticPtm(), new ArrayList());
                        }
                        ((ArrayList)modMap.get(modificationMatch.getTheoreticPtm())).add(i + offset);
                    }
                }
                offset += aminoAcidSequence.length();
                continue;
            }
            throw new IllegalArgumentException("Modification summary not implemented for TagComponent " + tagComponent.getClass() + ".");
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        ArrayList mods = new ArrayList(modMap.keySet());
        Collections.sort(mods);
        for (String mod : mods) {
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            boolean first2 = true;
            result.append(mod);
            result.append(" (");
            Iterator iterator = ((ArrayList)modMap.get(mod)).iterator();
            while (iterator.hasNext()) {
                int aa = (Integer)iterator.next();
                if (first2) {
                    first2 = false;
                } else {
                    result.append(", ");
                }
                result.append(aa);
            }
            result.append(")");
        }
        return result.toString();
    }

    public Tag reverse(boolean yIon) {
        double water = 2.0 * Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass();
        Tag newTag = new Tag();
        for (int i = this.content.size() - 1; i >= 0; --i) {
            TagComponent tagComponent = this.content.get(i);
            if (tagComponent instanceof MassGap) {
                double mass = tagComponent.getMass();
                if (i == this.content.size() - 1) {
                    mass = yIon ? (mass += water) : (mass -= water);
                } else if (i == 0) {
                    mass = yIon ? (mass -= water) : (mass += water);
                }
                newTag.addMassGap(mass);
                continue;
            }
            if (tagComponent instanceof AminoAcidPattern) {
                newTag.addAminoAcidPattern(((AminoAcidPattern)tagComponent).reverse());
                continue;
            }
            if (tagComponent instanceof AminoAcidSequence) {
                newTag.addAminoAcidSequence(((AminoAcidSequence)tagComponent).reverse());
                continue;
            }
            throw new UnsupportedOperationException("Reverse method not implemented for tag component " + tagComponent.getClass() + ".");
        }
        return newTag;
    }

    public boolean canReverse() {
        MassGap terminalGap;
        double water = 2.0 * Atom.H.getMonoisotopicMass() + Atom.O.getMonoisotopicMass();
        TagComponent terminalComponent = this.content.get(0);
        return terminalComponent instanceof MassGap && (terminalGap = (MassGap)terminalComponent).getMass() >= water && (terminalComponent = this.content.get(this.content.size() - 1)) instanceof MassGap && (terminalGap = (MassGap)terminalComponent).getMass() >= water;
    }

    public String toString() {
        return this.asSequence();
    }
}

