/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.identification_parameters;

import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public class PtmSettings
implements Serializable {
    static final long serialVersionUID = 342611308111304721L;
    private ArrayList<String> fixedModifications = new ArrayList();
    private ArrayList<String> variableModifications = new ArrayList();
    private ArrayList<String> refinementVariableModifications = new ArrayList();
    private ArrayList<String> refinementFixedModifications = new ArrayList();
    private HashMap<String, Color> colors = new HashMap();
    private HashMap<String, PTM> backUp = new HashMap();

    public PtmSettings() {
    }

    public PtmSettings(PtmSettings ptmSettings) {
        this.fixedModifications = ptmSettings.getFixedModifications();
        this.variableModifications = ptmSettings.getVariableModifications();
        this.refinementFixedModifications = ptmSettings.getRefinementFixedModifications();
        this.refinementVariableModifications = ptmSettings.getRefinementVariableModifications();
        this.colors = ptmSettings.getColors();
        this.backUp = ptmSettings.getBackedUpPtmsMap();
    }

    public ArrayList<String> getVariableModifications() {
        return this.variableModifications;
    }

    public ArrayList<String> getFixedModifications() {
        return this.fixedModifications;
    }

    public ArrayList<String> getRefinementVariableModifications() {
        return this.refinementVariableModifications;
    }

    public void clearVariableModifications() {
        this.variableModifications.clear();
    }

    public void clearFixedModifications() {
        this.fixedModifications.clear();
    }

    public void clearRefinementModifications() {
        this.refinementVariableModifications.clear();
    }

    public ArrayList<String> getRefinementFixedModifications() {
        return this.refinementFixedModifications;
    }

    public ArrayList<String> getAllModifications() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.fixedModifications);
        result.addAll(this.variableModifications);
        for (String ptmName : this.refinementFixedModifications) {
            if (result.contains(ptmName)) continue;
            result.add(ptmName);
        }
        for (String ptmName : this.refinementVariableModifications) {
            if (result.contains(ptmName)) continue;
            result.add(ptmName);
        }
        return result;
    }

    public ArrayList<String> getAllNotFixedModifications() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.variableModifications);
        for (String ptmName : this.refinementVariableModifications) {
            if (result.contains(ptmName)) continue;
            result.add(ptmName);
        }
        for (String ptmName : this.refinementFixedModifications) {
            if (this.fixedModifications.contains(ptmName) || result.contains(ptmName)) continue;
            result.add(ptmName);
        }
        return result;
    }

    public void addVariableModification(PTM modification) {
        String modName = modification.getName();
        if (!this.variableModifications.contains(modName)) {
            this.variableModifications.add(modName);
        }
        this.backUp.put(modName, modification);
    }

    public void addRefinementVariableModification(PTM modification) {
        String modName = modification.getName();
        if (!this.refinementVariableModifications.contains(modName)) {
            this.refinementVariableModifications.add(modName);
        }
        this.backUp.put(modName, modification);
    }

    public void addRefinementFixedModification(PTM modification) {
        String modName = modification.getName();
        if (!this.refinementFixedModifications.contains(modName)) {
            this.refinementFixedModifications.add(modName);
        }
        this.backUp.put(modName, modification);
    }

    public void addFixedModification(PTM modification) {
        String modName = modification.getName();
        if (!this.fixedModifications.contains(modName)) {
            this.fixedModifications.add(modName);
        }
        this.backUp.put(modName, modification);
    }

    public void setColor(String expectedModification, Color color) {
        this.colors.put(expectedModification, color);
    }

    public Color getColor(String modification) {
        if (!this.colors.containsKey(modification)) {
            PTMFactory ptmFactory = PTMFactory.getInstance();
            this.setColor(modification, ptmFactory.getColor(modification));
        }
        return this.colors.get(modification);
    }

    public HashMap<String, Color> getColors() {
        return this.colors;
    }

    public Set<String> getBackedUpPtms() {
        return this.backUp.keySet();
    }

    public PTM getPtm(String modName) {
        return this.backUp.get(modName);
    }

    public HashMap<String, PTM> getBackedUpPtmsMap() {
        return this.backUp;
    }

    public void removeVariableModification(String modificationName) {
        while (this.variableModifications.contains(modificationName)) {
            this.variableModifications.remove(modificationName);
        }
    }

    public void removeFixedModification(String modificationName) {
        while (this.fixedModifications.contains(modificationName)) {
            this.fixedModifications.remove(modificationName);
        }
    }

    public void removeRefinementVariableModification(String modificationName) {
        while (this.refinementVariableModifications.contains(modificationName)) {
            this.refinementVariableModifications.remove(modificationName);
        }
    }

    public void removeRefinementFixedModification(String modificationName) {
        while (this.refinementFixedModifications.contains(modificationName)) {
            this.refinementFixedModifications.remove(modificationName);
        }
    }

    public boolean contains(String modificationName) {
        return this.variableModifications.contains(modificationName) || this.fixedModifications.contains(modificationName) || this.refinementVariableModifications != null && this.refinementVariableModifications.contains(modificationName) || this.refinementFixedModifications != null && this.refinementFixedModifications.contains(modificationName);
    }

    public ArrayList<String> getSimilarNotFixedModifications(Double ptmMass) {
        PTMFactory ptmFactory = PTMFactory.getInstance();
        ArrayList<String> ptms = new ArrayList<String>();
        for (String ptmName : this.getAllNotFixedModifications()) {
            PTM ptm = ptmFactory.getPTM(ptmName);
            if (ptms.contains(ptmName) || ptm.getMass() != ptmMass.doubleValue()) continue;
            ptms.add(ptmName);
        }
        return ptms;
    }

    public boolean equals(PtmSettings otherProfile) {
        if (otherProfile == null) {
            return false;
        }
        if (!this.getVariableModifications().equals(otherProfile.getVariableModifications())) {
            return false;
        }
        if (!this.getFixedModifications().equals(otherProfile.getFixedModifications())) {
            return false;
        }
        if (!this.getRefinementVariableModifications().equals(otherProfile.getRefinementVariableModifications())) {
            return false;
        }
        if (!this.getRefinementFixedModifications().equals(otherProfile.getRefinementFixedModifications())) {
            return false;
        }
        if (this.colors.size() != otherProfile.colors.size()) {
            return false;
        }
        for (String tempKey : this.colors.keySet()) {
            if (!otherProfile.colors.containsKey(tempKey)) {
                return false;
            }
            if (this.colors.get(tempKey).equals(otherProfile.colors.get(tempKey))) continue;
            return false;
        }
        if (this.backUp.size() != otherProfile.backUp.size()) {
            return false;
        }
        for (String tempKey : this.backUp.keySet()) {
            if (otherProfile.backUp.containsKey(tempKey)) continue;
            return false;
        }
        return true;
    }
}

