/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.psm_scoring.psm_scores;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.math.BasicMathFunctions;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.math.MathException;

public class AAMS2MzFidelityScore {
    public double getScore(Peptide peptide, MSnSpectrum spectrum, AnnotationSettings annotationPreferences, SpecificAnnotationSettings specificAnnotationPreferences, PeptideSpectrumAnnotator peptideSpectrumAnnotator) throws InterruptedException, MathException {
        int sequenceLength = peptide.getSequence().length();
        HashMap<Integer, Double> aaDeviations = new HashMap<Integer, Double>(sequenceLength);
        for (int i = 1; i <= sequenceLength; ++i) {
            aaDeviations.put(i, specificAnnotationPreferences.getFragmentIonAccuracyInDa(spectrum.getMaxMz()));
        }
        ArrayList<IonMatch> matches = peptideSpectrumAnnotator.getSpectrumAnnotation(annotationPreferences, specificAnnotationPreferences, spectrum, peptide);
        for (IonMatch ionMatch : matches) {
            Ion ion = ionMatch.ion;
            if (!(ion instanceof PeptideFragmentIon)) continue;
            PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)ion;
            int number = peptideFragmentIon.getNumber();
            double error = (Double)aaDeviations.get(number);
            double tempError = Math.abs(ionMatch.getAbsoluteError());
            if (!(tempError < error)) continue;
            aaDeviations.put(number, tempError);
        }
        ArrayList<Double> mzDeviations = new ArrayList<Double>(aaDeviations.values());
        if (mzDeviations.isEmpty()) {
            return specificAnnotationPreferences.getFragmentIonAccuracyInDa(spectrum.getMaxMz());
        }
        return BasicMathFunctions.mean(mzDeviations);
    }
}

