/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.psm_scoring.psm_scores;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.protein_sequences.AaOccurrence;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.SimpleNoiseDistribution;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.math.MathException;
import org.apache.commons.math.util.FastMath;

public class SnrScore {
    private static double limitLog10 = -FastMath.log10((double)Double.MIN_VALUE);
    private AaOccurrence aaOccurrence;

    public SnrScore(AaOccurrence aaOccurrence) {
        this.aaOccurrence = aaOccurrence;
    }

    public double getScore(Peptide peptide, MSnSpectrum spectrum, AnnotationSettings annotationSettings, SpecificAnnotationSettings specificAnnotationSettings, PeptideSpectrumAnnotator peptideSpectrumAnnotator) throws InterruptedException, MathException {
        ArrayList<IonMatch> ionMatchesList = peptideSpectrumAnnotator.getSpectrumAnnotation(annotationSettings, specificAnnotationSettings, spectrum, peptide, false);
        return this.getScore(peptide, spectrum, ionMatchesList);
    }

    public double getScore(Peptide peptide, MSnSpectrum spectrum, ArrayList<IonMatch> ionMatchesList) throws InterruptedException, MathException {
        HashMap<Double, ArrayList<IonMatch>> ionMatches = new HashMap<Double, ArrayList<IonMatch>>(ionMatchesList.size());
        for (IonMatch ionMatch : ionMatchesList) {
            double mz = ionMatch.peak.mz;
            ArrayList<IonMatch> peakMatches = ionMatches.get(mz);
            if (peakMatches == null) {
                peakMatches = new ArrayList(1);
                ionMatches.put(mz, peakMatches);
            }
            peakMatches.add(ionMatch);
        }
        return this.getScore(peptide, spectrum, ionMatches);
    }

    public double getScore(Peptide peptide, MSnSpectrum spectrum, HashMap<Double, ArrayList<IonMatch>> ionMatches) throws InterruptedException, MathException {
        Object object;
        Object peakMatches;
        char[] sequence = peptide.getSequence().toCharArray();
        int sequenceLength = sequence.length;
        SimpleNoiseDistribution binnedCumulativeFunction = spectrum.getIntensityLogDistribution();
        double pFragmentIonMinusLog = 0.0;
        double pAnnotatedMinusLog = 0.0;
        for (double mz : ionMatches.keySet()) {
            peakMatches = ionMatches.get(mz);
            double intensity = ((IonMatch)((ArrayList)peakMatches).get((int)0)).peak.intensity;
            object = -binnedCumulativeFunction.getBinnedCumulativeProbabilityLog(intensity);
            Iterator iterator = ((ArrayList)peakMatches).iterator();
            while (iterator.hasNext()) {
                IonMatch ionMatch = (IonMatch)iterator.next();
                if (ionMatch.ion.getType() != Ion.IonType.PEPTIDE_FRAGMENT_ION) continue;
                PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)ionMatch.ion;
                int number = peptideFragmentIon.getNumber();
                if (peptideFragmentIon.hasNeutralLosses() || number < 2) continue;
                double aasP = peptideFragmentIon.getSubType() == 0 || peptideFragmentIon.getSubType() == 1 || peptideFragmentIon.getSubType() == 2 ? this.aaOccurrence.getP(sequence, 0, number, 4.0) : this.aaOccurrence.getP(sequence, sequenceLength - number, sequenceLength, 4.0);
                pFragmentIonMinusLog += object + aasP;
                break;
            }
            pAnnotatedMinusLog += object;
        }
        if (pFragmentIonMinusLog == 0.0) {
            return pFragmentIonMinusLog;
        }
        double pTotalMinusLog = 0.0;
        double[] intensities = spectrum.getIntensityValuesAsArray();
        peakMatches = intensities;
        int n = ((Object)peakMatches).length;
        for (int i = 0; i < n; ++i) {
            object = peakMatches[i];
            double pMinusLog = -binnedCumulativeFunction.getBinnedCumulativeProbabilityLog((double)object);
            pTotalMinusLog += pMinusLog;
        }
        double pNotAnnotatedMinusLog = pTotalMinusLog - pAnnotatedMinusLog;
        if (pNotAnnotatedMinusLog < limitLog10) {
            double notAnnotatedCorrection;
            double pNotAnnotated = FastMath.pow((double)10.0, (double)(-pNotAnnotatedMinusLog));
            if (pNotAnnotated > 1.0) {
                pNotAnnotated = 1.0;
            }
            if ((notAnnotatedCorrection = -FastMath.log10((double)(pNotAnnotated = 1.0 - pNotAnnotated))) > pAnnotatedMinusLog) {
                notAnnotatedCorrection = pAnnotatedMinusLog;
            }
            pFragmentIonMinusLog += notAnnotatedCorrection;
        }
        return pFragmentIonMinusLog;
    }
}

