/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.spectrum_annotation;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.IonFactory;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.biology.ions.TagFragmentIon;
import com.compomics.util.experiment.identification.SpectrumIdentificationAssumption;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.spectrum_annotation.AnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.IonMatchKeysCache;
import com.compomics.util.experiment.identification.spectrum_annotation.NeutralLossesMap;
import com.compomics.util.experiment.identification.spectrum_annotation.SpecificAnnotationSettings;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.PeptideSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_annotation.spectrum_annotators.TagSpectrumAnnotator;
import com.compomics.util.experiment.identification.spectrum_assumptions.PeptideAssumption;
import com.compomics.util.experiment.identification.spectrum_assumptions.TagAssumption;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.massspectrometry.indexes.SpectrumIndex;
import com.compomics.util.gui.interfaces.SpectrumAnnotation;
import com.compomics.util.gui.spectrum.DefaultSpectrumAnnotation;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import com.compomics.util.preferences.SequenceMatchingPreferences;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.apache.commons.math.MathException;

public abstract class SpectrumAnnotator {
    protected int precursorCharge;
    protected HashMap<Integer, HashMap<Integer, ArrayList<Ion>>> theoreticalFragmentIons;
    protected IonFactory fragmentFactory = IonFactory.getInstance();
    private String spectrumKey = "";
    protected double intensityLimit = 0.0;
    private SpectrumIndex spectrumIndex;
    protected double mzTolerance;
    protected boolean isPpm;
    protected static final boolean subtractIsotope = false;
    protected static final Integer minIsotopicCorrection = 0;
    protected static final Integer maxIsotopicCorrection = 0;
    protected double massShift = 0.0;
    protected double massShiftNTerm = 0.0;
    protected double massShiftCTerm = 0.0;
    protected TiesResolution tiesResolution;
    protected SpecificAnnotationSettings specificAnnotationSettings = null;
    protected IonMatchKeysCache ionMatchKeysCache = new IonMatchKeysCache();

    public static Vector<SpectrumAnnotation> getSpectrumAnnotation(ArrayList<IonMatch> ionMatches) {
        Vector<SpectrumAnnotation> currentAnnotations = new Vector<SpectrumAnnotation>();
        for (IonMatch ionMatch : ionMatches) {
            currentAnnotations.add(new DefaultSpectrumAnnotation(ionMatch.peak.mz, ionMatch.getAbsoluteError(minIsotopicCorrection, maxIsotopicCorrection), SpectrumPanel.determineFragmentIonColor(ionMatch.ion, true), ionMatch.getPeakAnnotation()));
        }
        return currentAnnotations;
    }

    protected IonMatch matchInSpectrum(Ion theoreticIon, Integer inspectedCharge) {
        double fragmentMz = theoreticIon.getTheoreticMz(inspectedCharge);
        ArrayList<Peak> matchedPeaks = this.spectrumIndex.getMatchingPeaks(fragmentMz);
        if (matchedPeaks.isEmpty()) {
            return null;
        }
        IonMatch ionMatch = new IonMatch(null, theoreticIon, inspectedCharge);
        ionMatch.peak = matchedPeaks.size() == 1 ? matchedPeaks.get(0) : this.getBestPeak(matchedPeaks, ionMatch);
        return ionMatch;
    }

    protected Peak getBestPeak(ArrayList<Peak> matchedPeaks, IonMatch ionMatch) {
        Peak bestPeak = null;
        switch (this.tiesResolution) {
            case mostAccurateMz: {
                Double bestPeakError = null;
                for (Peak peak : matchedPeaks) {
                    if (bestPeak == null) {
                        bestPeak = peak;
                        ionMatch.peak = peak;
                        bestPeakError = Math.abs(ionMatch.getError(this.isPpm));
                        continue;
                    }
                    ionMatch.peak = peak;
                    double peakError = Math.abs(ionMatch.getError(this.isPpm));
                    if (peakError < bestPeakError) {
                        bestPeak = peak;
                        bestPeakError = peakError;
                        continue;
                    }
                    if (peakError != bestPeakError || !(peak.intensity > bestPeak.intensity)) continue;
                    bestPeak = peak;
                }
                return bestPeak;
            }
            case mostIntense: {
                for (Peak peak : matchedPeaks) {
                    if (bestPeak == null || peak.intensity > bestPeak.intensity) {
                        bestPeak = peak;
                        continue;
                    }
                    if (peak.intensity != bestPeak.intensity) continue;
                    ionMatch.peak = bestPeak;
                    Double bestPeakError = Math.abs(ionMatch.getError(this.isPpm));
                    ionMatch.peak = peak;
                    double peakError = Math.abs(ionMatch.getError(this.isPpm));
                    if (!(peakError < bestPeakError)) continue;
                    bestPeak = peak;
                }
                return bestPeak;
            }
        }
        throw new UnsupportedOperationException("Ties resolution method " + (Object)((Object)this.tiesResolution) + " not implemented.");
    }

    protected void setSpectrum(MSnSpectrum spectrum, double intensityLimit) {
        if (this.spectrumIndex == null || !this.spectrumKey.equals(spectrum.getSpectrumKey()) || this.intensityLimit != intensityLimit) {
            this.spectrumKey = spectrum.getSpectrumKey();
            this.intensityLimit = intensityLimit;
            this.spectrumIndex = new SpectrumIndex();
            this.spectrumIndex = (SpectrumIndex)spectrum.getUrParam(this.spectrumIndex);
            if (this.spectrumIndex == null || this.spectrumIndex.intensityLimit != intensityLimit) {
                this.spectrumIndex = new SpectrumIndex(spectrum.getPeakMap(), intensityLimit, this.mzTolerance, this.isPpm);
                spectrum.addUrParam(this.spectrumIndex);
            }
        }
    }

    protected void setMassTolerance(double mzTolerance, boolean isPpm, TiesResolution tiesResolution) {
        if (mzTolerance != this.mzTolerance || tiesResolution != this.tiesResolution) {
            this.spectrumIndex = null;
            this.mzTolerance = mzTolerance;
            this.isPpm = isPpm;
            this.tiesResolution = tiesResolution;
        }
    }

    public boolean isAccounted(NeutralLossesMap neutralLosses, NeutralLoss neutralLoss, Ion ion) {
        if (neutralLosses == null || neutralLosses.isEmpty()) {
            return false;
        }
        for (String neutralLossName : neutralLosses.getAccountedNeutralLosses()) {
            NeutralLoss neutralLossRef = NeutralLoss.getNeutralLoss(neutralLossName);
            if (!neutralLoss.isSameAs(neutralLossRef)) continue;
            switch (ion.getType()) {
                case PEPTIDE_FRAGMENT_ION: {
                    PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)ion;
                    switch (ion.getSubType()) {
                        case 0: 
                        case 1: 
                        case 2: {
                            return neutralLosses.getForwardStart(neutralLossName) <= peptideFragmentIon.getNumber();
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            return neutralLosses.getRewindStart(neutralLossName) <= peptideFragmentIon.getNumber();
                        }
                    }
                    throw new UnsupportedOperationException("Fragment ion type " + ion.getSubTypeAsString() + " not implemented in the spectrum annotator.");
                }
                case TAG_FRAGMENT_ION: {
                    TagFragmentIon tagFragmentIon = (TagFragmentIon)ion;
                    switch (ion.getSubType()) {
                        case 0: 
                        case 1: 
                        case 2: {
                            return neutralLosses.getForwardStart(neutralLossName) <= tagFragmentIon.getNumber();
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            return neutralLosses.getRewindStart(neutralLossName) <= tagFragmentIon.getNumber();
                        }
                    }
                    throw new UnsupportedOperationException("Fragment ion type " + ion.getSubTypeAsString() + " not implemented in the spectrum annotator.");
                }
            }
            return true;
        }
        return false;
    }

    public boolean lossesValidated(NeutralLossesMap neutralLosses, Ion theoreticIon) {
        if (theoreticIon.hasNeutralLosses()) {
            for (NeutralLoss neutralLoss : theoreticIon.getNeutralLosses()) {
                if (this.isAccounted(neutralLosses, neutralLoss, theoreticIon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean chargeValidated(Ion theoreticIon, int charge, int precursorCharge) {
        if (charge == 1) {
            return true;
        }
        switch (theoreticIon.getType()) {
            case IMMONIUM_ION: 
            case RELATED_ION: {
                return false;
            }
            case REPORTER_ION: {
                return false;
            }
            case PEPTIDE_FRAGMENT_ION: {
                PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)theoreticIon;
                return charge <= peptideFragmentIon.getNumber() && charge < precursorCharge;
            }
            case TAG_FRAGMENT_ION: {
                TagFragmentIon tagFragmentIon = (TagFragmentIon)theoreticIon;
                return charge <= tagFragmentIon.getNumber() && charge < precursorCharge;
            }
            case PRECURSOR_ION: {
                return charge >= precursorCharge;
            }
        }
        throw new UnsupportedOperationException("Ion type " + theoreticIon.getTypeAsString() + " not implemented in the spectrum annotator.");
    }

    public ArrayList<IonMatch> getCurrentAnnotation(MSnSpectrum spectrum, AnnotationSettings annotationSettings, SpecificAnnotationSettings specificAnnotationSettings) throws InterruptedException, MathException {
        return this.getCurrentAnnotation(spectrum, annotationSettings, specificAnnotationSettings, true);
    }

    public abstract ArrayList<IonMatch> getCurrentAnnotation(MSnSpectrum var1, AnnotationSettings var2, SpecificAnnotationSettings var3, boolean var4) throws InterruptedException, MathException;

    public String getCurrentlyLoadedSpectrumKey() {
        return this.spectrumKey;
    }

    public double getMassShift() {
        return this.massShift;
    }

    public double getMassShiftNTerm() {
        return this.massShiftNTerm;
    }

    public double getMassShiftCTerm() {
        return this.massShiftNTerm;
    }

    public void setMassShift(double aMassShift) {
        this.massShift = aMassShift;
        this.updateMassShifts();
    }

    public void setMassShifts(double aMassShift, double aMassShiftNTerm, double aMassShiftCTerm) {
        this.massShift = aMassShift;
        this.massShiftNTerm = aMassShiftNTerm;
        this.massShiftCTerm = aMassShiftCTerm;
        this.updateMassShifts();
    }

    public void setTerminalMassShifts(double aMassShiftNTerm, double aMassShiftCTerm) {
        this.massShiftNTerm = aMassShiftNTerm;
        this.massShiftCTerm = aMassShiftCTerm;
        this.updateMassShifts();
    }

    protected void updateMassShifts() {
        if (this.theoreticalFragmentIons != null) {
            HashMap<Integer, ArrayList<Ion>> tagFragmentIons;
            HashMap<Integer, ArrayList<Ion>> peptideFragmentIons = this.theoreticalFragmentIons.get(Ion.IonType.PEPTIDE_FRAGMENT_ION.index);
            ArrayList<Ion> ions = peptideFragmentIons.get(0);
            if (ions != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                }
            }
            if ((ions = peptideFragmentIons.get(1)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                }
            }
            if ((ions = peptideFragmentIons.get(2)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                }
            }
            if ((ions = peptideFragmentIons.get(3)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
            if ((ions = peptideFragmentIons.get(4)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
            if ((ions = peptideFragmentIons.get(5)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
            if ((ions = (tagFragmentIons = this.theoreticalFragmentIons.get(Ion.IonType.TAG_FRAGMENT_ION.index)).get(0)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                }
            }
            if ((ions = tagFragmentIons.get(1)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                }
            }
            if ((ions = tagFragmentIons.get(2)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftNTerm);
                }
            }
            if ((ions = tagFragmentIons.get(3)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
            if ((ions = tagFragmentIons.get(4)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
            if ((ions = tagFragmentIons.get(5)) != null) {
                for (Ion ion : ions) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift + this.massShiftCTerm);
                }
            }
        }
    }

    public static NeutralLossesMap getDefaultLosses(SpectrumIdentificationAssumption spectrumIdentificationAssumption, SequenceMatchingPreferences sequenceMatchingPreferences, SequenceMatchingPreferences ptmSequenceMatchingPreferences) throws IOException, InterruptedException, ClassNotFoundException, SQLException {
        if (spectrumIdentificationAssumption instanceof PeptideAssumption) {
            PeptideAssumption peptideAssumption = (PeptideAssumption)spectrumIdentificationAssumption;
            return PeptideSpectrumAnnotator.getDefaultLosses(peptideAssumption.getPeptide(), sequenceMatchingPreferences, ptmSequenceMatchingPreferences);
        }
        if (spectrumIdentificationAssumption instanceof TagAssumption) {
            TagAssumption tagAssumption = (TagAssumption)spectrumIdentificationAssumption;
            return TagSpectrumAnnotator.getDefaultLosses(tagAssumption.getTag(), ptmSequenceMatchingPreferences);
        }
        throw new IllegalArgumentException("Default neutral loss map not implemented for SpectrumIdentificationAssumption " + spectrumIdentificationAssumption.getClass() + ".");
    }

    protected ArrayList<IonMatch> matchPeak(SpecificAnnotationSettings specificAnnotationSettings, Peak peak) {
        ArrayList<IonMatch> result = new ArrayList<IonMatch>();
        HashMap<Ion.IonType, HashSet<Integer>> ionTypes = specificAnnotationSettings.getIonTypes();
        for (Ion.IonType ionType : ionTypes.keySet()) {
            HashMap<Integer, ArrayList<Ion>> ionMap = this.theoreticalFragmentIons.get(ionType.index);
            if (ionMap == null) continue;
            HashSet<Integer> subtypes = ionTypes.get((Object)ionType);
            for (int subType : subtypes) {
                ArrayList<Ion> ions = ionMap.get(subType);
                if (ions == null) continue;
                for (Ion ion : ions) {
                    for (int charge : specificAnnotationSettings.getSelectedCharges()) {
                        IonMatch ionMatch;
                        if (!this.chargeValidated(ion, charge, specificAnnotationSettings.getPrecursorCharge()) || !this.lossesValidated(specificAnnotationSettings.getNeutralLossesMap(), ion) || !(Math.abs((ionMatch = new IonMatch(peak, ion, charge)).getError(specificAnnotationSettings.isFragmentIonPpm(), minIsotopicCorrection, maxIsotopicCorrection)) <= specificAnnotationSettings.getFragmentIonAccuracy())) continue;
                        result.add(ionMatch);
                    }
                }
            }
        }
        return result;
    }

    protected HashMap<Integer, ArrayList<Ion>> getExpectedIons(SpecificAnnotationSettings specificAnnotationSettings) {
        HashMap<Integer, ArrayList<Ion>> result = new HashMap<Integer, ArrayList<Ion>>();
        HashMap<Ion.IonType, HashSet<Integer>> ionTypes = specificAnnotationSettings.getIonTypes();
        for (Ion.IonType ionType : ionTypes.keySet()) {
            HashMap<Integer, ArrayList<Ion>> ionMap = this.theoreticalFragmentIons.get(ionType.index);
            if (ionMap == null) continue;
            HashSet<Integer> subtypes = ionTypes.get((Object)ionType);
            for (int subType : subtypes) {
                ArrayList<Ion> ions = ionMap.get(subType);
                if (ions == null) continue;
                for (Ion ion : ions) {
                    if (!this.lossesValidated(specificAnnotationSettings.getNeutralLossesMap(), ion)) continue;
                    for (int charge : specificAnnotationSettings.getSelectedCharges()) {
                        if (!this.chargeValidated(ion, charge, this.precursorCharge)) continue;
                        ArrayList<Ion> resultsAtCharge = result.get(charge);
                        if (resultsAtCharge == null) {
                            resultsAtCharge = new ArrayList();
                            result.put(charge, resultsAtCharge);
                        }
                        resultsAtCharge.add(ion);
                    }
                }
            }
        }
        return result;
    }

    public static ArrayList<IonMatch> matchReporterIon(Ion theoreticIon, int charge, Spectrum spectrum, double massTolerance) throws InterruptedException {
        ArrayList<IonMatch> result = new ArrayList<IonMatch>(1);
        double targetMass = theoreticIon.getTheoreticMz(charge);
        for (double mz : spectrum.getOrderedMzValues()) {
            if (Math.abs(mz - targetMass) <= massTolerance) {
                result.add(new IonMatch(spectrum.getPeakMap().get(mz), theoreticIon, charge));
            }
            if (mz > targetMass + massTolerance) break;
        }
        return result;
    }

    public static enum TiesResolution {
        mostIntense("Higest intensity"),
        mostAccurateMz("Most accurate m/z");

        public final String description;

        private TiesResolution(String description) {
            this.description = description;
        }
    }
}

