/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.massspectrometry.export;

import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.FragmentationMethod;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.Precursor;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.experiment.massspectrometry.SpectrumFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import uk.ac.ebi.jmzml.xml.io.MzMLUnmarshallerException;

public class AplExporter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mgfToApl(File mgfFile, File destinationFile, FragmentationMethod fragmentationMethod, int minCharge, int maxCharge) throws IOException, MzMLUnmarshallerException, InterruptedException {
        String fileName = mgfFile.getName();
        SpectrumFactory spectrumFactory = SpectrumFactory.getInstance();
        HashMap<Double, HashMap<String, Integer>> precursorMassToTitleMap = new HashMap<Double, HashMap<String, Integer>>(spectrumFactory.getNSpectra(fileName));
        for (String title : spectrumFactory.getSpectrumTitles(fileName)) {
            Precursor precursor = spectrumFactory.getPrecursor(Spectrum.getSpectrumKey(fileName, title));
            Double mz = precursor.getMz();
            if (!precursor.getPossibleCharges().isEmpty()) {
                for (Charge possibleCharge : precursor.getPossibleCharges()) {
                    int charge = possibleCharge.value;
                    double mass = mz * (double)charge - (double)charge * ElementaryIon.proton.getTheoreticMass();
                    HashMap<String, Integer> titlesAtMass = (HashMap<String, Integer>)precursorMassToTitleMap.get(mass);
                    if (titlesAtMass == null) {
                        titlesAtMass = new HashMap<String, Integer>(1);
                        precursorMassToTitleMap.put(mass, titlesAtMass);
                    }
                    titlesAtMass.put(title, charge);
                }
                continue;
            }
            for (int charge = minCharge; charge <= maxCharge; ++charge) {
                double mass = mz * (double)charge - (double)charge * ElementaryIon.proton.getTheoreticMass();
                HashMap<String, Integer> titlesAtMass = (HashMap<String, Integer>)precursorMassToTitleMap.get(mass);
                if (titlesAtMass == null) {
                    titlesAtMass = new HashMap<String, Integer>(1);
                    precursorMassToTitleMap.put(mass, titlesAtMass);
                }
                titlesAtMass.put(title, charge);
            }
        }
        ArrayList masses = new ArrayList(precursorMassToTitleMap.keySet());
        Collections.sort(masses);
        FileWriter fileWriter = new FileWriter(destinationFile);
        try {
            BufferedWriter bw = new BufferedWriter(fileWriter);
            try {
                for (Double mass : masses) {
                    HashMap titles = (HashMap)precursorMassToTitleMap.get(mass);
                    for (String title : titles.keySet()) {
                        MSnSpectrum spectrum = (MSnSpectrum)spectrumFactory.getSpectrum(fileName, title, false);
                        AplExporter.writeSpectrum(bw, spectrum, fragmentationMethod, (Integer)titles.get(title));
                    }
                }
            }
            finally {
                bw.close();
            }
        }
        finally {
            fileWriter.close();
        }
    }

    public static void writeSpectrum(BufferedWriter bw, MSnSpectrum spectrum, FragmentationMethod fragmentationMethod, int charge) throws IOException, InterruptedException {
        bw.write("peaklist start");
        bw.newLine();
        Precursor precursor = spectrum.getPrecursor();
        bw.write("mz=" + precursor.getMz());
        bw.newLine();
        bw.write("fragmentation=" + fragmentationMethod.name);
        bw.newLine();
        bw.write("charge=" + charge);
        bw.newLine();
        bw.write("header=" + spectrum.getSpectrumTitle());
        bw.newLine();
        HashMap<Double, Peak> peakMap = spectrum.getPeakMap();
        for (double mz : spectrum.getOrderedMzValues()) {
            Peak peak = peakMap.get(mz);
            bw.write(peak.mz + "\t" + peak.intensity);
            bw.newLine();
        }
        bw.write("peaklist end");
        bw.newLine();
        bw.newLine();
    }
}

