/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.protein_sequences_manager.gui.sequences_import.taxonomy;

import com.compomics.util.protein_sequences_manager.gui.sequences_import.taxonomy.ConnectionManager;
import com.compomics.util.protein_sequences_manager.gui.sequences_import.taxonomy.QueryType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class UniprotTaxonomyProvider {
    private static DefaultMutableTreeNode rootNode;
    private final HashSet<String> lineages = new HashSet();
    private final DefaultTreeModel model;
    private final HashMap<String, String> cachedTaxonomies = new HashMap();

    public UniprotTaxonomyProvider(DefaultTreeModel model) {
        rootNode = (DefaultMutableTreeNode)model.getRoot();
        this.model = model;
    }

    public UniprotTaxonomyProvider() {
        rootNode = new DefaultMutableTreeNode("root");
        this.model = new DefaultTreeModel(rootNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChildTaxonomies(String taxonomyName) throws MalformedURLException, IOException {
        ArrayList<String> childrenTaxonomies = new ArrayList<String>();
        String url = ConnectionManager.getUniprotHost() + "taxonomy/?query=\"" + taxonomyName + "\"&format=tab";
        URL website = new URL(url);
        URLConnection connection = website.openConnection();
        BufferedReader in = null;
        try {
            String inputLine;
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            in.readLine();
            while ((inputLine = in.readLine()) != null) {
                String[] split = inputLine.split("\t");
                String taxName = split[2];
                String taxID = split[0];
                String lineage = split[8] + ";" + taxName;
                this.lineages.add(lineage);
                this.cachedTaxonomies.put(taxName, taxID);
                childrenTaxonomies.add(taxName);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return childrenTaxonomies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getLineagesForTaxonomyID(String taxonomyName) throws MalformedURLException, IOException, IllegalArgumentException, URISyntaxException {
        int maxPerQuery = 20000;
        String query = "\"" + taxonomyName + "\"&sort=score&format=tab";
        HttpURLConnection connection = ConnectionManager.getQueryConnection(query, QueryType.TAXONOMY);
        HashMap<String, String> tempTaxIdMap = new HashMap<String, String>();
        ArrayList<String> tempLineages = new ArrayList<String>();
        BufferedReader in = null;
        try {
            String inputLine;
            in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            in.readLine();
            while ((inputLine = in.readLine()) != null) {
                String[] split = inputLine.split("\t");
                String taxName = split[2];
                String taxID = split[0];
                String lineage = split[8] + ";" + taxName;
                tempLineages.add(lineage);
                tempTaxIdMap.put(taxName, taxID);
                if (tempLineages.size() <= maxPerQuery) continue;
                throw new IllegalArgumentException("There were over " + maxPerQuery + " lineages found for this query. Try a more specific search or browse manually");
            }
            this.lineages.addAll(tempLineages);
            this.cachedTaxonomies.putAll(tempTaxIdMap);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return this.lineages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getLineagesFromFile(File taxonomyFile) throws MalformedURLException, IOException {
        BufferedReader in = null;
        try {
            String inputLine;
            in = new BufferedReader(new InputStreamReader(new FileInputStream(taxonomyFile)));
            in.readLine();
            while ((inputLine = in.readLine()) != null) {
                if (this.lineages.size() % 10000 == 0) {
                    System.out.println(this.lineages.size() + " processed lineages");
                }
                String[] split = inputLine.split("\t");
                this.lineages.add(split[8] + ";" + split[2]);
                this.cachedTaxonomies.put(split[2], split[0]);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return this.lineages;
    }

    public DefaultTreeModel getModelFromFile(File taxonomyTabFile) throws IOException, InterruptedException {
        System.out.println("Building Tree");
        this.getLineagesFromFile(taxonomyTabFile);
        int processed = 0;
        for (String lineage : this.lineages) {
            if (processed % 10000 == 0) {
                System.out.println(processed + " added in tree");
            }
            String[] taxonomies = lineage.split(";");
            DefaultMutableTreeNode parent = new DefaultMutableTreeNode(new String[]{"root", taxonomies[0]});
            for (String taxonomy : taxonomies) {
                DefaultMutableTreeNode node = this.searchNode(taxonomy = taxonomy.trim());
                if (node == null) {
                    node = new DefaultMutableTreeNode(taxonomy);
                    this.model.insertNodeInto(node, parent, parent.getChildCount());
                }
                parent = node;
            }
            ++processed;
        }
        return this.model;
    }

    public DefaultTreeModel getModelAfterSearch(String taxonomyName) throws IllegalArgumentException, IOException, MalformedURLException, URISyntaxException {
        this.getLineagesForTaxonomyID(taxonomyName);
        for (String lineage : this.lineages) {
            String[] taxonomies = lineage.split(";");
            DefaultMutableTreeNode parent = new DefaultMutableTreeNode(new String[]{"root", taxonomies[0]});
            for (String taxonomy : taxonomies) {
                DefaultMutableTreeNode node = this.searchNode(taxonomy = taxonomy.trim());
                if (node == null) {
                    node = new DefaultMutableTreeNode(taxonomy);
                    this.model.insertNodeInto(node, parent, parent.getChildCount());
                }
                parent = node;
            }
        }
        return this.model;
    }

    public DefaultTreeModel getModelAfterClick(String taxonomyName) throws IOException {
        List<String> childTaxonomies = this.getChildTaxonomies(taxonomyName);
        for (String lineage : childTaxonomies) {
            String[] taxonomies = lineage.split(";");
            DefaultMutableTreeNode parent = this.searchNode(taxonomyName);
            for (String taxonomy : taxonomies) {
                taxonomy = taxonomy.trim();
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(taxonomy);
                try {
                    this.model.insertNodeInto(node, parent, parent.getChildCount());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        return this.model;
    }

    private DefaultMutableTreeNode searchNode(String nodeStr) {
        Enumeration<TreeNode> e = rootNode.breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!nodeStr.equals(node.getUserObject().toString())) continue;
            return node;
        }
        return null;
    }

    public String getCachedTaxonomyID(String taxonomyName) {
        return this.cachedTaxonomies.get(taxonomyName);
    }

    public String queryTaxonomy(String queryTerm, boolean returnID) throws MalformedURLException, IOException {
        String url = ConnectionManager.getUniprotHost() + "taxonomy/?query=" + queryTerm + "&sort=score&format=tab";
        URL website = new URL(url);
        String taxName = "";
        String taxID = "";
        URLConnection connection = website.openConnection();
        HashMap<String, String> tempTaxIdMap = new HashMap<String, String>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            in.readLine();
            String inputLine = in.readLine();
            if (inputLine != null) {
                String[] split = inputLine.split("\t");
                taxName = split[2];
                taxID = split[0];
                tempTaxIdMap.put(taxName, taxID);
            }
            if (!taxName.isEmpty() && !taxID.isEmpty()) {
                this.cachedTaxonomies.put(taxName, taxID);
            }
        }
        catch (ArrayIndexOutOfBoundsException in) {
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        if (returnID) {
            return taxID;
        }
        return taxName;
    }
}

