/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi;

import java.io.File;
import java.util.Iterator;
import uk.ac.ebi.jmzidml.MzIdentMLElement;
import uk.ac.ebi.jmzidml.model.mzidml.ProteinAmbiguityGroup;
import uk.ac.ebi.jmzidml.xml.io.MzIdentMLUnmarshaller;

public class JmzIdentMLParser {
    public static void main(String[] args) {
        try {
            File file = new File(args[0]);
            System.out.println("mzIdentML file: " + file.getAbsolutePath());
            if (file != null) {
                boolean aUseSpectrumCache = true;
                long start = System.currentTimeMillis();
                MzIdentMLUnmarshaller unmarshaller = new MzIdentMLUnmarshaller(file, true);
                System.out.println("mzIdentML ID: " + unmarshaller.getMzIdentMLId());
                System.out.println("mzIdentML name: " + unmarshaller.getMzIdentMLName());
                System.out.println("mzIdentML version: " + unmarshaller.getMzIdentMLVersion());
                System.out.println("Peptides: " + unmarshaller.getObjectCountForXpath(MzIdentMLElement.Peptide.getXpath()));
                System.out.println("PeptideEvidences: " + unmarshaller.getObjectCountForXpath(MzIdentMLElement.PeptideEvidence.getXpath()));
                System.out.println("ProteinAmbiguityGroups: " + unmarshaller.getObjectCountForXpath(MzIdentMLElement.ProteinAmbiguityGroup.getXpath()));
                Iterator iter = unmarshaller.unmarshalCollectionFromXpath(MzIdentMLElement.ProteinAmbiguityGroup);
                while (iter.hasNext()) {
                    ProteinAmbiguityGroup group = (ProteinAmbiguityGroup)iter.next();
                    System.out.println("ProteinAmbiguityGroup ID" + group.getId());
                }
                long end = System.currentTimeMillis();
                System.out.println("Time to initialise unmarshaller: " + (end - start) + "ms");
            } else {
                System.out.println("FILE NOT FOUND");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

