/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzidml.model.mzidml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import uk.ac.ebi.jmzidml.model.ParamGroupCapable;
import uk.ac.ebi.jmzidml.model.mzidml.AbstractParam;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.DBSequence;
import uk.ac.ebi.jmzidml.model.mzidml.Identifiable;
import uk.ac.ebi.jmzidml.model.mzidml.Peptide;
import uk.ac.ebi.jmzidml.model.mzidml.TranslationTable;
import uk.ac.ebi.jmzidml.model.mzidml.UserParam;
import uk.ac.ebi.jmzidml.model.utils.FacadeList;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PeptideEvidenceType", propOrder={"paramGroup"})
public class PeptideEvidence
extends Identifiable
implements Serializable,
ParamGroupCapable {
    private static final long serialVersionUID = 100L;
    @XmlElements(value={@XmlElement(name="userParam", type=UserParam.class), @XmlElement(name="cvParam", type=CvParam.class)})
    protected List<AbstractParam> paramGroup;
    @XmlAttribute(name="dBSequence_ref", required=true)
    protected String dbSequenceRef;
    @XmlAttribute(name="peptide_ref", required=true)
    protected String peptideRef;
    @XmlAttribute
    protected Integer start;
    @XmlAttribute
    protected Integer end;
    @XmlAttribute
    protected String pre;
    @XmlAttribute
    protected String post;
    @XmlAttribute(name="translationTable_ref")
    protected String translationTableRef;
    @XmlAttribute
    protected Integer frame;
    @XmlAttribute
    protected Boolean isDecoy;
    @XmlTransient
    protected DBSequence dbSequence;
    @XmlTransient
    protected Peptide peptide;
    @XmlTransient
    protected TranslationTable translationTable;

    public Peptide getPeptide() {
        return this.peptide;
    }

    public void setPeptide(Peptide peptide) {
        if (peptide == null) {
            this.peptideRef = null;
        } else {
            String refId = peptide.getId();
            if (refId == null) {
                throw new IllegalArgumentException("Referenced object does not have an identifier.");
            }
            this.peptideRef = refId;
        }
        this.peptide = peptide;
    }

    public DBSequence getDBSequence() {
        return this.dbSequence;
    }

    public void setDBSequence(DBSequence dbSequence) {
        if (dbSequence == null) {
            this.dbSequenceRef = null;
        } else {
            String refId = dbSequence.getId();
            if (refId == null) {
                throw new IllegalArgumentException("Referenced object does not have an identifier.");
            }
            this.dbSequenceRef = refId;
        }
        this.dbSequence = dbSequence;
    }

    public TranslationTable getTranslationTable() {
        return this.translationTable;
    }

    public void setTranslationTable(TranslationTable translationTable) {
        if (translationTable == null) {
            this.translationTableRef = null;
        } else {
            String refId = translationTable.getId();
            if (refId == null) {
                throw new IllegalArgumentException("Referenced object does not have an identifier.");
            }
            this.translationTableRef = refId;
        }
        this.translationTable = translationTable;
    }

    public List<AbstractParam> getParamGroup() {
        if (this.paramGroup == null) {
            this.paramGroup = new ArrayList<AbstractParam>();
        }
        return this.paramGroup;
    }

    public String getDBSequenceRef() {
        return this.dbSequenceRef;
    }

    public String getPeptideRef() {
        return this.peptideRef;
    }

    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer value) {
        this.start = value;
    }

    public Integer getEnd() {
        return this.end;
    }

    public void setEnd(Integer value) {
        this.end = value;
    }

    public String getPre() {
        return this.pre;
    }

    public void setPre(String value) {
        this.pre = value;
    }

    public String getPost() {
        return this.post;
    }

    public void setPost(String value) {
        this.post = value;
    }

    public String getTranslationTableRef() {
        return this.translationTableRef;
    }

    public Integer getFrame() {
        return this.frame;
    }

    public void setFrame(Integer value) {
        this.frame = value;
    }

    public boolean isIsDecoy() {
        if (this.isDecoy == null) {
            return false;
        }
        return this.isDecoy;
    }

    public void setIsDecoy(Boolean value) {
        this.isDecoy = value;
    }

    @Override
    public List<CvParam> getCvParam() {
        return new FacadeList<CvParam>(this.getParamGroup(), CvParam.class);
    }

    @Override
    public List<UserParam> getUserParam() {
        return new FacadeList<UserParam>(this.getParamGroup(), UserParam.class);
    }
}

