/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzidml.model.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import uk.ac.ebi.jmzidml.MzIdentMLElement;
import uk.ac.ebi.jmzidml.model.mzidml.MzIdentML;

public class ModelConstants {
    public static final String PACKAGE = MzIdentML.class.getPackage().getName();
    public static final String MZIDML_NS = "http://psidev.info/psi/pi/mzIdentML/1.1";
    public static final String MZIDML_VERSION = "1.1.0";
    public static final String MZIDML_SCHEMA = "http://www.psidev.info/files/mzIdentML1.1.0.xsd";
    private static Map<Class, QName> modelQNames = new HashMap<Class, QName>();

    public static boolean isRegisteredClass(Class cls) {
        return modelQNames.containsKey(cls);
    }

    public static QName getQNameForClass(Class cls) {
        if (ModelConstants.isRegisteredClass(cls)) {
            return modelQNames.get(cls);
        }
        throw new IllegalStateException("No QName registered for class: " + cls);
    }

    public static String getElementNameForClass(Class cls) {
        if (ModelConstants.isRegisteredClass(cls)) {
            return modelQNames.get(cls).getLocalPart();
        }
        throw new IllegalStateException("No QName registered for class: " + cls);
    }

    public static Class getClassForElementName(String name) {
        for (Map.Entry<Class, QName> entry : modelQNames.entrySet()) {
            if (!entry.getValue().getLocalPart().equals(name)) continue;
            return entry.getKey();
        }
        return null;
    }

    static {
        for (MzIdentMLElement element : MzIdentMLElement.values()) {
            if (element.getTagName() == null) continue;
            modelQNames.put(element.getClazz(), new QName(MZIDML_NS, element.getTagName()));
        }
        modelQNames = Collections.unmodifiableMap(modelQNames);
    }
}

