/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzidml.model.utils;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.jmzidml.model.mzidml.AbstractParam;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.UserParam;

public class ParamUpdater {
    private static void updateAbstractParamProperties(AbstractParam input, AbstractParam newParam) throws NoSuchFieldException, IllegalAccessException {
        if (input == null || newParam == null) {
            throw new IllegalArgumentException("Neither input or newParam can be null");
        }
        Field unitRefField = input.getClass().getSuperclass().getDeclaredField("unitCvRef");
        unitRefField.setAccessible(true);
        unitRefField.set(newParam, input.getUnitCvRef());
    }

    public static <T extends CvParam> T updateCvParamSubclass(CvParam input, Class<T> cvParamSubClass) throws IllegalAccessException, InstantiationException {
        if (input != null) {
            CvParam newParam = (CvParam)cvParamSubClass.newInstance();
            newParam.setAccession(input.getAccession());
            if (input.getCv() != null) {
                newParam.setCv(input.getCv());
            } else {
                try {
                    Class<?> cls = input.getClass();
                    Field cvRefField = cls.getDeclaredField("cvRef");
                    cvRefField.setAccessible(true);
                    cvRefField.set(newParam, input.getCvRef());
                }
                catch (Exception e) {
                    throw new InstantiationError("Unable to create new instance of CvParam subclass due to problem updating cvRef.");
                }
                try {
                    ParamUpdater.updateAbstractParamProperties(input, newParam);
                }
                catch (Exception e) {
                    throw new InstantiationError("Unable to create new instance of CvParam subclass due to problem updating superclass properties.");
                }
            }
            if (input.getUnitCv() != null) {
                newParam.setUnitCv(input.getUnitCv());
            } else if (input.getUnitCvRef() != null) {
                try {
                    Field unitCvRefField = AbstractParam.class.getDeclaredField("unitCvRef");
                    unitCvRefField.setAccessible(true);
                    unitCvRefField.set(newParam, input.getUnitCvRef());
                }
                catch (Exception e) {
                    throw new InstantiationError("Unable to create new instance of CvParam subclass due to problem updating unitCvRef.");
                }
                try {
                    ParamUpdater.updateAbstractParamProperties(input, newParam);
                }
                catch (Exception e) {
                    throw new InstantiationError("Unable to create new instance of CvParam subclass due to problem updating superclass properties.");
                }
            }
            newParam.setName(input.getName());
            newParam.setValue(input.getValue());
            newParam.setUnitAccession(input.getUnitAccession());
            newParam.setUnitName(input.getUnitName());
            return (T)newParam;
        }
        return null;
    }

    public static <T extends CvParam> void updateCvParamSubclassesList(List<CvParam> inputs, Class<T> cvParamSubClass) throws InstantiationException, IllegalAccessException {
        if (inputs != null && inputs.size() > 0) {
            ArrayList<T> newList = new ArrayList<T>();
            for (CvParam cvParam : inputs) {
                newList.add(ParamUpdater.updateCvParamSubclass(cvParam, cvParamSubClass));
            }
            inputs.removeAll(inputs);
            inputs.addAll(newList);
        }
    }

    public static <T extends UserParam> T updateUserParamSubclass(UserParam input, Class<T> userParamSubClass) throws InstantiationException, IllegalAccessException {
        if (input != null) {
            UserParam newParam = (UserParam)userParamSubClass.newInstance();
            try {
                ParamUpdater.updateAbstractParamProperties(input, newParam);
            }
            catch (Exception e) {
                throw new InstantiationException("Unable to create new instance of UserParam subclass due to problem updating superclass properties.");
            }
            newParam.setName(input.getName());
            newParam.setValue(input.getValue());
            newParam.setUnitAccession(input.getUnitAccession());
            newParam.setUnitName(input.getUnitName());
            return (T)newParam;
        }
        return null;
    }

    public static <T extends UserParam> void updateUserParamSubclassesList(List<UserParam> inputs, Class<T> userParamSubClass) throws InstantiationException, IllegalAccessException {
        if (inputs != null && inputs.size() > 0) {
            ArrayList<T> newList = new ArrayList<T>();
            for (UserParam userParam : inputs) {
                newList.add(ParamUpdater.updateUserParamSubclass(userParam, userParamSubClass));
            }
            inputs.removeAll(inputs);
            inputs.addAll(newList);
        }
    }
}

