/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzidml.xml.io;

import com.sun.xml.txw2.output.IndentingXMLStreamWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.log4j.Logger;
import uk.ac.ebi.jmzidml.model.MzIdentMLObject;
import uk.ac.ebi.jmzidml.model.mzidml.MzIdentML;
import uk.ac.ebi.jmzidml.model.utils.ModelConstants;
import uk.ac.ebi.jmzidml.xml.jaxb.marshaller.MarshallerFactory;
import uk.ac.ebi.jmzidml.xml.util.EscapingXMLStreamWriter;

public class MzIdentMLMarshaller {
    private static final Logger logger = Logger.getLogger(MzIdentMLMarshaller.class);

    @Deprecated
    public <T extends MzIdentMLObject> String marshall(T object) {
        return this.marshal(object);
    }

    public <T extends MzIdentMLObject> String marshal(T object) {
        StringWriter sw = new StringWriter();
        this.marshal(object, sw);
        return sw.toString();
    }

    @Deprecated
    public <T extends MzIdentMLObject> void marshall(T object, OutputStream os) {
        this.marshal(object, os);
    }

    public <T extends MzIdentMLObject> void marshal(T object, OutputStream os) {
        this.marshal(object, os, "UTF-8");
    }

    public <T extends MzIdentMLObject> void marshal(T object, OutputStream os, String encoding) {
        try {
            this.marshal(object, new OutputStreamWriter(os, encoding), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Could not set character encoding!");
        }
    }

    @Deprecated
    public <T extends MzIdentMLObject> void marshall(T object, Writer out) {
        this.marshal(object, out);
    }

    public <T extends MzIdentMLObject> void marshal(T object, Writer out) {
        this.marshal(object, out, "UTF-8");
    }

    public <T extends MzIdentMLObject> void marshal(T object, Writer out, String encoding) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot marshall a NULL object");
        }
        try {
            Marshaller marshaller = MarshallerFactory.getInstance().initializeMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)encoding);
            if (!(object instanceof MzIdentML)) {
                marshaller.setProperty("jaxb.fragment", (Object)true);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Object '" + object.getClass().getName() + "' will be treated as root element."));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Object '" + object.getClass().getName() + "' will be treated as fragment."));
            }
            QName aQName = ModelConstants.getQNameForClass(object.getClass());
            JAXBElement jaxbElement = new JAXBElement(aQName, object.getClass(), object);
            XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
            IndentingXMLStreamWriter writer = new IndentingXMLStreamWriter((XMLStreamWriter)new EscapingXMLStreamWriter(xmlStreamWriter, encoding));
            marshaller.marshal((Object)jaxbElement, (XMLStreamWriter)writer);
        }
        catch (JAXBException e) {
            logger.error((Object)"MzMLMarshaller.marshall", (Throwable)e);
            throw new IllegalStateException("Error while marshalling object:" + object.toString());
        }
        catch (XMLStreamException e) {
            logger.error((Object)"MzMLMarshaller.marshall", (Throwable)e);
            throw new IllegalStateException("Error while marshalling object:" + object.toString());
        }
    }

    public String createXmlHeader() {
        String encoding = System.getProperty("file.encoding");
        return "<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>";
    }

    public String createMzIdentMLStartTag(String id) {
        StringBuffer sb = new StringBuffer();
        sb.append("<MzIdentML id=\"").append(id).append("\"");
        sb.append(" version=\"").append("1.1.0").append("\"");
        sb.append(" xmlns=\"").append("http://psidev.info/psi/pi/mzIdentML/1.1").append("\"");
        sb.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        sb.append(" xsi:schemaLocation=\"").append("http://psidev.info/psi/pi/mzIdentML/1.1").append(" ").append("http://www.psidev.info/files/mzIdentML1.1.0.xsd").append("\"");
        SimpleDateFormat dfm = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        sb.append(" creationDate=\"").append(dfm.format(new Date())).append("\"");
        sb.append(" >");
        return sb.toString();
    }

    public String createMzIdentMLClosingTag() {
        return "</MzIdentML>";
    }

    public String createDataCollectionStartTag() {
        return "<DataCollection>";
    }

    public String createDataCollectionClosingTag() {
        return "</DataCollection>";
    }

    public String createAnalysisDataStartTag() {
        return "<AnalysisData>";
    }

    public String createAnalysisDataClosingTag() {
        return "</AnalysisData>";
    }

    public String createProteinDetectionListStartTag(String id, String name) {
        if (id == null) {
            throw new IllegalArgumentException("The 'id' attribute must not be null!");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<ProteinDetectionList id=\"").append(id).append("\"");
        if (name != null) {
            sb.append(" name=\"").append(name).append("\"");
        }
        sb.append(" >");
        return sb.toString();
    }

    public String createProteinDetectionListClosingTag() {
        return "</ProteinDetectionList>";
    }

    public String createSpectrumIdentificationListStartTag(String id, String name, Long numSeqSearched) {
        if (id == null) {
            throw new IllegalArgumentException("The 'id' attribute must not be null!");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<SpectrumIdentificationList id=\"").append(id).append("\"");
        if (name != null) {
            sb.append(" name=\"").append(name).append("\"");
        }
        if (numSeqSearched != null) {
            sb.append(" numSequencesSearched=\"").append(numSeqSearched).append("\"");
        }
        sb.append(" >");
        return sb.toString();
    }

    public String createSpectrumIdentificationListClosingTag() {
        return "</SpectrumIdentificationList>";
    }
}

