/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzidml.xml.jaxb.unmarshaller.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.jmzidml.MzIdentMLElement;
import uk.ac.ebi.jmzidml.model.IdentifiableMzIdentMLObject;
import uk.ac.ebi.jmzidml.model.MzIdentMLObject;
import uk.ac.ebi.jmzidml.xml.io.MzIdentMLObjectCache;

public class AdapterObjectCache
implements MzIdentMLObjectCache {
    private HashMap<Class, HashMap<String, MzIdentMLObject>> cache = new HashMap();

    @Override
    public void putInCache(String id, MzIdentMLObject object) {
        Class<?> cls = object.getClass();
        MzIdentMLElement element = MzIdentMLElement.getType(cls);
        if (element.isCached()) {
            HashMap<String, MzIdentMLObject> classCache = this.cache.get(cls);
            if (classCache == null) {
                classCache = new HashMap();
                this.cache.put(cls, classCache);
            }
            System.out.println("Element put in cache: " + object);
            classCache.put(id, object);
        }
    }

    @Override
    public void putInCache(IdentifiableMzIdentMLObject element) {
    }

    @Override
    public <T extends MzIdentMLObject> T getCachedObject(String id, Class<T> cls) {
        Map classCache = this.cache.get(cls);
        if (classCache == null) {
            return null;
        }
        MzIdentMLObject o = (MzIdentMLObject)classCache.get(id);
        return (T)o;
    }

    @Override
    public <T extends MzIdentMLObject> boolean hasEntry(Class<T> clazz) {
        HashMap<String, MzIdentMLObject> map = this.cache.get(clazz);
        return map != null && map.size() > 0;
    }

    @Override
    public <T extends MzIdentMLObject> List<T> getEntries(Class<T> clazz) {
        HashMap<String, MzIdentMLObject> map = this.cache.get(clazz);
        if (map == null) {
            return null;
        }
        ArrayList<MzIdentMLObject> retVal = new ArrayList<MzIdentMLObject>();
        for (MzIdentMLObject value : map.values()) {
            retVal.add(value);
        }
        return retVal;
    }
}

