/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzidml.xml.xxindex;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.tools.xxindex.index.IndexElement;

public class MemoryMappedXmlElementExtractor {
    private static final Log log = LogFactory.getLog(MemoryMappedXmlElementExtractor.class);
    protected static final Pattern xmlHeader = Pattern.compile(".*<\\?xml.+\\?>.*", 32);
    protected static final Pattern xmlEnc = Pattern.compile(".*encoding\\s*=\\s*[\"']([A-Za-z]([A-Za-z0-9._]|[-])*)[\"'](.*)", 32);
    private boolean useSystemDefaultEncoding;
    private Charset encoding;

    public MemoryMappedXmlElementExtractor() {
        this.setUseSystemDefaultEncoding(false);
        this.setEncoding(Charset.forName("ASCII"));
    }

    public MemoryMappedXmlElementExtractor(Charset encoding) {
        this();
        this.setEncoding(encoding);
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    public void setEncoding(Charset encoding) {
        this.encoding = encoding;
    }

    public int setEncoding(String encoding) {
        int result;
        try {
            this.encoding = Charset.forName(encoding);
            result = 0;
        }
        catch (IllegalCharsetNameException icne) {
            log.error((Object)("Illegal encoding: " + encoding), (Throwable)icne);
            result = -1;
        }
        catch (UnsupportedCharsetException ucne) {
            log.error((Object)("Unsupported encoding: " + encoding), (Throwable)ucne);
            result = -2;
        }
        return result;
    }

    public boolean isUseSystemDefaultEncoding() {
        return this.useSystemDefaultEncoding;
    }

    public void setUseSystemDefaultEncoding(boolean useSystemDefaultEncoding) {
        this.useSystemDefaultEncoding = useSystemDefaultEncoding;
    }

    public String readString(IndexElement br, InputStream inputStream) throws IOException {
        return this.readString(br.getStart(), br.getStop(), inputStream);
    }

    public byte[] readBytes(long from, long to, InputStream inputStream) throws IOException {
        Long length = to - from;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Can not read more than 2147483647 bytes!");
        }
        byte[] bytes = new byte[length.intValue()];
        inputStream.skip(from);
        inputStream.read(bytes, 0, length.intValue());
        return bytes;
    }

    public String readString(long from, long to, InputStream inputStream) throws IOException {
        byte[] bytes = this.readBytes(from, to, inputStream);
        byte[] newBytes = this.removeZeroBytes(bytes);
        return this.bytes2String(newBytes);
    }

    public String detectFileEncoding(InputStream inputStream) throws IOException {
        return this.detectFileEncoding(inputStream, 1000);
    }

    public String detectFileEncoding(InputStream inputStream, int maxReadLength) throws IOException {
        int length = inputStream.available();
        byte[] bytes = length > maxReadLength ? new byte[maxReadLength] : new byte[length];
        inputStream.read(bytes);
        String fileStart = new String(bytes, "ASCII");
        Matcher mHead = xmlHeader.matcher(fileStart);
        if (!mHead.matches()) {
            log.debug((Object)"No XML header found for input");
            return null;
        }
        Matcher mEnc = xmlEnc.matcher(fileStart);
        if (!mEnc.matches()) {
            return null;
        }
        if (mEnc.groupCount() < 1) {
            return null;
        }
        String charsetName = mEnc.group(1);
        log.debug((Object)("Detected charset " + charsetName + " for input"));
        return charsetName;
    }

    public byte[] removeZeroBytes(byte[] bytes) {
        byte[] result;
        byte[] temp = new byte[bytes.length];
        int count = 0;
        for (byte aByte : bytes) {
            if (aByte == 0) continue;
            temp[count] = aByte;
            ++count;
        }
        if (count != bytes.length) {
            result = new byte[count];
            System.arraycopy(temp, 0, result, 0, count);
        } else {
            result = temp;
        }
        return result;
    }

    public String bytes2String(byte[] bytes) throws UnsupportedEncodingException {
        if (this.isUseSystemDefaultEncoding()) {
            if (log.isDebugEnabled()) {
                log.info((Object)"Using system default for encoding.");
            }
            return new String(bytes);
        }
        if (this.getEncoding() == null) {
            throw new IllegalStateException("No character encoding available to convert the byte array!");
        }
        return new String(bytes, this.getEncoding().name());
    }
}

