/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzml.model.mzml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import uk.ac.ebi.jmzml.model.mzml.CV;
import uk.ac.ebi.jmzml.model.mzml.CVParam;
import uk.ac.ebi.jmzml.model.mzml.DataProcessing;
import uk.ac.ebi.jmzml.model.mzml.ParamGroup;
import uk.ac.ebi.jmzml.model.mzml.params.BinaryDataArrayCVParam;
import uk.ac.ebi.jmzml.xml.jaxb.adapters.IdRefAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="BinaryDataArrayType", propOrder={"binary"})
public class BinaryDataArray
extends ParamGroup
implements Serializable {
    public static final int BYTES_64_PRECISION = 8;
    public static final int BYTES_32_PRECISION = 4;
    public static final String MS_COMPRESSED_AC = "MS:1000574";
    public static final String MS_COMPRESSED_NAME = "zlib compression";
    public static final String MS_UNCOMPRESSED_AC = "MS:1000576";
    public static final String MS_UNCOMPRESSED_NAME = "no compression";
    public static final String MS_FLOAT32BIT_AC = "MS:1000521";
    public static final String MS_FLOAT32BIT_NAME = "32-bit float";
    public static final String MS_FLOAT64BIT_AC = "MS:1000523";
    public static final String MS_FLOAT64BIT_NAME = "64-bit float";
    public static final String MS_INT32BIT_AC = "MS:1000519";
    public static final String MS_INT32BIT_NAME = "32-bit integer";
    public static final String MS_INT64BIT_AC = "MS:1000522";
    public static final String MS_INT64BIT_NAME = "64-bit integer";
    public static final String MS_NTSTRING_AC = "MS:1001479";
    public static final String MS_NTSTRING_NAME = "null-terminated ASCII string";
    private static final long serialVersionUID = 100L;
    @XmlElement(required=true)
    protected byte[] binary;
    @XmlAttribute
    @XmlSchemaType(name="nonNegativeInteger")
    protected Integer arrayLength;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=IdRefAdapter.class)
    @XmlSchemaType(name="IDREF")
    protected String dataProcessingRef;
    @XmlTransient
    private DataProcessing dataProcessing;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="nonNegativeInteger")
    protected Integer encodedLength;

    public byte[] getBinary() {
        return this.binary;
    }

    public void setBinary(byte[] value) {
        this.binary = value;
    }

    public Integer getArrayLength() {
        return this.arrayLength;
    }

    public void setArrayLength(Integer value) {
        this.arrayLength = value;
    }

    public String getDataProcessingRef() {
        return this.dataProcessingRef;
    }

    public void setDataProcessingRef(String value) {
        this.dataProcessingRef = value;
    }

    public DataProcessing getDataProcessing() {
        return this.dataProcessing;
    }

    public void setDataProcessing(DataProcessing dataProcessing) {
        this.dataProcessing = dataProcessing;
        if (dataProcessing != null) {
            this.dataProcessingRef = dataProcessing.getId();
        }
    }

    public Integer getEncodedLength() {
        return this.encodedLength;
    }

    public void setEncodedLength(Integer value) {
        this.encodedLength = value;
    }

    public Number[] getBinaryDataAsNumberArray() {
        Number[] dataArray;
        byte[] data = this.needsUncompressing() ? this.decompress(this.binary) : this.binary;
        switch (this.getPrecision()) {
            case FLOAT64BIT: {
                dataArray = this.convertData(data, Precision.FLOAT64BIT);
                break;
            }
            case FLOAT32BIT: {
                dataArray = this.convertData(data, Precision.FLOAT32BIT);
                break;
            }
            case INT64BIT: {
                dataArray = this.convertData(data, Precision.INT64BIT);
                break;
            }
            case INT32BIT: {
                dataArray = this.convertData(data, Precision.INT32BIT);
                break;
            }
            case NTSTRING: {
                throw new IllegalArgumentException("Precision " + (Object)((Object)Precision.NTSTRING) + " is not supported in this method!");
            }
            default: {
                throw new IllegalStateException("Not supported Precision in BinaryDataArray: " + (Object)((Object)this.getPrecision()));
            }
        }
        return dataArray;
    }

    public String getBinaryDataAsString() throws UnsupportedEncodingException {
        if (this.getPrecision() != Precision.NTSTRING) {
            throw new IllegalStateException("This method has to be used with data according to Precision " + (Object)((Object)Precision.NTSTRING) + "!");
        }
        byte[] data = this.needsUncompressing() ? this.decompress(this.binary) : this.binary;
        byte[] stringData = new byte[data.length - 1];
        System.arraycopy(data, 0, stringData, 0, stringData.length);
        return new String(stringData, "ASCII");
    }

    public int set64BitFloatArrayAsBinaryData(double[] value, boolean compress, CV cv) {
        ByteBuffer buffer = ByteBuffer.allocate(value.length * 8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (double aDoubleArray : value) {
            buffer.putDouble(aDoubleArray);
        }
        byte[] data = buffer.array();
        int dataLength = data.length;
        this.setBinaryData(data, compress, cv);
        BinaryDataArrayCVParam cvParam = new BinaryDataArrayCVParam();
        cvParam.setAccession(MS_FLOAT64BIT_AC);
        cvParam.setName(MS_FLOAT64BIT_NAME);
        cvParam.setCv(cv);
        this.getCvParam().add(cvParam);
        return dataLength;
    }

    public int set32BitFloatArrayAsBinaryData(float[] value, boolean compress, CV cv) {
        ByteBuffer buffer = ByteBuffer.allocate(value.length * 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (float aFloatArray : value) {
            buffer.putFloat(aFloatArray);
        }
        byte[] data = buffer.array();
        int dataLength = data.length;
        this.setBinaryData(data, compress, cv);
        BinaryDataArrayCVParam cvParam = new BinaryDataArrayCVParam();
        cvParam.setAccession(MS_FLOAT32BIT_AC);
        cvParam.setName(MS_FLOAT32BIT_NAME);
        cvParam.setCv(cv);
        this.getCvParam().add(cvParam);
        return dataLength;
    }

    public int set32BitIntArrayAsBinaryData(int[] array, boolean compress, CV cv) {
        ByteBuffer buffer = ByteBuffer.allocate(array.length * 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (int aIntValue : array) {
            buffer.putInt(aIntValue);
        }
        byte[] data = buffer.array();
        int dataLength = data.length;
        this.setBinaryData(data, compress, cv);
        BinaryDataArrayCVParam cvParam = new BinaryDataArrayCVParam();
        cvParam.setAccession(MS_INT32BIT_AC);
        cvParam.setName(MS_INT32BIT_NAME);
        cvParam.setCv(cv);
        this.getCvParam().add(cvParam);
        return dataLength;
    }

    public int set64BitIntArrayAsBinaryData(long[] array, boolean compress, CV cv) {
        ByteBuffer buffer = ByteBuffer.allocate(array.length * 8);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        for (long aIntValue : array) {
            buffer.putLong(aIntValue);
        }
        byte[] data = buffer.array();
        int dataLength = data.length;
        this.setBinaryData(data, compress, cv);
        BinaryDataArrayCVParam cvParam = new BinaryDataArrayCVParam();
        cvParam.setAccession(MS_INT64BIT_AC);
        cvParam.setName(MS_INT64BIT_NAME);
        cvParam.setCv(cv);
        this.getCvParam().add(cvParam);
        return dataLength;
    }

    public int setStringAsBinaryData(String value, boolean compress, CV cv) throws UnsupportedEncodingException {
        byte[] tmp = value.getBytes("ASCII");
        byte[] data = new byte[tmp.length + 1];
        System.arraycopy(tmp, 0, data, 0, tmp.length);
        data[data.length - 1] = 0;
        int dataLength = data.length;
        this.setBinaryData(data, compress, cv);
        BinaryDataArrayCVParam cvParam = new BinaryDataArrayCVParam();
        cvParam.setAccession(MS_NTSTRING_AC);
        cvParam.setName(MS_NTSTRING_NAME);
        cvParam.setCv(cv);
        this.getCvParam().add(cvParam);
        return dataLength;
    }

    public int setNumberArrayAsBinaryData(Number[] array, Precision p, boolean compress, CV cv) {
        int size;
        switch (p) {
            case FLOAT32BIT: {
                size = this.set32BitFloatArrayAsBinaryData(this.convertNumberToFloatArray(array), compress, cv);
                break;
            }
            case FLOAT64BIT: {
                size = this.set64BitFloatArrayAsBinaryData(this.convertNumberToDoubleArray(array), compress, cv);
                break;
            }
            case INT32BIT: {
                size = this.set32BitIntArrayAsBinaryData(this.convertNumberToIntArray(array), compress, cv);
                break;
            }
            case INT64BIT: {
                size = this.set64BitIntArrayAsBinaryData(this.convertNumberToLongArray(array), compress, cv);
                break;
            }
            case NTSTRING: {
                throw new IllegalArgumentException("Precision " + (Object)((Object)Precision.NTSTRING) + " is not supported in this method!");
            }
            default: {
                throw new IllegalStateException("Not supported Precision in BinaryDataArray: " + (Object)((Object)p));
            }
        }
        return size;
    }

    public Precision getPrecision() {
        Precision p;
        ArrayList<String> cvs2 = new ArrayList<String>();
        for (CVParam param : this.getCvParam()) {
            cvs2.add(param.getAccession());
        }
        if (cvs2.contains(MS_FLOAT64BIT_AC)) {
            p = Precision.FLOAT64BIT;
        } else if (cvs2.contains(MS_FLOAT32BIT_AC)) {
            p = Precision.FLOAT32BIT;
        } else if (cvs2.contains(MS_INT64BIT_AC)) {
            p = Precision.INT64BIT;
        } else if (cvs2.contains(MS_INT32BIT_AC)) {
            p = Precision.INT32BIT;
        } else if (cvs2.contains(MS_NTSTRING_AC)) {
            p = Precision.NTSTRING;
        } else {
            throw new IllegalStateException("Required precision CV parameter ('64-bit float' or '32-bit float' or '64-bit integer' or '32-bit integer' or 'null-terminated ASCII string') not found in BinaryDataArray!");
        }
        return p;
    }

    public boolean needsUncompressing() {
        boolean uncompress;
        ArrayList<String> cvs = new ArrayList<String>();
        for (CVParam param : this.getCvParam()) {
            cvs.add(param.getAccession());
        }
        if (cvs.contains(MS_COMPRESSED_AC)) {
            uncompress = true;
        } else if (cvs.contains(MS_UNCOMPRESSED_AC)) {
            uncompress = false;
        } else {
            throw new IllegalStateException("Required compression CV parameter ('zlib compression' or 'no compression') not found in BinaryDataArray!");
        }
        return uncompress;
    }

    private Number[] convertData(byte[] data, Precision prec) {
        int step;
        switch (prec) {
            case FLOAT64BIT: 
            case INT64BIT: {
                step = 8;
                break;
            }
            case FLOAT32BIT: 
            case INT32BIT: {
                step = 4;
                break;
            }
            default: {
                step = -1;
            }
        }
        Number[] resultArray = new Number[data.length / step];
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        for (int indexOut = 0; indexOut < data.length; indexOut += step) {
            Number num;
            switch (prec) {
                case FLOAT64BIT: {
                    num = bb.getDouble(indexOut);
                    break;
                }
                case INT64BIT: {
                    num = bb.getLong(indexOut);
                    break;
                }
                case FLOAT32BIT: {
                    num = Float.valueOf(bb.getFloat(indexOut));
                    break;
                }
                case INT32BIT: {
                    num = bb.getInt(indexOut);
                    break;
                }
                default: {
                    num = null;
                }
            }
            resultArray[indexOut / step] = num;
        }
        return resultArray;
    }

    private byte[] decompress(byte[] compressedData) {
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressedData);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(compressedData.length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (DataFormatException e) {
                throw new IllegalStateException("Encountered wrong data format while trying to decompress binary data!", e);
            }
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] decompressedData = bos.toByteArray();
        if (decompressedData == null) {
            throw new IllegalStateException("Decompression of binary data prodeuced no result (null)!");
        }
        return decompressedData;
    }

    private byte[] compress(byte[] uncompressedData) {
        byte[] temp = new byte[uncompressedData.length];
        Deflater compresser = new Deflater();
        compresser.setInput(uncompressedData);
        compresser.finish();
        int cdl = compresser.deflate(temp);
        byte[] data = new byte[cdl];
        System.arraycopy(temp, 0, data, 0, cdl);
        return data;
    }

    private double[] convertNumberToDoubleArray(Number[] array) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].doubleValue();
        }
        return result;
    }

    private float[] convertNumberToFloatArray(Number[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].floatValue();
        }
        return result;
    }

    private int[] convertNumberToIntArray(Number[] array) {
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].intValue();
        }
        return result;
    }

    private long[] convertNumberToLongArray(Number[] array) {
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].longValue();
        }
        return result;
    }

    private void setBinaryData(byte[] input, boolean compress, CV cv) {
        byte[] output;
        if (compress) {
            output = this.compress(input);
            BinaryDataArrayCVParam cvParam = new BinaryDataArrayCVParam();
            cvParam.setAccession(MS_COMPRESSED_AC);
            cvParam.setName(MS_COMPRESSED_NAME);
            cvParam.setCv(cv);
            this.getCvParam().add(cvParam);
        } else {
            output = input;
            BinaryDataArrayCVParam cvParam = new BinaryDataArrayCVParam();
            cvParam.setAccession(MS_UNCOMPRESSED_AC);
            cvParam.setName(MS_UNCOMPRESSED_NAME);
            cvParam.setCv(cv);
            this.getCvParam().add(cvParam);
        }
        this.setBinary(output);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Precision {
        FLOAT32BIT,
        FLOAT64BIT,
        INT32BIT,
        INT64BIT,
        NTSTRING;

    }
}

