/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzml.model.mzml.utilities;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ebi.jmzml.model.mzml.CVParam;
import uk.ac.ebi.jmzml.model.mzml.ParamGroup;
import uk.ac.ebi.jmzml.model.mzml.ReferenceableParamGroupRef;
import uk.ac.ebi.jmzml.model.mzml.UserParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamGroupUpdater {
    public static void updateParamGroupSubclasses(ParamGroup input, Class cvParamClass, Class userParamClass) throws IllegalAccessException, InstantiationException {
        if (input != null) {
            List<CVParam> cvList = input.getCvParam();
            List<UserParam> userList = input.getUserParam();
            List<ReferenceableParamGroupRef> refParams = input.getReferenceableParamGroupRef();
            for (ReferenceableParamGroupRef refParam : refParams) {
                List<CVParam> inferredCVParams = refParam.getReferenceableParamGroup().getCvParam();
                for (CVParam inferredCVParam : inferredCVParams) {
                    inferredCVParam.setInferredFromReferenceableParamGroupRef(true);
                    cvList.add(inferredCVParam);
                }
                List<UserParam> inferredUserParams = refParam.getReferenceableParamGroup().getUserParam();
                for (UserParam inferredUserParam : inferredUserParams) {
                    inferredUserParam.setInferredFromReferenceableParamGroupRef(true);
                    userList.add(inferredUserParam);
                }
            }
            if (cvList != null) {
                ParamGroupUpdater.updateCVParamSubclasses(input.getCvParam(), cvParamClass);
            }
            if (userList != null) {
                ParamGroupUpdater.updateUserParamSubclasses(input.getUserParam(), userParamClass);
            }
        }
    }

    private static void updateUserParamSubclasses(List<UserParam> input, Class userParamClass) throws IllegalAccessException, InstantiationException {
        if (input != null && !input.isEmpty()) {
            ArrayList<UserParam> newList = new ArrayList<UserParam>();
            for (UserParam param : input) {
                UserParam newParam = (UserParam)userParamClass.newInstance();
                newParam.setType(param.getType());
                newParam.setName(param.getName());
                newParam.setValue(param.getValue());
                newParam.setInferredFromReferenceableParamGroupRef(param.isInferredFromReferenceableParamGroupRef());
                newList.add(newParam);
            }
            input.clear();
            input.addAll(newList);
        }
    }

    public static void updateCVParamSubclasses(List<CVParam> input, Class cvParamClass) throws IllegalAccessException, InstantiationException {
        if (input != null && !input.isEmpty()) {
            ArrayList<CVParam> newList = new ArrayList<CVParam>();
            for (CVParam param : input) {
                CVParam newParam = (CVParam)cvParamClass.newInstance();
                newParam.setAccession(param.getAccession());
                newParam.setCvRef(param.getCvRef());
                newParam.setName(param.getName());
                newParam.setUnitAccession(param.getUnitAccession());
                newParam.setUnitCvRef(param.getUnitCvRef());
                newParam.setUnitName(param.getUnitName());
                newParam.setValue(param.getValue());
                newParam.setInferredFromReferenceableParamGroupRef(param.isInferredFromReferenceableParamGroupRef());
                newList.add(newParam);
            }
            input.clear();
            input.addAll(newList);
        }
    }
}

