/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzml.xml.io;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import uk.ac.ebi.jmzml.model.mzml.MzML;
import uk.ac.ebi.jmzml.model.mzml.MzMLObject;
import uk.ac.ebi.jmzml.model.mzml.utilities.ModelConstants;
import uk.ac.ebi.jmzml.xml.jaxb.marshaller.MarshallerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MzMLMarshaller {
    private static final Logger logger = Logger.getLogger(MzMLMarshaller.class);

    public <T extends MzMLObject> String marshall(T object) {
        StringWriter sw = new StringWriter();
        this.marshall(object, sw);
        return sw.toString();
    }

    public <T extends MzMLObject> void marshall(T object, OutputStream os) {
        this.marshall(object, new OutputStreamWriter(os));
    }

    public <T extends MzMLObject> void marshall(T object, Writer out) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot marshall a NULL object");
        }
        try {
            Marshaller marshaller = MarshallerFactory.getInstance().initializeMarshaller();
            if (!(object instanceof MzML)) {
                marshaller.setProperty("jaxb.fragment", (Object)true);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Object '" + object.getClass().getName() + "' will be treated as root element."));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("Object '" + object.getClass().getName() + "' will be treated as fragment."));
            }
            QName aQName = ModelConstants.getQNameForClass(object.getClass());
            marshaller.marshal((Object)new JAXBElement(aQName, object.getClass(), object), out);
        }
        catch (JAXBException e) {
            logger.error((Object)"MzMLMarshaller.marshall", (Throwable)e);
            throw new IllegalStateException("Error while marshalling object:" + object.toString());
        }
    }
}

