/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzml.xml.io;

import java.io.StringReader;
import java.util.Iterator;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import uk.ac.ebi.jmzml.model.mzml.MzMLObject;
import uk.ac.ebi.jmzml.xml.io.MzMLObjectCache;
import uk.ac.ebi.jmzml.xml.jaxb.unmarshaller.UnmarshallerFactory;
import uk.ac.ebi.jmzml.xml.jaxb.unmarshaller.filters.MzMLNamespaceFilter;
import uk.ac.ebi.jmzml.xml.xxindex.MzMLIndexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MzMLObjectIterator<X extends MzMLObject>
implements Iterator<X> {
    private static Logger logger = Logger.getLogger(MzMLObjectIterator.class);
    private MzMLIndexer index;
    private Iterator<String> innerXpathIterator;
    private String xpath;
    private Class cls;
    private MzMLObjectCache cache;
    private boolean useSpectrumCache = true;

    MzMLObjectIterator(String xpath, Class cls, MzMLIndexer index, MzMLObjectCache cache) {
        this(xpath, cls, index, cache, true);
    }

    MzMLObjectIterator(String xpath, Class cls, MzMLIndexer index, MzMLObjectCache cache, boolean aUseSpectrumCache) {
        this.innerXpathIterator = index.getXmlStringIterator(xpath);
        this.xpath = xpath;
        this.cls = cls;
        this.index = index;
        this.cache = cache;
        this.useSpectrumCache = aUseSpectrumCache;
    }

    @Override
    public boolean hasNext() {
        return this.innerXpathIterator.hasNext();
    }

    @Override
    public X next() {
        try {
            String xmlSt = this.innerXpathIterator.next();
            if (logger.isDebugEnabled()) {
                logger.trace((Object)("XML to unmarshal: " + xmlSt));
            }
            MzMLNamespaceFilter xmlFilter = new MzMLNamespaceFilter();
            Unmarshaller unmarshaller = UnmarshallerFactory.getInstance().initializeUnmarshaller(this.index, xmlFilter, this.cache, this.useSpectrumCache);
            JAXBElement holder = unmarshaller.unmarshal((Source)new SAXSource(xmlFilter, new InputSource(new StringReader(xmlSt))), this.cls);
            MzMLObject retval = (MzMLObject)holder.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("unmarshalled object = " + retval));
            }
            return (X)retval;
        }
        catch (JAXBException e) {
            logger.error((Object)"MzMLObjectIterator.next", (Throwable)e);
            throw new IllegalStateException("Could not unmarshal object at xpath:" + this.xpath);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException(MzMLObjectIterator.class.getName() + " can't be used to remove objects while iterating");
    }
}

