/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzml.xml.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import psidev.psi.tools.xxindex.index.IndexElement;
import uk.ac.ebi.jmzml.MzMLElement;
import uk.ac.ebi.jmzml.model.mzml.Chromatogram;
import uk.ac.ebi.jmzml.model.mzml.Index;
import uk.ac.ebi.jmzml.model.mzml.IndexList;
import uk.ac.ebi.jmzml.model.mzml.MzML;
import uk.ac.ebi.jmzml.model.mzml.MzMLObject;
import uk.ac.ebi.jmzml.model.mzml.Offset;
import uk.ac.ebi.jmzml.model.mzml.Spectrum;
import uk.ac.ebi.jmzml.model.mzml.utilities.ModelConstants;
import uk.ac.ebi.jmzml.xml.io.MzMLObjectCache;
import uk.ac.ebi.jmzml.xml.io.MzMLObjectIterator;
import uk.ac.ebi.jmzml.xml.io.MzMLUnmarshallerException;
import uk.ac.ebi.jmzml.xml.jaxb.unmarshaller.UnmarshallerFactory;
import uk.ac.ebi.jmzml.xml.jaxb.unmarshaller.filters.MzMLNamespaceFilter;
import uk.ac.ebi.jmzml.xml.xxindex.FileUtils;
import uk.ac.ebi.jmzml.xml.xxindex.MzMLIndexer;
import uk.ac.ebi.jmzml.xml.xxindex.MzMLIndexerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MzMLUnmarshaller {
    private static final Logger logger = Logger.getLogger(MzMLUnmarshaller.class);
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private final File mzMLFile;
    private final MzMLIndexer index;
    private final boolean useSpectrumCache;
    private final MzMLObjectCache cache;
    private IndexList indexList = null;
    private boolean fileCorrupted = false;
    private final Pattern ID_PATTERN = Pattern.compile("id *= *\"([^\"]*)?\"", 2);
    private final Pattern AC_PATTERN = Pattern.compile("accession *= *\"([^\"]*)?\"", 2);
    private final Pattern VERSION_PATTERN = Pattern.compile("version *= *\"([^\"]*)?\"", 2);
    private static final Pattern XML_ATT_PATTERN = Pattern.compile("\\s+([A-Za-z:]+)\\s*=\\s*[\"']([^\"'>]+?)[\"']", 32);

    public MzMLUnmarshaller(URL mzMLFileURL) {
        this(mzMLFileURL, true);
    }

    public MzMLUnmarshaller(File mzMLFile) {
        this(mzMLFile, true, null);
    }

    public MzMLUnmarshaller(URL mzMLFileURL, boolean aUseSpectrumCache) {
        this(FileUtils.getFileFromURL(mzMLFileURL), aUseSpectrumCache, null);
    }

    public MzMLUnmarshaller(File mzMLFile, boolean aUseSpectrumCache, MzMLObjectCache cache) {
        this.mzMLFile = mzMLFile;
        this.index = MzMLIndexerFactory.getInstance().buildIndex(mzMLFile);
        this.useSpectrumCache = aUseSpectrumCache;
        this.cache = cache;
    }

    public MzML unmarshall() {
        return (MzML)this.unmarshalFromXpath("", MzML.class);
    }

    public String getMzMLVersion() {
        Matcher match = this.VERSION_PATTERN.matcher(this.index.getMzMLAttributeXMLString());
        if (match.find()) {
            return match.group(1);
        }
        return null;
    }

    public String getMzMLAccession() {
        Matcher match = this.AC_PATTERN.matcher(this.index.getMzMLAttributeXMLString());
        if (match.find()) {
            return match.group(1);
        }
        return null;
    }

    public String getMzMLId() {
        Matcher match = this.ID_PATTERN.matcher(this.index.getMzMLAttributeXMLString());
        if (match.find()) {
            return match.group(1);
        }
        return null;
    }

    public Map<String, String> getSingleElementAttributes(String xpath) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        String tag = this.index.getStartTag(xpath);
        if (tag == null) {
            return null;
        }
        Matcher match = XML_ATT_PATTERN.matcher(tag);
        while (match.find()) {
            if (match.groupCount() == 2) {
                String name = match.group(1);
                String value = match.group(2);
                attributes.put(name, value);
                continue;
            }
            System.out.println("Unexpected number of groups for XML attribute: " + match.groupCount() + " in tag: " + tag);
        }
        return attributes;
    }

    public Map<String, String> getElementAttributes(String id, Class clazz) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        String tag = this.index.getStartTag(id, clazz);
        if (tag == null) {
            return null;
        }
        Matcher match = XML_ATT_PATTERN.matcher(tag);
        while (match.find()) {
            if (match.groupCount() == 2) {
                String name = match.group(1);
                String value = match.group(2);
                attributes.put(name, value);
                continue;
            }
            System.out.println("Unexpected number of groups for XML attribute: " + match.groupCount() + " in tag: " + tag);
        }
        return attributes;
    }

    public int getObjectCountForXpath(String xpath) {
        return this.index.getCount(xpath);
    }

    public <T extends MzMLObject> T unmarshalFromXpath(String xpath, Class cls) {
        MzMLObject retval = null;
        try {
            Iterator<String> xpathIter;
            if (xpath.equals("")) {
                xpath = MzMLElement.MzML.getXpath();
                if (this.isIndexedmzML()) {
                    xpath = MzMLElement.IndexedmzML.getXpath().concat(xpath);
                }
            }
            if ((xpathIter = this.index.getXmlStringIterator(xpath)).hasNext()) {
                String xmlSt = xpathIter.next();
                if (logger.isDebugEnabled()) {
                    logger.trace((Object)("XML to unmarshal: " + xmlSt));
                }
                MzMLNamespaceFilter xmlFilter = new MzMLNamespaceFilter();
                Unmarshaller unmarshaller = UnmarshallerFactory.getInstance().initializeUnmarshaller(this.index, xmlFilter, this.cache, this.useSpectrumCache);
                JAXBElement holder = unmarshaller.unmarshal((Source)new SAXSource(xmlFilter, new InputSource(new StringReader(xmlSt))), cls);
                retval = (MzMLObject)holder.getValue();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("unmarshalled object = " + retval));
                }
            }
        }
        catch (JAXBException e) {
            logger.error((Object)"MzMLUnmarshaller.unmarshalFromXpath", (Throwable)e);
            throw new IllegalStateException("Could not unmarshal object at xpath:" + xpath);
        }
        return (T)retval;
    }

    public <T extends MzMLObject> MzMLObjectIterator<T> unmarshalCollectionFromXpath(String xpath, Class cls) {
        return new MzMLObjectIterator(xpath, cls, this.index, this.cache, this.useSpectrumCache);
    }

    public boolean isIndexedmzML() {
        Iterator<String> iter = this.index.getXmlStringIterator("/indexedmzML/indexList");
        return iter.hasNext();
    }

    public boolean isOkFileChecksum() throws MzMLUnmarshallerException {
        if (this.fileCorrupted) {
            return false;
        }
        if (!this.isIndexedmzML()) {
            throw new MzMLUnmarshallerException("Attempted check of file checksum on un-indexed mzML file.");
        }
        String indexChecksum = this.getFileChecksumFromIndex();
        logger.info((Object)("provided checksum (index)  : " + indexChecksum));
        String calcChecksum = this.calculateChecksum();
        logger.info((Object)("calculated checksum (jmzml): " + calcChecksum));
        boolean checkSumOK = indexChecksum.equals(calcChecksum);
        if (!checkSumOK) {
            this.fileCorrupted = true;
        }
        return checkSumOK;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IndexList getMzMLIndex() throws MzMLUnmarshallerException {
        IndexList retval;
        if (this.indexList != null) return this.indexList;
        if (!this.isOkFileChecksum()) throw new MzMLUnmarshallerException("File checksum did not match! This file has been changed after the index was created. The index is invalid.");
        this.indexList = retval = (IndexList)this.unmarshalFromXpath("/indexedmzML/indexList", IndexList.class);
        return retval;
    }

    public Spectrum getSpectrumById(String aID) throws MzMLUnmarshallerException {
        Spectrum result = null;
        String xml = this.index.getXmlString(aID, Spectrum.class);
        try {
            MzMLNamespaceFilter xmlFilter = new MzMLNamespaceFilter();
            Unmarshaller unmarshaller = UnmarshallerFactory.getInstance().initializeUnmarshaller(this.index, xmlFilter, this.cache, this.useSpectrumCache);
            JAXBElement holder = unmarshaller.unmarshal((Source)new SAXSource(xmlFilter, new InputSource(new StringReader(xml))), Spectrum.class);
            result = (Spectrum)holder.getValue();
        }
        catch (JAXBException je) {
            logger.error((Object)"MzMLUnmarshaller.getSpectrumByID", (Throwable)je);
            throw new IllegalStateException("Could not unmarshal spectrum with ID: " + aID);
        }
        return result;
    }

    public Chromatogram getChromatogramById(String aID) throws MzMLUnmarshallerException {
        Chromatogram result = null;
        String xml = this.index.getXmlString(aID, Chromatogram.class);
        try {
            MzMLNamespaceFilter xmlFilter = new MzMLNamespaceFilter();
            Unmarshaller unmarshaller = UnmarshallerFactory.getInstance().initializeUnmarshaller(this.index, xmlFilter, this.cache, this.useSpectrumCache);
            JAXBElement holder = unmarshaller.unmarshal((Source)new SAXSource(xmlFilter, new InputSource(new StringReader(xml))), Chromatogram.class);
            result = (Chromatogram)holder.getValue();
        }
        catch (JAXBException je) {
            logger.error((Object)"MzMLUnmarshaller.getChromatogramByID", (Throwable)je);
            throw new IllegalStateException("Could not unmarshal chromatogram with ID: " + aID);
        }
        return result;
    }

    public Spectrum getSpectrumByRefId(String refId) throws MzMLUnmarshallerException {
        Index aIndexEntry = this.getIndex("spectrum");
        for (Offset offset : aIndexEntry.getOffset()) {
            if (!offset.getIdRef().equalsIgnoreCase(refId)) continue;
            return (Spectrum)this.getElementByOffset("spectrum", offset.getValue());
        }
        return null;
    }

    public Spectrum getSpectrumBySpotId(String spotId) throws MzMLUnmarshallerException {
        Index aIndexEntry = this.getIndex("spectrum");
        for (Offset offset : aIndexEntry.getOffset()) {
            if (offset.getSpotID() == null || !offset.getSpotID().equalsIgnoreCase(spotId)) continue;
            return (Spectrum)this.getElementByOffset("spectrum", offset.getValue());
        }
        return null;
    }

    public Spectrum getSpectrumByScanTime(double scanTime) throws MzMLUnmarshallerException {
        Index aIndexEntry = this.getIndex("spectrum");
        for (Offset offset : aIndexEntry.getOffset()) {
            if (offset.getScanTime() == null || offset.getScanTime() != scanTime) continue;
            return (Spectrum)this.getElementByOffset("spectrum", offset.getValue());
        }
        return null;
    }

    public Spectrum getSpectrumByScanTime(Integer aIndex) throws MzMLUnmarshallerException {
        String specID = this.index.getSpectrumIDFromSpectrumIndex(aIndex);
        return this.getSpectrumById(specID);
    }

    public Chromatogram getChromatogramByRefId(String refId) throws MzMLUnmarshallerException {
        Index aIndexEntry = this.getIndex("chromatogram");
        for (Offset offset : aIndexEntry.getOffset()) {
            if (!offset.getIdRef().equalsIgnoreCase(refId)) continue;
            return (Chromatogram)this.getElementByOffset("chromatogram", offset.getValue());
        }
        return null;
    }

    public Set<String> getSpectrumIDs() {
        return this.index.getSpectrumIDs();
    }

    public Set<Integer> getSpectrumIndexes() {
        return this.index.getSpectrumIndexes();
    }

    public String getSpectrumIDFromSpectrumIndex(Integer aIndex) {
        return this.index.getSpectrumIDFromSpectrumIndex(aIndex);
    }

    public Set<String> getChromatogramIDs() {
        return this.index.getChromatogramIDs();
    }

    private String getFileChecksumFromIndex() throws MzMLUnmarshallerException {
        if (!this.isIndexedmzML()) {
            throw new MzMLUnmarshallerException("Can not retrieve fileChecksum from a non indexed mzML file!");
        }
        Iterator<String> snipIter = this.index.getXmlStringIterator("/indexedmzML/fileChecksum");
        if (!snipIter.hasNext()) {
            throw new IllegalStateException("Could not find fileChecksum tag in indexedmzML: " + this.mzMLFile.getName());
        }
        String snippet = snipIter.next();
        String test = snippet.replace("<fileChecksum>", "");
        String checksum = test.replace("</fileChecksum>", "").trim().intern();
        return checksum;
    }

    private String calculateChecksum() {
        FileInputStream fis;
        MessageDigest hash;
        long limit = this.mzMLFile.length() - 200L;
        logger.debug((Object)("Looking for fileChecksum tag between byte " + limit + " and byte " + this.mzMLFile.length() + " (the end) of the mzML file."));
        try {
            hash = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("SHA-1 not recognized as Secure Hash Algorithm.", e);
        }
        try {
            fis = new FileInputStream(this.mzMLFile);
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("File " + this.mzMLFile.getAbsoluteFile() + " could not be found!", e);
        }
        BufferedInputStream bis = new BufferedInputStream(fis);
        DigestInputStream dis = new DigestInputStream(bis, hash);
        CircularFifoBuffer bBuf = new CircularFifoBuffer(15);
        long cnt = 0L;
        byte[] b = new byte[1];
        try {
            while (dis.read(b) >= 0) {
                String readBuffer;
                bBuf.add((Object)b[0]);
                if (++cnt <= limit || !(readBuffer = this.convert2String(bBuf)).endsWith("<fileChecksum>")) continue;
                if (b[0] == 62) break;
                throw new IllegalStateException("We are not at the end of <fileChecksum> tag!");
            }
            dis.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not read from file '" + this.mzMLFile.getAbsolutePath() + "' while trying ot calculate hash.", e);
        }
        logger.debug((Object)("Read over " + cnt + " bytes while calculating the file hash."));
        byte[] bytesDigest = dis.getMessageDigest().digest();
        return MzMLUnmarshaller.asHex(bytesDigest);
    }

    private String convert2String(CircularFifoBuffer bBuf) {
        byte[] tmp = new byte[bBuf.size()];
        int tmpCnt = 0;
        for (Object aBBuf : bBuf) {
            tmp[tmpCnt++] = (Byte)aBBuf;
        }
        return new String(tmp);
    }

    public static String asHex(byte[] buf) {
        char[] chars = new char[2 * buf.length];
        for (int i = 0; i < buf.length; ++i) {
            chars[2 * i] = HEX_CHARS[(buf[i] & 0xF0) >>> 4];
            chars[2 * i + 1] = HEX_CHARS[buf[i] & 0xF];
        }
        return new String(chars);
    }

    private Index getIndex(String elementName) throws MzMLUnmarshallerException {
        IndexList list = this.getMzMLIndex();
        for (Index entry : list.getIndex()) {
            if (!entry.getName().equalsIgnoreCase(elementName)) continue;
            return entry;
        }
        return null;
    }

    private <T extends MzMLObject> T getElementByOffset(String elementName, long offset) throws MzMLUnmarshallerException {
        MzMLObject retval;
        String aXpath = null;
        for (String xxindexPath : this.index.getXpath()) {
            if (!xxindexPath.endsWith(elementName)) continue;
            aXpath = xxindexPath;
        }
        if (aXpath == null) {
            throw new MzMLUnmarshallerException("Could not find a valid xpath (in xxindex) for the requested mzML index element '" + elementName + "'!");
        }
        String xmlSnippet = this.index.getXmlString(aXpath, offset);
        if (xmlSnippet == null) {
            throw new MzMLUnmarshallerException("No element '" + elementName + "' with the specified " + "offset (" + offset + ") could be found (xpath: '" + aXpath + "')! Perhaps the " + "mzML index containing the offset was corrupted.");
        }
        try {
            MzMLNamespaceFilter xmlFilter = new MzMLNamespaceFilter();
            Unmarshaller unmarshaller = UnmarshallerFactory.getInstance().initializeUnmarshaller(this.index, xmlFilter, this.cache, this.useSpectrumCache);
            Class cls = ModelConstants.getClassForElementName(elementName);
            JAXBElement holder = unmarshaller.unmarshal((Source)new SAXSource(xmlFilter, new InputSource(new StringReader(xmlSnippet))), cls);
            retval = (MzMLObject)holder.getValue();
        }
        catch (JAXBException e) {
            logger.error((Object)"MzMLUnmarshaller.getObjectFromXml", (Throwable)e);
            throw new IllegalStateException("Could not unmarshal object from XML string:" + xmlSnippet);
        }
        return (T)retval;
    }

    public <T extends MzMLObject> T unmarshalFromIndexElement(IndexElement element, Class cls) throws MzMLUnmarshallerException {
        MzMLObject retval;
        String xmlSnippet = this.index.getXmlString(element);
        try {
            MzMLNamespaceFilter xmlFilter = new MzMLNamespaceFilter();
            Unmarshaller unmarshaller = UnmarshallerFactory.getInstance().initializeUnmarshaller(this.index, xmlFilter, this.cache, this.useSpectrumCache);
            JAXBElement holder = unmarshaller.unmarshal((Source)new SAXSource(xmlFilter, new InputSource(new StringReader(xmlSnippet))), cls);
            retval = (MzMLObject)holder.getValue();
        }
        catch (JAXBException e) {
            logger.error((Object)"MzMLUnmarshaller.getObjectFromXml", (Throwable)e);
            throw new IllegalStateException("Could not unmarshal object from XML string:" + xmlSnippet);
        }
        return (T)retval;
    }

    public MzMLIndexer getMzMLIndexer() {
        return this.index;
    }
}

