/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzml.xml.jaxb.marshaller;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.log4j.Logger;
import uk.ac.ebi.jmzml.model.mzml.utilities.ModelConstants;
import uk.ac.ebi.jmzml.xml.jaxb.marshaller.listeners.ObjectClassListener;

public class MarshallerFactory {
    private static final Logger logger = Logger.getLogger(MarshallerFactory.class);
    private static MarshallerFactory instance = new MarshallerFactory();
    private static JAXBContext jc = null;

    public static MarshallerFactory getInstance() {
        return instance;
    }

    private MarshallerFactory() {
    }

    public Marshaller initializeMarshaller() {
        logger.debug((Object)"Initializing Marshaller for mzML.");
        try {
            if (jc == null) {
                jc = JAXBContext.newInstance((String)ModelConstants.PACKAGE);
            }
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.setListener((Marshaller.Listener)new ObjectClassListener());
            logger.info((Object)"Marshaller initialized");
            return marshaller;
        }
        catch (JAXBException e) {
            logger.error((Object)"MarshallerFactory.initializeMarshaller", (Throwable)e);
            throw new IllegalStateException("Can't initialize marshaller: " + e.getMessage());
        }
    }
}

