/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzml.xml.jaxb.resolver;

import java.io.StringReader;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.apache.log4j.Logger;
import org.xml.sax.InputSource;
import uk.ac.ebi.jmzml.model.mzml.MzMLObject;
import uk.ac.ebi.jmzml.xml.io.MzMLObjectCache;
import uk.ac.ebi.jmzml.xml.jaxb.unmarshaller.UnmarshallerFactory;
import uk.ac.ebi.jmzml.xml.jaxb.unmarshaller.filters.MzMLNamespaceFilter;
import uk.ac.ebi.jmzml.xml.xxindex.MzMLIndexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReferenceResolver<T extends MzMLObject>
extends Unmarshaller.Listener {
    private static final Logger log = Logger.getLogger(AbstractReferenceResolver.class);
    private MzMLIndexer index = null;
    private MzMLObjectCache cache = null;

    protected AbstractReferenceResolver(MzMLIndexer index, MzMLObjectCache cache) {
        this.index = index;
        this.cache = cache;
    }

    public <R extends MzMLObject> R unmarshal(String refId, Class<R> cls) {
        MzMLObject retVal = null;
        if (retVal == null) {
            log.debug((Object)("AbstractReferenceResolver.unmarshal for id: " + refId));
            String xml = this.index.getXmlString(refId, cls);
            try {
                MzMLNamespaceFilter xmlFilter = new MzMLNamespaceFilter();
                Unmarshaller unmarshaller = UnmarshallerFactory.getInstance().initializeUnmarshaller(this.index, this.cache, xmlFilter);
                JAXBElement holder = unmarshaller.unmarshal((Source)new SAXSource(xmlFilter, new InputSource(new StringReader(xml))), cls);
                retVal = (MzMLObject)holder.getValue();
            }
            catch (JAXBException e) {
                log.error((Object)"AbstractReferenceResolver.unmarshal", (Throwable)e);
                throw new IllegalStateException("Could not unmarshall refId: " + refId + " for element type: " + cls);
            }
        }
        return (R)retVal;
    }

    public abstract void updateObject(T var1);

    public abstract void checkRefID(T var1);
}

