/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzml.xml.jaxb.unmarshaller;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import uk.ac.ebi.jmzml.model.mzml.utilities.ModelConstants;
import uk.ac.ebi.jmzml.xml.io.MzMLObjectCache;
import uk.ac.ebi.jmzml.xml.jaxb.unmarshaller.filters.MzMLNamespaceFilter;
import uk.ac.ebi.jmzml.xml.jaxb.unmarshaller.listeners.RawXMLListener;
import uk.ac.ebi.jmzml.xml.xxindex.MzMLIndexer;

public class UnmarshallerFactory {
    private static final Logger logger = Logger.getLogger(UnmarshallerFactory.class);
    private static UnmarshallerFactory instance = new UnmarshallerFactory();
    private static JAXBContext jc = null;

    public static UnmarshallerFactory getInstance() {
        return instance;
    }

    private UnmarshallerFactory() {
    }

    public Unmarshaller initializeUnmarshaller(MzMLIndexer index, MzMLObjectCache cache, MzMLNamespaceFilter xmlFilter) {
        return this.initializeUnmarshaller(index, xmlFilter, cache, true);
    }

    public Unmarshaller initializeUnmarshaller(MzMLIndexer index, MzMLNamespaceFilter xmlFilter, MzMLObjectCache cache, boolean useCacheForSpectra) {
        try {
            if (jc == null) {
                jc = JAXBContext.newInstance((String)ModelConstants.PACKAGE);
            }
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            unmarshaller.setListener((Unmarshaller.Listener)new RawXMLListener(index, cache));
            UnmarshallerHandler uh = unmarshaller.getUnmarshallerHandler();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            XMLReader xmlReader = parser.getXMLReader();
            xmlFilter.setParent(xmlReader);
            xmlFilter.setContentHandler((ContentHandler)uh);
            logger.debug((Object)"Unmarshaller Initialized");
            return unmarshaller;
        }
        catch (JAXBException e) {
            logger.error((Object)"UnmarshallerFactory.initializeUnmarshaller", (Throwable)e);
            throw new IllegalStateException("Could not initialize unmarshaller");
        }
        catch (SAXException e) {
            logger.error((Object)"UnmarshallerFactory.initializeUnmarshaller", (Throwable)e);
            throw new IllegalStateException("Could not initialize unmarshaller");
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)"UnmarshallerFactory.initializeUnmarshaller", (Throwable)e);
            throw new IllegalStateException("Could not initialize unmarshaller");
        }
    }
}

