/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.jmzml.xml.xxindex;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;

public class FileUtils {
    private static Logger logger = Logger.getLogger(FileUtils.class);

    public static File getFileFromURL(URL url) {
        File tempFile;
        BufferedInputStream in = null;
        FilterOutputStream out = null;
        try {
            String tempDir = System.getProperty("java.io.tmpdir", ".");
            tempFile = File.createTempFile("xxindex", ".tmp", new File(tempDir));
            tempFile.deleteOnExit();
            InputStream is = url.openStream();
            in = new BufferedInputStream(is);
            FileOutputStream fos = new FileOutputStream(tempFile);
            out = new BufferedOutputStream(fos);
            byte[] b = new byte[1];
            while (in.read(b) >= 0) {
                out.write(b);
            }
            logger.debug((Object)(url + " written to local file " + tempFile.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not create local file for URL: " + url, e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
        return tempFile;
    }
}

