/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import no.uib.jsparklines.renderers.JSparklinesBarChartTableCellRenderer;
import no.uib.jsparklines.renderers.JSparklinesBubbleHeatMapTableCellRenderer;
import no.uib.jsparklines.renderers.util.GradientColorCoding;
import org.jfree.chart.plot.PlotOrientation;

public class JSparklinesHeatMapDemo
extends JFrame {
    private JComboBox backgoundColorJComboBox;
    private JPanel backgroundPanel;
    private JComboBox colorGradientJComboBox;
    private JScrollPane heatmapJScrollPane;
    private JTable heatmapJTable;
    private JComboBox heatmapTypeJComboBox;
    private JCheckBox showHeatmapJCheckBox;
    private JPanel singleValuesJPanel;

    public JSparklinesHeatMapDemo() {
        this.initComponents();
        this.setAdditionalGuiProperties();
        this.addHeatmapValues(50);
        for (int i = 0; i < this.heatmapJTable.getColumnCount(); ++i) {
            this.heatmapJTable.getColumn(this.heatmapJTable.getColumnName(i)).setCellRenderer(new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, (Double)-100.0, 100.0));
            ((JSparklinesBarChartTableCellRenderer)this.heatmapJTable.getColumn(this.heatmapJTable.getColumnName(i)).getCellRenderer()).showAsHeatMap(GradientColorCoding.ColorGradient.RedBlackGreen, false);
        }
        this.backgoundColorJComboBoxActionPerformed(null);
        this.heatmapJTable.setRowHeight(this.heatmapJTable.getColumn("1").getWidth() - 25);
        this.heatmapJScrollPane.setColumnHeaderView(null);
    }

    private void setAdditionalGuiProperties() {
        this.colorGradientJComboBox.setModel(new DefaultComboBoxModel<GradientColorCoding.ColorGradient>(GradientColorCoding.ColorGradient.values()));
        this.colorGradientJComboBox.setRenderer(new ComboBoxListCellRenderer());
        this.backgoundColorJComboBox.setRenderer(new ComboBoxListCellRenderer());
        this.heatmapTypeJComboBox.setRenderer(new ComboBoxListCellRenderer());
        this.heatmapJTable.getTableHeader().setReorderingAllowed(false);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/line_plot.GIF")));
        this.setTitle("JSparklines " + this.getVersion() + " - Heat Map Demo");
        this.heatmapJScrollPane.getViewport().setOpaque(false);
        this.setLocationRelativeTo(null);
    }

    private void addHeatmapValues(int maxValue) {
        Random random = new Random();
        for (int i = 0; i < this.heatmapJTable.getColumnCount() + 2; ++i) {
            ((DefaultTableModel)this.heatmapJTable.getModel()).addRow(new Object[]{null, null, null, null, null, null, null, null, null});
            for (int j = 0; j < this.heatmapJTable.getColumnCount(); ++j) {
                if (random.nextInt(2) == 0) {
                    ((DefaultTableModel)this.heatmapJTable.getModel()).setValueAt(new Double(-random.nextInt(maxValue)), i, j);
                    continue;
                }
                ((DefaultTableModel)this.heatmapJTable.getModel()).setValueAt(new Double(random.nextInt(maxValue)), i, j);
            }
        }
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.singleValuesJPanel = new JPanel();
        this.showHeatmapJCheckBox = new JCheckBox();
        this.heatmapJScrollPane = new JScrollPane();
        this.heatmapJTable = new JTable(){

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return true;
            }
        };
        this.colorGradientJComboBox = new JComboBox();
        this.backgoundColorJComboBox = new JComboBox();
        this.heatmapTypeJComboBox = new JComboBox();
        this.setDefaultCloseOperation(3);
        this.setTitle("JSparklines Heat Map Demo");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(255, 255, 255));
        this.singleValuesJPanel.setBorder(BorderFactory.createTitledBorder("Heat Map"));
        this.singleValuesJPanel.setOpaque(false);
        this.showHeatmapJCheckBox.setSelected(true);
        this.showHeatmapJCheckBox.setText("Heat Map");
        this.showHeatmapJCheckBox.setToolTipText("Turn the heat map on or off");
        this.showHeatmapJCheckBox.setIconTextGap(8);
        this.showHeatmapJCheckBox.setOpaque(false);
        this.showHeatmapJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSparklinesHeatMapDemo.this.showHeatmapJCheckBoxActionPerformed(evt);
            }
        });
        this.heatmapJScrollPane.setOpaque(false);
        this.heatmapJTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.heatmapJTable.setFillsViewportHeight(true);
        this.heatmapJTable.setRowSelectionAllowed(false);
        this.heatmapJTable.setSelectionBackground(new Color(204, 204, 204));
        this.heatmapJTable.setShowHorizontalLines(false);
        this.heatmapJTable.setShowVerticalLines(false);
        this.heatmapJScrollPane.setViewportView(this.heatmapJTable);
        this.colorGradientJComboBox.setMaximumSize(new Dimension(48, 20));
        this.colorGradientJComboBox.setOpaque(false);
        this.colorGradientJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSparklinesHeatMapDemo.this.colorGradientJComboBoxActionPerformed(evt);
            }
        });
        this.backgoundColorJComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"White", "Black"}));
        this.backgoundColorJComboBox.setSelectedIndex(1);
        this.backgoundColorJComboBox.setMaximumSize(new Dimension(48, 20));
        this.backgoundColorJComboBox.setOpaque(false);
        this.backgoundColorJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSparklinesHeatMapDemo.this.backgoundColorJComboBoxActionPerformed(evt);
            }
        });
        this.heatmapTypeJComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Bubble", "Area"}));
        this.heatmapTypeJComboBox.setSelectedIndex(1);
        this.heatmapTypeJComboBox.setMaximumSize(new Dimension(48, 20));
        this.heatmapTypeJComboBox.setOpaque(false);
        this.heatmapTypeJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JSparklinesHeatMapDemo.this.heatmapTypeJComboBoxActionPerformed(evt);
            }
        });
        GroupLayout singleValuesJPanelLayout = new GroupLayout(this.singleValuesJPanel);
        this.singleValuesJPanel.setLayout(singleValuesJPanelLayout);
        singleValuesJPanelLayout.setHorizontalGroup(singleValuesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, singleValuesJPanelLayout.createSequentialGroup().addContainerGap().addGroup(singleValuesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.heatmapJScrollPane, -1, 744, Short.MAX_VALUE).addGroup(singleValuesJPanelLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.heatmapTypeJComboBox, -2, 145, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.backgoundColorJComboBox, -2, 145, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colorGradientJComboBox, -2, 145, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.showHeatmapJCheckBox).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        singleValuesJPanelLayout.setVerticalGroup(singleValuesJPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, singleValuesJPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.heatmapJScrollPane, -1, 593, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(singleValuesJPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showHeatmapJCheckBox, -2, 26, -2).addComponent(this.colorGradientJComboBox, -2, -1, -2).addComponent(this.backgoundColorJComboBox, -2, -1, -2).addComponent(this.heatmapTypeJComboBox, -2, -1, -2)).addGap(9, 9, 9)));
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.singleValuesJPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.singleValuesJPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void showHeatmapJCheckBoxActionPerformed(ActionEvent evt) {
        this.heatmapTypeJComboBox.setEnabled(this.showHeatmapJCheckBox.isSelected());
        this.backgoundColorJComboBox.setEnabled(this.showHeatmapJCheckBox.isSelected());
        this.colorGradientJComboBox.setEnabled(this.showHeatmapJCheckBox.isSelected());
        if (this.heatmapTypeJComboBox.getSelectedIndex() == 0) {
            for (int i = 0; i < this.heatmapJTable.getColumnCount(); ++i) {
                ((JSparklinesBubbleHeatMapTableCellRenderer)this.heatmapJTable.getColumn(this.heatmapJTable.getColumnName(i)).getCellRenderer()).showNumbers(!this.showHeatmapJCheckBox.isSelected());
            }
        } else {
            for (int i = 0; i < this.heatmapJTable.getColumnCount(); ++i) {
                ((JSparklinesBarChartTableCellRenderer)this.heatmapJTable.getColumn(this.heatmapJTable.getColumnName(i)).getCellRenderer()).showNumbers(!this.showHeatmapJCheckBox.isSelected());
            }
        }
        this.heatmapJTable.revalidate();
        this.heatmapJTable.repaint();
    }

    private void colorGradientJComboBoxActionPerformed(ActionEvent evt) {
        GradientColorCoding.ColorGradient[] colorGradients = GradientColorCoding.ColorGradient.values();
        GradientColorCoding.ColorGradient colorGradient = colorGradients[this.colorGradientJComboBox.getSelectedIndex()];
        if (this.heatmapTypeJComboBox.getSelectedIndex() == 0) {
            for (int i = 0; i < this.heatmapJTable.getColumnCount(); ++i) {
                ((JSparklinesBubbleHeatMapTableCellRenderer)this.heatmapJTable.getColumn(this.heatmapJTable.getColumnName(i)).getCellRenderer()).setGradientColoring(colorGradient, false);
            }
        } else {
            for (int i = 0; i < this.heatmapJTable.getColumnCount(); ++i) {
                ((JSparklinesBarChartTableCellRenderer)this.heatmapJTable.getColumn(this.heatmapJTable.getColumnName(i)).getCellRenderer()).setGradientColoring(colorGradient, false);
            }
        }
        this.heatmapJTable.revalidate();
        this.heatmapJTable.repaint();
    }

    private void backgoundColorJComboBoxActionPerformed(ActionEvent evt) {
        if (((String)this.backgoundColorJComboBox.getSelectedItem()).equalsIgnoreCase("Black")) {
            this.heatmapJTable.setGridColor(Color.BLACK);
            this.heatmapJTable.setBackground(Color.BLACK);
            this.heatmapJTable.setOpaque(true);
            this.heatmapJTable.setForeground(Color.WHITE);
        } else {
            this.heatmapJTable.setGridColor(Color.WHITE);
            this.heatmapJTable.setBackground(Color.WHITE);
            this.heatmapJTable.setOpaque(true);
            this.heatmapJTable.setForeground(Color.BLACK);
        }
        this.heatmapJTable.revalidate();
        this.heatmapJTable.repaint();
    }

    private void heatmapTypeJComboBoxActionPerformed(ActionEvent evt) {
        GradientColorCoding.ColorGradient[] colorGradients = GradientColorCoding.ColorGradient.values();
        GradientColorCoding.ColorGradient colorGradient = colorGradients[this.colorGradientJComboBox.getSelectedIndex()];
        if (this.heatmapTypeJComboBox.getSelectedIndex() == 0) {
            for (int i = 0; i < this.heatmapJTable.getColumnCount(); ++i) {
                this.heatmapJTable.getColumn(this.heatmapJTable.getColumnName(i)).setCellRenderer(new JSparklinesBubbleHeatMapTableCellRenderer(100.0, colorGradient, false));
            }
        } else {
            for (int i = 0; i < this.heatmapJTable.getColumnCount(); ++i) {
                this.heatmapJTable.getColumn(this.heatmapJTable.getColumnName(i)).setCellRenderer(new JSparklinesBarChartTableCellRenderer(PlotOrientation.HORIZONTAL, (Double)-100.0, 100.0));
                ((JSparklinesBarChartTableCellRenderer)this.heatmapJTable.getColumn(this.heatmapJTable.getColumnName(i)).getCellRenderer()).showAsHeatMap(colorGradient, false);
            }
        }
        this.heatmapJTable.revalidate();
        this.heatmapJTable.repaint();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JSparklinesHeatMapDemo().setVisible(true);
            }
        });
    }

    public String getVersion() {
        Properties p = new Properties();
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("jsparklines.properties");
            p.load(is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return p.getProperty("jsparklines.version");
    }

    public class ComboBoxListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            c.setOpaque(isSelected);
            if (isSelected || cellHasFocus) {
                c.setBackground(Color.LIGHT_GRAY);
            }
            c.setHorizontalAlignment(0);
            return c;
        }
    }

    public class NonOpaqueCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent c = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            c.setOpaque(isSelected);
            return c;
        }
    }
}

