/*
 * Decompiled with CFR 0.152.
 */
package no.uib.jsparklines.renderers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import no.uib.jsparklines.data.XYDataPoint;
import no.uib.jsparklines.renderers.util.GradientColorCoding;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.IntervalBarRenderer;
import org.jfree.chart.renderer.category.LayeredBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.category.DefaultIntervalCategoryDataset;

public class JSparklinesIntervalChartTableCellRenderer
extends JPanel
implements TableCellRenderer {
    private int labelHorizontalAlignement = 4;
    private double minimumChartValue = 0.05;
    private double tooltipLowerValue = 0.01;
    private ChartPanel chartPanel;
    private JFreeChart chart;
    private JLabel valueLabel;
    private double maxValue = 1.0;
    private double minValue = 0.0;
    private boolean showNumbers = false;
    private boolean showNumberAndChart = false;
    private int widthOfValueLabel = 40;
    private Color plotBackgroundColor = null;
    private Color negativeValuesColor = new Color(51, 51, 255);
    private Color positiveValuesColor = new Color(255, 51, 51);
    private boolean gradientColoring = false;
    private GradientColorCoding.ColorGradient currentColorGradient = GradientColorCoding.ColorGradient.RedBlackBlue;
    private boolean positiveColorGradient = false;
    private double widthOfInterval;
    private boolean xyDataPointRequied = false;
    private boolean showReferenceLine = false;
    private double referenceLineWidth = 0.03;
    private Color referenceLineColor = Color.BLACK;

    public JSparklinesIntervalChartTableCellRenderer(PlotOrientation plotOrientation, Double maxValue, Double widthOfInterval) {
        this.maxValue = maxValue;
        this.widthOfInterval = widthOfInterval;
        this.setUpRendererAndChart(plotOrientation);
        if (widthOfInterval < 0.0) {
            throw new IllegalArgumentException("widthOfInterval has to be non-negative! Current value: " + widthOfInterval + ".");
        }
    }

    public JSparklinesIntervalChartTableCellRenderer(PlotOrientation plotOrientation, Double maxValue, Double widthOfInterval, Color positiveValuesColor) {
        this(plotOrientation, 0.0, maxValue, widthOfInterval, positiveValuesColor, positiveValuesColor);
    }

    public JSparklinesIntervalChartTableCellRenderer(PlotOrientation plotOrientation, Double minValue, Double maxValue, Double widthOfInterval) {
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.widthOfInterval = widthOfInterval;
        this.setUpRendererAndChart(plotOrientation);
        if (widthOfInterval < 0.0) {
            throw new IllegalArgumentException("widthOfInterval has to be non-negative! Current value: " + widthOfInterval + ".");
        }
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue has to be smaller than maxValue! Current values: minValue: " + minValue + ", maxValue: " + maxValue + ".");
        }
    }

    public JSparklinesIntervalChartTableCellRenderer(PlotOrientation plotOrientation, Double minValue, Double maxValue, Double widthOfInterval, Color negativeValuesColor, Color positiveValuesColor) {
        this.positiveValuesColor = positiveValuesColor;
        this.negativeValuesColor = negativeValuesColor;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.widthOfInterval = widthOfInterval;
        this.setUpRendererAndChart(plotOrientation);
        if (widthOfInterval < 0.0) {
            throw new IllegalArgumentException("widthOfInterval has to be non-negative! Current value: " + widthOfInterval + ".");
        }
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue has to be smaller than maxValue! Current values: minValue: " + minValue + ", maxValue: " + maxValue + ".");
        }
    }

    public JSparklinesIntervalChartTableCellRenderer(PlotOrientation plotOrientation, Double minValue, Double maxValue, Color negativeValuesColor, Color positiveValuesColor) {
        this.positiveValuesColor = positiveValuesColor;
        this.negativeValuesColor = negativeValuesColor;
        this.maxValue = maxValue;
        this.minValue = minValue;
        this.xyDataPointRequied = true;
        this.setUpRendererAndChart(plotOrientation);
        if (minValue > maxValue) {
            throw new IllegalArgumentException("minValue has to be smaller than maxValue! Current values: minValue: " + minValue + ", maxValue: " + maxValue + ".");
        }
    }

    private void setUpRendererAndChart(PlotOrientation plotOrientation) {
        this.setName("Table.cellRenderer");
        this.setLayout(new BorderLayout());
        this.valueLabel = new JLabel("");
        this.valueLabel.setMinimumSize(new Dimension(this.widthOfValueLabel, 0));
        this.valueLabel.setHorizontalAlignment(0);
        this.valueLabel.setFont(this.valueLabel.getFont().deriveFont((float)this.valueLabel.getFont().getSize() - 2.0f));
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        this.chart = ChartFactory.createBarChart(null, null, null, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)false, (boolean)false, (boolean)false);
        this.chartPanel = new ChartPanel(this.chart);
        this.setLayout(new BoxLayout(this, 2));
        this.add(this.valueLabel);
        this.add((Component)this.chartPanel);
    }

    public void showReferenceLine(boolean showReferenceLine) {
        this.showReferenceLine = showReferenceLine;
    }

    public void showReferenceLine(boolean showReferenceLine, double lineWidth, Color color) {
        this.showReferenceLine = showReferenceLine;
        this.referenceLineWidth = lineWidth;
        this.referenceLineColor = color;
    }

    public void setGradientColoring(GradientColorCoding.ColorGradient colorGradient, Color plotBackgroundColor, boolean positiveColorGradient) {
        this.gradientColoring = colorGradient != null;
        this.positiveColorGradient = positiveColorGradient;
        this.plotBackgroundColor = plotBackgroundColor;
        this.currentColorGradient = colorGradient;
        if (this.gradientColoring && Math.abs(this.minValue) > this.maxValue) {
            this.maxValue = Math.abs(this.minValue);
        }
    }

    public void setBackgroundColor(Color plotBackgroundColor) {
        this.plotBackgroundColor = plotBackgroundColor;
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel) {
        this.showNumberAndChart = showNumberAndChart;
        this.widthOfValueLabel = widthOfLabel;
    }

    public void showNumberAndChart(boolean showNumberAndChart, int widthOfLabel, Font font, int horizontalAlignement) {
        this.showNumberAndChart = showNumberAndChart;
        this.widthOfValueLabel = widthOfLabel;
        this.labelHorizontalAlignement = horizontalAlignement;
        this.valueLabel.setFont(font);
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public void showNumbers(boolean showNumbers) {
        this.showNumbers = showNumbers;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        int i;
        double[][] lows;
        JComponent c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        boolean supportedObjectType = false;
        if (value != null && (value instanceof Double || value instanceof Float || value instanceof Integer || value instanceof Short || value instanceof Long || value instanceof Byte || value instanceof XYDataPoint || value instanceof XYDataPoint[])) {
            supportedObjectType = true;
        }
        if (!supportedObjectType) {
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        if (this.xyDataPointRequied && !(value instanceof XYDataPoint) && !(value instanceof XYDataPoint[])) {
            throw new IllegalArgumentException("Inconsistent use of constructor! The constructor used requires that the cells contain values of type XYDataPoint or XYDataPoint[]. Type found: " + value.getClass());
        }
        if (this.showNumbers) {
            if (value instanceof Double || value instanceof Float) {
                if (value instanceof Float) {
                    value = ((Float)value).doubleValue();
                }
                c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, JSparklinesIntervalChartTableCellRenderer.roundDouble((Double)value, 2), isSelected, hasFocus, row, column);
                Double d = new Double("" + value);
                if (Math.abs(d) < this.tooltipLowerValue) {
                    c.setToolTipText("" + JSparklinesIntervalChartTableCellRenderer.roundDouble(new Double("" + value), 8));
                }
            } else if (value instanceof Integer || value instanceof Short || value instanceof Long || value instanceof Byte) {
                if (value instanceof Short) {
                    value = ((Short)value).intValue();
                } else if (value instanceof Long) {
                    value = ((Long)value).intValue();
                } else if (value instanceof Byte) {
                    value = ((Byte)value).intValue();
                }
                c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, (Integer)value, isSelected, hasFocus, row, column);
            } else if (value instanceof XYDataPoint) {
                c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, "[" + JSparklinesIntervalChartTableCellRenderer.roundDouble(((XYDataPoint)value).getX(), 2) + ", " + JSparklinesIntervalChartTableCellRenderer.roundDouble(((XYDataPoint)value).getY(), 2) + "]", isSelected, hasFocus, row, column);
            } else if (value instanceof XYDataPoint[]) {
                XYDataPoint[] tempValues;
                String temp = "";
                for (XYDataPoint tempValue : tempValues = (XYDataPoint[])value) {
                    temp = temp + "[" + JSparklinesIntervalChartTableCellRenderer.roundDouble(tempValue.getX(), 2) + ", " + JSparklinesIntervalChartTableCellRenderer.roundDouble(tempValue.getY(), 2) + "] ";
                }
                c = (JComponent)new DefaultTableCellRenderer().getTableCellRendererComponent(table, temp, isSelected, hasFocus, row, column);
            }
            ((JLabel)c).setHorizontalAlignment(4);
            Color bg = c.getBackground();
            c.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            return c;
        }
        if (value instanceof Double || value instanceof Float) {
            if (value instanceof Float) {
                value = ((Float)value).doubleValue();
            }
            Double d = new Double("" + value);
            if (Math.abs(d) < this.tooltipLowerValue) {
                this.setToolTipText("" + JSparklinesIntervalChartTableCellRenderer.roundDouble(new Double("" + value), 8));
            } else {
                this.setToolTipText("" + JSparklinesIntervalChartTableCellRenderer.roundDouble(new Double("" + value), 2));
            }
        } else if (value instanceof Integer || value instanceof Short || value instanceof Long || value instanceof Byte) {
            this.setToolTipText("" + value);
        } else if (value instanceof XYDataPoint) {
            double x = ((XYDataPoint)value).getX();
            double y = ((XYDataPoint)value).getY();
            if (Math.floor(x) == x && Math.floor(y) == y) {
                this.setToolTipText("[" + (int)x + ", " + (int)y + "]");
            } else {
                this.setToolTipText("[" + JSparklinesIntervalChartTableCellRenderer.roundDouble(x, 2) + ", " + JSparklinesIntervalChartTableCellRenderer.roundDouble(y, 2) + "]");
            }
        } else if (value instanceof XYDataPoint[]) {
            XYDataPoint[] tempValues;
            String temp = "<html>";
            for (XYDataPoint tempValue : tempValues = (XYDataPoint[])value) {
                double x = tempValue.getX();
                double y = tempValue.getY();
                temp = Math.floor(x) == x && Math.floor(y) == y ? temp + "[" + (int)x + ", " + (int)y + "]<br>" : temp + "[" + JSparklinesIntervalChartTableCellRenderer.roundDouble(x, 2) + ", " + JSparklinesIntervalChartTableCellRenderer.roundDouble(y, 2) + "]<br>";
            }
            temp = temp + "</html>";
            this.setToolTipText(temp);
        }
        if (this.showNumberAndChart) {
            DecimalFormat numberFormat = new DecimalFormat("0.00");
            numberFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
            if (value instanceof Double || value instanceof Float) {
                double temp = Double.valueOf("" + value);
                if (temp == -1.0) {
                    this.valueLabel.setText("N/A");
                } else {
                    this.valueLabel.setText(numberFormat.format(temp));
                }
            } else if (value instanceof Integer || value instanceof Short || value instanceof Long || value instanceof Byte) {
                this.valueLabel.setText("" + Integer.valueOf("" + value));
            } else if (value instanceof XYDataPoint) {
                this.valueLabel.setText("[" + JSparklinesIntervalChartTableCellRenderer.roundDouble(((XYDataPoint)value).getX(), 2) + ", " + JSparklinesIntervalChartTableCellRenderer.roundDouble(((XYDataPoint)value).getY(), 2) + "]");
            } else if (value instanceof XYDataPoint[]) {
                XYDataPoint[] tempValues;
                String temp = "";
                for (XYDataPoint tempValue : tempValues = (XYDataPoint[])value) {
                    temp = temp + "[" + JSparklinesIntervalChartTableCellRenderer.roundDouble(tempValue.getX(), 2) + ", " + JSparklinesIntervalChartTableCellRenderer.roundDouble(tempValue.getY(), 2) + "] ";
                }
                this.valueLabel.setText(temp);
            }
            Color bg = c.getBackground();
            this.valueLabel.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            if (this.labelHorizontalAlignement == 4) {
                this.valueLabel.setText(this.valueLabel.getText() + "  ");
            } else if (this.labelHorizontalAlignement == 2) {
                this.valueLabel.setText("  " + this.valueLabel.getText());
            }
            this.valueLabel.setForeground(c.getForeground());
            this.valueLabel.setHorizontalAlignment(this.labelHorizontalAlignement);
            this.valueLabel.setMinimumSize(new Dimension(this.widthOfValueLabel, 0));
            this.valueLabel.setSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
            this.valueLabel.setMaximumSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
            this.valueLabel.setPreferredSize(new Dimension(this.widthOfValueLabel, this.valueLabel.getPreferredSize().height));
            this.valueLabel.setVisible(true);
        } else {
            this.valueLabel.setMinimumSize(new Dimension(0, 0));
            this.valueLabel.setSize(0, 0);
            this.valueLabel.setVisible(false);
        }
        this.setBorder(c.getBorder());
        this.setOpaque(c.isOpaque());
        this.setBackground(c.getBackground());
        DefaultIntervalCategoryDataset dataset = null;
        if (value instanceof Double || value instanceof Float) {
            if (value instanceof Float) {
                value = ((Float)value).doubleValue();
            }
            if ((Double)value < this.minimumChartValue && (Double)value > 0.0) {
                value = this.minimumChartValue;
            }
            if ((Double)value == -1.0) {
                lows = new double[][]{{0.0}};
                double[][] highs = new double[][]{{0.0}};
                dataset = new DefaultIntervalCategoryDataset((double[][])lows, (double[][])highs);
            } else {
                lows = new double[][]{{(Double)value - this.widthOfInterval / 2.0}};
                double[][] highs = new double[][]{{(Double)value + this.widthOfInterval / 2.0}};
                dataset = new DefaultIntervalCategoryDataset((double[][])lows, (double[][])highs);
            }
        } else if (value instanceof Integer || value instanceof Short || value instanceof Long || value instanceof Byte) {
            if (value instanceof Short) {
                value = ((Short)value).intValue();
            } else if (value instanceof Long) {
                value = ((Long)value).intValue();
            } else if (value instanceof Byte) {
                value = ((Byte)value).intValue();
            }
            if ((double)((Integer)value).intValue() < this.minimumChartValue && (Integer)value > 0) {
                value = Double.valueOf(this.minimumChartValue).intValue();
            }
            lows = new double[][]{{(double)((Integer)value).intValue() - this.widthOfInterval / 2.0}};
            double[][] highs = new double[][]{{(double)((Integer)value).intValue() + this.widthOfInterval / 2.0}};
            dataset = new DefaultIntervalCategoryDataset((double[][])lows, (double[][])highs);
        } else if (value instanceof XYDataPoint) {
            lows = new double[][]{{((XYDataPoint)value).getX()}};
            double[][] highs = new double[][]{{((XYDataPoint)value).getY()}};
            if (((XYDataPoint)value).getX() > ((XYDataPoint)value).getY()) {
                throw new IllegalArgumentException("Lower interval range >= upper interval range! " + ((XYDataPoint)value).getX() + ">" + ((XYDataPoint)value).getY());
            }
            dataset = new DefaultIntervalCategoryDataset((double[][])lows, (double[][])highs);
        } else if (value instanceof XYDataPoint[]) {
            XYDataPoint[] values = (XYDataPoint[])value;
            double[][] lows2 = new double[values.length][1];
            double[][] highs = new double[values.length][1];
            for (i = 0; i < values.length; ++i) {
                lows2[i][0] = values[i].getX();
                highs[i][0] = values[i].getY();
                if (!(lows2[i][0] >= highs[i][0])) continue;
                throw new IllegalArgumentException("Lower interval range >= upper interval range! " + lows2[i][0] + ">=" + highs[i][0]);
            }
            dataset = new DefaultIntervalCategoryDataset(lows2, highs);
        }
        CategoryPlot plot = this.chart.getCategoryPlot();
        plot.getRangeAxis().setRange(this.minValue, this.maxValue);
        plot.setDataset(dataset);
        plot.setOutlineVisible(false);
        plot.getRangeAxis().setVisible(false);
        plot.getDomainAxis().setVisible(false);
        plot.setRangeGridlinesVisible(false);
        IntervalBarRenderer renderer = new IntervalBarRenderer();
        renderer.setShadowVisible(false);
        if (value instanceof Double || value instanceof Float) {
            if (value instanceof Float) {
                value = ((Float)value).doubleValue();
            }
            if (this.gradientColoring) {
                renderer.setSeriesPaint(0, (Paint)GradientColorCoding.findGradientColor((Double)value, this.minValue, this.maxValue, this.currentColorGradient, this.positiveColorGradient));
            } else if ((Double)value >= 0.0) {
                renderer.setSeriesPaint(0, (Paint)this.positiveValuesColor);
            } else {
                renderer.setSeriesPaint(0, (Paint)this.negativeValuesColor);
            }
        } else if (value instanceof Integer || value instanceof Short || value instanceof Long || value instanceof Byte) {
            if (value instanceof Short) {
                value = ((Short)value).intValue();
            } else if (value instanceof Long) {
                value = ((Long)value).intValue();
            } else if (value instanceof Byte) {
                value = ((Byte)value).intValue();
            }
            if (this.gradientColoring) {
                renderer.setSeriesPaint(0, (Paint)GradientColorCoding.findGradientColor(((Integer)value).doubleValue(), this.minValue, this.maxValue, this.currentColorGradient, this.positiveColorGradient));
            } else if ((Integer)value >= 0) {
                renderer.setSeriesPaint(0, (Paint)this.positiveValuesColor);
            } else {
                renderer.setSeriesPaint(0, (Paint)this.negativeValuesColor);
            }
        } else if (value instanceof XYDataPoint) {
            double temp = ((XYDataPoint)value).getX() + ((XYDataPoint)value).getY();
            temp /= 2.0;
            if (this.gradientColoring) {
                renderer.setSeriesPaint(0, (Paint)GradientColorCoding.findGradientColor(temp, this.minValue, this.maxValue, this.currentColorGradient, this.positiveColorGradient));
            } else if (temp >= 0.0) {
                renderer.setSeriesPaint(0, (Paint)this.positiveValuesColor);
            } else {
                renderer.setSeriesPaint(0, (Paint)this.negativeValuesColor);
            }
        } else if (value instanceof XYDataPoint[]) {
            XYDataPoint[] values = (XYDataPoint[])value;
            for (i = 0; i < values.length; ++i) {
                double temp = values[i].getX() + values[i].getY();
                temp /= 2.0;
                if (this.gradientColoring) {
                    renderer.setSeriesPaint(i, (Paint)GradientColorCoding.findGradientColor(temp, this.minValue, this.maxValue, this.currentColorGradient, this.positiveColorGradient));
                    continue;
                }
                if (temp >= 0.0) {
                    renderer.setSeriesPaint(i, (Paint)this.positiveValuesColor);
                    continue;
                }
                renderer.setSeriesPaint(i, (Paint)this.negativeValuesColor);
            }
        }
        if (this.showReferenceLine) {
            DefaultCategoryDataset referenceLineDataset = new DefaultCategoryDataset();
            referenceLineDataset.addValue(this.maxValue, (Comparable)((Object)"A"), (Comparable)((Object)"B"));
            plot.setDataset(1, (CategoryDataset)referenceLineDataset);
            LayeredBarRenderer referenceLineRenderer = new LayeredBarRenderer();
            referenceLineRenderer.setSeriesBarWidth(0, this.referenceLineWidth);
            referenceLineRenderer.setSeriesFillPaint(0, (Paint)this.referenceLineColor);
            referenceLineRenderer.setSeriesPaint(0, (Paint)this.referenceLineColor);
            plot.setRenderer(1, (CategoryItemRenderer)referenceLineRenderer);
        }
        if (this.plotBackgroundColor != null && !isSelected) {
            plot.setBackgroundPaint((Paint)this.plotBackgroundColor);
            this.chartPanel.setBackground(this.plotBackgroundColor);
            this.chart.setBackgroundPaint((Paint)this.plotBackgroundColor);
        } else {
            Color bg = c.getBackground();
            plot.setBackgroundPaint((Paint)new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.chartPanel.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.chart.setBackgroundPaint((Paint)new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
            this.setBackground(new Color(bg.getRed(), bg.getGreen(), bg.getBlue()));
        }
        plot.setRenderer((CategoryItemRenderer)renderer);
        return this;
    }

    private static double roundDouble(double d, int places) {
        return (double)Math.round(d * Math.pow(10.0, places)) / Math.pow(10.0, places);
    }

    public double getMinimumChartValue() {
        return this.minimumChartValue;
    }

    public void setMinimumChartValue(double minimumChartValue) {
        this.minimumChartValue = minimumChartValue;
    }

    public double getTooltipLowerValue() {
        return this.tooltipLowerValue;
    }

    public void setTooltipLowerValue(double tooltipLowerValue) {
        this.tooltipLowerValue = tooltipLowerValue;
    }

    public void setNegativeValuesColor(Color negativeValuesColor) {
        this.negativeValuesColor = negativeValuesColor;
    }

    public void setPositiveValuesColor(Color positiveValuesColor) {
        this.positiveValuesColor = positiveValuesColor;
    }

    static {
        IntervalBarRenderer.setDefaultBarPainter((BarPainter)new StandardBarPainter());
    }
}

