/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.settings.PathKey;
import eu.isas.searchgui.preferences.SearchGUIPathPreferences;
import eu.isas.searchgui.utilities.Properties;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class SearchGUIWrapper
extends CompomicsWrapper {
    public SearchGUIWrapper() {
        this(null);
    }

    public SearchGUIWrapper(String[] args) {
        String jarFileName = "SearchGUI-" + new Properties().getVersion() + ".jar";
        String path = this.getJarFilePath();
        File jarFile = new File(path, jarFileName);
        String splash = "searchgui-splash.png";
        String mainClass = "eu.isas.searchgui.gui.SearchGUI";
        try {
            this.setPathConfiguration();
        }
        catch (Exception e) {
            System.out.println("Unable to load the path configurations. Default paths will be used.");
        }
        try {
            ArrayList<PathKey> errorKeys = SearchGUIPathPreferences.getErrorKeys(this.getJarFilePath());
            if (!errorKeys.isEmpty()) {
                System.out.println("Unable to write in the following configuration folders. Please edit the configuration paths.");
                for (PathKey pathKey : errorKeys) {
                    System.out.println(pathKey.getId() + ": " + pathKey.getDescription());
                }
            }
        }
        catch (Exception e) {
            System.out.println("Unable to load the path configurations. Default paths will be used.");
        }
        this.launchTool("SearchGUI", jarFile, splash, mainClass, args);
    }

    private void setPathConfiguration() throws IOException {
        File pathConfigurationFile = new File(this.getJarFilePath(), "resources/conf/paths.txt");
        if (pathConfigurationFile.exists()) {
            SearchGUIPathPreferences.loadPathPreferencesFromFile(pathConfigurationFile);
        }
    }

    public String getJarFilePath() {
        return CompomicsWrapper.getJarFilePath(this.getClass().getResource("SearchGUIWrapper.class").getPath(), "SearchGUI");
    }

    public static void main(String[] args) {
        new SearchGUIWrapper(args);
    }
}

