/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.Util;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationParametersFactory;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.AndromedaParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.CometParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.MyriMatchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.OmssaParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.TideParameters;
import com.compomics.util.experiment.identification.protein_sequences.SequenceFactory;
import com.compomics.util.experiment.io.massspectrometry.export.AplExporter;
import com.compomics.util.experiment.io.massspectrometry.export.Ms2Exporter;
import com.compomics.util.experiment.massspectrometry.SpectrumFactory;
import com.compomics.util.experiment.massspectrometry.proteowizard.MsConvertParameters;
import com.compomics.util.gui.filehandling.TempFilesManager;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingDialog;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.io.ConfigurationFile;
import com.compomics.util.io.compression.ZipUtils;
import com.compomics.util.preferences.IdentificationParameters;
import com.compomics.util.preferences.ProcessingPreferences;
import com.compomics.util.preferences.SearchGuiOutputOption;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.waiting.Duration;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.AndromedaProcessBuilder;
import eu.isas.searchgui.processbuilders.CometProcessBuilder;
import eu.isas.searchgui.processbuilders.DirecTagProcessBuilder;
import eu.isas.searchgui.processbuilders.MakeblastdbProcessBuilder;
import eu.isas.searchgui.processbuilders.MsAmandaProcessBuilder;
import eu.isas.searchgui.processbuilders.MsConvertProcessBuilder;
import eu.isas.searchgui.processbuilders.MsgfProcessBuilder;
import eu.isas.searchgui.processbuilders.MyriMatchProcessBuilder;
import eu.isas.searchgui.processbuilders.NovorProcessBuilder;
import eu.isas.searchgui.processbuilders.OmssaclProcessBuilder;
import eu.isas.searchgui.processbuilders.PeptideShakerProcessBuilder;
import eu.isas.searchgui.processbuilders.TandemProcessBuilder;
import eu.isas.searchgui.processbuilders.TideIndexProcessBuilder;
import eu.isas.searchgui.processbuilders.TideSearchProcessBuilder;
import eu.isas.searchgui.utilities.Properties;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.apache.commons.io.FileUtils;

public class SearchHandler {
    private static final String SEARCHGUI_INPUT = "searchGUI_input.txt";
    private WaitingHandler waitingHandler;
    private static String enzymeFile = "resources/conf/searchGUI_enzymes.xml";
    public static final String OUTPUT_TEMP_FOLDER_NAME = ".SearchGUI_temp";
    private static final String PEAK_LIST_SUBFOLDER = "peak_lists";
    private static boolean useCommandLine = false;
    private SearchWorker searchWorker;
    private IndexingWorker indexingWorker;
    private File resultsFolder;
    private boolean enableOmssa = false;
    private boolean enableXtandem = false;
    private boolean enableMsgf = false;
    private boolean enableMsAmanda = false;
    private boolean enableMyriMatch = false;
    private boolean enableComet = false;
    private boolean enableTide = false;
    private boolean enableAndromeda = false;
    private boolean enableNovor = false;
    private boolean enableDirecTag = false;
    private boolean enablePeptideShaker = false;
    private boolean enableReporter = false;
    private IdentificationParameters identificationParameters;
    private File identificationParametersFile;
    private ArrayList<File> rawFiles;
    private ArrayList<File> mgfFiles;
    private File omssaLocation = null;
    private File xtandemLocation = null;
    private File msgfLocation = null;
    private File msAmandaLocation = null;
    private File myriMatchLocation = null;
    private File cometLocation = null;
    private File tideLocation = null;
    private File andromedaLocation = null;
    private File novorLocation = null;
    private File direcTagLocation = null;
    private File makeblastdbLocation;
    private String experimentLabel;
    private String sampleLabel;
    private Integer replicateNumber = 0;
    private File peptideShakerFile = null;
    private ArrayList<File> mascotFiles = new ArrayList();
    private ArrayList<MsConvertProcessBuilder> msConvertProcessBuilders = null;
    private MakeblastdbProcessBuilder makeblastdbProcessBuilder = null;
    private OmssaclProcessBuilder omssaProcessBuilder = null;
    private TandemProcessBuilder xTandemProcessBuilder = null;
    private MsgfProcessBuilder msgfProcessBuilder = null;
    private MsAmandaProcessBuilder msAmandaProcessBuilder = null;
    private MyriMatchProcessBuilder myriMatchProcessBuilder = null;
    private CometProcessBuilder cometProcessBuilder = null;
    private TideIndexProcessBuilder tideIndexProcessBuilder = null;
    private TideSearchProcessBuilder tideSearchProcessBuilder = null;
    private AndromedaProcessBuilder andromedaProcessBuilder = null;
    private NovorProcessBuilder novorProcessBuilder = null;
    private DirecTagProcessBuilder direcTagProcessBuilder = null;
    private PeptideShakerProcessBuilder peptideShakerProcessBuilder = null;
    private ProcessingPreferences processingPreferences = new ProcessingPreferences();
    private MsConvertParameters msConvertParameters;
    public static final String DEFAULT_OUTPUT = "searchgui_out";
    public static final String DEFAULT_OUTPUT_FILE_NAME_ENDING = ".zip";
    public static final String DEFAULT_DATA_FOLDER = "data";
    public static final String SEARCHGUI_CONFIGURATION_FILE = "searchGUI_configuration.txt";
    private ExceptionHandler exceptionHandler;
    private static String tempFolderPath = null;
    private Duration searchDuration;
    private File logFolder = null;
    private static String outputTimeStamp = null;
    private HashMap<String, File> idFileToSpectrumFileMap;
    private IdentificationParametersFactory identificationParametersFactory = IdentificationParametersFactory.getInstance();

    public SearchHandler(IdentificationParameters identificationParameters, File resultsFolder, ArrayList<File> mgfFiles, ArrayList<File> rawFiles, File identificationParametersFile, ProcessingPreferences processingPreferences, ExceptionHandler exceptionHandler) {
        this.resultsFolder = resultsFolder;
        this.mgfFiles = mgfFiles;
        this.rawFiles = rawFiles;
        this.exceptionHandler = exceptionHandler;
        this.enableOmssa = this.loadSearchEngineLocation(Advocate.omssa, false, true, true, true, false, false, false);
        this.enableXtandem = this.loadSearchEngineLocation(Advocate.xtandem, false, true, true, true, true, false, true);
        this.enableMsgf = this.loadSearchEngineLocation(Advocate.msgf, true, true, true, true, false, false, false);
        this.enableMsAmanda = this.loadSearchEngineLocation(Advocate.msAmanda, false, true, true, true, false, false, false);
        this.enableMyriMatch = this.loadSearchEngineLocation(Advocate.myriMatch, false, true, false, true, true, false, true);
        this.enableComet = this.loadSearchEngineLocation(Advocate.comet, false, true, false, true, true, false, false);
        this.enableTide = this.loadSearchEngineLocation(Advocate.tide, false, true, true, true, true, false, true);
        this.enableAndromeda = this.loadSearchEngineLocation(Advocate.andromeda, false, true, false, false, false, false, false);
        this.enableNovor = this.loadSearchEngineLocation(Advocate.novor, true, true, true, true, false, false, false);
        this.enableDirecTag = this.loadSearchEngineLocation(Advocate.direcTag, false, true, false, true, true, false, true);
        this.identificationParametersFile = identificationParametersFile;
        this.processingPreferences = processingPreferences;
        this.identificationParameters = identificationParameters;
        this.searchDuration = new Duration();
    }

    public SearchHandler(IdentificationParameters identificationParameters, File resultsFolder, ArrayList<File> mgfFiles, ArrayList<File> rawFiles, File identificationParametersFile, boolean searchOmssa, boolean searchXTandem, boolean searchMsgf, boolean searchMsAmanda, boolean searchMyriMatch, boolean searchComet, boolean searchTide, boolean searchAndromeda, boolean runNovor, boolean runDirecTag, File omssaFolder, File xTandemFolder, File msgfFolder, File msAmandaFolder, File myriMatchFolder, File cometFolder, File tideFolder, File andromedaFolder, File novorFolder, File direcTagFolder, File makeblastdbFolder, ProcessingPreferences processingPreferences) {
        this.resultsFolder = resultsFolder;
        this.mgfFiles = mgfFiles;
        this.rawFiles = rawFiles;
        this.enableOmssa = searchOmssa;
        this.enableXtandem = searchXTandem;
        this.enableMsgf = searchMsgf;
        this.enableMsAmanda = searchMsAmanda;
        this.enableMyriMatch = searchMyriMatch;
        this.enableComet = searchComet;
        this.enableTide = searchTide;
        this.enableAndromeda = searchAndromeda;
        this.enableNovor = runNovor;
        this.enableDirecTag = runDirecTag;
        this.identificationParameters = identificationParameters;
        this.processingPreferences = processingPreferences;
        this.identificationParametersFile = identificationParametersFile;
        if (omssaFolder != null) {
            this.omssaLocation = omssaFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.omssa, false, true, true, true, false, false, false);
        }
        if (xTandemFolder != null) {
            this.xtandemLocation = xTandemFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.xtandem, false, true, true, true, true, false, true);
        }
        if (msgfFolder != null) {
            this.msgfLocation = msgfFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.msgf, true, true, true, true, false, false, false);
        }
        if (msAmandaFolder != null) {
            this.msAmandaLocation = msAmandaFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.msAmanda, false, true, true, true, false, false, false);
        }
        if (myriMatchFolder != null) {
            this.myriMatchLocation = myriMatchFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.myriMatch, false, true, false, true, true, false, true);
        }
        if (cometFolder != null) {
            this.cometLocation = cometFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.comet, false, true, false, true, true, false, false);
        }
        if (tideFolder != null) {
            this.tideLocation = tideFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.tide, false, true, true, true, true, false, true);
        }
        if (andromedaFolder != null) {
            this.andromedaLocation = andromedaFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.andromeda, false, true, false, false, false, false, false);
        }
        if (novorFolder != null) {
            this.novorLocation = novorFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.novor, true, true, true, true, false, false, false);
        }
        if (direcTagFolder != null) {
            this.direcTagLocation = direcTagFolder;
        } else {
            this.loadSearchEngineLocation(Advocate.direcTag, false, true, false, true, true, false, true);
        }
        if (makeblastdbFolder != null) {
            this.makeblastdbLocation = makeblastdbFolder;
        } else {
            this.loadSearchEngineLocation(null, false, true, true, true, false, false, true);
        }
        if (!this.getJarFilePath().equalsIgnoreCase(".")) {
            UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
            String versionNumber = new Properties().getVersion();
            utilitiesUserPreferences.setSearchGuiPath(new File(this.getJarFilePath(), "SearchGUI-" + versionNumber + ".jar").getAbsolutePath());
            UtilitiesUserPreferences.saveUserPreferences(utilitiesUserPreferences);
        }
        this.searchDuration = new Duration();
    }

    public synchronized void startSearch(WaitingHandler waitingHandler) throws InterruptedException {
        this.waitingHandler = waitingHandler;
        this.searchDuration.start();
        this.searchWorker = new SearchWorker(waitingHandler);
        this.searchWorker.execute();
        this.indexingWorker = new IndexingWorker(waitingHandler);
        this.indexingWorker.execute();
        if (waitingHandler != null && waitingHandler instanceof WaitingDialog) {
            try {
                ((WaitingDialog)waitingHandler).setVisible(true);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ((WaitingDialog)waitingHandler).setModal(true);
        } else {
            useCommandLine = true;
        }
        if (useCommandLine && !this.searchWorker.isFinished()) {
            this.wait();
        }
    }

    private synchronized void notifySearchFinished() {
        this.notify();
    }

    public void cancelSearch() {
        this.searchWorker.cancelRun();
        if (this.waitingHandler != null) {
            this.waitingHandler.setRunCanceled();
        }
    }

    public static File getEnzymesFile(String jarFilePath) {
        File result = new File(jarFilePath, enzymeFile);
        if (!result.exists()) {
            throw new IllegalArgumentException(enzymeFile + " not found.");
        }
        return result;
    }

    private void searchCompleted() {
        if (this.searchWorker.isFinished() && this.indexingWorker.isFinished()) {
            if (this.waitingHandler != null) {
                if (this.waitingHandler instanceof WaitingDialog) {
                    ((JFrame)((WaitingDialog)this.waitingHandler).getParent()).setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")));
                }
                this.searchDuration.end();
                this.waitingHandler.appendReport("Search Completed (" + this.searchDuration.toString() + ").", true, true);
                this.waitingHandler.appendReportEndLine();
            }
            this.saveReport();
            if (this.waitingHandler != null && !this.waitingHandler.isRunCanceled()) {
                this.waitingHandler.setRunFinished();
            }
            if (this.enablePeptideShaker) {
                if (this.peptideShakerFile.exists()) {
                    try {
                        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
                        CompomicsWrapper wrapper = new CompomicsWrapper();
                        ArrayList<String> javaHomeAndOptions = wrapper.getJavaHomeAndOptions(utilitiesUserPreferences.getPeptideShakerPath());
                        ArrayList<String> process_name_array = new ArrayList<String>();
                        process_name_array.add(javaHomeAndOptions.get(0));
                        for (int i = 1; i < javaHomeAndOptions.size(); ++i) {
                            process_name_array.add(javaHomeAndOptions.get(i));
                        }
                        process_name_array.add("-jar");
                        process_name_array.add(new File(utilitiesUserPreferences.getPeptideShakerPath()).getName());
                        process_name_array.add("-cps");
                        process_name_array.add(CommandLineUtils.getCommandLineArgument(this.peptideShakerFile));
                        ProcessBuilder openPeptideShakerProcess = new ProcessBuilder(process_name_array);
                        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "PeptideShaker command: ");
                        for (String currentElement : process_name_array) {
                            System.out.print(currentElement + " ");
                        }
                        System.out.println(System.getProperty("line.separator"));
                        File psFolder = new File(utilitiesUserPreferences.getPeptideShakerPath()).getParentFile();
                        openPeptideShakerProcess.directory(psFolder);
                        openPeptideShakerProcess.redirectErrorStream(true);
                        openPeptideShakerProcess.start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (this.waitingHandler != null) {
                    this.waitingHandler.appendReport("PeptideShaker file (" + this.peptideShakerFile.getAbsolutePath() + ") not found!", true, true);
                }
            }
            if (useCommandLine) {
                System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "Search Completed." + System.getProperty("line.separator"));
                System.exit(0);
            }
        } else if (!this.indexingWorker.isFinished()) {
            this.waitingHandler.appendReport("Search completed. Waiting for the file indexing to finish.", true, true);
            this.waitingHandler.appendReportEndLine();
            this.waitingHandler.appendReport("Please do not close SearchGUI.", true, true);
            this.waitingHandler.appendReportEndLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveReport() {
        block14: {
            FileWriter fw;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH.mm.ss");
            String fileName = "SearchGUI Report " + df.format(new Date()) + ".html";
            String report = "";
            if (this.waitingHandler instanceof WaitingDialog) {
                report = "<pre>" + ((WaitingDialog)this.waitingHandler).getReport(new File(this.resultsFolder, fileName)) + "</pre>";
            }
            report = report + this.identificationParameters.getSearchParameters().toString(true);
            report = "<html>" + report + "</html>";
            try {
                fw = new FileWriter(new File(this.resultsFolder, fileName));
                try {
                    fw.write(report);
                }
                finally {
                    fw.close();
                }
            }
            catch (IOException e) {
                if (this.waitingHandler != null) {
                    this.waitingHandler.appendReport("Failed to write to the report file!", true, true);
                }
                e.printStackTrace();
            }
            try {
                if (this.logFolder == null) break block14;
                fw = new FileWriter(new File(this.logFolder, fileName));
                try {
                    fw.write(report);
                }
                finally {
                    fw.close();
                }
            }
            catch (IOException e) {
                if (this.waitingHandler != null) {
                    this.waitingHandler.appendReport("Failed to write to the log report file!", true, true);
                }
                e.printStackTrace();
            }
        }
    }

    private void searchCrashed() {
        if (this.waitingHandler != null) {
            if (this.waitingHandler instanceof WaitingDialog) {
                ((JFrame)((WaitingDialog)this.waitingHandler).getParent()).setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")));
            }
            this.waitingHandler.appendReport("The search or processing did not finish properly!", true, true);
            this.waitingHandler.setRunCanceled();
            this.saveReport();
            if (this.waitingHandler instanceof WaitingHandlerCLIImpl) {
                System.exit(0);
            }
        } else {
            System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "The search did not finish properly:" + System.getProperty("line.separator") + 0);
            System.exit(0);
        }
    }

    private boolean loadSearchEngineLocation(Advocate searchEngineAdvocate, boolean sameVersionForAll, boolean windowsSupported, boolean osxSupported, boolean linuxSupported, boolean windowsBitVersions, boolean osxBitVersions, boolean linuxBitVersions) {
        boolean enableSearchEngine = false;
        String advocateName = searchEngineAdvocate == null ? "makeblastdb" : searchEngineAdvocate.getName();
        String correctedAdvocateName = advocateName.replaceAll("!", "");
        File folder = new File(this.getJarFilePath() + File.separator + "resources" + File.separator + "conf" + File.separator);
        File searchEngineLoation = null;
        if (folder.exists()) {
            File input = new File(folder, SEARCHGUI_CONFIGURATION_FILE);
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(input));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).equals("") || line.startsWith("#") || !line.equals(advocateName + " Location:")) continue;
                    String result = br.readLine().trim();
                    searchEngineLoation = new File(result);
                    if (result.equalsIgnoreCase("Not Selected") || !searchEngineLoation.exists()) {
                        String basePath = this.getJarFilePath() + File.separator + "resources" + File.separator + correctedAdvocateName;
                        if (sameVersionForAll) {
                            searchEngineLoation = new File(basePath);
                        } else {
                            boolean is64Bit;
                            String operatingSystem = System.getProperty("os.name").toLowerCase();
                            String arch = System.getProperty("os.arch").toLowerCase();
                            boolean bl = is64Bit = arch.lastIndexOf("64") != -1;
                            searchEngineLoation = operatingSystem.contains("windows") && windowsSupported ? (!windowsBitVersions ? new File(basePath + File.separator + "windows") : (is64Bit ? new File(basePath + File.separator + "windows" + File.separator + "windows_64bit") : new File(basePath + File.separator + "windows" + File.separator + "windows_32bit"))) : (operatingSystem.contains("mac os") && osxSupported ? (!osxBitVersions ? new File(basePath + File.separator + "osx") : (is64Bit ? new File(basePath + File.separator + "osx" + File.separator + "osx_64bit") : new File(basePath + File.separator + "osx" + File.separator + "osx_32bit"))) : ((operatingSystem.contains("nix") || operatingSystem.contains("nux")) && linuxSupported ? (!linuxBitVersions ? new File(basePath + File.separator + "linux") : (is64Bit ? new File(basePath + File.separator + "linux" + File.separator + "linux_64bit") : new File(basePath + File.separator + "linux" + File.separator + "linux_32bit"))) : null));
                        }
                    } else {
                        searchEngineLoation = new File(result);
                    }
                    if (searchEngineLoation == null) {
                        enableSearchEngine = false;
                        continue;
                    }
                    String selected = br.readLine().trim();
                    if (selected.length() > 0) {
                        enableSearchEngine = Boolean.parseBoolean(selected);
                        continue;
                    }
                    enableSearchEngine = true;
                }
                br.close();
            }
            catch (IOException ioe) {
                enableSearchEngine = false;
                ioe.printStackTrace();
                JOptionPane.showMessageDialog(null, "An error occurred when trying to load the " + advocateName + " location.", "Configuration Import Error", 0);
            }
        } else {
            enableSearchEngine = false;
        }
        if (searchEngineAdvocate != null) {
            if (searchEngineAdvocate == Advocate.omssa) {
                this.omssaLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.xtandem) {
                this.xtandemLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.myriMatch) {
                this.myriMatchLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.msAmanda) {
                this.msAmandaLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.msgf) {
                this.msgfLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.comet) {
                this.cometLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.tide) {
                this.tideLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.andromeda) {
                this.andromedaLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.novor) {
                this.novorLocation = searchEngineLoation;
            } else if (searchEngineAdvocate == Advocate.direcTag) {
                this.direcTagLocation = searchEngineLoation;
            }
        } else {
            this.makeblastdbLocation = searchEngineLoation;
        }
        return enableSearchEngine;
    }

    public String loadModificationsUse() {
        String result = "";
        File folder = new File(this.getJarFilePath() + File.separator + "resources" + File.separator + "conf" + File.separator);
        if (folder.exists()) {
            File input = new File(folder, SEARCHGUI_CONFIGURATION_FILE);
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(input));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).equals("") || line.startsWith("#") || !line.equals("Modification use:")) continue;
                    result = br.readLine().trim();
                }
                br.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                JOptionPane.showMessageDialog(null, "An error occurred when trying to load the modifications preferences.", "Configuration Import Error", 0);
            }
        }
        return result;
    }

    public static String getXTandemFileName(String spectrumFileName) {
        return Util.removeExtension(spectrumFileName) + ".t.xml";
    }

    public String getCometFileName(String spectrumFileName) {
        CometParameters cometParameters = (CometParameters)this.identificationParameters.getSearchParameters().getIdentificationAlgorithmParameter(Advocate.comet.getIndex());
        return SearchHandler.getCometFileName(spectrumFileName, cometParameters);
    }

    public static String getCometFileName(String spectrumFileName, CometParameters cometParameters) {
        if (cometParameters.getSelectedOutputFormat() != null) {
            switch (cometParameters.getSelectedOutputFormat()) {
                case PepXML: {
                    return Util.removeExtension(spectrumFileName) + ".comet.pep.xml";
                }
                case Percolator: {
                    return Util.removeExtension(spectrumFileName) + ".comet.pin";
                }
                case SQT: {
                    return Util.removeExtension(spectrumFileName) + ".comet.sqt";
                }
                case TXT: {
                    return Util.removeExtension(spectrumFileName) + ".comet.txt";
                }
            }
        }
        return Util.removeExtension(spectrumFileName) + ".comet.pep.xml";
    }

    public String getTideFileName(String spectrumFileName) {
        TideParameters tideParameters = (TideParameters)this.identificationParameters.getSearchParameters().getIdentificationAlgorithmParameter(Advocate.tide.getIndex());
        return SearchHandler.getTideFileName(spectrumFileName, tideParameters);
    }

    public static String getTideFileName(String spectrumFileName, TideParameters tideParameters) {
        if (tideParameters.getTextOutput().booleanValue()) {
            return Util.removeExtension(spectrumFileName) + ".tide-search.target.txt";
        }
        if (tideParameters.getMzidOutput().booleanValue()) {
            return Util.removeExtension(spectrumFileName) + ".tide-search.target.mzid";
        }
        if (tideParameters.getPepXmlOutput().booleanValue()) {
            return Util.removeExtension(spectrumFileName) + ".tide-search.target.pep.xml";
        }
        if (tideParameters.getSqtOutput().booleanValue()) {
            return Util.removeExtension(spectrumFileName) + ".tide-search.target.sqt";
        }
        return Util.removeExtension(spectrumFileName) + ".tide-search.target.pin";
    }

    public static String getAndromedaFileName(String spectrumFileName) {
        return Util.removeExtension(spectrumFileName) + ".res";
    }

    public static String getNovorFileName(String spectrumFileName) {
        return Util.removeExtension(spectrumFileName) + ".novor.csv";
    }

    public static String getDirecTagFileName(String spectrumFileName) {
        return Util.removeExtension(spectrumFileName) + ".tags";
    }

    public String getOMSSAFileName(String spectrumFileName) {
        OmssaParameters omssaParameters = (OmssaParameters)this.identificationParameters.getSearchParameters().getIdentificationAlgorithmParameter(Advocate.omssa.getIndex());
        return SearchHandler.getOMSSAFileName(spectrumFileName, omssaParameters);
    }

    public static String getOMSSAFileName(String spectrumFileName, OmssaParameters omssaParameters) {
        return Util.removeExtension(spectrumFileName) + "." + omssaParameters.getSelectedOutput().toLowerCase();
    }

    public static String getMsgfFileName(String spectrumFileName) {
        return Util.removeExtension(spectrumFileName) + ".msgf.mzid";
    }

    public static String getMsAmandaFileName(String spectrumFileName) {
        return Util.removeExtension(spectrumFileName) + ".ms-amanda.csv";
    }

    public String getMyriMatchFileName(String spectrumFileName) {
        MyriMatchParameters myriMatchParameters = (MyriMatchParameters)this.identificationParameters.getSearchParameters().getIdentificationAlgorithmParameter(Advocate.myriMatch.getIndex());
        return SearchHandler.getMyriMatchFileName(spectrumFileName, myriMatchParameters);
    }

    public static String getMyriMatchFileName(String spectrumFileName, MyriMatchParameters myriMatchParameters) {
        if (myriMatchParameters.getOutputFormat().equalsIgnoreCase("mzIdentML")) {
            return Util.removeExtension(spectrumFileName) + ".myrimatch.mzid";
        }
        return Util.removeExtension(spectrumFileName) + ".myrimatch.pepXML";
    }

    public ArrayList<File> getXTandemFiles(File folder, String spectrumFileName) {
        String regex = ".*\\d{4}_\\d{2}[_]\\d{2}[_]\\d{2}[_]\\d{2}[_]\\d{2}[.]t[.]xml";
        Pattern pattern = Pattern.compile(regex);
        ArrayList<File> result = new ArrayList<File>();
        for (File file : folder.listFiles()) {
            String fileName = file.getName();
            Matcher matcher = pattern.matcher(fileName);
            if (!matcher.matches() && !fileName.equals(SearchHandler.getXTandemFileName(spectrumFileName))) continue;
            result.add(file);
        }
        return result;
    }

    public File getOmssaLocation() {
        return this.omssaLocation;
    }

    public void setOmssaLocation(File omssaLocation) {
        this.omssaLocation = omssaLocation;
    }

    public File getXtandemLocation() {
        return this.xtandemLocation;
    }

    public void setXtandemLocation(File xtandemLocation) {
        this.xtandemLocation = xtandemLocation;
    }

    public File getMsgfLocation() {
        return this.msgfLocation;
    }

    public void setMsgfLocation(File msgfLocation) {
        this.msgfLocation = msgfLocation;
    }

    public File getMsAmandaLocation() {
        return this.msAmandaLocation;
    }

    public void setMsAmandaLocation(File msAmandaLocation) {
        this.msAmandaLocation = msAmandaLocation;
    }

    public File getMyriMatchLocation() {
        return this.myriMatchLocation;
    }

    public void setMyriMatchLocation(File myriMatchLocation) {
        this.myriMatchLocation = myriMatchLocation;
    }

    public File getCometLocation() {
        return this.cometLocation;
    }

    public void setCometLocation(File cometLocation) {
        this.cometLocation = cometLocation;
    }

    public File getTideLocation() {
        return this.tideLocation;
    }

    public void setTideLocation(File tideLocation) {
        this.tideLocation = tideLocation;
    }

    public File getAndromedaLocation() {
        return this.andromedaLocation;
    }

    public void setAndromedaLocation(File andromedaLocation) {
        this.andromedaLocation = andromedaLocation;
    }

    public File getNovorLocation() {
        return this.novorLocation;
    }

    public void setNovorLocation(File novorLocation) {
        this.novorLocation = novorLocation;
    }

    public File getDirecTagLocation() {
        return this.direcTagLocation;
    }

    public void setDirecTagLocation(File direcTagLocation) {
        this.direcTagLocation = direcTagLocation;
    }

    public File getMakeblastdbLocation() {
        return this.makeblastdbLocation;
    }

    public void setMakeblastdbLocation(File makeblastdbLocation) {
        this.makeblastdbLocation = makeblastdbLocation;
    }

    public boolean isOmssaEnabled() {
        return this.enableOmssa;
    }

    public void setPeptideShakerEnabled(boolean runPeptideShaker) {
        this.enablePeptideShaker = runPeptideShaker;
    }

    public boolean isPeptideShakerEnabled() {
        return this.enablePeptideShaker;
    }

    public boolean isReporterEnabled() {
        return this.enableReporter;
    }

    public void setOmssaEnabled(boolean runOmssa) {
        this.enableOmssa = runOmssa;
    }

    public boolean isXtandemEnabled() {
        return this.enableXtandem;
    }

    public boolean isMsgfEnabled() {
        return this.enableMsgf;
    }

    public boolean isMsAmandaEnabled() {
        return this.enableMsAmanda;
    }

    public boolean isMyriMatchEnabled() {
        return this.enableMyriMatch;
    }

    public boolean isCometEnabled() {
        return this.enableComet;
    }

    public boolean isTideEnabled() {
        return this.enableTide;
    }

    public boolean isAndromedaEnabled() {
        return this.enableAndromeda;
    }

    public boolean isNovorEnabled() {
        return this.enableNovor;
    }

    public boolean isDirecTagEnabled() {
        return this.enableDirecTag;
    }

    public void setXtandemEnabled(boolean runXtandem) {
        this.enableXtandem = runXtandem;
    }

    public void setMsgfEnabled(boolean runMsgf) {
        this.enableMsgf = runMsgf;
    }

    public void setMsAmandaEnabled(boolean runMsAmanda) {
        this.enableMsAmanda = runMsAmanda;
    }

    public void setMyriMatchEnabled(boolean runMyriMatch) {
        this.enableMyriMatch = runMyriMatch;
    }

    public void setCometEnabled(boolean runComet) {
        this.enableComet = runComet;
    }

    public void setTideEnabled(boolean runTide) {
        this.enableTide = runTide;
    }

    public void setAndromedaEnabled(boolean runAndromeda) {
        this.enableAndromeda = runAndromeda;
    }

    public void setNovorEnabled(boolean runNovor) {
        this.enableNovor = runNovor;
    }

    public void setDirecTagEnabled(boolean runDirecTag) {
        this.enableDirecTag = runDirecTag;
    }

    public File getResultsFolder() {
        return this.resultsFolder;
    }

    public void setResultsFolder(File resultsFolder) {
        this.resultsFolder = resultsFolder;
    }

    public ArrayList<File> getMgfFiles() {
        return this.mgfFiles;
    }

    public void setMgfFiles(ArrayList<File> mgfFiles) {
        this.mgfFiles = mgfFiles;
    }

    public ArrayList<File> getRawFiles() {
        return this.rawFiles;
    }

    public void setRawFiles(ArrayList<File> rawFiles) {
        this.rawFiles = rawFiles;
    }

    public String getExperimentLabel() {
        return this.experimentLabel;
    }

    public void setExperimentLabel(String experimentLabel) {
        this.experimentLabel = experimentLabel;
    }

    public String getSampleLabel() {
        return this.sampleLabel;
    }

    public void setSampleLabel(String sampleLabel) {
        this.sampleLabel = sampleLabel;
    }

    public Integer getReplicateNumber() {
        return this.replicateNumber;
    }

    public void setReplicateNumber(Integer replicateNumber) {
        this.replicateNumber = replicateNumber;
    }

    public File getPeptideShakerFile() {
        return this.peptideShakerFile;
    }

    public void setPeptideShakerFile(File peptideShakerFile) {
        this.peptideShakerFile = peptideShakerFile;
    }

    public void saveInputFile(File folder) {
        File outputFile = SearchHandler.getInputFile(folder);
        ArrayList<File> tempMgfFiles = new ArrayList<File>(this.mgfFiles);
        ArrayList<String> names = new ArrayList<String>();
        for (File file : tempMgfFiles) {
            names.add(file.getName());
        }
        if (outputFile.exists()) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(outputFile));
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).equals("")) continue;
                    try {
                        File newFile = new File(line);
                        if (names.contains(newFile.getName())) continue;
                        names.add(newFile.getName());
                        tempMgfFiles.add(newFile);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                br.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                tempMgfFiles = new ArrayList<File>(this.mgfFiles);
            }
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));
            for (File mgfFile : tempMgfFiles) {
                bw.write(mgfFile.getAbsolutePath() + System.getProperty("line.separator"));
            }
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setIdentificationParameters(IdentificationParameters identificationParameters) {
        this.identificationParameters = identificationParameters;
    }

    public void setIdentificationParametersFile(File identificationParametersFile) {
        this.identificationParametersFile = identificationParametersFile;
    }

    public void setMascotFiles(ArrayList<File> mascotFiles) {
        this.mascotFiles = mascotFiles;
    }

    public ArrayList<File> getMascotFiles() {
        return this.mascotFiles;
    }

    public ProcessingPreferences getProcessingPreferences() {
        return this.processingPreferences;
    }

    public void setProcessingPreferences(ProcessingPreferences processingPreferences) {
        this.processingPreferences = processingPreferences;
    }

    public MsConvertParameters getMsConvertParameters() {
        return this.msConvertParameters;
    }

    public void setMsConvertParameters(MsConvertParameters msConvertParameters) {
        this.msConvertParameters = msConvertParameters;
    }

    public static String getEnzymeFile() {
        return enzymeFile;
    }

    public static void setEnzymeFile(String enzymeFile) {
        SearchHandler.enzymeFile = enzymeFile;
    }

    public static File getDefaultOutputFile(File outputFolder, boolean includeDate) {
        String fileName = "";
        fileName = fileName + DEFAULT_OUTPUT;
        if (includeDate) {
            fileName = fileName + "_" + outputTimeStamp;
        }
        fileName = fileName + DEFAULT_OUTPUT_FILE_NAME_ENDING;
        return new File(outputFolder, fileName);
    }

    public static File getDefaultOutputFile(File outputFolder, String classifier, boolean includeDate) {
        String fileName = classifier;
        fileName = fileName + "_searchgui_out";
        if (includeDate) {
            fileName = fileName + "_" + outputTimeStamp;
        }
        fileName = fileName + DEFAULT_OUTPUT_FILE_NAME_ENDING;
        return new File(outputFolder, fileName);
    }

    public static String getOutputDate() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
        return df.format(new Date());
    }

    public void setOutputTimeStamp(String outputTimeStamp) {
        SearchHandler.outputTimeStamp = outputTimeStamp;
    }

    public static File getInputFile(File outputFolder) {
        return new File(outputFolder, SEARCHGUI_INPUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void organizeOutput(File outputFolder, File tempOutputFolder, HashMap<String, HashMap<Integer, File>> identificationFiles, File parametersFile, boolean includeDate) throws IOException {
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        switch (utilitiesUserPreferences.getOutputOption()) {
            case grouped: {
                File zipFile = SearchHandler.getDefaultOutputFile(outputFolder, includeDate);
                if (zipFile.exists()) {
                    zipFile.delete();
                }
                FileOutputStream fos = new FileOutputStream(zipFile);
                try {
                    BufferedOutputStream bos = new BufferedOutputStream(fos);
                    try {
                        ZipOutputStream out = new ZipOutputStream(bos);
                        long totalUncompressedSize = this.getTotalUncompressedSize(tempOutputFolder, parametersFile, identificationFiles);
                        this.waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                        this.waitingHandler.setSecondaryProgressCounter(0);
                        this.waitingHandler.setMaxSecondaryProgressCounter(100);
                        try {
                            File file = SearchHandler.getInputFile(tempOutputFolder);
                            ZipUtils.addFileToZip(file, out, this.waitingHandler, totalUncompressedSize);
                            ZipUtils.addFileToZip(parametersFile, out, this.waitingHandler, totalUncompressedSize);
                            if (this.enableOmssa) {
                                Iterator<HashMap<Integer, File>> modificationsFile = new File(tempOutputFolder, "omssa_mods.xml");
                                ZipUtils.addFileToZip((File)((Object)modificationsFile), out, this.waitingHandler, totalUncompressedSize);
                                File userModificationsFile = new File(tempOutputFolder, "omssa_usermods.xml");
                                ZipUtils.addFileToZip(userModificationsFile, out, this.waitingHandler, totalUncompressedSize);
                            }
                            if (this.enableMsAmanda) {
                                for (File spectrumFile : this.mgfFiles) {
                                    String newName = Util.removeExtension(spectrumFile.getName()) + "_settings.xml";
                                    File settingsFile = new File(tempOutputFolder, newName);
                                    if (!settingsFile.exists()) continue;
                                    ZipUtils.addFileToZip(settingsFile, out, this.waitingHandler, totalUncompressedSize);
                                }
                            }
                            for (HashMap<Integer, File> fileMap : identificationFiles.values()) {
                                for (File identificationFile : fileMap.values()) {
                                    ZipUtils.addFileToZip(identificationFile, out, this.waitingHandler, totalUncompressedSize);
                                }
                            }
                            if (!utilitiesUserPreferences.outputData().booleanValue()) break;
                            this.addDataToZip(out, totalUncompressedSize);
                            break;
                        }
                        finally {
                            out.close();
                        }
                    }
                    finally {
                        bos.close();
                    }
                }
                finally {
                    fos.close();
                }
            }
            case algorithm: {
                HashMap<Integer, ArrayList<File>> algorithmToFileMap = new HashMap<Integer, ArrayList<File>>();
                for (HashMap<Integer, File> fileMap : identificationFiles.values()) {
                    for (Integer n : fileMap.keySet()) {
                        ArrayList<File> files = (ArrayList<File>)algorithmToFileMap.get(n);
                        if (files == null) {
                            files = new ArrayList<File>();
                            algorithmToFileMap.put(n, files);
                        }
                        files.add(fileMap.get(n));
                    }
                }
                File inputFile = SearchHandler.getInputFile(tempOutputFolder);
                long totalUncompressedSize = 0L;
                for (Integer algorithm : algorithmToFileMap.keySet()) {
                    totalUncompressedSize += this.getTotalUncompressedSizeAlgorithm(inputFile, tempOutputFolder, algorithm, parametersFile, (ArrayList)algorithmToFileMap.get(algorithm));
                }
                this.waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                this.waitingHandler.setSecondaryProgressCounter(0);
                this.waitingHandler.setMaxSecondaryProgressCounter(100);
                for (Integer algorithm : algorithmToFileMap.keySet()) {
                    String advocateName = Advocate.getAdvocate(algorithm).getName();
                    File zipFile = SearchHandler.getDefaultOutputFile(outputFolder, advocateName, includeDate);
                    if (zipFile.exists()) {
                        zipFile.delete();
                    }
                    FileOutputStream fos = new FileOutputStream(zipFile);
                    try {
                        BufferedOutputStream bos = new BufferedOutputStream(fos);
                        try {
                            ZipOutputStream out = new ZipOutputStream(bos);
                            try {
                                ZipUtils.addFileToZip(inputFile, out, this.waitingHandler, totalUncompressedSize);
                                ZipUtils.addFileToZip(parametersFile, out, this.waitingHandler, totalUncompressedSize);
                                if (algorithm.intValue() == Advocate.omssa.getIndex()) {
                                    Iterator modificationsFile = new File(tempOutputFolder, "omssa_mods.xml");
                                    ZipUtils.addFileToZip((File)((Object)modificationsFile), out, this.waitingHandler, totalUncompressedSize);
                                    File userModificationsFile = new File(tempOutputFolder, "omssa_usermods.xml");
                                    ZipUtils.addFileToZip(userModificationsFile, out, this.waitingHandler, totalUncompressedSize);
                                }
                                if (algorithm.intValue() == Advocate.msAmanda.getIndex()) {
                                    for (File spectrumFile : this.mgfFiles) {
                                        String newName = Util.removeExtension(spectrumFile.getName()) + "_settings.xml";
                                        File settingsFile = new File(tempOutputFolder, newName);
                                        if (!settingsFile.exists()) continue;
                                        ZipUtils.addFileToZip(settingsFile, out, this.waitingHandler, totalUncompressedSize);
                                    }
                                }
                                for (File identificationFile : (ArrayList)algorithmToFileMap.get(algorithm)) {
                                    ZipUtils.addFileToZip(identificationFile, out, this.waitingHandler, totalUncompressedSize);
                                }
                                if (!utilitiesUserPreferences.outputData().booleanValue()) continue;
                                this.addDataToZip(out, totalUncompressedSize);
                            }
                            finally {
                                out.close();
                            }
                        }
                        finally {
                            bos.close();
                        }
                    }
                    finally {
                        fos.close();
                    }
                }
                break;
            }
            case run: {
                String mgfFileNameWithoutExtension;
                File inputFile = SearchHandler.getInputFile(tempOutputFolder);
                long totalUncompressedSize = 0L;
                for (String mgfFileName : identificationFiles.keySet()) {
                    mgfFileNameWithoutExtension = Util.removeExtension(mgfFileName);
                    File mgfFile = this.idFileToSpectrumFileMap.get(mgfFileName);
                    totalUncompressedSize += this.getTotalUncompressedSizeRun(inputFile, tempOutputFolder, mgfFileNameWithoutExtension, mgfFileName, parametersFile, identificationFiles, mgfFile);
                }
                this.waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                this.waitingHandler.setSecondaryProgressCounter(0);
                this.waitingHandler.setMaxSecondaryProgressCounter(100);
                for (String mgfFileName : identificationFiles.keySet()) {
                    mgfFileNameWithoutExtension = Util.removeExtension(mgfFileName);
                    File zipFile = SearchHandler.getDefaultOutputFile(outputFolder, mgfFileNameWithoutExtension, includeDate);
                    if (zipFile.exists()) {
                        zipFile.delete();
                    }
                    FileOutputStream fos = new FileOutputStream(zipFile);
                    try {
                        BufferedOutputStream bos = new BufferedOutputStream(fos);
                        try {
                            ZipOutputStream out = new ZipOutputStream(bos);
                            try {
                                String newName;
                                File settingsFile;
                                ZipUtils.addFileToZip(inputFile, out, this.waitingHandler, totalUncompressedSize);
                                ZipUtils.addFileToZip(parametersFile, out, this.waitingHandler, totalUncompressedSize);
                                if (this.enableOmssa) {
                                    File modificationsFile = new File(tempOutputFolder, "omssa_mods.xml");
                                    ZipUtils.addFileToZip(modificationsFile, out, this.waitingHandler, totalUncompressedSize);
                                    File userModificationsFile = new File(tempOutputFolder, "omssa_usermods.xml");
                                    ZipUtils.addFileToZip(userModificationsFile, out, this.waitingHandler, totalUncompressedSize);
                                }
                                if (this.enableMsAmanda && (settingsFile = new File(tempOutputFolder, newName = mgfFileNameWithoutExtension + "_settings.xml")).exists()) {
                                    ZipUtils.addFileToZip(settingsFile, out, this.waitingHandler, totalUncompressedSize);
                                }
                                HashMap<Integer, File> fileMap = identificationFiles.get(mgfFileName);
                                for (File identificationFile : fileMap.values()) {
                                    ZipUtils.addFileToZip(identificationFile, out, this.waitingHandler, totalUncompressedSize);
                                }
                                if (!utilitiesUserPreferences.outputData().booleanValue()) continue;
                                this.addDataToZip(out, totalUncompressedSize, mgfFileName);
                            }
                            finally {
                                out.close();
                            }
                        }
                        finally {
                            bos.close();
                        }
                    }
                    finally {
                        fos.close();
                    }
                }
                break;
            }
            default: {
                if (!utilitiesUserPreferences.outputData().booleanValue()) break;
                File file = new File(outputFolder, DEFAULT_DATA_FOLDER);
                file.mkdir();
                File dbFile = this.identificationParameters.getSearchParameters().getFastaFile();
                Util.copyFile(dbFile, new File(file, dbFile.getName()));
                for (File spectrumFile : this.getMgfFiles()) {
                    Util.copyFile(spectrumFile, new File(file, spectrumFile.getName()));
                }
            }
        }
        if (!outputFolder.getAbsolutePath().equals(tempOutputFolder.getAbsolutePath())) {
            Util.deleteDir(tempOutputFolder);
        }
    }

    private void addDataToZip(ZipOutputStream out, long totalUncompressedSize) throws IOException {
        this.addDataToZip(out, totalUncompressedSize, null);
    }

    private void addDataToZip(ZipOutputStream out, long totalUncompressedSize, String mgfFileName) throws IOException {
        ZipUtils.addFolderToZip(DEFAULT_DATA_FOLDER, out);
        File dbFile = this.identificationParameters.getSearchParameters().getFastaFile();
        ZipUtils.addFileToZip(DEFAULT_DATA_FOLDER, dbFile, out, this.waitingHandler, totalUncompressedSize);
        for (File spectrumFile : this.getMgfFiles()) {
            boolean addFile = true;
            if (mgfFileName != null) {
                addFile = spectrumFile.getName().equals(mgfFileName);
            }
            if (!addFile) continue;
            ZipUtils.addFileToZip(DEFAULT_DATA_FOLDER, spectrumFile, out, this.waitingHandler, totalUncompressedSize);
        }
    }

    private long getTotalUncompressedSize(File outputFolder, File parametersFile, HashMap<String, HashMap<Integer, File>> identificationFiles) {
        long totalUncompressedSize = 0L;
        totalUncompressedSize += SearchHandler.getInputFile(outputFolder).length();
        totalUncompressedSize += parametersFile.length();
        if (this.enableOmssa) {
            Iterator<HashMap<Integer, File>> modificationsFile = new File(outputFolder, "omssa_mods.xml");
            totalUncompressedSize += ((File)((Object)modificationsFile)).length();
            File userModificationsFile = new File(outputFolder, "omssa_usermods.xml");
            totalUncompressedSize += userModificationsFile.length();
        }
        if (this.enableMsAmanda) {
            for (File spectrumFile : this.mgfFiles) {
                String newName = Util.removeExtension(spectrumFile.getName()) + "_settings.xml";
                File settingsFile = new File(outputFolder, newName);
                if (!settingsFile.exists()) continue;
                totalUncompressedSize += settingsFile.length();
            }
        }
        for (HashMap<Integer, File> fileMap : identificationFiles.values()) {
            for (File identificationFile : fileMap.values()) {
                totalUncompressedSize += identificationFile.length();
            }
        }
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (utilitiesUserPreferences.outputData().booleanValue()) {
            totalUncompressedSize += this.getTotalUncompressedSizeOfData();
        }
        return totalUncompressedSize;
    }

    private long getTotalUncompressedSizeAlgorithm(File inputFile, File outputFolder, Integer algorithm, File parametersFile, ArrayList<File> identificationFiles) {
        long totalUncompressedSize = 0L;
        totalUncompressedSize += inputFile.length();
        totalUncompressedSize += parametersFile.length();
        if (algorithm.intValue() == Advocate.omssa.getIndex()) {
            Iterator<File> modificationsFile = new File(outputFolder, "omssa_mods.xml");
            totalUncompressedSize += ((File)((Object)modificationsFile)).length();
            File userModificationsFile = new File(outputFolder, "omssa_usermods.xml");
            totalUncompressedSize += userModificationsFile.length();
        }
        if (algorithm.intValue() == Advocate.msAmanda.getIndex()) {
            for (File spectrumFile : this.mgfFiles) {
                String newName = Util.removeExtension(spectrumFile.getName()) + "_settings.xml";
                File settingsFile = new File(outputFolder, newName);
                if (!settingsFile.exists()) continue;
                totalUncompressedSize += settingsFile.length();
            }
        }
        for (File identificationFile : identificationFiles) {
            totalUncompressedSize += identificationFile.length();
        }
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (utilitiesUserPreferences.outputData().booleanValue()) {
            totalUncompressedSize += this.getTotalUncompressedSizeOfData();
        }
        return totalUncompressedSize;
    }

    private long getTotalUncompressedSizeRun(File inputFile, File outputFolder, String runName, String run, File parametersFile, HashMap<String, HashMap<Integer, File>> identificationFiles) {
        return this.getTotalUncompressedSizeRun(inputFile, outputFolder, runName, run, parametersFile, identificationFiles, null);
    }

    private long getTotalUncompressedSizeRun(File inputFile, File outputFolder, String runName, String run, File parametersFile, HashMap<String, HashMap<Integer, File>> identificationFiles, File mgfFile) {
        String newName;
        Object settingsFile;
        long totalUncompressedSize = 0L;
        totalUncompressedSize += inputFile.length();
        totalUncompressedSize += parametersFile.length();
        if (this.enableOmssa) {
            File modificationsFile = new File(outputFolder, "omssa_mods.xml");
            totalUncompressedSize += modificationsFile.length();
            File userModificationsFile = new File(outputFolder, "omssa_usermods.xml");
            totalUncompressedSize += userModificationsFile.length();
        }
        if (this.enableMsAmanda && ((File)(settingsFile = new File(outputFolder, newName = runName + "_settings.xml"))).exists()) {
            totalUncompressedSize += ((File)settingsFile).length();
        }
        HashMap<Integer, File> fileMap = identificationFiles.get(run);
        for (File identificationFile : fileMap.values()) {
            totalUncompressedSize += identificationFile.length();
        }
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (utilitiesUserPreferences.outputData().booleanValue()) {
            totalUncompressedSize += this.getTotalUncompressedSizeOfData(mgfFile);
        }
        return totalUncompressedSize;
    }

    private long getTotalUncompressedSizeOfData() {
        return this.getTotalUncompressedSizeOfData(null);
    }

    private long getTotalUncompressedSizeOfData(File mgfFile) {
        long totalUncompressedSize = this.identificationParameters.getSearchParameters().getFastaFile().length();
        if (mgfFile != null) {
            totalUncompressedSize += mgfFile.length();
        } else {
            for (File spectrumFile : this.getMgfFiles()) {
                totalUncompressedSize += spectrumFile.length();
            }
        }
        return totalUncompressedSize;
    }

    public ConfigurationFile getConfigurationFile() {
        File folder = new File(this.getJarFilePath() + File.separator + "resources" + File.separator + "conf" + File.separator);
        File file = new File(folder, SEARCHGUI_CONFIGURATION_FILE);
        return new ConfigurationFile(file);
    }

    public static File getPeakListFolder(String jarFilePath) {
        File peakListFolder = new File(SearchHandler.getTempFolderPath(jarFilePath), PEAK_LIST_SUBFOLDER);
        if (!peakListFolder.exists()) {
            peakListFolder.mkdirs();
        }
        return peakListFolder;
    }

    public String getJarFilePath() {
        return CompomicsWrapper.getJarFilePath(this.getClass().getResource("SearchHandler.class").getPath(), "SearchGUI");
    }

    public static String getTempFolderPath(String jarFilePath) {
        File tempFolder;
        if (tempFolderPath == null && !(tempFolder = new File(tempFolderPath = jarFilePath.equals(".") ? "resources" + File.separator + "temp" : jarFilePath + File.separator + "resources" + File.separator + "temp")).exists()) {
            tempFolder.mkdirs();
        }
        return tempFolderPath;
    }

    public static void setTempFolderPath(String aTempFolderPath) {
        tempFolderPath = aTempFolderPath;
    }

    public void setLogFolder(File logFolder) {
        this.logFolder = logFolder;
    }

    public static String loadModifications(SearchParameters searchParameters) {
        String error = null;
        ArrayList<String> toCheck = PTMFactory.getInstance().loadBackedUpModifications(searchParameters, true);
        if (!toCheck.isEmpty()) {
            error = "The definition of the following PTM(s) seems to have changed and were overwritten:\n";
            for (int i = 0; i < toCheck.size(); ++i) {
                if (i > 0) {
                    error = i < toCheck.size() - 1 ? error + ", " : error + " and ";
                }
                error = error + toCheck.get(i);
            }
            error = error + ".\nPlease verify the definition of the PTM(s) in the modifications editor.";
        }
        return error;
    }

    private class IndexingWorker
    extends SwingWorker {
        private WaitingHandler waitingHandler;
        private boolean finished = false;

        public IndexingWorker(WaitingHandler waitingHandler) {
            this.waitingHandler = waitingHandler;
            if (waitingHandler instanceof WaitingDialog) {
                ((JFrame)((WaitingDialog)waitingHandler).getParent()).setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
            }
        }

        protected Object doInBackground() throws Exception {
            File fastaFile = SearchHandler.this.identificationParameters.getSearchParameters().getFastaFile();
            File indexFile = new File(fastaFile.getParent(), fastaFile.getName() + ".cui");
            if (!indexFile.exists()) {
                SequenceFactory.getInstance().loadFastaFile(fastaFile, this.waitingHandler);
            }
            this.finished = true;
            if (!this.waitingHandler.isRunCanceled()) {
                SearchHandler.this.searchCompleted();
            }
            return 0;
        }

        public boolean isFinished() {
            return this.finished;
        }
    }

    private class SearchWorker
    extends SwingWorker {
        private WaitingHandler waitingHandler;
        private boolean finished = false;

        public SearchWorker(WaitingHandler waitingHandler) {
            this.waitingHandler = waitingHandler;
            if (waitingHandler instanceof WaitingDialog) {
                ((JFrame)((WaitingDialog)waitingHandler).getParent()).setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
            }
        }

        public void cancelRun() {
            if (this.waitingHandler != null) {
                this.waitingHandler.setWaitingText("Canceling");
            }
            if (SearchHandler.this.makeblastdbProcessBuilder != null) {
                SearchHandler.this.makeblastdbProcessBuilder.endProcess();
            }
            if (SearchHandler.this.msConvertProcessBuilders != null) {
                for (MsConvertProcessBuilder msConvertProcessBuilder : SearchHandler.this.msConvertProcessBuilders) {
                    msConvertProcessBuilder.endProcess();
                }
            }
            if (SearchHandler.this.omssaProcessBuilder != null) {
                SearchHandler.this.omssaProcessBuilder.endProcess();
            }
            if (SearchHandler.this.xTandemProcessBuilder != null) {
                SearchHandler.this.xTandemProcessBuilder.endProcess();
            }
            if (SearchHandler.this.msgfProcessBuilder != null) {
                SearchHandler.this.msgfProcessBuilder.endProcess();
            }
            if (SearchHandler.this.msAmandaProcessBuilder != null) {
                SearchHandler.this.msAmandaProcessBuilder.endProcess();
            }
            if (SearchHandler.this.myriMatchProcessBuilder != null) {
                SearchHandler.this.myriMatchProcessBuilder.endProcess();
            }
            if (SearchHandler.this.cometProcessBuilder != null) {
                SearchHandler.this.cometProcessBuilder.endProcess();
            }
            if (SearchHandler.this.tideIndexProcessBuilder != null) {
                SearchHandler.this.tideIndexProcessBuilder.endProcess();
            }
            if (SearchHandler.this.tideSearchProcessBuilder != null) {
                SearchHandler.this.tideSearchProcessBuilder.endProcess();
            }
            if (SearchHandler.this.andromedaProcessBuilder != null) {
                SearchHandler.this.andromedaProcessBuilder.endProcess();
            }
            if (SearchHandler.this.novorProcessBuilder != null) {
                SearchHandler.this.novorProcessBuilder.endProcess();
            }
            if (SearchHandler.this.direcTagProcessBuilder != null) {
                SearchHandler.this.direcTagProcessBuilder.endProcess();
            }
            if (SearchHandler.this.peptideShakerProcessBuilder != null) {
                SearchHandler.this.peptideShakerProcessBuilder.endProcess();
            }
        }

        protected Object doInBackground() {
            try {
                File andromedaTempFolder;
                TideParameters tideParameters;
                int i;
                File outputTempFolder;
                UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
                File outputFolder = SearchHandler.this.getResultsFolder();
                if (utilitiesUserPreferences.getOutputOption() == SearchGuiOutputOption.no_zip) {
                    outputTempFolder = outputFolder;
                } else {
                    try {
                        outputTempFolder = new File(outputFolder, SearchHandler.OUTPUT_TEMP_FOLDER_NAME);
                        if (outputTempFolder.exists()) {
                            Util.deleteDir(outputTempFolder);
                        }
                        outputTempFolder.mkdirs();
                        TempFilesManager.registerTempFolder(outputTempFolder);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        outputTempFolder = outputFolder;
                    }
                }
                SearchParameters searchParameters = SearchHandler.this.identificationParameters.getSearchParameters();
                File fastaFile = searchParameters.getFastaFile();
                if (SearchHandler.this.enableOmssa) {
                    File modsXmlFile;
                    SearchHandler.this.makeblastdbProcessBuilder = new MakeblastdbProcessBuilder(SearchHandler.this.getJarFilePath(), fastaFile, SearchHandler.this.makeblastdbLocation, this.waitingHandler, SearchHandler.this.exceptionHandler);
                    if (SearchHandler.this.makeblastdbProcessBuilder.needsFormatting()) {
                        if (this.waitingHandler != null) {
                            if (!useCommandLine) {
                                this.waitingHandler.setWaitingText("Formatting " + SearchHandler.this.makeblastdbProcessBuilder.getCurrentlyProcessedFileName() + " for OMSSA.");
                            }
                            this.waitingHandler.appendReport("Formatting " + SearchHandler.this.makeblastdbProcessBuilder.getCurrentlyProcessedFileName() + " for OMSSA.", true, true);
                            this.waitingHandler.appendReportEndLine();
                        }
                        SearchHandler.this.makeblastdbProcessBuilder.startProcess();
                        if (this.waitingHandler != null) {
                            this.waitingHandler.appendReport(SearchHandler.this.makeblastdbProcessBuilder.getCurrentlyProcessedFileName() + " formatted for OMSSA.", true, true);
                            this.waitingHandler.appendReportEndLine();
                        }
                    }
                    if (!(modsXmlFile = new File(SearchHandler.this.omssaLocation, "mods.xml")).exists()) {
                        throw new IllegalArgumentException("OMSSA mods.xml file not found.");
                    }
                    File userModsXmlFile = new File(SearchHandler.this.omssaLocation, "usermods.xml");
                    OmssaclProcessBuilder.writeOmssaUserModificationsFile(userModsXmlFile, SearchHandler.this.identificationParameters, SearchHandler.this.identificationParametersFile);
                    File destinationFile = new File(outputTempFolder, "omssa_mods.xml");
                    Util.copyFile(modsXmlFile, destinationFile);
                    destinationFile = new File(outputTempFolder, "omssa_usermods.xml");
                    Util.copyFile(userModsXmlFile, destinationFile);
                }
                if (SearchHandler.this.enableAndromeda) {
                    if (!useCommandLine) {
                        this.waitingHandler.setWaitingText("Andromeda configuration.");
                    }
                    this.waitingHandler.appendReport("Andromeda configuration.", true, true);
                    this.waitingHandler.appendReportEndLine();
                    AndromedaProcessBuilder.createDatabaseFile(SearchHandler.this.andromedaLocation, searchParameters);
                    AndromedaProcessBuilder.createEnzymesFile(SearchHandler.this.andromedaLocation);
                    AndromedaProcessBuilder.createPtmFile(SearchHandler.this.andromedaLocation, SearchHandler.this.identificationParameters, SearchHandler.this.identificationParametersFile);
                }
                int nRawFiles = SearchHandler.this.getRawFiles().size();
                int nFilesToSearch = nRawFiles + SearchHandler.this.getMgfFiles().size();
                int nProgress = 2 + nRawFiles;
                if (SearchHandler.this.isOmssaEnabled()) {
                    nProgress += nFilesToSearch;
                }
                if (SearchHandler.this.enableXtandem) {
                    nProgress += nFilesToSearch;
                }
                if (SearchHandler.this.enableMsgf) {
                    nProgress += nFilesToSearch;
                }
                if (SearchHandler.this.enableMsAmanda) {
                    nProgress += nFilesToSearch;
                }
                if (SearchHandler.this.enableMyriMatch) {
                    nProgress += nFilesToSearch;
                }
                if (SearchHandler.this.enableComet) {
                    nProgress += nFilesToSearch;
                }
                if (SearchHandler.this.enableTide) {
                    nProgress += nFilesToSearch;
                    ++nProgress;
                }
                if (SearchHandler.this.enableAndromeda) {
                    nProgress += nFilesToSearch;
                }
                if (SearchHandler.this.enableNovor) {
                    nProgress += nFilesToSearch;
                }
                if (SearchHandler.this.enableDirecTag) {
                    nProgress += nFilesToSearch;
                }
                if (SearchHandler.this.enablePeptideShaker) {
                    ++nProgress;
                }
                if (SearchHandler.this.isReporterEnabled()) {
                    ++nProgress;
                }
                this.waitingHandler.setMaxPrimaryProgressCounter(nProgress);
                this.waitingHandler.increasePrimaryProgressCounter();
                if (SearchHandler.this.enableTide && !this.waitingHandler.isRunCanceled()) {
                    SearchHandler.this.tideIndexProcessBuilder = new TideIndexProcessBuilder(SearchHandler.this.tideLocation, searchParameters, this.waitingHandler, SearchHandler.this.exceptionHandler);
                    this.waitingHandler.appendReport("Indexing " + fastaFile.getName() + " for Tide.", true, true);
                    this.waitingHandler.appendReportEndLine();
                    SearchHandler.this.tideIndexProcessBuilder.startProcess();
                }
                ExecutorService pool = Executors.newFixedThreadPool(SearchHandler.this.processingPreferences.getnThreads());
                ArrayList<File> rawFiles = SearchHandler.this.getRawFiles();
                if (!rawFiles.isEmpty() && !this.waitingHandler.isRunCanceled()) {
                    this.waitingHandler.resetSecondaryProgressCounter();
                    this.waitingHandler.setMaxSecondaryProgressCounter(rawFiles.size() * 100);
                    SearchHandler.this.msConvertProcessBuilders = new ArrayList();
                    Duration conversionDuration = new Duration();
                    if (rawFiles.size() > 1) {
                        conversionDuration.start();
                        this.waitingHandler.appendReport("Converting raw files.", true, true);
                    }
                    for (i = 0; i < rawFiles.size() && !this.waitingHandler.isRunCanceled(); ++i) {
                        String mgfFileName;
                        File rawFile = rawFiles.get(i);
                        String string = rawFile.getName();
                        File folder = rawFile.getParentFile();
                        File mgfFile = new File(folder, mgfFileName = Util.removeExtension(string) + ".mgf");
                        if (!mgfFile.exists()) {
                            MsConvertProcessBuilder msConvertProcessBuilder = new MsConvertProcessBuilder(this.waitingHandler, SearchHandler.this.exceptionHandler, rawFile, folder, SearchHandler.this.getMsConvertParameters());
                            SearchHandler.this.msConvertProcessBuilders.add(msConvertProcessBuilder);
                            pool.submit(msConvertProcessBuilder);
                        } else {
                            this.waitingHandler.appendReport(mgfFileName + " already exists. Conversion canceled.", true, true);
                            this.waitingHandler.appendReportEndLine();
                        }
                        SearchHandler.this.mgfFiles.add(mgfFile);
                    }
                    if (this.waitingHandler.isRunCanceled()) {
                        pool.shutdownNow();
                    } else {
                        pool.shutdown();
                        if (!pool.awaitTermination(1 * rawFiles.size(), TimeUnit.DAYS)) {
                            throw new InterruptedException("Conversion timed out. Please contact the developers.");
                        }
                        if (!this.waitingHandler.isRunCanceled() && rawFiles.size() > 1) {
                            conversionDuration.end();
                            this.waitingHandler.appendReport("Raw files conversion completed (" + conversionDuration.toString() + ").", true, true);
                        }
                    }
                    this.waitingHandler.setSecondaryProgressCounterIndeterminate(true);
                }
                if (!this.waitingHandler.isRunCanceled()) {
                    this.waitingHandler.appendReportEndLine();
                    this.waitingHandler.appendReport("Indexing spectrum files.", true, true);
                    SpectrumFactory spectrumFactory = SpectrumFactory.getInstance();
                    for (File mgfFile : SearchHandler.this.mgfFiles) {
                        spectrumFactory.addSpectra(mgfFile);
                    }
                    this.waitingHandler.appendReport("Extracting search settings.", true, true);
                    this.waitingHandler.appendReportEndLine();
                }
                if (!this.waitingHandler.isRunCanceled()) {
                    SearchHandler.this.saveInputFile(outputTempFolder);
                    this.waitingHandler.increasePrimaryProgressCounter();
                }
                HashMap<String, HashMap<Integer, File>> identificationFiles = new HashMap<String, HashMap<Integer, File>>(SearchHandler.this.mgfFiles.size());
                SearchHandler.this.idFileToSpectrumFileMap = new HashMap();
                for (i = 0; i < SearchHandler.this.getMgfFiles().size() && !this.waitingHandler.isRunCanceled(); ++i) {
                    HashMap<Integer, File> runIdentificationFiles;
                    HashMap<Integer, File> runIdentificationFiles2;
                    File spectrumFile = SearchHandler.this.getMgfFiles().get(i);
                    String string = spectrumFile.getName();
                    if (useCommandLine) {
                        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "Processing: " + string + " (" + (i + 1) + "/" + SearchHandler.this.getMgfFiles().size() + ")");
                    } else {
                        this.waitingHandler.setWaitingText("Processing: " + string + " (" + (i + 1) + "/" + SearchHandler.this.getMgfFiles().size() + ")");
                    }
                    if (SearchHandler.this.enableXtandem && !this.waitingHandler.isRunCanceled()) {
                        File xTandemOutputFile = new File(outputTempFolder, Util.removeExtension(string) + ".t.xml");
                        SearchHandler.this.xTandemProcessBuilder = new TandemProcessBuilder(SearchHandler.this.xtandemLocation, spectrumFile.getAbsolutePath(), xTandemOutputFile.getAbsolutePath(), searchParameters, this.waitingHandler, SearchHandler.this.exceptionHandler, SearchHandler.this.processingPreferences.getnThreads());
                        this.waitingHandler.appendReport("Processing " + string + " with " + Advocate.xtandem.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.xTandemProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            if (utilitiesUserPreferences.renameXTandemFile().booleanValue()) {
                                ArrayList<File> result = SearchHandler.this.getXTandemFiles(outputTempFolder, string);
                                if (result.size() == 1) {
                                    File xTandemFile = result.get(0);
                                    File destinationFile = new File(outputTempFolder, SearchHandler.getXTandemFileName(string));
                                    try {
                                        xTandemFile.renameTo(destinationFile);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        this.waitingHandler.appendReport("Could not rename " + Advocate.xtandem.getName() + " result for " + string + ".", true, true);
                                    }
                                } else {
                                    this.waitingHandler.appendReport("Could not rename " + Advocate.xtandem.getName() + " result for " + string + ".", true, true);
                                }
                            }
                            if ((runIdentificationFiles2 = identificationFiles.get(string)) == null) {
                                runIdentificationFiles2 = new HashMap();
                                identificationFiles.put(string, runIdentificationFiles2);
                            }
                            if (xTandemOutputFile.exists()) {
                                runIdentificationFiles2.put(Advocate.xtandem.getIndex(), xTandemOutputFile);
                                SearchHandler.this.idFileToSpectrumFileMap.put(xTandemOutputFile.getName(), spectrumFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.xtandem.getName() + " result file for " + string + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    if (SearchHandler.this.enableMyriMatch && !this.waitingHandler.isRunCanceled()) {
                        File myriMatchOutputFile = new File(outputTempFolder, SearchHandler.this.getMyriMatchFileName(string));
                        SearchHandler.this.myriMatchProcessBuilder = new MyriMatchProcessBuilder(SearchHandler.this.myriMatchLocation, spectrumFile.getAbsolutePath(), outputTempFolder, searchParameters, this.waitingHandler, SearchHandler.this.exceptionHandler, SearchHandler.this.processingPreferences.getnThreads());
                        this.waitingHandler.appendReport("Processing " + string + " with " + Advocate.myriMatch.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.myriMatchProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            HashMap<Integer, File> runIdentificationFiles4 = identificationFiles.get(string);
                            if (runIdentificationFiles4 == null) {
                                runIdentificationFiles4 = new HashMap();
                                identificationFiles.put(string, runIdentificationFiles4);
                            }
                            if (myriMatchOutputFile.exists()) {
                                runIdentificationFiles4.put(Advocate.myriMatch.getIndex(), myriMatchOutputFile);
                                SearchHandler.this.idFileToSpectrumFileMap.put(myriMatchOutputFile.getName(), spectrumFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.myriMatch.getName() + " result file for " + string + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    if (SearchHandler.this.enableMsAmanda && !this.waitingHandler.isRunCanceled()) {
                        File msAmandaOutputFile = new File(outputTempFolder, Util.removeExtension(string) + ".ms-amanda.csv");
                        String filePath = msAmandaOutputFile.getAbsolutePath();
                        SearchHandler.this.msAmandaProcessBuilder = new MsAmandaProcessBuilder(SearchHandler.this.msAmandaLocation, spectrumFile.getAbsolutePath(), filePath, searchParameters, this.waitingHandler, SearchHandler.this.exceptionHandler, SearchHandler.this.processingPreferences.getnThreads());
                        this.waitingHandler.appendReport("Processing " + string + " with " + Advocate.msAmanda.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.msAmandaProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            HashMap<Integer, File> runIdentificationFiles3 = identificationFiles.get(string);
                            if (runIdentificationFiles3 == null) {
                                runIdentificationFiles3 = new HashMap();
                                identificationFiles.put(string, runIdentificationFiles3);
                            }
                            if (msAmandaOutputFile.exists()) {
                                runIdentificationFiles3.put(Advocate.msAmanda.getIndex(), msAmandaOutputFile);
                                SearchHandler.this.idFileToSpectrumFileMap.put(msAmandaOutputFile.getName(), spectrumFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.msAmanda.getName() + " result file for " + string + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    if (SearchHandler.this.enableMsgf && !this.waitingHandler.isRunCanceled()) {
                        File msgfOutputFile = new File(outputTempFolder, Util.removeExtension(string) + ".msgf.mzid");
                        SearchHandler.this.msgfProcessBuilder = new MsgfProcessBuilder(SearchHandler.this.msgfLocation, spectrumFile.getAbsolutePath(), msgfOutputFile, searchParameters, this.waitingHandler, SearchHandler.this.exceptionHandler, SearchHandler.this.processingPreferences.getnThreads(), useCommandLine);
                        this.waitingHandler.appendReport("Processing " + string + " with " + Advocate.msgf.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.msgfProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            runIdentificationFiles2 = identificationFiles.get(string);
                            if (runIdentificationFiles2 == null) {
                                runIdentificationFiles2 = new HashMap();
                                identificationFiles.put(string, runIdentificationFiles2);
                            }
                            if (msgfOutputFile.exists()) {
                                runIdentificationFiles2.put(Advocate.msgf.getIndex(), msgfOutputFile);
                                SearchHandler.this.idFileToSpectrumFileMap.put(msgfOutputFile.getName(), spectrumFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.msgf.getName() + " result file for " + string + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    if (SearchHandler.this.enableOmssa && !this.waitingHandler.isRunCanceled()) {
                        File omssaOutputFile = new File(outputTempFolder, SearchHandler.this.getOMSSAFileName(string));
                        SearchHandler.this.omssaProcessBuilder = new OmssaclProcessBuilder(SearchHandler.this.omssaLocation, spectrumFile.getAbsolutePath(), omssaOutputFile, searchParameters, this.waitingHandler, SearchHandler.this.exceptionHandler, utilitiesUserPreferences.getRefMass(), SearchHandler.this.processingPreferences.getnThreads());
                        this.waitingHandler.appendReport("Processing " + string + " with " + Advocate.omssa.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.omssaProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            runIdentificationFiles2 = identificationFiles.get(string);
                            if (runIdentificationFiles2 == null) {
                                runIdentificationFiles2 = new HashMap();
                                identificationFiles.put(string, runIdentificationFiles2);
                            }
                            if (omssaOutputFile.exists()) {
                                runIdentificationFiles2.put(Advocate.omssa.getIndex(), omssaOutputFile);
                                SearchHandler.this.idFileToSpectrumFileMap.put(omssaOutputFile.getName(), spectrumFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.omssa.getName() + " result file for " + string + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    if (SearchHandler.this.enableComet && !this.waitingHandler.isRunCanceled()) {
                        File cometOutputFile = new File(outputTempFolder, SearchHandler.this.getCometFileName(string));
                        if (cometOutputFile.exists()) {
                            cometOutputFile.delete();
                        }
                        SearchHandler.this.cometProcessBuilder = new CometProcessBuilder(SearchHandler.this.cometLocation, searchParameters, spectrumFile, this.waitingHandler, SearchHandler.this.exceptionHandler, SearchHandler.this.processingPreferences.getnThreads(), utilitiesUserPreferences.getRefMass());
                        this.waitingHandler.appendReport("Processing " + string + " with " + Advocate.comet.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.cometProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            File tempCometOutputFile = new File(spectrumFile.getParent(), SearchHandler.this.getCometFileName(string));
                            FileUtils.moveFile((File)tempCometOutputFile, (File)cometOutputFile);
                            HashMap<Integer, File> runIdentificationFiles3 = identificationFiles.get(string);
                            if (runIdentificationFiles3 == null) {
                                runIdentificationFiles3 = new HashMap();
                                identificationFiles.put(string, runIdentificationFiles3);
                            }
                            if (cometOutputFile.exists()) {
                                runIdentificationFiles3.put(Advocate.comet.getIndex(), cometOutputFile);
                                SearchHandler.this.idFileToSpectrumFileMap.put(cometOutputFile.getName(), spectrumFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.comet.getName() + " result file for " + string + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    File ms2File = null;
                    if (SearchHandler.this.enableTide && !this.waitingHandler.isRunCanceled()) {
                        this.waitingHandler.appendReport("Converting spectrum file " + string + " for Tide.", true, true);
                        ms2File = new File(SearchHandler.getPeakListFolder(SearchHandler.this.getJarFilePath()), Util.removeExtension(string) + ".ms2");
                        Ms2Exporter.mgfToMs2(spectrumFile, ms2File, true);
                        File tideOutputFile = new File(outputTempFolder, SearchHandler.this.getTideFileName(string));
                        if (!this.waitingHandler.isRunCanceled()) {
                            SearchHandler.this.tideSearchProcessBuilder = new TideSearchProcessBuilder(SearchHandler.this.tideLocation, searchParameters, ms2File, this.waitingHandler, SearchHandler.this.exceptionHandler, SearchHandler.this.processingPreferences.getnThreads());
                            this.waitingHandler.appendReport("Processing " + string + " with " + Advocate.tide.getName() + ".", true, true);
                            this.waitingHandler.appendReportEndLine();
                            SearchHandler.this.tideSearchProcessBuilder.startProcess();
                        }
                        if (!this.waitingHandler.isRunCanceled()) {
                            String tideResultsFolderName = ((TideParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.tide.getIndex())).getOutputFolderName();
                            File tempTideOutputFile = new File(new File(SearchHandler.this.tideLocation, tideResultsFolderName), SearchHandler.this.getTideFileName(string));
                            FileUtils.moveFile((File)tempTideOutputFile, (File)tideOutputFile);
                            HashMap<Integer, File> runIdentificationFiles22 = identificationFiles.get(string);
                            if (runIdentificationFiles22 == null) {
                                runIdentificationFiles22 = new HashMap();
                                identificationFiles.put(string, runIdentificationFiles22);
                            }
                            if (tideOutputFile.exists()) {
                                runIdentificationFiles22.put(Advocate.tide.getIndex(), tideOutputFile);
                                SearchHandler.this.idFileToSpectrumFileMap.put(tideOutputFile.getName(), spectrumFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.tide.getName() + " result file for " + string + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    File aplFile = null;
                    if (SearchHandler.this.enableAndromeda && !this.waitingHandler.isRunCanceled()) {
                        this.waitingHandler.appendReport("Converting spectrum file " + string + " for Andromeda.", true, true);
                        aplFile = new File(SearchHandler.getPeakListFolder(SearchHandler.this.getJarFilePath()), Util.removeExtension(string) + ".apl");
                        AndromedaParameters andromedaParameters = (AndromedaParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.andromeda.getIndex());
                        AplExporter.mgfToApl(spectrumFile, aplFile, andromedaParameters.getFragmentationMethod(), searchParameters.getMinChargeSearched().value, searchParameters.getMaxChargeSearched().value);
                    }
                    if (SearchHandler.this.enableAndromeda && !this.waitingHandler.isRunCanceled()) {
                        File andromedaOutputFile = new File(outputTempFolder, SearchHandler.getAndromedaFileName(string));
                        SearchHandler.this.andromedaProcessBuilder = new AndromedaProcessBuilder(SearchHandler.this.andromedaLocation, searchParameters, SearchHandler.this.identificationParametersFile, aplFile, this.waitingHandler, SearchHandler.this.exceptionHandler, SearchHandler.this.processingPreferences.getnThreads());
                        this.waitingHandler.appendReport("Processing " + string + " with " + Advocate.andromeda.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.andromedaProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            File tempResultFile = new File(aplFile.getParent(), SearchHandler.getAndromedaFileName(string));
                            if (tempResultFile.exists()) {
                                Util.copyFile(tempResultFile, andromedaOutputFile);
                                try {
                                    tempResultFile.delete();
                                }
                                catch (Exception e) {
                                    this.waitingHandler.appendReport("An error occurred when attempting to delete " + tempResultFile.getName() + ".", true, true);
                                }
                                HashMap<Integer, File> runIdentificationFiles4 = identificationFiles.get(string);
                                if (runIdentificationFiles4 == null) {
                                    runIdentificationFiles4 = new HashMap();
                                    identificationFiles.put(string, runIdentificationFiles4);
                                }
                                if (andromedaOutputFile.exists()) {
                                    runIdentificationFiles4.put(Advocate.andromeda.getIndex(), andromedaOutputFile);
                                    SearchHandler.this.idFileToSpectrumFileMap.put(andromedaOutputFile.getName(), spectrumFile);
                                } else {
                                    this.waitingHandler.appendReport("Could not find " + Advocate.andromeda.getName() + " result file for " + string + ".", true, true);
                                }
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.andromeda.getName() + " .res file for " + string + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    if (aplFile != null) {
                        aplFile.delete();
                    }
                    if (ms2File != null) {
                        ms2File.delete();
                    }
                    if (SearchHandler.this.enableNovor && !this.waitingHandler.isRunCanceled()) {
                        File novorOutputFile = new File(outputTempFolder, SearchHandler.getNovorFileName(string));
                        SearchHandler.this.novorProcessBuilder = new NovorProcessBuilder(SearchHandler.this.novorLocation, spectrumFile, novorOutputFile, searchParameters, useCommandLine, this.waitingHandler, SearchHandler.this.exceptionHandler);
                        this.waitingHandler.appendReport("Processing " + string + " with " + Advocate.novor.getName() + ".", true, true);
                        this.waitingHandler.appendReportEndLine();
                        SearchHandler.this.novorProcessBuilder.startProcess();
                        if (!this.waitingHandler.isRunCanceled()) {
                            runIdentificationFiles = identificationFiles.get(string);
                            if (runIdentificationFiles == null) {
                                runIdentificationFiles = new HashMap();
                                identificationFiles.put(string, runIdentificationFiles);
                            }
                            if (novorOutputFile.exists()) {
                                runIdentificationFiles.put(Advocate.novor.getIndex(), novorOutputFile);
                                SearchHandler.this.idFileToSpectrumFileMap.put(novorOutputFile.getName(), spectrumFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.novor.getName() + " result file for " + string + ".", true, true);
                            }
                            this.waitingHandler.increasePrimaryProgressCounter();
                        }
                    }
                    if (!SearchHandler.this.enableDirecTag || this.waitingHandler.isRunCanceled()) continue;
                    File direcTagOutputFile = new File(outputTempFolder, SearchHandler.getDirecTagFileName(string));
                    SearchHandler.this.direcTagProcessBuilder = new DirecTagProcessBuilder(SearchHandler.this.direcTagLocation, spectrumFile, SearchHandler.this.processingPreferences.getnThreads(), outputTempFolder, searchParameters, this.waitingHandler, SearchHandler.this.exceptionHandler);
                    this.waitingHandler.appendReport("Processing " + string + " with " + Advocate.direcTag.getName() + ".", true, true);
                    this.waitingHandler.appendReportEndLine();
                    SearchHandler.this.direcTagProcessBuilder.startProcess();
                    if (this.waitingHandler.isRunCanceled()) continue;
                    runIdentificationFiles = identificationFiles.get(string);
                    if (runIdentificationFiles == null) {
                        runIdentificationFiles = new HashMap();
                        identificationFiles.put(string, runIdentificationFiles);
                    }
                    if (direcTagOutputFile.exists()) {
                        runIdentificationFiles.put(Advocate.direcTag.getIndex(), direcTagOutputFile);
                        SearchHandler.this.idFileToSpectrumFileMap.put(direcTagOutputFile.getName(), spectrumFile);
                    } else {
                        this.waitingHandler.appendReport("Could not find " + Advocate.direcTag.getName() + " result file for " + string + ".", true, true);
                    }
                    this.waitingHandler.increasePrimaryProgressCounter();
                }
                if (SearchHandler.this.enableTide && (tideParameters = (TideParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.tide.getIndex())).getRemoveTempFolders().booleanValue()) {
                    File tideIndexFolder;
                    String tideResultsFolderName = tideParameters.getOutputFolderName();
                    File file = new File(SearchHandler.this.tideLocation, tideResultsFolderName);
                    if (file.exists()) {
                        FileUtils.deleteDirectory((File)file);
                    }
                    if ((tideIndexFolder = new File(SearchHandler.this.tideLocation, "fasta-index")).exists()) {
                        FileUtils.deleteDirectory((File)tideIndexFolder);
                    }
                }
                SearchHandler.this.identificationParametersFactory.addIdentificationParameters(SearchHandler.this.identificationParameters);
                outputTimeStamp = SearchHandler.getOutputDate();
                if (!this.waitingHandler.isRunCanceled()) {
                    if (utilitiesUserPreferences.getOutputOption() != SearchGuiOutputOption.no_zip) {
                        this.waitingHandler.appendReport("Zipping output files.", true, true);
                    } else {
                        this.waitingHandler.appendReport("Preparing output files.", true, true);
                    }
                    this.waitingHandler.appendReportEndLine();
                    SearchHandler.this.organizeOutput(outputFolder, outputTempFolder, identificationFiles, SearchHandler.this.identificationParametersFile, utilitiesUserPreferences.isIncludeDateInOutputName());
                    this.waitingHandler.increasePrimaryProgressCounter();
                }
                if (SearchHandler.this.enablePeptideShaker && !this.waitingHandler.isRunCanceled()) {
                    Object outputFile;
                    ArrayList<File> identificationFilesList = new ArrayList<File>();
                    identificationFilesList.addAll(SearchHandler.this.mascotFiles);
                    if (utilitiesUserPreferences.getOutputOption() == SearchGuiOutputOption.grouped) {
                        outputFile = SearchHandler.getDefaultOutputFile(outputFolder, utilitiesUserPreferences.isIncludeDateInOutputName());
                        if (((File)outputFile).exists()) {
                            identificationFilesList.add((File)outputFile);
                        } else {
                            this.waitingHandler.appendReport("Could not find SearchGUI results.", true, true);
                        }
                    } else if (utilitiesUserPreferences.getOutputOption() == SearchGuiOutputOption.algorithm) {
                        if (SearchHandler.this.enableMsAmanda) {
                            outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.msAmanda.getName(), utilitiesUserPreferences.isIncludeDateInOutputName());
                            if (((File)outputFile).exists()) {
                                identificationFilesList.add((File)outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.msAmanda.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableMsgf) {
                            outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.msgf.getName(), utilitiesUserPreferences.isIncludeDateInOutputName());
                            if (((File)outputFile).exists()) {
                                identificationFilesList.add((File)outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.msgf.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableMyriMatch) {
                            outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.myriMatch.getName(), utilitiesUserPreferences.isIncludeDateInOutputName());
                            if (((File)outputFile).exists()) {
                                identificationFilesList.add((File)outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.myriMatch.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableOmssa) {
                            outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.omssa.getName(), utilitiesUserPreferences.isIncludeDateInOutputName());
                            if (((File)outputFile).exists()) {
                                identificationFilesList.add((File)outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.omssa.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableXtandem) {
                            outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.xtandem.getName(), utilitiesUserPreferences.isIncludeDateInOutputName());
                            if (((File)outputFile).exists()) {
                                identificationFilesList.add((File)outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.xtandem.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableComet) {
                            outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.comet.getName(), utilitiesUserPreferences.isIncludeDateInOutputName());
                            if (((File)outputFile).exists()) {
                                identificationFilesList.add((File)outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.comet.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableTide) {
                            outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.tide.getName(), utilitiesUserPreferences.isIncludeDateInOutputName());
                            if (((File)outputFile).exists()) {
                                identificationFilesList.add((File)outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.tide.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableAndromeda) {
                            outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.andromeda.getName(), utilitiesUserPreferences.isIncludeDateInOutputName());
                            if (((File)outputFile).exists()) {
                                identificationFilesList.add((File)outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.andromeda.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableNovor) {
                            outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.novor.getName(), utilitiesUserPreferences.isIncludeDateInOutputName());
                            if (((File)outputFile).exists()) {
                                identificationFilesList.add((File)outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.novor.getName() + " results.", true, true);
                            }
                        }
                        if (SearchHandler.this.enableDirecTag) {
                            outputFile = SearchHandler.getDefaultOutputFile(outputFolder, Advocate.direcTag.getName(), utilitiesUserPreferences.isIncludeDateInOutputName());
                            if (((File)outputFile).exists()) {
                                identificationFilesList.add((File)outputFile);
                            } else {
                                this.waitingHandler.appendReport("Could not find " + Advocate.direcTag.getName() + " results.", true, true);
                            }
                        }
                    } else if (utilitiesUserPreferences.getOutputOption() == SearchGuiOutputOption.run) {
                        for (String string : identificationFiles.keySet()) {
                            String runName = Util.removeExtension(string);
                            File outputFile2 = SearchHandler.getDefaultOutputFile(outputFolder, runName, utilitiesUserPreferences.isIncludeDateInOutputName());
                            if (outputFile2.exists()) {
                                identificationFilesList.add(outputFile2);
                                continue;
                            }
                            this.waitingHandler.appendReport("SearchGUI results not found for run " + runName + ".", true, true);
                        }
                    } else {
                        for (HashMap hashMap : identificationFiles.values()) {
                            for (File identificationFile : hashMap.values()) {
                                identificationFilesList.add(identificationFile);
                            }
                        }
                    }
                    if (utilitiesUserPreferences.getPeptideShakerPath() == null || !new File(utilitiesUserPreferences.getPeptideShakerPath()).exists()) {
                        this.waitingHandler.appendReport("PeptideShaker not found! Please check the PeptideShaker path.", true, true);
                        this.waitingHandler.appendReportEndLine();
                        this.waitingHandler.setRunCanceled();
                    } else if (!identificationFiles.isEmpty()) {
                        SearchHandler.this.peptideShakerProcessBuilder = new PeptideShakerProcessBuilder(this.waitingHandler, SearchHandler.this.exceptionHandler, SearchHandler.this.experimentLabel, SearchHandler.this.sampleLabel, SearchHandler.this.replicateNumber, SearchHandler.this.mgfFiles, identificationFilesList, SearchHandler.this.identificationParameters, SearchHandler.this.identificationParametersFile, SearchHandler.this.peptideShakerFile, true, SearchHandler.this.processingPreferences, utilitiesUserPreferences.outputData());
                        this.waitingHandler.appendReport("Processing identification files with PeptideShaker.", true, true);
                        SearchHandler.this.peptideShakerProcessBuilder.startProcess();
                    } else {
                        SearchHandler.this.enablePeptideShaker = false;
                        this.waitingHandler.appendReportEndLine();
                        this.waitingHandler.appendReport("No identification files to process with PeptideShaker!", true, true);
                        this.waitingHandler.appendReportEndLine();
                    }
                }
                if (!outputFolder.getAbsolutePath().equals(outputTempFolder.getAbsolutePath())) {
                    boolean deleteTempFolder = true;
                    if (!identificationFiles.isEmpty() && this.waitingHandler.isRunCanceled() && this.waitingHandler instanceof WaitingDialog) {
                        WaitingDialog guiWaitingDialog = (WaitingDialog)this.waitingHandler;
                        ((JFrame)guiWaitingDialog.getParent()).setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")));
                        int n = JOptionPane.showConfirmDialog(guiWaitingDialog, "Keep the partial search results?", "Keep Partial Results?", 0);
                        deleteTempFolder = n == 1;
                        ((JFrame)guiWaitingDialog.getParent()).setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
                    }
                    if (deleteTempFolder) {
                        Util.deleteDir(outputTempFolder);
                    }
                }
                if (SearchHandler.this.enableAndromeda && AndromedaProcessBuilder.getTempFolderPath() != null && (andromedaTempFolder = new File(AndromedaProcessBuilder.getTempFolderPath())).exists()) {
                    Util.emptyDir(andromedaTempFolder);
                }
                this.finished = true;
                if (!this.waitingHandler.isRunCanceled()) {
                    SearchHandler.this.searchCompleted();
                } else {
                    SearchHandler.this.searchCrashed();
                }
                SearchHandler.this.notifySearchFinished();
                return 0;
            }
            catch (Exception e) {
                this.waitingHandler.appendReport("Error: " + e.getMessage(), true, true);
                this.waitingHandler.appendReport("An error occurred while running SearchGUI. Please contact the developers.", true, true);
                e.printStackTrace();
                SearchHandler.this.searchCrashed();
                return 1;
            }
        }

        public boolean isFinished() {
            return this.finished;
        }
    }
}

