/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.cmd;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.settings.PathKey;
import com.compomics.util.experiment.identification.protein_sequences.FastaIndex;
import com.compomics.util.experiment.identification.protein_sequences.SequenceFactory;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import eu.isas.searchgui.cmd.FastaCLIInputBean;
import eu.isas.searchgui.cmd.FastaCLIParams;
import eu.isas.searchgui.cmd.PathSettingsCLI;
import eu.isas.searchgui.cmd.PathSettingsCLIInputBean;
import eu.isas.searchgui.cmd.SearchCLI;
import eu.isas.searchgui.preferences.SearchGUIPathPreferences;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class FastaCLI {
    private FastaCLIInputBean fastaCLIInputBean;

    public FastaCLI(String[] args) {
        try {
            Options lOptions = new Options();
            FastaCLIParams.createOptionsCLI(lOptions);
            BasicParser parser = new BasicParser();
            CommandLine line = parser.parse(lOptions, args);
            if (!FastaCLIInputBean.isValidStartup(line)) {
                PrintWriter lPrintWriter = new PrintWriter(System.out);
                lPrintWriter.print(System.getProperty("line.separator") + "======================" + System.getProperty("line.separator"));
                lPrintWriter.print("FastaCLI" + System.getProperty("line.separator"));
                lPrintWriter.print("======================" + System.getProperty("line.separator"));
                lPrintWriter.print(FastaCLI.getHeader());
                lPrintWriter.print(FastaCLIParams.getOptionsAsString());
                lPrintWriter.flush();
                lPrintWriter.close();
                System.exit(0);
            } else {
                this.fastaCLIInputBean = new FastaCLIInputBean(line);
                this.call();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void call() {
        PathSettingsCLIInputBean pathSettingsCLIInputBean = this.fastaCLIInputBean.getPathSettingsCLIInputBean();
        if (pathSettingsCLIInputBean.getLogFolder() != null) {
            SearchCLI.redirectErrorStream(pathSettingsCLIInputBean.getLogFolder());
        }
        if (pathSettingsCLIInputBean.hasInput()) {
            PathSettingsCLI pathSettingsCLI = new PathSettingsCLI(pathSettingsCLIInputBean);
            pathSettingsCLI.setPathSettings();
        } else {
            try {
                File pathConfigurationFile = new File(this.getJarFilePath(), "resources/conf/paths.txt");
                if (pathConfigurationFile.exists()) {
                    SearchGUIPathPreferences.loadPathPreferencesFromFile(pathConfigurationFile);
                }
            }
            catch (Exception e) {
                System.out.println("An error occurred when setting path configuration. Default paths will be used.");
                e.printStackTrace();
            }
            try {
                ArrayList<PathKey> errorKeys = SearchGUIPathPreferences.getErrorKeys(this.getJarFilePath());
                if (!errorKeys.isEmpty()) {
                    System.out.println("Unable to write in the following configuration folders. Please use a temporary folder, the path configuration command line, or edit the configuration paths from the graphical interface.");
                    for (PathKey pathKey : errorKeys) {
                        System.out.println(pathKey.getId() + ": " + pathKey.getDescription());
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Unable to load the path configurations. Default pathswill be used.");
            }
        }
        try {
            WaitingHandlerCLIImpl waitingHandlerCLIImpl = new WaitingHandlerCLIImpl();
            SequenceFactory sequenceFactory = SequenceFactory.getInstance();
            File fastaFile = this.fastaCLIInputBean.getInputFile();
            sequenceFactory.loadFastaFile(fastaFile, waitingHandlerCLIImpl);
            System.out.println("Input: " + fastaFile.getAbsolutePath() + System.getProperty("line.separator"));
            this.writeDbProperties();
            if (this.fastaCLIInputBean.isDecoy()) {
                boolean success;
                String decoySuffix = this.fastaCLIInputBean.getDecoySuffix();
                if (decoySuffix != null) {
                    UtilitiesUserPreferences userPreferences = UtilitiesUserPreferences.loadUserPreferences();
                    userPreferences.setTargetDecoyFileNameSuffix(decoySuffix + ".fasta");
                }
                if (success = this.generateTargetDecoyDatabase(waitingHandlerCLIImpl)) {
                    System.out.println("Decoy file successfully created: " + System.getProperty("line.separator"));
                    System.out.println("Output: " + sequenceFactory.getCurrentFastaFile().getAbsolutePath() + System.getProperty("line.separator"));
                    this.writeDbProperties();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeDbProperties() {
        SequenceFactory sequenceFactory = SequenceFactory.getInstance();
        FastaIndex fastaIndex = sequenceFactory.getCurrentFastaIndex();
        System.out.println("Name: " + fastaIndex.getName());
        System.out.println("Version: " + fastaIndex.getVersion());
        System.out.println("Decoy Tag: " + fastaIndex.getDecoyTag());
        System.out.println("Type: " + fastaIndex.getMainDatabaseType().toString());
        System.out.println("Last modified: " + new Date(fastaIndex.getLastModified()).toString());
        String nSequences = fastaIndex.getNSequences() + " sequences";
        if (fastaIndex.isConcatenatedTargetDecoy()) {
            nSequences = nSequences + " (" + fastaIndex.getNTarget() + " target)";
        }
        System.out.println("Size: " + nSequences + System.getProperty("line.separator"));
    }

    public boolean generateTargetDecoyDatabase(WaitingHandlerCLIImpl waitingHandlerCLIImpl) {
        SequenceFactory sequenceFactory = SequenceFactory.getInstance();
        String newFasta = this.fastaCLIInputBean.getInputFile().getAbsolutePath();
        if (newFasta.lastIndexOf(".") != -1) {
            newFasta = newFasta.substring(0, newFasta.lastIndexOf("."));
        }
        UtilitiesUserPreferences userPreferences = UtilitiesUserPreferences.loadUserPreferences();
        newFasta = newFasta + userPreferences.getTargetDecoyFileNameSuffix() + ".fasta";
        File newFile = new File(newFasta);
        try {
            waitingHandlerCLIImpl.setWaitingText("Appending Decoy Sequences. Please Wait...");
            sequenceFactory.appendDecoySequences(newFile, waitingHandlerCLIImpl);
            sequenceFactory.clearFactory();
            sequenceFactory.loadFastaFile(newFile, waitingHandlerCLIImpl);
        }
        catch (OutOfMemoryError error) {
            System.out.println("Ran out of memory!");
            error.printStackTrace();
            return false;
        }
        catch (Exception e) {
            System.out.println("An error occurred while appending decoy sequences");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static String getHeader() {
        return System.getProperty("line.separator") + "FastaCLI takes a fasta file as input, generates general information about the database and allows operations on the fasta file." + System.getProperty("line.separator") + System.getProperty("line.separator") + "For further help see http://compomics.github.io/projects/searchgui.html and http://compomics.github.io/projects/searchgui/wiki/searchcli.html." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Or contact the developers at https://groups.google.com/group/peptide-shaker." + System.getProperty("line.separator") + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "OPTIONS" + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "\n";
    }

    public static void main(String[] args) {
        try {
            new FastaCLI(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getJarFilePath() {
        return CompomicsWrapper.getJarFilePath(this.getClass().getResource("FastaCLI.class").getPath(), "SearchGUI");
    }
}

