/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.cmd;

import com.compomics.software.settings.UtilitiesPathPreferences;
import eu.isas.searchgui.preferences.SearchGUIPathPreferences;
import org.apache.commons.cli.Options;

public enum PathSettingsCLIParams {
    ALL("temp_folder", "A folder for temporary file storage. Use only if you encounter problems with the default configuration."),
    LOG("log", "Folder where to write log files.");

    public String id;
    public String description;

    private PathSettingsCLIParams(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public static void createOptionsCLI(Options aOptions) {
        for (PathSettingsCLIParams pathSettingsCLIParams : PathSettingsCLIParams.values()) {
            aOptions.addOption(pathSettingsCLIParams.id, true, pathSettingsCLIParams.description);
        }
        for (Enum enum_ : SearchGUIPathPreferences.SearchGUIPathKey.values()) {
            aOptions.addOption(((SearchGUIPathPreferences.SearchGUIPathKey)enum_).getId(), true, ((SearchGUIPathPreferences.SearchGUIPathKey)enum_).getDescription());
        }
        for (Enum enum_ : UtilitiesPathPreferences.UtilitiesPathKey.values()) {
            aOptions.addOption(((UtilitiesPathPreferences.UtilitiesPathKey)enum_).getId(), true, ((UtilitiesPathPreferences.UtilitiesPathKey)enum_).getDescription());
        }
    }

    public static String getOptionsAsString() {
        String output = "";
        String formatter = "%-35s";
        output = output + "Log Folder:\n\n";
        output = output + "-" + String.format(formatter, PathSettingsCLIParams.LOG.id) + " " + PathSettingsCLIParams.LOG.description + "\n";
        output = output + "Generic Temporary Folder:\n\n";
        output = output + "-" + String.format(formatter, PathSettingsCLIParams.ALL.id) + " " + PathSettingsCLIParams.ALL.description + "\n";
        output = output + "\n\nSpecific Path Setting:\n\n";
        for (SearchGUIPathPreferences.SearchGUIPathKey searchGUIPathKey : SearchGUIPathPreferences.SearchGUIPathKey.values()) {
            output = output + "-" + String.format(formatter, searchGUIPathKey.getId()) + " " + searchGUIPathKey.getDescription() + System.getProperty("line.separator");
        }
        for (Enum enum_ : UtilitiesPathPreferences.UtilitiesPathKey.values()) {
            output = output + "-" + String.format(formatter, ((UtilitiesPathPreferences.UtilitiesPathKey)enum_).getId()) + " " + ((UtilitiesPathPreferences.UtilitiesPathKey)enum_).getDescription() + System.getProperty("line.separator");
        }
        return output;
    }
}

