/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.cmd;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.settings.PathKey;
import com.compomics.util.Util;
import com.compomics.util.experiment.biology.EnzymeFactory;
import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.protein_sequences.SequenceFactory;
import com.compomics.util.experiment.io.massspectrometry.MgfIndex;
import com.compomics.util.experiment.io.massspectrometry.MgfReader;
import com.compomics.util.experiment.massspectrometry.SpectrumFactory;
import com.compomics.util.gui.filehandling.TempFilesManager;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingHandlerCLIImpl;
import com.compomics.util.preferences.IdentificationParameters;
import com.compomics.util.preferences.ProcessingPreferences;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.SearchHandler;
import eu.isas.searchgui.cmd.PathSettingsCLI;
import eu.isas.searchgui.cmd.PathSettingsCLIInputBean;
import eu.isas.searchgui.cmd.SearchCLIInputBean;
import eu.isas.searchgui.cmd.SearchCLIParams;
import eu.isas.searchgui.preferences.SearchGUIPathPreferences;
import eu.isas.searchgui.utilities.Properties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class SearchCLI
implements Callable {
    private SearchCLIInputBean searchCLIInputBean;
    private EnzymeFactory enzymeFactory;
    private SpectrumFactory spectrumFactory = SpectrumFactory.getInstance();

    public SearchCLI(String[] args) {
        try {
            try {
                SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
                speciesFactory.initiate(this.getJarFilePath());
            }
            catch (Exception e) {
                System.out.println("An error occurred while loading the species.");
                e.printStackTrace();
            }
            Options lOptions = new Options();
            SearchCLIParams.createOptionsCLI(lOptions);
            BasicParser parser = new BasicParser();
            CommandLine line = parser.parse(lOptions, args);
            if (!SearchCLIInputBean.isValidStartup(line)) {
                PrintWriter lPrintWriter = new PrintWriter(System.out);
                lPrintWriter.print(System.getProperty("line.separator") + "======================" + System.getProperty("line.separator"));
                lPrintWriter.print("SearchCLI" + System.getProperty("line.separator"));
                lPrintWriter.print("======================" + System.getProperty("line.separator"));
                lPrintWriter.print(SearchCLI.getHeader());
                lPrintWriter.print(SearchCLIParams.getOptionsAsString());
                lPrintWriter.flush();
                lPrintWriter.close();
                System.exit(0);
            } else {
                this.searchCLIInputBean = new SearchCLIInputBean(line);
                this.call();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Object call() {
        PathSettingsCLIInputBean pathSettingsCLIInputBean = this.searchCLIInputBean.getPathSettingsCLIInputBean();
        if (pathSettingsCLIInputBean.getLogFolder() != null) {
            SearchCLI.redirectErrorStream(pathSettingsCLIInputBean.getLogFolder());
        }
        if (pathSettingsCLIInputBean.hasInput()) {
            PathSettingsCLI pathSettingsCLI = new PathSettingsCLI(pathSettingsCLIInputBean);
            pathSettingsCLI.setPathSettings();
        } else {
            try {
                File pathConfigurationFile = new File(this.getJarFilePath(), "resources/conf/paths.txt");
                if (pathConfigurationFile.exists()) {
                    SearchGUIPathPreferences.loadPathPreferencesFromFile(pathConfigurationFile);
                }
            }
            catch (Exception e) {
                System.out.println("An error occurred when setting path configuration. Default paths will be used.");
                e.printStackTrace();
            }
            try {
                ArrayList<PathKey> errorKeys = SearchGUIPathPreferences.getErrorKeys(this.getJarFilePath());
                if (!errorKeys.isEmpty()) {
                    System.out.println("Unable to write in the following configuration folders. Please use a temporary folder, the path configuration command line, or edit the configuration paths from the graphical interface.");
                    for (PathKey pathKey : errorKeys) {
                        System.out.println(pathKey.getId() + ": " + pathKey.getDescription());
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Unable to load the path configurations. Default pathswill be used.");
            }
        }
        this.enzymeFactory = EnzymeFactory.getInstance();
        try {
            SearchParameters searchParameters;
            String error;
            WaitingHandlerCLIImpl waitingHandlerCLIImpl = new WaitingHandlerCLIImpl();
            for (File tempMgfFile : this.searchCLIInputBean.getSpectrumFiles()) {
                waitingHandlerCLIImpl.appendReport("Validating MGF file: " + tempMgfFile.getAbsolutePath(), true, true);
                this.spectrumFactory.addSpectra(tempMgfFile, waitingHandlerCLIImpl);
                File indexFile = new File(tempMgfFile.getParent(), tempMgfFile.getName() + ".cui");
                if (this.spectrumFactory.getIndex(indexFile).getSpectrumTitles().size() < this.spectrumFactory.getIndex(indexFile).getNSpectra()) {
                    if (this.searchCLIInputBean.getMissingSpectrumTitleHandling() == 0) {
                        if (this.spectrumFactory.getIndex(indexFile).getSpectrumTitles().isEmpty()) {
                            waitingHandlerCLIImpl.appendReport("Warning: No spectrum titles found in file: " + tempMgfFile.getAbsolutePath() + "! Titles are mandatory. See the missing_titles option. File will be ignored.", true, true);
                        } else {
                            waitingHandlerCLIImpl.appendReport("Warning: Spectrum titles missing in file: " + tempMgfFile.getAbsolutePath() + "! Titles are mandatory. See the missing_titles option. File will be ignored.", true, true);
                        }
                        return false;
                    }
                    waitingHandlerCLIImpl.appendReport("Adding missing spectrum titles in file: " + tempMgfFile.getAbsolutePath(), true, true);
                    this.spectrumFactory.closeFiles();
                    MgfReader.addMissingSpectrumTitles(tempMgfFile, waitingHandlerCLIImpl);
                    this.spectrumFactory.addSpectra(tempMgfFile, waitingHandlerCLIImpl);
                }
                if (!this.spectrumFactory.getIndex(indexFile).isPeakPicked().booleanValue()) {
                    waitingHandlerCLIImpl.appendReport("Warning: The file '" + tempMgfFile.getName() + "' contains zero intensity peaks. It is highly recommended to apply peak picking before starting a search!", true, true);
                }
                if (this.spectrumFactory.getIndex(indexFile).getMaxPeakCount() == 0) {
                    waitingHandlerCLIImpl.appendReport("Warning: No MS2 spectra found in file: " + tempMgfFile.getName() + "! File will be ignored.", true, true);
                    return false;
                }
                HashMap<String, Integer> hashMap = this.spectrumFactory.getIndex(indexFile).getDuplicatedSpectrumTitles();
                if (hashMap == null || hashMap.size() <= 0) continue;
                waitingHandlerCLIImpl.appendReport("Warning: The spectrum file contains non-unique spectrum titles!", true, true);
                if (this.searchCLIInputBean.getDuplicateSpectrumTitleHandling() == 1) {
                    waitingHandlerCLIImpl.appendReport("Renaming duplicated spectrum titles in file: " + tempMgfFile.getAbsolutePath(), true, true);
                    this.spectrumFactory.closeFiles();
                    MgfReader.renameDuplicateSpectrumTitles(tempMgfFile, null);
                    this.spectrumFactory.addSpectra(tempMgfFile, waitingHandlerCLIImpl);
                    continue;
                }
                if (this.searchCLIInputBean.getDuplicateSpectrumTitleHandling() != 2) continue;
                waitingHandlerCLIImpl.appendReport("Removing spectra with duplicated titles in file: " + tempMgfFile.getAbsolutePath(), true, true);
                this.spectrumFactory.closeFiles();
                MgfReader.removeDuplicateSpectrumTitles(tempMgfFile, null);
                this.spectrumFactory.addSpectra(tempMgfFile, waitingHandlerCLIImpl);
            }
            ArrayList<File> spectrumFiles = new ArrayList<File>();
            ArrayList<File> fatMgfFiles = new ArrayList<File>();
            for (File file : this.searchCLIInputBean.getSpectrumFiles()) {
                if (this.searchCLIInputBean.checkMgfSize().booleanValue() && file.length() > (long)this.searchCLIInputBean.getMgfMaxSize() * 0x100000L) {
                    fatMgfFiles.add(file);
                    continue;
                }
                spectrumFiles.add(file);
            }
            if (!fatMgfFiles.isEmpty()) {
                waitingHandlerCLIImpl.appendReportEndLine();
                waitingHandlerCLIImpl.appendReport("MGF files requires splitting. (See options: mgf_splitting and mgf_spectrum_count.)", true, true);
                ArrayList<File> splitMgfs = this.splitFiles(fatMgfFiles, waitingHandlerCLIImpl);
                if (splitMgfs != null) {
                    for (File tempMgfFile : splitMgfs) {
                        spectrumFiles.add(tempMgfFile);
                    }
                }
                waitingHandlerCLIImpl.appendReport("Current MGF input (listed in \"output_folder\"\\searchGUI_input.txt): ", true, true);
                for (File tempMgfFile : spectrumFiles) {
                    waitingHandlerCLIImpl.appendReport(tempMgfFile.getAbsolutePath(), false, true);
                }
            }
            ProcessingPreferences processingPreferences = new ProcessingPreferences();
            processingPreferences.setnThreads(this.searchCLIInputBean.getNThreads());
            IdentificationParameters identificationParameters = this.searchCLIInputBean.getIdentificationParameters();
            File parametersFile = this.searchCLIInputBean.getIdentificationParametersFile();
            if (parametersFile == null) {
                String name = identificationParameters.getName();
                name = name == null ? "SearchCLI.par" : name + ".par";
                parametersFile = new File(this.searchCLIInputBean.getOutputFile(), name);
                IdentificationParameters.saveIdentificationParameters(identificationParameters, parametersFile);
            }
            if ((error = SearchHandler.loadModifications(searchParameters = identificationParameters.getSearchParameters())) != null) {
                System.out.println(error);
            }
            UtilitiesUserPreferences userPreferences = UtilitiesUserPreferences.loadUserPreferences();
            userPreferences.setTargetDecoyFileNameSuffix(this.searchCLIInputBean.getTargetDecoyFileNameTag());
            userPreferences.setRefMass(this.searchCLIInputBean.getRefMass());
            userPreferences.setRenameXTandemFile(this.searchCLIInputBean.renameXTandemFile());
            userPreferences.setOutputOption(this.searchCLIInputBean.getOutputOption());
            userPreferences.setOutputData(this.searchCLIInputBean.isOutputData());
            userPreferences.setIncludeDateInOutputName(this.searchCLIInputBean.isOutputDate());
            UtilitiesUserPreferences.saveUserPreferences(userPreferences);
            File fastaFile = searchParameters.getFastaFile();
            SequenceFactory.getInstance().loadFastaFile(fastaFile);
            SearchHandler searchHandler = new SearchHandler(identificationParameters, this.searchCLIInputBean.getOutputFile(), spectrumFiles, new ArrayList<File>(), parametersFile, this.searchCLIInputBean.isOmssaEnabled(), this.searchCLIInputBean.isXTandemEnabled(), this.searchCLIInputBean.isMsgfEnabled(), this.searchCLIInputBean.isMsAmandaEnabled(), this.searchCLIInputBean.isMyriMatchEnabled(), this.searchCLIInputBean.isCometEnabled(), this.searchCLIInputBean.isTideEnabled(), this.searchCLIInputBean.isAndromedaEnabled(), this.searchCLIInputBean.isNovorEnabled(), this.searchCLIInputBean.isDirecTagEnabled(), this.searchCLIInputBean.getOmssaLocation(), this.searchCLIInputBean.getXtandemLocation(), this.searchCLIInputBean.getMsgfLocation(), this.searchCLIInputBean.getMsAmandaLocation(), this.searchCLIInputBean.getMyriMatchLocation(), this.searchCLIInputBean.getCometLocation(), this.searchCLIInputBean.getTideLocation(), this.searchCLIInputBean.getAndromedaLocation(), this.searchCLIInputBean.getNovorLocation(), this.searchCLIInputBean.getDirecTagLocation(), this.searchCLIInputBean.getMakeblastdbLocation(), processingPreferences);
            File logFolder = pathSettingsCLIInputBean.getLogFolder();
            if (logFolder != null) {
                searchHandler.setLogFolder(logFolder);
            }
            if (userPreferences.isAutoUpdate().booleanValue()) {
                Util.sendGAUpdate("UA-36198780-2", "startrun-cl", "searchgui-" + new Properties().getVersion());
            }
            searchHandler.startSearch(waitingHandlerCLIImpl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            TempFilesManager.deleteTempFolders();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private ArrayList<File> splitFiles(ArrayList<File> mgfFiles, WaitingHandler waitingHandler) {
        ArrayList<File> splitMgfFiles = new ArrayList<File>();
        MgfReader mgfReader = new MgfReader();
        for (File originalFile : mgfFiles) {
            ArrayList<MgfIndex> indexes;
            waitingHandler.appendReport("Splitting " + originalFile.getName() + ". Please Wait...", true, true);
            try {
                indexes = mgfReader.splitFile(originalFile, this.searchCLIInputBean.getMgfNSpectra(), waitingHandler);
            }
            catch (FileNotFoundException e) {
                waitingHandler.appendReport("File " + originalFile.getName() + " not found.", true, true);
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                waitingHandler.appendReport("An error occurred while reading/writing the mgf file.", true, true);
                e.printStackTrace();
                return null;
            }
            catch (OutOfMemoryError error) {
                waitingHandler.appendReport("SearchGUI used up all the available memory and had to be stopped.\nMemory boundaries are set in the Edit menu (Edit > Java Options).", true, true);
                error.printStackTrace();
                return null;
            }
            try {
                if (indexes != null && !indexes.isEmpty()) {
                    waitingHandler.appendReport("Writing Indexes. Please Wait...", true, true);
                    for (MgfIndex currentIndex : indexes) {
                        this.spectrumFactory.writeIndex(currentIndex, originalFile.getParentFile());
                    }
                }
            }
            catch (IOException e) {
                waitingHandler.appendReport("An error occurred while writing an mgf index.", true, true);
                e.printStackTrace();
                return null;
            }
            for (MgfIndex currentIndex : indexes) {
                File newFile = new File(originalFile.getParent(), currentIndex.getFileName());
                splitMgfFiles.add(newFile);
            }
        }
        waitingHandler.appendReport("MGF file(s) split and selected.", true, true);
        return splitMgfFiles;
    }

    private static String getHeader() {
        return System.getProperty("line.separator") + "SearchCLI searches spectrum files according to search parameters using multiple search engines." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Spectra must be provided in the Mascot Generic File (mgf) format." + System.getProperty("line.separator") + System.getProperty("line.separator") + "The identification parameters can be provided as a file as saved from the GUI or generated using the IdentificationParametersCLI." + System.getProperty("line.separator") + "See http://compomics.github.io/projects/compomics-utilities/wiki/identificationparameterscli.html for more details." + System.getProperty("line.separator") + System.getProperty("line.separator") + "For further help see http://compomics.github.io/projects/searchgui.html and http://compomics.github.io/projects/searchgui/wiki/searchcli.html." + System.getProperty("line.separator") + System.getProperty("line.separator") + "Or contact the developers at https://groups.google.com/group/peptide-shaker." + System.getProperty("line.separator") + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "OPTIONS" + System.getProperty("line.separator") + "----------------------" + System.getProperty("line.separator") + "\n";
    }

    public static void main(String[] args) {
        try {
            new SearchCLI(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void redirectErrorStream(File logFolder) {
        try {
            logFolder.mkdirs();
            File file = new File(logFolder, "SearchGUI.log");
            System.setErr(new PrintStream(new FileOutputStream(file, true)));
            System.err.println(System.getProperty("line.separator") + System.getProperty("line.separator") + new Date() + ": SearchGUI version " + new Properties().getVersion() + ".");
            System.err.println("Memory given to the Java virtual machine: " + Runtime.getRuntime().maxMemory() + ".");
            System.err.println("Total amount of memory in the Java virtual machine: " + Runtime.getRuntime().totalMemory() + ".");
            System.err.println("Free memory: " + Runtime.getRuntime().freeMemory() + ".");
            System.err.println("Java version: " + System.getProperty("java.version") + ".");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getJarFilePath() {
        return CompomicsWrapper.getJarFilePath(this.getClass().getResource("SearchCLI.class").getPath(), "SearchGUI");
    }
}

