/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.gui;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.autoupdater.MavenJarFile;
import com.compomics.software.cli.CommandLineUtils;
import com.compomics.software.dialogs.JavaHomeOrMemoryDialogParent;
import com.compomics.software.dialogs.JavaSettingsDialog;
import com.compomics.software.dialogs.PeptideShakerSetupDialog;
import com.compomics.software.dialogs.ProteoWizardSetupDialog;
import com.compomics.software.settings.PathKey;
import com.compomics.software.settings.UtilitiesPathPreferences;
import com.compomics.software.settings.gui.PathSettingsDialog;
import com.compomics.util.Util;
import com.compomics.util.db.DerbyUtil;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.exceptions.exception_handlers.FrameExceptionHandler;
import com.compomics.util.experiment.biology.EnzymeFactory;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.genes.GeneFactory;
import com.compomics.util.experiment.biology.taxonomy.SpeciesFactory;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.IdentificationParametersFactory;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.AndromedaParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.CometParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.DirecTagParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.MsAmandaParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.MsgfParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.MyriMatchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.NovorParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.OmssaParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.TideParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.XtandemParameters;
import com.compomics.util.experiment.identification.protein_sequences.FastaIndex;
import com.compomics.util.experiment.identification.protein_sequences.SequenceFactory;
import com.compomics.util.experiment.io.massspectrometry.MgfIndex;
import com.compomics.util.experiment.io.massspectrometry.MgfReader;
import com.compomics.util.experiment.massspectrometry.SpectrumFactory;
import com.compomics.util.experiment.massspectrometry.proteowizard.MsConvertParameters;
import com.compomics.util.experiment.massspectrometry.proteowizard.MsFormat;
import com.compomics.util.experiment.massspectrometry.proteowizard.ProteoWizardFilter;
import com.compomics.util.experiment.massspectrometry.proteowizard.gui.MsConvertParametersDialog;
import com.compomics.util.gui.JOptionEditorPane;
import com.compomics.util.gui.PrivacySettingsDialog;
import com.compomics.util.gui.UtilitiesGUIDefaults;
import com.compomics.util.gui.error_handlers.BugReport;
import com.compomics.util.gui.error_handlers.HelpDialog;
import com.compomics.util.gui.filehandling.FileDisplayDialog;
import com.compomics.util.gui.filehandling.TempFilesManager;
import com.compomics.util.gui.parameters.IdentificationParametersEditionDialog;
import com.compomics.util.gui.parameters.IdentificationParametersOverviewDialog;
import com.compomics.util.gui.parameters.ProcessingPreferencesDialog;
import com.compomics.util.gui.parameters.identification_parameters.SearchSettingsDialog;
import com.compomics.util.gui.parameters.identification_parameters.algorithm_settings.AndromedaSettingsDialog;
import com.compomics.util.gui.parameters.identification_parameters.algorithm_settings.CometSettingsDialog;
import com.compomics.util.gui.parameters.identification_parameters.algorithm_settings.DirecTagSettingsDialog;
import com.compomics.util.gui.parameters.identification_parameters.algorithm_settings.MsAmandaSettingsDialog;
import com.compomics.util.gui.parameters.identification_parameters.algorithm_settings.MsgfSettingsDialog;
import com.compomics.util.gui.parameters.identification_parameters.algorithm_settings.MyriMatchSettingsDialog;
import com.compomics.util.gui.parameters.identification_parameters.algorithm_settings.NovorSettingsDialog;
import com.compomics.util.gui.parameters.identification_parameters.algorithm_settings.OmssaSettingsDialog;
import com.compomics.util.gui.parameters.identification_parameters.algorithm_settings.TideSettingsDialog;
import com.compomics.util.gui.parameters.identification_parameters.algorithm_settings.XTandemSettingsDialog;
import com.compomics.util.gui.ptm.ModificationsDialog;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import com.compomics.util.gui.waiting.waitinghandlers.WaitingDialog;
import com.compomics.util.preferences.IdentificationParameters;
import com.compomics.util.preferences.LastSelectedFolder;
import com.compomics.util.preferences.ProcessingPreferences;
import com.compomics.util.preferences.SearchGuiOutputOption;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.waiting.WaitingActionListener;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.SearchGUIWrapper;
import eu.isas.searchgui.SearchHandler;
import eu.isas.searchgui.gui.AdvancedSettingsDialog;
import eu.isas.searchgui.gui.AlignedListCellRenderer;
import eu.isas.searchgui.gui.PeptideShakerSettingsDialog;
import eu.isas.searchgui.gui.SoftwareLocationDialog;
import eu.isas.searchgui.preferences.SearchGUIPathPreferences;
import eu.isas.searchgui.processbuilders.AndromedaProcessBuilder;
import eu.isas.searchgui.utilities.Properties;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import net.jimmc.jshortcut.JShellLink;

public class SearchGUI
extends JFrame
implements JavaHomeOrMemoryDialogParent {
    private LastSelectedFolder lastSelectedFolder = new LastSelectedFolder();
    private static ProgressDialogX progressDialog;
    private File outputFolder;
    private ArrayList<File> mgfFiles = new ArrayList();
    private ArrayList<File> rawFiles = new ArrayList();
    private PTMFactory ptmFactory;
    private SpectrumFactory spectrumFactory;
    private EnzymeFactory enzymeFactory;
    private SearchHandler searchHandler;
    private MgfReader mgfReader;
    private boolean settingsTabDisplayed = false;
    private File identificationParametersFile;
    private IdentificationParameters identificationParameters;
    private ProcessingPreferences processingPreferences;
    private MsConvertParameters msConvertParameters;
    public static String TITLED_BORDER_HORIZONTAL_PADDING;
    private static boolean useLogFile;
    private WaitingDialog waitingDialog;
    private UtilitiesUserPreferences utilitiesUserPreferences = null;
    public static final String MODIFICATION_SEPARATOR = "//";
    public static final String MODIFICATION_USE_SEPARATOR = "_";
    private ArrayList<String> modificationUse = new ArrayList();
    private boolean validSpectrumTitles;
    private FrameExceptionHandler exceptionHandler = new FrameExceptionHandler(this, "https://github.com/compomics/searchgui/issues");
    public static String msAmandaErrorMessage;
    private IdentificationParametersFactory identificationParametersFactory = IdentificationParametersFactory.getInstance();
    private JButton aboutButton;
    private JMenuItem aboutMenuItem;
    private JButton addSettingsButton;
    private JButton addSpectraButton;
    private JMenuItem advancedSettingsMenuItem;
    private JButton andromedaButton;
    private JLabel andromedaLinkLabel;
    private JButton andromedaSettingsButton;
    private JButton andromedaSupportButton;
    private JButton clearSpectraButton;
    private JButton cometButton;
    private JLabel cometLinkLabel;
    private JButton cometSettingsButton;
    private JButton cometSupportButton;
    private JPanel deNovoPanel;
    private JButton direcTagButton;
    private JLabel direcTagLinkLabel;
    private JButton direcTagSettingsButton;
    private JButton direcTagSupportButton;
    private JMenuItem editIdSettingsFilesMenuItem;
    private JMenu editMenu;
    private JMenuItem editModificationsEditMenuItem;
    private JMenuItem editModificationsMenuItem;
    private JLabel editReporterSettingsLabel;
    private JMenuItem editSearchEngineLocationsMenuItem;
    private JButton editSettingsButton;
    private JCheckBox enableAndromedaJCheckBox;
    private JCheckBox enableCometJCheckBox;
    private JCheckBox enableDirecTagJCheckBox;
    private JCheckBox enableMsAmandaJCheckBox;
    private JCheckBox enableMsgfJCheckBox;
    private JCheckBox enableMyriMatchJCheckBox;
    private JCheckBox enableNovorJCheckBox;
    private JCheckBox enableOmssaJCheckBox;
    private JCheckBox enableTideJCheckBox;
    private JCheckBox enableXTandemJCheckBox;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuItem helpMenuItem;
    private JPanel inputFilesPanel;
    private JMenuItem jMenuItem1;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator16;
    private JPopupMenu.Separator jSeparator17;
    private JPopupMenu.Separator jSeparator2;
    private JMenuItem javaSettingsJMenuItem;
    private JMenuItem logReportMenu;
    private JMenuBar menuBar;
    private JPopupMenu modificationOptionsPopupMenu;
    private JButton msAmandaButton;
    private JLabel msAmandaLinkLabel;
    private JButton msAmandaSettingsButton;
    private JButton msAmandaSupportButton;
    private JButton msconvertButton;
    private JCheckBox msconvertCheckBox;
    private JLabel msconvertLabel;
    private JButton msconvertSettingsButton;
    private JButton msconvertSupportButton;
    private JButton msgfButton;
    private JLabel msgfLinkLabel;
    private JButton msgfSettingsButton;
    private JButton msgfSupportButton;
    private JButton myriMatchButton;
    private JLabel myriMatchLinkLabel;
    private JButton myriMatchSettingsButton;
    private JButton myrimatchSupportButton;
    private JButton novorButton;
    private JLabel novorLinkLabel;
    private JButton novorSettingsButton;
    private JButton novorSupportButton;
    private JButton omssaButton;
    private JLabel omssaLinkLabel;
    private JButton omssaSettingsButton;
    private JButton omssaSupportButton;
    private JTextField outputFolderTxt;
    private JButton peptideShakerButton;
    private JCheckBox peptideShakerCheckBox;
    private JLabel peptideShakerLabel;
    private JButton peptideShakerSettingsButton;
    private JButton peptideShakerSupportButton;
    private JPanel postProcessingPanel;
    private JPanel preProcessingPanel;
    private JMenuItem privacyMenuItem;
    private JMenuItem processingMenuItem;
    private JButton reporterButton;
    private JCheckBox reporterCheckBox;
    private JLabel reporterLabel;
    private JPanel reporterPostProcessPanel;
    private JMenuItem resourceSettingsMenuItem;
    private JButton resultFolderBrowseButton;
    private JLabel resultFolderLbl;
    private JButton searchButton;
    private JPanel searchEnginesLocationPanel;
    private JPanel searchEnginesPanel;
    private JScrollPane searchEnginesScrollPane;
    private JLabel searchGUIPublicationLabel;
    private JLabel searchSettingsLbl;
    private JComboBox settingsComboBox;
    private JLabel spectraFilesLabel;
    private JTextField spectraFilesTxt;
    private JPanel taskEditorPanel;
    private JButton tideButton;
    private JLabel tideLinkLabel;
    private JButton tideSettingsButton;
    private JButton tideSupportButton;
    private JButton xtandemButton;
    private JLabel xtandemLinkLabel;
    private JButton xtandemSettingsButton;
    private JButton xtandemSupportButton;

    private SearchGUI() {
    }

    public SearchGUI(ArrayList<File> spectrumFiles, ArrayList<File> rawFiles, File aIdentificationParametersFile, File outputFolder, String species, String speciesType, String projectName) {
        this.identificationParametersFile = aIdentificationParametersFile;
        try {
            this.setPathConfiguration();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (!SearchGUIPathPreferences.getErrorKeys(this.getJarFilePath()).isEmpty()) {
                this.editPathSettings();
            }
        }
        catch (Exception e) {
            this.editPathSettings();
        }
        this.ptmFactory = PTMFactory.getInstance();
        this.spectrumFactory = SpectrumFactory.getInstance();
        this.enzymeFactory = EnzymeFactory.getInstance();
        this.initComponents();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")));
        this.setTitle("SearchGUI " + new Properties().getVersion());
        this.setUpLogFile();
        DerbyUtil.disableDerbyLog();
        try {
            this.utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error occurred when reading the user preferences.", "File Error", 0);
            e.printStackTrace();
        }
        boolean newVersion = false;
        if (!this.getJarFilePath().equalsIgnoreCase(".") && this.utilitiesUserPreferences.isAutoUpdate().booleanValue()) {
            newVersion = this.checkForNewVersion();
        }
        if (!newVersion) {
            this.enzymeFactory = EnzymeFactory.getInstance();
            GeneFactory geneFactory = GeneFactory.getInstance();
            try {
                geneFactory.initialize(this.getJarFilePath());
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "An error occurred while loading the gene mappings.", "Gene Mapping File Error", 0);
            }
            try {
                SpeciesFactory speciesFactory = SpeciesFactory.getInstance();
                speciesFactory.initiate(this.getJarFilePath());
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, "An error occurred while loading the species mapping.", "File Error", 0);
            }
            if (!this.getJarFilePath().equalsIgnoreCase(".")) {
                String versionNumber = new Properties().getVersion();
                this.utilitiesUserPreferences.setSearchGuiPath(new File(this.getJarFilePath(), "SearchGUI-" + versionNumber + ".jar").getAbsolutePath());
                UtilitiesUserPreferences.saveUserPreferences(this.utilitiesUserPreferences);
            }
            this.processingPreferences = new ProcessingPreferences();
            this.processingPreferences.setnThreads(Runtime.getRuntime().availableProcessors());
            this.updateIdentificationSettingsDropDownMenu(true);
            this.searchHandler = new SearchHandler(this.identificationParameters, outputFolder, spectrumFiles, rawFiles, this.identificationParametersFile, this.processingPreferences, this.exceptionHandler);
            this.enableOmssaJCheckBox.setSelected(this.searchHandler.isOmssaEnabled());
            this.enableXTandemJCheckBox.setSelected(this.searchHandler.isXtandemEnabled());
            this.enableMsgfJCheckBox.setSelected(this.searchHandler.isMsgfEnabled());
            this.enableMsAmandaJCheckBox.setSelected(this.searchHandler.isMsAmandaEnabled());
            this.enableMyriMatchJCheckBox.setSelected(this.searchHandler.isMyriMatchEnabled());
            this.enableCometJCheckBox.setSelected(this.searchHandler.isCometEnabled());
            this.enableTideJCheckBox.setSelected(this.searchHandler.isTideEnabled());
            this.enableAndromedaJCheckBox.setSelected(this.searchHandler.isAndromedaEnabled());
            this.enableNovorJCheckBox.setSelected(this.searchHandler.isNovorEnabled());
            this.enableDirecTagJCheckBox.setSelected(this.searchHandler.isDirecTagEnabled());
            if (!this.getJarFilePath().equalsIgnoreCase(".") && System.getProperty("os.name").lastIndexOf("Windows") != -1 && new File(this.getJarFilePath() + "/resources/conf/firstRun").exists()) {
                int value;
                boolean fileDeleted = new File(this.getJarFilePath() + "/resources/conf/firstRun").delete();
                if (!fileDeleted) {
                    JOptionPane.showMessageDialog(this, "Failed to delete the file /resources/conf/firstRun.\nPlease contact the developers.", "File Error", 0);
                }
                if ((value = JOptionPane.showConfirmDialog(null, "Create a shortcut to SearchGUI on the desktop?", "Create Desktop Shortcut?", 0, 3)) == 0) {
                    this.addShortcutAtDeskTop();
                }
            }
            this.msConvertParameters = new MsConvertParameters();
            this.msConvertParameters.setMsFormat(MsFormat.mgf);
            this.msConvertParameters.addFilter(ProteoWizardFilter.peakPicking.number, "");
            this.settingsComboBox.setRenderer(new AlignedListCellRenderer(0));
            UIManager.put("TitledBorder.titleColor", new Color(59, 59, 59));
            ((TitledBorder)this.inputFilesPanel.getBorder()).setTitle(TITLED_BORDER_HORIZONTAL_PADDING + "Input & Output" + TITLED_BORDER_HORIZONTAL_PADDING);
            ((TitledBorder)this.preProcessingPanel.getBorder()).setTitle(TITLED_BORDER_HORIZONTAL_PADDING + "Pre Processing" + TITLED_BORDER_HORIZONTAL_PADDING);
            ((TitledBorder)this.searchEnginesLocationPanel.getBorder()).setTitle(TITLED_BORDER_HORIZONTAL_PADDING + "Search Engines" + TITLED_BORDER_HORIZONTAL_PADDING);
            ((TitledBorder)this.deNovoPanel.getBorder()).setTitle(TITLED_BORDER_HORIZONTAL_PADDING + "De Novo Algorithms" + TITLED_BORDER_HORIZONTAL_PADDING);
            ((TitledBorder)this.postProcessingPanel.getBorder()).setTitle(TITLED_BORDER_HORIZONTAL_PADDING + "Post Processing" + TITLED_BORDER_HORIZONTAL_PADDING);
            this.searchEnginesLocationPanel.repaint();
            this.inputFilesPanel.repaint();
            this.mgfReader = new MgfReader();
            this.loadModificationUse(this.searchHandler.loadModificationsUse());
            String operatingSystem = System.getProperty("os.name").toLowerCase();
            if (operatingSystem.contains("mac os")) {
                this.enableMyriMatchJCheckBox.setSelected(false);
                this.enableMyriMatchJCheckBox.setEnabled(false);
                this.enableMyriMatchJCheckBox.setToolTipText("Not available for Mac");
                this.myriMatchButton.setEnabled(false);
                this.myriMatchButton.setToolTipText("Not available for Mac");
                this.myriMatchSettingsButton.setEnabled(false);
                this.myriMatchSettingsButton.setToolTipText("Not available for Mac");
                this.myriMatchLinkLabel.setEnabled(false);
                this.searchHandler.setMyriMatchEnabled(false);
                this.enableCometJCheckBox.setSelected(false);
                this.enableCometJCheckBox.setEnabled(false);
                this.enableCometJCheckBox.setToolTipText("Not available for Mac");
                this.cometButton.setEnabled(false);
                this.cometButton.setToolTipText("Not available for Mac");
                this.cometSettingsButton.setEnabled(false);
                this.cometSettingsButton.setToolTipText("Not available for Mac");
                this.cometLinkLabel.setEnabled(false);
                this.searchHandler.setCometEnabled(false);
                this.enableDirecTagJCheckBox.setSelected(false);
                this.enableDirecTagJCheckBox.setEnabled(false);
                this.enableDirecTagJCheckBox.setToolTipText("Not available for Mac");
                this.direcTagButton.setEnabled(false);
                this.direcTagButton.setToolTipText("Not available for Mac");
                this.direcTagSettingsButton.setEnabled(false);
                this.direcTagSettingsButton.setToolTipText("Not available for Mac");
                this.direcTagLinkLabel.setEnabled(false);
                this.searchHandler.setCometEnabled(false);
            }
            if (!operatingSystem.contains("windows")) {
                this.enableAndromedaJCheckBox.setSelected(false);
                this.enableAndromedaJCheckBox.setEnabled(false);
                this.enableAndromedaJCheckBox.setToolTipText("Only available for Windows");
                this.andromedaButton.setEnabled(false);
                this.andromedaButton.setToolTipText("Only available for Windows");
                this.andromedaSettingsButton.setEnabled(false);
                this.andromedaSettingsButton.setToolTipText("Only available for Windows");
                this.andromedaLinkLabel.setEnabled(false);
                this.searchHandler.setCometEnabled(false);
            }
            this.validateSearchEngines(true);
            if (spectrumFiles != null && !spectrumFiles.isEmpty() || rawFiles != null && !rawFiles.isEmpty()) {
                this.setSpectrumFiles(spectrumFiles, rawFiles);
                String experimentLabel = "PeptideShakerProject";
                if (projectName != null) {
                    experimentLabel = projectName;
                }
                ArrayList<File> tempFiles = spectrumFiles != null ? spectrumFiles : rawFiles;
                this.searchHandler.setExperimentLabel(experimentLabel);
                this.searchHandler.setSampleLabel(experimentLabel);
                this.searchHandler.setPeptideShakerFile(new File(tempFiles.get(0).getParentFile(), experimentLabel + ".cpsx"));
                this.peptideShakerCheckBox.setSelected(true);
            }
            if (outputFolder != null && outputFolder.exists()) {
                this.setOutputFolder(outputFolder);
            }
            if (rawFiles != null && !rawFiles.isEmpty()) {
                this.checkProteoWizard();
                this.msconvertCheckBox.setSelected(!rawFiles.isEmpty());
            }
            this.validateInput(false);
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            if (this.utilitiesUserPreferences.isAutoUpdate().booleanValue()) {
                Util.sendGAUpdate("UA-36198780-2", "toolstart", "searchgui-" + new Properties().getVersion());
            }
        }
    }

    private void updateIdentificationSettingsDropDownMenu(boolean loadSettings) {
        Vector<String> parameterList = new Vector<String>();
        parameterList.add("-- Select --");
        if (this.identificationParametersFile != null && loadSettings) {
            try {
                this.identificationParameters = IdentificationParameters.getIdentificationParameters(this.identificationParametersFile);
                String error = SearchHandler.loadModifications(this.getIdentificationParameters().getSearchParameters());
                if (error != null) {
                    JOptionPane.showMessageDialog(this, error, "PTM Definition Changed", 2);
                }
                if (this.identificationParametersFactory.getParametersList().contains(this.identificationParameters.getName())) {
                    this.identificationParameters.setName(this.getIdentificationSettingsFileName());
                }
                this.identificationParametersFactory.addIdentificationParameters(this.identificationParameters);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Failed to import search parameters from: " + this.identificationParametersFile.getAbsolutePath() + ".", "Search Parameters", 2);
                e.printStackTrace();
                this.identificationParameters = null;
                this.identificationParametersFile = null;
            }
        }
        for (String tempParameters : this.identificationParametersFactory.getParametersList()) {
            parameterList.add(tempParameters);
        }
        this.settingsComboBox.setModel(new DefaultComboBoxModel(parameterList));
        if (this.identificationParameters != null) {
            this.settingsComboBox.setSelectedItem(this.identificationParameters.getName());
        }
        this.settingsComboBoxActionPerformed(null);
    }

    private String getIdentificationSettingsFileName() {
        String name = this.identificationParameters.getName();
        int counter = 2;
        String currentName = name;
        while (this.identificationParametersFactory.getParametersList().contains(currentName) && !this.identificationParametersFactory.getIdentificationParameters(currentName).equals(this.identificationParameters)) {
            currentName = name + MODIFICATION_USE_SEPARATOR + counter++;
        }
        return currentName;
    }

    private void initComponents() {
        this.modificationOptionsPopupMenu = new JPopupMenu();
        this.editModificationsMenuItem = new JMenuItem();
        this.reporterPostProcessPanel = new JPanel();
        this.editReporterSettingsLabel = new JLabel();
        this.reporterButton = new JButton();
        this.reporterCheckBox = new JCheckBox();
        this.reporterLabel = new JLabel();
        this.jMenuItem1 = new JMenuItem();
        this.taskEditorPanel = new JPanel();
        this.searchEnginesLocationPanel = new JPanel();
        this.searchEnginesScrollPane = new JScrollPane();
        this.searchEnginesPanel = new JPanel();
        this.omssaButton = new JButton();
        this.msgfSettingsButton = new JButton();
        this.enableTideJCheckBox = new JCheckBox();
        this.msAmandaSettingsButton = new JButton();
        this.myrimatchSupportButton = new JButton();
        this.myriMatchLinkLabel = new JLabel();
        this.andromedaLinkLabel = new JLabel();
        this.andromedaButton = new JButton();
        this.tideLinkLabel = new JLabel();
        this.xtandemSettingsButton = new JButton();
        this.tideButton = new JButton();
        this.msgfSupportButton = new JButton();
        this.enableCometJCheckBox = new JCheckBox();
        this.cometLinkLabel = new JLabel();
        this.enableMyriMatchJCheckBox = new JCheckBox();
        this.omssaSupportButton = new JButton();
        this.enableMsAmandaJCheckBox = new JCheckBox();
        this.xtandemLinkLabel = new JLabel();
        this.xtandemSupportButton = new JButton();
        this.myriMatchSettingsButton = new JButton();
        this.enableMsgfJCheckBox = new JCheckBox();
        this.xtandemButton = new JButton();
        this.msAmandaSupportButton = new JButton();
        this.omssaLinkLabel = new JLabel();
        this.myriMatchButton = new JButton();
        this.andromedaSupportButton = new JButton();
        this.msAmandaLinkLabel = new JLabel();
        this.enableXTandemJCheckBox = new JCheckBox();
        this.cometSettingsButton = new JButton();
        this.msAmandaButton = new JButton();
        this.andromedaSettingsButton = new JButton();
        this.omssaSettingsButton = new JButton();
        this.enableAndromedaJCheckBox = new JCheckBox();
        this.tideSettingsButton = new JButton();
        this.msgfLinkLabel = new JLabel();
        this.tideSupportButton = new JButton();
        this.cometSupportButton = new JButton();
        this.msgfButton = new JButton();
        this.enableOmssaJCheckBox = new JCheckBox();
        this.cometButton = new JButton();
        this.inputFilesPanel = new JPanel();
        this.spectraFilesLabel = new JLabel();
        this.clearSpectraButton = new JButton();
        this.addSpectraButton = new JButton();
        this.spectraFilesTxt = new JTextField();
        this.searchSettingsLbl = new JLabel();
        this.editSettingsButton = new JButton();
        this.addSettingsButton = new JButton();
        this.resultFolderLbl = new JLabel();
        this.outputFolderTxt = new JTextField();
        this.resultFolderBrowseButton = new JButton();
        this.settingsComboBox = new JComboBox();
        this.searchButton = new JButton();
        this.aboutButton = new JButton();
        this.searchGUIPublicationLabel = new JLabel();
        this.postProcessingPanel = new JPanel();
        this.peptideShakerCheckBox = new JCheckBox();
        this.peptideShakerLabel = new JLabel();
        this.peptideShakerButton = new JButton();
        this.peptideShakerSettingsButton = new JButton();
        this.peptideShakerSupportButton = new JButton();
        this.preProcessingPanel = new JPanel();
        this.msconvertCheckBox = new JCheckBox();
        this.msconvertLabel = new JLabel();
        this.msconvertButton = new JButton();
        this.msconvertSettingsButton = new JButton();
        this.msconvertSupportButton = new JButton();
        this.deNovoPanel = new JPanel();
        this.enableNovorJCheckBox = new JCheckBox();
        this.novorButton = new JButton();
        this.novorSupportButton = new JButton();
        this.novorLinkLabel = new JLabel();
        this.novorSettingsButton = new JButton();
        this.enableDirecTagJCheckBox = new JCheckBox();
        this.direcTagButton = new JButton();
        this.direcTagSupportButton = new JButton();
        this.direcTagLinkLabel = new JLabel();
        this.direcTagSettingsButton = new JButton();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.advancedSettingsMenuItem = new JMenuItem();
        this.processingMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.editModificationsEditMenuItem = new JMenuItem();
        this.editSearchEngineLocationsMenuItem = new JMenuItem();
        this.editIdSettingsFilesMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.javaSettingsJMenuItem = new JMenuItem();
        this.resourceSettingsMenuItem = new JMenuItem();
        this.privacyMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.helpMenuItem = new JMenuItem();
        this.jSeparator17 = new JPopupMenu.Separator();
        this.logReportMenu = new JMenuItem();
        this.jSeparator16 = new JPopupMenu.Separator();
        this.aboutMenuItem = new JMenuItem();
        this.editModificationsMenuItem.setText("Edit Modifications");
        this.editModificationsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.editModificationsMenuItemActionPerformed(evt);
            }
        });
        this.modificationOptionsPopupMenu.add(this.editModificationsMenuItem);
        this.editReporterSettingsLabel.setFont(this.editReporterSettingsLabel.getFont().deriveFont(this.editReporterSettingsLabel.getFont().getStyle() | 2));
        this.editReporterSettingsLabel.setText("<html><a href=\"\">Edit Settings</a></html>");
        this.editReporterSettingsLabel.setToolTipText("Edit Reporter settings");
        this.editReporterSettingsLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchGUI.this.editReporterSettingsLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.editReporterSettingsLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.editReporterSettingsLabelMouseExited(evt);
            }
        });
        this.reporterButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/reporter_logo.png")));
        this.reporterButton.setToolTipText("<html>\nOpen the Reporter web page<br>\n(under development...)\n</html>");
        this.reporterButton.setBorder(null);
        this.reporterButton.setBorderPainted(false);
        this.reporterButton.setContentAreaFilled(false);
        this.reporterButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.reporterButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.reporterButtonMouseExited(evt);
            }
        });
        this.reporterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.reporterButtonActionPerformed(evt);
            }
        });
        this.reporterCheckBox.setIconTextGap(15);
        this.reporterLabel.setText("<html>Reporter - <a href=\"http://compomics.github.io/projects/reporter.html\">Quantify the Reporter Ions in Reporter</a></html>");
        this.reporterLabel.setToolTipText("Open the Reporter web page");
        this.reporterLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchGUI.this.reporterLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.reporterLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.reporterLabelMouseExited(evt);
            }
        });
        GroupLayout reporterPostProcessPanelLayout = new GroupLayout(this.reporterPostProcessPanel);
        this.reporterPostProcessPanel.setLayout(reporterPostProcessPanelLayout);
        reporterPostProcessPanelLayout.setHorizontalGroup(reporterPostProcessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterPostProcessPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.reporterCheckBox).addGap(73, 73, 73).addComponent(this.reporterButton, -2, 84, -2).addGap(62, 62, 62).addComponent(this.reporterLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 109, Short.MAX_VALUE).addComponent(this.editReporterSettingsLabel, -2, -1, -2).addContainerGap()));
        reporterPostProcessPanelLayout.setVerticalGroup(reporterPostProcessPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterPostProcessPanelLayout.createSequentialGroup().addContainerGap().addGroup(reporterPostProcessPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.reporterCheckBox).addComponent(this.reporterButton, -2, 48, -2).addComponent(this.reporterLabel, -2, -1, -2).addComponent(this.editReporterSettingsLabel, -2, -1, -2)).addContainerGap()));
        this.jMenuItem1.setText("jMenuItem1");
        this.setDefaultCloseOperation(3);
        this.setTitle("SearchGUI");
        this.setMinimumSize(new Dimension(775, 600));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SearchGUI.this.formWindowClosing(evt);
            }
        });
        this.taskEditorPanel.setBackground(new Color(230, 230, 230));
        this.searchEnginesLocationPanel.setBorder(BorderFactory.createTitledBorder("Search Engines"));
        this.searchEnginesLocationPanel.setOpaque(false);
        this.searchEnginesScrollPane.setBorder(null);
        this.searchEnginesPanel.setBackground(new Color(230, 230, 230));
        this.omssaButton.setFont(new Font("Segoe UI", 1, 15));
        this.omssaButton.setText("OMSSA");
        this.omssaButton.setToolTipText("Enable OMSSA");
        this.omssaButton.setBorder(null);
        this.omssaButton.setBorderPainted(false);
        this.omssaButton.setContentAreaFilled(false);
        this.omssaButton.setEnabled(false);
        this.omssaButton.setHorizontalAlignment(2);
        this.omssaButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.omssaButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.omssaButtonMouseExited(evt);
            }
        });
        this.omssaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.omssaButtonActionPerformed(evt);
            }
        });
        this.msgfSettingsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.msgfSettingsButton.setToolTipText("Edit MS-GF+ Advanced Settings");
        this.msgfSettingsButton.setBorder(null);
        this.msgfSettingsButton.setBorderPainted(false);
        this.msgfSettingsButton.setContentAreaFilled(false);
        this.msgfSettingsButton.setEnabled(false);
        this.msgfSettingsButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.msgfSettingsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.msgfSettingsButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.msgfSettingsButtonMouseExited(evt);
            }
        });
        this.msgfSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.msgfSettingsButtonActionPerformed(evt);
            }
        });
        this.enableTideJCheckBox.setToolTipText("Enable Tide");
        this.enableTideJCheckBox.setEnabled(false);
        this.enableTideJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.enableTideJCheckBoxActionPerformed(evt);
            }
        });
        this.msAmandaSettingsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.msAmandaSettingsButton.setToolTipText("Edit MS Amanda Advanced Settings");
        this.msAmandaSettingsButton.setBorder(null);
        this.msAmandaSettingsButton.setBorderPainted(false);
        this.msAmandaSettingsButton.setContentAreaFilled(false);
        this.msAmandaSettingsButton.setEnabled(false);
        this.msAmandaSettingsButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.msAmandaSettingsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.msAmandaSettingsButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.msAmandaSettingsButtonMouseExited(evt);
            }
        });
        this.msAmandaSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.msAmandaSettingsButtonActionPerformed(evt);
            }
        });
        this.myrimatchSupportButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/windows_and_linux_gray.png")));
        this.myrimatchSupportButton.setToolTipText("Supported on Windows and Linux");
        this.myrimatchSupportButton.setBorderPainted(false);
        this.myrimatchSupportButton.setContentAreaFilled(false);
        this.myriMatchLinkLabel.setText("<html>MyriMatch Search Algorithm - <a href=\"http://htmlpreview.github.io/?https://github.com/ProteoWizard/pwiz/blob/master/pwiz_tools/Bumbershoot/myrimatch/doc/index.html\">MyriMatch web page</a></html> ");
        this.myriMatchLinkLabel.setToolTipText("Open the MyriMatch web page");
        this.myriMatchLinkLabel.setEnabled(false);
        this.myriMatchLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.myriMatchLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.myriMatchLinkLabelMouseExited(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                SearchGUI.this.myriMatchLinkLabelMouseReleased(evt);
            }
        });
        this.andromedaLinkLabel.setText("<html>Andromeda Search Algorithm - <a href=\"http://coxdocs.org/doku.php?id=maxquant:andromeda:start\">Andromeda web page</a></html> ");
        this.andromedaLinkLabel.setToolTipText("Open the Andromeda web page");
        this.andromedaLinkLabel.setEnabled(false);
        this.andromedaLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchGUI.this.andromedaLinkLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.andromedaLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.andromedaLinkLabelMouseExited(evt);
            }
        });
        this.andromedaButton.setFont(new Font("Segoe UI", 1, 15));
        this.andromedaButton.setText("Andromeda");
        this.andromedaButton.setToolTipText("Enable Andromeda");
        this.andromedaButton.setBorder(null);
        this.andromedaButton.setBorderPainted(false);
        this.andromedaButton.setContentAreaFilled(false);
        this.andromedaButton.setEnabled(false);
        this.andromedaButton.setHorizontalAlignment(2);
        this.andromedaButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.andromedaButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.andromedaButtonMouseExited(evt);
            }
        });
        this.andromedaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.andromedaButtonActionPerformed(evt);
            }
        });
        this.tideLinkLabel.setText("<html>Tide Search Algorithm - <a href=http://cruxtoolkit.sourceforge.net\">Tide web page</a></html> ");
        this.tideLinkLabel.setToolTipText("Open the Tide web page");
        this.tideLinkLabel.setEnabled(false);
        this.tideLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchGUI.this.tideLinkLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.tideLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.tideLinkLabelMouseExited(evt);
            }
        });
        this.xtandemSettingsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.xtandemSettingsButton.setToolTipText("Edit X!Tandem Advanced Settings");
        this.xtandemSettingsButton.setBorder(null);
        this.xtandemSettingsButton.setBorderPainted(false);
        this.xtandemSettingsButton.setContentAreaFilled(false);
        this.xtandemSettingsButton.setEnabled(false);
        this.xtandemSettingsButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.xtandemSettingsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.xtandemSettingsButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.xtandemSettingsButtonMouseExited(evt);
            }
        });
        this.xtandemSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.xtandemSettingsButtonActionPerformed(evt);
            }
        });
        this.tideButton.setFont(new Font("Segoe UI", 1, 15));
        this.tideButton.setText("Tide");
        this.tideButton.setToolTipText("Enable Tide");
        this.tideButton.setBorder(null);
        this.tideButton.setBorderPainted(false);
        this.tideButton.setContentAreaFilled(false);
        this.tideButton.setEnabled(false);
        this.tideButton.setHorizontalAlignment(2);
        this.tideButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.tideButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.tideButtonMouseExited(evt);
            }
        });
        this.tideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.tideButtonActionPerformed(evt);
            }
        });
        this.msgfSupportButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/all_platforms_gray.png")));
        this.msgfSupportButton.setToolTipText("Supported on Windows, Mac and Linux");
        this.msgfSupportButton.setBorderPainted(false);
        this.msgfSupportButton.setContentAreaFilled(false);
        this.enableCometJCheckBox.setToolTipText("Enable Comet");
        this.enableCometJCheckBox.setEnabled(false);
        this.enableCometJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.enableCometJCheckBoxActionPerformed(evt);
            }
        });
        this.cometLinkLabel.setText("<html>Comet Search Algorithm - <a href=http://comet-ms.sourceforge.net\">Comet web page</a></html> ");
        this.cometLinkLabel.setToolTipText("Open the Comet web page");
        this.cometLinkLabel.setEnabled(false);
        this.cometLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchGUI.this.cometLinkLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.cometLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.cometLinkLabelMouseExited(evt);
            }
        });
        this.enableMyriMatchJCheckBox.setToolTipText("Enable MyriMatch");
        this.enableMyriMatchJCheckBox.setEnabled(false);
        this.enableMyriMatchJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.enableMyriMatchJCheckBoxActionPerformed(evt);
            }
        });
        this.omssaSupportButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/all_platforms_gray.png")));
        this.omssaSupportButton.setToolTipText("Supported on Windows, Mac and Linux");
        this.omssaSupportButton.setBorderPainted(false);
        this.omssaSupportButton.setContentAreaFilled(false);
        this.enableMsAmandaJCheckBox.setToolTipText("Enable MS Amanda");
        this.enableMsAmandaJCheckBox.setEnabled(false);
        this.enableMsAmandaJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.enableMsAmandaJCheckBoxActionPerformed(evt);
            }
        });
        this.xtandemLinkLabel.setText("<html>X!Tandem Search Algorithm - <a href=\"http://www.thegpm.org/tandem\">X!Tandem web page</a></html>\n");
        this.xtandemLinkLabel.setToolTipText("Open the X!Tandem web page");
        this.xtandemLinkLabel.setEnabled(false);
        this.xtandemLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchGUI.this.xtandemLinkLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.xtandemLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.xtandemLinkLabelMouseExited(evt);
            }
        });
        this.xtandemSupportButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/all_platforms_gray.png")));
        this.xtandemSupportButton.setToolTipText("Supported on Windows, Mac and Linux");
        this.xtandemSupportButton.setBorderPainted(false);
        this.xtandemSupportButton.setContentAreaFilled(false);
        this.myriMatchSettingsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.myriMatchSettingsButton.setToolTipText("Edit MyriMatch Advanced Settings");
        this.myriMatchSettingsButton.setBorder(null);
        this.myriMatchSettingsButton.setBorderPainted(false);
        this.myriMatchSettingsButton.setContentAreaFilled(false);
        this.myriMatchSettingsButton.setEnabled(false);
        this.myriMatchSettingsButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.myriMatchSettingsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.myriMatchSettingsButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.myriMatchSettingsButtonMouseExited(evt);
            }
        });
        this.myriMatchSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.myriMatchSettingsButtonActionPerformed(evt);
            }
        });
        this.enableMsgfJCheckBox.setToolTipText("Enable MS-GF+");
        this.enableMsgfJCheckBox.setEnabled(false);
        this.enableMsgfJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.enableMsgfJCheckBoxActionPerformed(evt);
            }
        });
        this.xtandemButton.setFont(new Font("Segoe UI", 1, 15));
        this.xtandemButton.setText("X! Tandem");
        this.xtandemButton.setToolTipText("Enable X!Tandem");
        this.xtandemButton.setBorder(null);
        this.xtandemButton.setBorderPainted(false);
        this.xtandemButton.setContentAreaFilled(false);
        this.xtandemButton.setEnabled(false);
        this.xtandemButton.setHorizontalAlignment(2);
        this.xtandemButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.xtandemButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.xtandemButtonMouseExited(evt);
            }
        });
        this.xtandemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.xtandemButtonActionPerformed(evt);
            }
        });
        this.msAmandaSupportButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/all_platforms_gray.png")));
        this.msAmandaSupportButton.setToolTipText("Supported on Windows, Mac and Linux");
        this.msAmandaSupportButton.setBorderPainted(false);
        this.msAmandaSupportButton.setContentAreaFilled(false);
        this.omssaLinkLabel.setText("<html>OMSSA Search Algorithm - <a href=\"http://www.ncbi.nlm.nih.gov/pubmed/15473683\">OMSSA web page</a></html> ");
        this.omssaLinkLabel.setToolTipText("Open the OMSSA web page");
        this.omssaLinkLabel.setEnabled(false);
        this.omssaLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchGUI.this.omssaLinkLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.omssaLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.omssaLinkLabelMouseExited(evt);
            }
        });
        this.myriMatchButton.setFont(new Font("Segoe UI", 1, 15));
        this.myriMatchButton.setText("MyriMatch");
        this.myriMatchButton.setToolTipText("Enable MyriMatch");
        this.myriMatchButton.setBorder(null);
        this.myriMatchButton.setBorderPainted(false);
        this.myriMatchButton.setContentAreaFilled(false);
        this.myriMatchButton.setEnabled(false);
        this.myriMatchButton.setHorizontalAlignment(2);
        this.myriMatchButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.myriMatchButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.myriMatchButtonMouseExited(evt);
            }
        });
        this.myriMatchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.myriMatchButtonActionPerformed(evt);
            }
        });
        this.andromedaSupportButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/windows_only_gray.png")));
        this.andromedaSupportButton.setToolTipText("Supported on Windows");
        this.andromedaSupportButton.setBorderPainted(false);
        this.andromedaSupportButton.setContentAreaFilled(false);
        this.msAmandaLinkLabel.setText("<html>MS Amanda Search Algorithm - <a href=\"http://ms.imp.ac.at/?goto=msamanda\">MS Amanda web page</a></html> ");
        this.msAmandaLinkLabel.setToolTipText("Open the MS Amanda web page");
        this.msAmandaLinkLabel.setEnabled(false);
        this.msAmandaLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchGUI.this.msAmandaLinkLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.msAmandaLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.msAmandaLinkLabelMouseExited(evt);
            }
        });
        this.enableXTandemJCheckBox.setToolTipText("Enable X!Tandem");
        this.enableXTandemJCheckBox.setEnabled(false);
        this.enableXTandemJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.enableXTandemJCheckBoxActionPerformed(evt);
            }
        });
        this.cometSettingsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.cometSettingsButton.setToolTipText("Edit Comet Advanced Settings");
        this.cometSettingsButton.setBorder(null);
        this.cometSettingsButton.setBorderPainted(false);
        this.cometSettingsButton.setContentAreaFilled(false);
        this.cometSettingsButton.setEnabled(false);
        this.cometSettingsButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.cometSettingsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.cometSettingsButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.cometSettingsButtonMouseExited(evt);
            }
        });
        this.cometSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.cometSettingsButtonActionPerformed(evt);
            }
        });
        this.msAmandaButton.setFont(new Font("Segoe UI", 1, 15));
        this.msAmandaButton.setText("MS Amanda");
        this.msAmandaButton.setToolTipText("Enable MS Amanda");
        this.msAmandaButton.setBorder(null);
        this.msAmandaButton.setBorderPainted(false);
        this.msAmandaButton.setContentAreaFilled(false);
        this.msAmandaButton.setEnabled(false);
        this.msAmandaButton.setHorizontalAlignment(2);
        this.msAmandaButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.msAmandaButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.msAmandaButtonMouseExited(evt);
            }
        });
        this.msAmandaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.msAmandaButtonActionPerformed(evt);
            }
        });
        this.andromedaSettingsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.andromedaSettingsButton.setToolTipText("Edit Andromeda Advanced Settings");
        this.andromedaSettingsButton.setBorder(null);
        this.andromedaSettingsButton.setBorderPainted(false);
        this.andromedaSettingsButton.setContentAreaFilled(false);
        this.andromedaSettingsButton.setEnabled(false);
        this.andromedaSettingsButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.andromedaSettingsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.andromedaSettingsButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.andromedaSettingsButtonMouseExited(evt);
            }
        });
        this.andromedaSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.andromedaSettingsButtonActionPerformed(evt);
            }
        });
        this.omssaSettingsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.omssaSettingsButton.setToolTipText("Edit OMSSA Advanced Settings");
        this.omssaSettingsButton.setBorder(null);
        this.omssaSettingsButton.setBorderPainted(false);
        this.omssaSettingsButton.setContentAreaFilled(false);
        this.omssaSettingsButton.setEnabled(false);
        this.omssaSettingsButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.omssaSettingsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.omssaSettingsButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.omssaSettingsButtonMouseExited(evt);
            }
        });
        this.omssaSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.omssaSettingsButtonActionPerformed(evt);
            }
        });
        this.enableAndromedaJCheckBox.setToolTipText("Enable Andromeda");
        this.enableAndromedaJCheckBox.setEnabled(false);
        this.enableAndromedaJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.enableAndromedaJCheckBoxActionPerformed(evt);
            }
        });
        this.tideSettingsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.tideSettingsButton.setToolTipText("Edit Tide Advanced Settings");
        this.tideSettingsButton.setBorder(null);
        this.tideSettingsButton.setBorderPainted(false);
        this.tideSettingsButton.setContentAreaFilled(false);
        this.tideSettingsButton.setEnabled(false);
        this.tideSettingsButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.tideSettingsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.tideSettingsButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.tideSettingsButtonMouseExited(evt);
            }
        });
        this.tideSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.tideSettingsButtonActionPerformed(evt);
            }
        });
        this.msgfLinkLabel.setText("<html>MS-GF+ Search Algorithm - <a href=\"http://proteomics.ucsd.edu/Software/MSGFPlus\">MS-GF+ web page</a></html> ");
        this.msgfLinkLabel.setToolTipText("Open the MS-GF+ web page");
        this.msgfLinkLabel.setEnabled(false);
        this.msgfLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchGUI.this.msgfLinkLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.msgfLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.msgfLinkLabelMouseExited(evt);
            }
        });
        this.tideSupportButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/all_platforms_gray.png")));
        this.tideSupportButton.setToolTipText("Supported on Windows, Mac and Linux");
        this.tideSupportButton.setBorderPainted(false);
        this.tideSupportButton.setContentAreaFilled(false);
        this.cometSupportButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/windows_and_linux_gray.png")));
        this.cometSupportButton.setToolTipText("Supported on Windows and Linux");
        this.cometSupportButton.setBorderPainted(false);
        this.cometSupportButton.setContentAreaFilled(false);
        this.msgfButton.setFont(new Font("Segoe UI", 1, 15));
        this.msgfButton.setText("MS-GF+");
        this.msgfButton.setToolTipText("Enable MS-GF+");
        this.msgfButton.setBorder(null);
        this.msgfButton.setBorderPainted(false);
        this.msgfButton.setContentAreaFilled(false);
        this.msgfButton.setEnabled(false);
        this.msgfButton.setHorizontalAlignment(2);
        this.msgfButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.msgfButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.msgfButtonMouseExited(evt);
            }
        });
        this.msgfButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.msgfButtonActionPerformed(evt);
            }
        });
        this.enableOmssaJCheckBox.setToolTipText("Enable OMSSA");
        this.enableOmssaJCheckBox.setEnabled(false);
        this.enableOmssaJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.enableOmssaJCheckBoxActionPerformed(evt);
            }
        });
        this.cometButton.setFont(new Font("Segoe UI", 1, 15));
        this.cometButton.setText("Comet");
        this.cometButton.setToolTipText("Enable Comet");
        this.cometButton.setBorder(null);
        this.cometButton.setBorderPainted(false);
        this.cometButton.setContentAreaFilled(false);
        this.cometButton.setEnabled(false);
        this.cometButton.setHorizontalAlignment(2);
        this.cometButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.cometButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.cometButtonMouseExited(evt);
            }
        });
        this.cometButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.cometButtonActionPerformed(evt);
            }
        });
        GroupLayout searchEnginesPanelLayout = new GroupLayout(this.searchEnginesPanel);
        this.searchEnginesPanel.setLayout(searchEnginesPanelLayout);
        searchEnginesPanelLayout.setHorizontalGroup(searchEnginesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchEnginesPanelLayout.createSequentialGroup().addGap(14, 14, 14).addGroup(searchEnginesPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.enableXTandemJCheckBox).addComponent(this.enableMyriMatchJCheckBox).addComponent(this.enableMsAmandaJCheckBox).addComponent(this.enableMsgfJCheckBox).addComponent(this.enableOmssaJCheckBox).addComponent(this.enableCometJCheckBox).addComponent(this.enableTideJCheckBox).addComponent(this.enableAndromedaJCheckBox)).addGap(61, 61, 61).addGroup(searchEnginesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.xtandemButton, -2, 140, -2).addComponent(this.myriMatchButton, -2, 140, -2).addComponent(this.msAmandaButton, -2, 140, -2).addComponent(this.msgfButton, -2, 140, -2).addComponent(this.omssaButton, -2, 140, -2).addComponent(this.cometButton, -2, 140, -2).addComponent(this.tideButton, -2, 140, -2).addComponent(this.andromedaButton, -2, 140, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(searchEnginesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tideSupportButton).addComponent(this.xtandemSupportButton).addComponent(this.myrimatchSupportButton).addComponent(this.msAmandaSupportButton).addComponent(this.msgfSupportButton).addComponent(this.cometSupportButton).addComponent(this.omssaSupportButton).addComponent(this.andromedaSupportButton)).addGap(34, 34, 34).addGroup(searchEnginesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.xtandemLinkLabel, -2, -1, -2).addComponent(this.msAmandaLinkLabel, -2, -1, -2).addComponent(this.myriMatchLinkLabel, -2, -1, -2).addComponent(this.msgfLinkLabel, -2, -1, -2).addComponent(this.omssaLinkLabel, -2, -1, -2).addComponent(this.cometLinkLabel, -2, -1, -2).addComponent(this.tideLinkLabel, -2, -1, -2).addComponent(this.andromedaLinkLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(searchEnginesPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.msAmandaSettingsButton, -2, 22, -2).addComponent(this.myriMatchSettingsButton, -2, 22, -2).addComponent(this.omssaSettingsButton, -2, 22, -2).addComponent(this.xtandemSettingsButton, -2, 25, -2).addComponent(this.msgfSettingsButton, -2, 25, -2).addComponent(this.cometSettingsButton, -2, 22, -2).addComponent(this.tideSettingsButton, -2, 22, -2).addComponent(this.andromedaSettingsButton)).addGap(10, 10, 10)));
        searchEnginesPanelLayout.linkSize(0, this.andromedaButton, this.cometButton, this.msAmandaButton, this.msgfButton, this.myriMatchButton, this.omssaButton, this.tideButton, this.xtandemButton);
        searchEnginesPanelLayout.linkSize(0, this.andromedaSettingsButton, this.cometSettingsButton, this.msAmandaSettingsButton, this.msgfSettingsButton, this.myriMatchSettingsButton, this.omssaSettingsButton, this.tideSettingsButton, this.xtandemSettingsButton);
        searchEnginesPanelLayout.setVerticalGroup(searchEnginesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchEnginesPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(searchEnginesPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.enableXTandemJCheckBox).addComponent(this.xtandemButton, -2, 25, -2).addComponent(this.xtandemSupportButton).addComponent(this.xtandemLinkLabel, -2, -1, -2).addComponent(this.xtandemSettingsButton, -2, 25, -2)).addGap(0, 0, 0).addGroup(searchEnginesPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.enableMyriMatchJCheckBox).addComponent(this.myriMatchButton, -2, 25, -2).addComponent(this.myrimatchSupportButton).addComponent(this.myriMatchLinkLabel, -2, -1, -2).addComponent(this.myriMatchSettingsButton, -2, 25, -2)).addGap(0, 0, 0).addGroup(searchEnginesPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.enableMsAmandaJCheckBox).addComponent(this.msAmandaButton, -2, 25, -2).addComponent(this.msAmandaLinkLabel, -2, -1, -2).addComponent(this.msAmandaSettingsButton, -2, 25, -2).addComponent(this.msAmandaSupportButton)).addGap(0, 0, 0).addGroup(searchEnginesPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.enableMsgfJCheckBox).addComponent(this.msgfButton, -2, 25, -2).addComponent(this.msgfLinkLabel, -2, -1, -2).addComponent(this.msgfSettingsButton, -2, 25, -2).addComponent(this.msgfSupportButton)).addGap(0, 0, 0).addGroup(searchEnginesPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.enableOmssaJCheckBox).addComponent(this.omssaButton, -2, 25, -2).addComponent(this.omssaLinkLabel, -2, -1, -2).addComponent(this.omssaSettingsButton, -2, 25, -2).addComponent(this.omssaSupportButton)).addGap(0, 0, 0).addGroup(searchEnginesPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.enableCometJCheckBox).addComponent(this.cometButton, -2, 25, -2).addComponent(this.cometLinkLabel, -2, -1, -2).addComponent(this.cometSettingsButton, -2, 25, -2).addComponent(this.cometSupportButton)).addGap(0, 0, 0).addGroup(searchEnginesPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.enableTideJCheckBox).addComponent(this.tideButton, -2, 25, -2).addComponent(this.tideLinkLabel, -2, -1, -2).addComponent(this.tideSettingsButton, -2, 25, -2).addComponent(this.tideSupportButton)).addGap(0, 0, 0).addGroup(searchEnginesPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.enableAndromedaJCheckBox).addComponent(this.andromedaButton, -2, 25, -2).addComponent(this.andromedaSupportButton).addComponent(this.andromedaLinkLabel, -2, -1, -2).addComponent(this.andromedaSettingsButton)).addGap(0, 0, 0)));
        searchEnginesPanelLayout.linkSize(1, this.andromedaButton, this.cometButton, this.msAmandaButton, this.msgfButton, this.myriMatchButton, this.omssaButton, this.tideButton, this.xtandemButton);
        searchEnginesPanelLayout.linkSize(1, this.andromedaSettingsButton, this.cometSettingsButton, this.msAmandaSettingsButton, this.msgfSettingsButton, this.myriMatchSettingsButton, this.omssaSettingsButton, this.tideSettingsButton, this.xtandemSettingsButton);
        this.searchEnginesScrollPane.setViewportView(this.searchEnginesPanel);
        GroupLayout searchEnginesLocationPanelLayout = new GroupLayout(this.searchEnginesLocationPanel);
        this.searchEnginesLocationPanel.setLayout(searchEnginesLocationPanelLayout);
        searchEnginesLocationPanelLayout.setHorizontalGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchEnginesLocationPanelLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.searchEnginesScrollPane, -1, 875, Short.MAX_VALUE).addGap(25, 25, 25)));
        searchEnginesLocationPanelLayout.setVerticalGroup(searchEnginesLocationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(searchEnginesLocationPanelLayout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.searchEnginesScrollPane)));
        this.inputFilesPanel.setBorder(BorderFactory.createTitledBorder("Input & Output"));
        this.inputFilesPanel.setOpaque(false);
        this.spectraFilesLabel.setForeground(new Color(255, 0, 0));
        this.spectraFilesLabel.setText("Spectrum File(s)");
        this.clearSpectraButton.setText("Clear");
        this.clearSpectraButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.clearSpectraButtonActionPerformed(evt);
            }
        });
        this.addSpectraButton.setText("Add");
        this.addSpectraButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.addSpectraButtonActionPerformed(evt);
            }
        });
        this.spectraFilesTxt.setEditable(false);
        this.spectraFilesTxt.setHorizontalAlignment(0);
        this.spectraFilesTxt.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchGUI.this.spectraFilesTxtMouseClicked(evt);
            }
        });
        this.searchSettingsLbl.setForeground(new Color(255, 0, 0));
        this.searchSettingsLbl.setText("Search Settings");
        this.editSettingsButton.setText("Edit");
        this.editSettingsButton.setEnabled(false);
        this.editSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.editSettingsButtonActionPerformed(evt);
            }
        });
        this.addSettingsButton.setText("Add");
        this.addSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.addSettingsButtonActionPerformed(evt);
            }
        });
        this.resultFolderLbl.setForeground(new Color(255, 0, 0));
        this.resultFolderLbl.setText("Output Folder");
        this.outputFolderTxt.setEditable(false);
        this.outputFolderTxt.setHorizontalAlignment(0);
        this.resultFolderBrowseButton.setText("Browse");
        this.resultFolderBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.resultFolderBrowseButtonActionPerformed(evt);
            }
        });
        this.settingsComboBox.setMaximumRowCount(16);
        this.settingsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"-- Select --"}));
        this.settingsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.settingsComboBoxActionPerformed(evt);
            }
        });
        GroupLayout inputFilesPanelLayout = new GroupLayout(this.inputFilesPanel);
        this.inputFilesPanel.setLayout(inputFilesPanelLayout);
        inputFilesPanelLayout.setHorizontalGroup(inputFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputFilesPanelLayout.createSequentialGroup().addContainerGap().addGroup(inputFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputFilesPanelLayout.createSequentialGroup().addGroup(inputFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchSettingsLbl, -2, 100, -2).addComponent(this.resultFolderLbl, -2, 100, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(inputFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.settingsComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.outputFolderTxt))).addGroup(inputFilesPanelLayout.createSequentialGroup().addComponent(this.spectraFilesLabel, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spectraFilesTxt))).addGap(10, 10, 10).addGroup(inputFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputFilesPanelLayout.createSequentialGroup().addComponent(this.addSettingsButton, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editSettingsButton)).addGroup(GroupLayout.Alignment.TRAILING, inputFilesPanelLayout.createSequentialGroup().addComponent(this.addSpectraButton, -2, 51, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearSpectraButton, -1, 67, Short.MAX_VALUE))).addComponent(this.resultFolderBrowseButton)).addContainerGap()));
        inputFilesPanelLayout.linkSize(0, this.addSettingsButton, this.addSpectraButton, this.clearSpectraButton, this.editSettingsButton, this.resultFolderBrowseButton);
        inputFilesPanelLayout.linkSize(0, this.resultFolderLbl, this.searchSettingsLbl, this.spectraFilesLabel);
        inputFilesPanelLayout.setVerticalGroup(inputFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(inputFilesPanelLayout.createSequentialGroup().addGap(2, 2, 2).addGroup(inputFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.spectraFilesLabel).addComponent(this.spectraFilesTxt, -2, -1, -2).addComponent(this.clearSpectraButton).addComponent(this.addSpectraButton)).addGap(2, 2, 2).addGroup(inputFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.searchSettingsLbl).addComponent(this.addSettingsButton).addComponent(this.settingsComboBox, -2, -1, -2).addComponent(this.editSettingsButton)).addGap(2, 2, 2).addGroup(inputFilesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.resultFolderLbl).addComponent(this.resultFolderBrowseButton).addComponent(this.outputFolderTxt, -2, -1, -2)).addGap(2, 2, 2)));
        inputFilesPanelLayout.linkSize(1, this.addSettingsButton, this.addSpectraButton, this.clearSpectraButton, this.editSettingsButton, this.resultFolderBrowseButton);
        this.searchButton.setBackground(new Color(0, 153, 0));
        this.searchButton.setFont(this.searchButton.getFont().deriveFont(this.searchButton.getFont().getStyle() | 1));
        this.searchButton.setForeground(new Color(255, 255, 255));
        this.searchButton.setText("Start the Search!");
        this.searchButton.setToolTipText("Click here to start the search");
        this.searchButton.setEnabled(false);
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.searchButtonActionPerformed(evt);
            }
        });
        this.aboutButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/searchgui_shadow.png")));
        this.aboutButton.setToolTipText("Open the SearchGUI web page");
        this.aboutButton.setBorder(null);
        this.aboutButton.setBorderPainted(false);
        this.aboutButton.setContentAreaFilled(false);
        this.aboutButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.aboutButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.aboutButtonMouseExited(evt);
            }
        });
        this.aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.aboutButtonActionPerformed(evt);
            }
        });
        this.searchGUIPublicationLabel.setText("<html>Please cite SearchGUI as <a href=\"http://www.ncbi.nlm.nih.gov/pubmed/21337703\">Vaudel <i>et al.</i>: Proteomics 2011;11(5):996-9</a>.</html>");
        this.searchGUIPublicationLabel.setToolTipText("Open the SearchGUI publication");
        this.searchGUIPublicationLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchGUI.this.searchGUIPublicationLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.searchGUIPublicationLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.searchGUIPublicationLabelMouseExited(evt);
            }
        });
        this.postProcessingPanel.setBorder(BorderFactory.createTitledBorder("Post Processing"));
        this.postProcessingPanel.setOpaque(false);
        this.postProcessingPanel.setPreferredSize(new Dimension(785, 83));
        this.peptideShakerCheckBox.setToolTipText("Enable PeptideShaker");
        this.peptideShakerCheckBox.setEnabled(false);
        this.peptideShakerCheckBox.setIconTextGap(15);
        this.peptideShakerCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.peptideShakerCheckBoxActionPerformed(evt);
            }
        });
        this.peptideShakerLabel.setText("<html>PeptideShaker - <a href=\"http://compomics.github.io/projects/peptide-shaker.html\">Visualize the results in PeptideShaker</a></html>");
        this.peptideShakerLabel.setToolTipText("Open the PeptideShaker web page");
        this.peptideShakerLabel.setEnabled(false);
        this.peptideShakerLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchGUI.this.peptideShakerLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.peptideShakerLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.peptideShakerLabelMouseExited(evt);
            }
        });
        this.peptideShakerButton.setFont(new Font("Segoe UI", 1, 15));
        this.peptideShakerButton.setText("PeptideShaker");
        this.peptideShakerButton.setToolTipText("Enable PeptideShaker");
        this.peptideShakerButton.setBorder(null);
        this.peptideShakerButton.setBorderPainted(false);
        this.peptideShakerButton.setContentAreaFilled(false);
        this.peptideShakerButton.setEnabled(false);
        this.peptideShakerButton.setHorizontalAlignment(2);
        this.peptideShakerButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.peptideShakerButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.peptideShakerButtonMouseExited(evt);
            }
        });
        this.peptideShakerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.peptideShakerButtonActionPerformed(evt);
            }
        });
        this.peptideShakerSettingsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.peptideShakerSettingsButton.setToolTipText("Edit PeptideShaker Settings");
        this.peptideShakerSettingsButton.setBorder(null);
        this.peptideShakerSettingsButton.setBorderPainted(false);
        this.peptideShakerSettingsButton.setContentAreaFilled(false);
        this.peptideShakerSettingsButton.setEnabled(false);
        this.peptideShakerSettingsButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.peptideShakerSettingsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.peptideShakerSettingsButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.peptideShakerSettingsButtonMouseExited(evt);
            }
        });
        this.peptideShakerSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.peptideShakerSettingsButtonActionPerformed(evt);
            }
        });
        this.peptideShakerSupportButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/all_platforms_gray.png")));
        this.peptideShakerSupportButton.setToolTipText("Supported on Windows, Mac and Linux");
        this.peptideShakerSupportButton.setBorderPainted(false);
        this.peptideShakerSupportButton.setContentAreaFilled(false);
        GroupLayout postProcessingPanelLayout = new GroupLayout(this.postProcessingPanel);
        this.postProcessingPanel.setLayout(postProcessingPanelLayout);
        postProcessingPanelLayout.setHorizontalGroup(postProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(postProcessingPanelLayout.createSequentialGroup().addGap(35, 35, 35).addComponent(this.peptideShakerCheckBox).addGap(60, 60, 60).addComponent(this.peptideShakerButton, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideShakerSupportButton).addGap(34, 34, 34).addComponent(this.peptideShakerLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.peptideShakerSettingsButton).addGap(39, 39, 39)));
        postProcessingPanelLayout.setVerticalGroup(postProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(postProcessingPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(postProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.peptideShakerCheckBox).addComponent(this.peptideShakerButton, -2, 25, -2).addComponent(this.peptideShakerLabel, -2, -1, -2).addComponent(this.peptideShakerSettingsButton).addComponent(this.peptideShakerSupportButton)).addGap(0, 0, 0)));
        this.preProcessingPanel.setBorder(BorderFactory.createTitledBorder("Pre Processing"));
        this.preProcessingPanel.setOpaque(false);
        this.msconvertCheckBox.setToolTipText("Enable msconvert");
        this.msconvertCheckBox.setEnabled(false);
        this.msconvertCheckBox.setIconTextGap(15);
        this.msconvertCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.msconvertCheckBoxActionPerformed(evt);
            }
        });
        this.msconvertLabel.setText("<html>MSConvert File Conversion - <a href=\"http://proteowizard.sourceforge.net/downloads.shtml\">ProteoWizard web page</a></html>");
        this.msconvertLabel.setToolTipText("Open the ProteoWizard web page");
        this.msconvertLabel.setEnabled(false);
        this.msconvertLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchGUI.this.msconvertLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.msconvertLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.msconvertLabelMouseExited(evt);
            }
        });
        this.msconvertButton.setFont(new Font("Segoe UI", 1, 15));
        this.msconvertButton.setText("MSConvert");
        this.msconvertButton.setBorder(null);
        this.msconvertButton.setBorderPainted(false);
        this.msconvertButton.setContentAreaFilled(false);
        this.msconvertButton.setEnabled(false);
        this.msconvertButton.setHorizontalAlignment(2);
        this.msconvertSettingsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.msconvertSettingsButton.setToolTipText("Edit MSConvert Settings");
        this.msconvertSettingsButton.setBorder(null);
        this.msconvertSettingsButton.setBorderPainted(false);
        this.msconvertSettingsButton.setContentAreaFilled(false);
        this.msconvertSettingsButton.setEnabled(false);
        this.msconvertSettingsButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.msconvertSettingsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.msconvertSettingsButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.msconvertSettingsButtonMouseExited(evt);
            }
        });
        this.msconvertSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.msconvertSettingsButtonActionPerformed(evt);
            }
        });
        this.msconvertSupportButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/all_platforms_gray.png")));
        this.msconvertSupportButton.setToolTipText("<html>\nSupported on Windows, Mac and Linux<br>\nVendor raw file conversion requires Windows\n</html>");
        this.msconvertSupportButton.setBorderPainted(false);
        this.msconvertSupportButton.setContentAreaFilled(false);
        GroupLayout preProcessingPanelLayout = new GroupLayout(this.preProcessingPanel);
        this.preProcessingPanel.setLayout(preProcessingPanelLayout);
        preProcessingPanelLayout.setHorizontalGroup(preProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(preProcessingPanelLayout.createSequentialGroup().addGap(35, 35, 35).addComponent(this.msconvertCheckBox).addGap(60, 60, 60).addComponent(this.msconvertButton, -2, 140, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.msconvertSupportButton).addGap(34, 34, 34).addComponent(this.msconvertLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.msconvertSettingsButton).addGap(39, 39, 39)));
        preProcessingPanelLayout.setVerticalGroup(preProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(preProcessingPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(preProcessingPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.msconvertCheckBox).addComponent(this.msconvertButton, -2, 25, -2).addComponent(this.msconvertLabel, -2, -1, -2).addComponent(this.msconvertSettingsButton).addComponent(this.msconvertSupportButton)).addGap(0, 0, 0)));
        this.deNovoPanel.setBorder(BorderFactory.createTitledBorder("De Novo Algorithms"));
        this.deNovoPanel.setOpaque(false);
        this.enableNovorJCheckBox.setToolTipText("Enable Novor");
        this.enableNovorJCheckBox.setEnabled(false);
        this.enableNovorJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.enableNovorJCheckBoxActionPerformed(evt);
            }
        });
        this.novorButton.setFont(new Font("Segoe UI", 1, 15));
        this.novorButton.setText("Novor");
        this.novorButton.setToolTipText("Enable Novor");
        this.novorButton.setBorder(null);
        this.novorButton.setBorderPainted(false);
        this.novorButton.setContentAreaFilled(false);
        this.novorButton.setEnabled(false);
        this.novorButton.setHorizontalAlignment(2);
        this.novorButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.novorButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.novorButtonMouseExited(evt);
            }
        });
        this.novorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.novorButtonActionPerformed(evt);
            }
        });
        this.novorSupportButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/all_platforms_gray.png")));
        this.novorSupportButton.setToolTipText("Supported on Windows, Mac and Linux");
        this.novorSupportButton.setBorderPainted(false);
        this.novorSupportButton.setContentAreaFilled(false);
        this.novorLinkLabel.setText("<html>Novor De Novo Peptide Sequencing - <a href=\"http://rapidnovor.com\">Novor web page</a></html> ");
        this.novorLinkLabel.setToolTipText("Open the Novor web page");
        this.novorLinkLabel.setEnabled(false);
        this.novorLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchGUI.this.novorLinkLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.novorLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.novorLinkLabelMouseExited(evt);
            }
        });
        this.novorSettingsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.novorSettingsButton.setToolTipText("Edit Novor Advanced Settings");
        this.novorSettingsButton.setBorder(null);
        this.novorSettingsButton.setBorderPainted(false);
        this.novorSettingsButton.setContentAreaFilled(false);
        this.novorSettingsButton.setEnabled(false);
        this.novorSettingsButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.novorSettingsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.novorSettingsButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.novorSettingsButtonMouseExited(evt);
            }
        });
        this.novorSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.novorSettingsButtonActionPerformed(evt);
            }
        });
        this.enableDirecTagJCheckBox.setToolTipText("Enable DirecTag");
        this.enableDirecTagJCheckBox.setEnabled(false);
        this.enableDirecTagJCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.enableDirecTagJCheckBoxActionPerformed(evt);
            }
        });
        this.direcTagButton.setFont(new Font("Segoe UI", 1, 15));
        this.direcTagButton.setText("DirecTag");
        this.direcTagButton.setToolTipText("Enable DirecTag");
        this.direcTagButton.setBorder(null);
        this.direcTagButton.setBorderPainted(false);
        this.direcTagButton.setContentAreaFilled(false);
        this.direcTagButton.setEnabled(false);
        this.direcTagButton.setHorizontalAlignment(2);
        this.direcTagButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.direcTagButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.direcTagButtonMouseExited(evt);
            }
        });
        this.direcTagButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.direcTagButtonActionPerformed(evt);
            }
        });
        this.direcTagSupportButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/windows_and_linux_gray.png")));
        this.direcTagSupportButton.setToolTipText("Supported on Windows and Linux");
        this.direcTagSupportButton.setBorderPainted(false);
        this.direcTagSupportButton.setContentAreaFilled(false);
        this.direcTagLinkLabel.setText("<html>DirecTag MS/MS Sequence Tagging - <a href=\"http://fenchurch.mc.vanderbilt.edu/bumbershoot/directag/\">DirecTag web page</a></html> ");
        this.direcTagLinkLabel.setToolTipText("Open the DirecTag web page");
        this.direcTagLinkLabel.setEnabled(false);
        this.direcTagLinkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                SearchGUI.this.direcTagLinkLabelMouseClicked(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.direcTagLinkLabelMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.direcTagLinkLabelMouseExited(evt);
            }
        });
        this.direcTagSettingsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/edit_gray.png")));
        this.direcTagSettingsButton.setToolTipText("Edit DirecTag Advanced Settings");
        this.direcTagSettingsButton.setBorder(null);
        this.direcTagSettingsButton.setBorderPainted(false);
        this.direcTagSettingsButton.setContentAreaFilled(false);
        this.direcTagSettingsButton.setEnabled(false);
        this.direcTagSettingsButton.setRolloverIcon(new ImageIcon(this.getClass().getResource("/icons/edit.png")));
        this.direcTagSettingsButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                SearchGUI.this.direcTagSettingsButtonMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                SearchGUI.this.direcTagSettingsButtonMouseExited(evt);
            }
        });
        this.direcTagSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.direcTagSettingsButtonActionPerformed(evt);
            }
        });
        GroupLayout deNovoPanelLayout = new GroupLayout(this.deNovoPanel);
        this.deNovoPanel.setLayout(deNovoPanelLayout);
        deNovoPanelLayout.setHorizontalGroup(deNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(deNovoPanelLayout.createSequentialGroup().addGap(35, 35, 35).addGroup(deNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.enableNovorJCheckBox).addComponent(this.enableDirecTagJCheckBox)).addGap(60, 60, 60).addGroup(deNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.novorButton, -2, 140, -2).addComponent(this.direcTagButton, -2, 140, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(deNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.novorSupportButton).addComponent(this.direcTagSupportButton)).addGap(35, 35, 35).addGroup(deNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.direcTagLinkLabel, -2, -1, -2).addComponent(this.novorLinkLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(deNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.novorSettingsButton, -2, 22, -2).addComponent(this.direcTagSettingsButton, -2, 22, -2)).addGap(37, 37, 37)));
        deNovoPanelLayout.setVerticalGroup(deNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(deNovoPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(deNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.enableNovorJCheckBox).addComponent(this.novorButton, -2, 25, -2).addComponent(this.novorLinkLabel, -2, -1, -2).addComponent(this.novorSettingsButton, -2, 25, -2).addComponent(this.novorSupportButton)).addGap(0, 0, 0).addGroup(deNovoPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.enableDirecTagJCheckBox).addComponent(this.direcTagButton, -2, 25, -2).addComponent(this.direcTagLinkLabel, -2, -1, -2).addComponent(this.direcTagSettingsButton, -2, 25, -2).addComponent(this.direcTagSupportButton)).addGap(0, 0, 0)));
        GroupLayout taskEditorPanelLayout = new GroupLayout(this.taskEditorPanel);
        this.taskEditorPanel.setLayout(taskEditorPanelLayout);
        taskEditorPanelLayout.setHorizontalGroup(taskEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(taskEditorPanelLayout.createSequentialGroup().addContainerGap().addGroup(taskEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchEnginesLocationPanel, -1, -1, Short.MAX_VALUE).addComponent(this.postProcessingPanel, -1, 949, Short.MAX_VALUE).addComponent(this.inputFilesPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, taskEditorPanelLayout.createSequentialGroup().addComponent(this.aboutButton).addGap(46, 46, 46).addComponent(this.searchGUIPublicationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.searchButton, -2, 154, -2).addGap(12, 12, 12)).addComponent(this.preProcessingPanel, -1, -1, Short.MAX_VALUE).addComponent(this.deNovoPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        taskEditorPanelLayout.setVerticalGroup(taskEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(taskEditorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.inputFilesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.preProcessingPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchEnginesLocationPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deNovoPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.postProcessingPanel, -2, 73, -2).addGap(5, 5, 5).addGroup(taskEditorPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.aboutButton).addComponent(this.searchGUIPublicationLabel, -2, -1, -2).addComponent(this.searchButton, -2, 53, -2)).addGap(5, 5, 5)));
        taskEditorPanelLayout.linkSize(1, this.postProcessingPanel, this.preProcessingPanel);
        this.fileMenu.setText("File");
        this.exitMenuItem.setMnemonic('x');
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.advancedSettingsMenuItem.setMnemonic('A');
        this.advancedSettingsMenuItem.setText("Advanced Settings");
        this.advancedSettingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.advancedSettingsMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.advancedSettingsMenuItem);
        this.processingMenuItem.setMnemonic('R');
        this.processingMenuItem.setText("Processing Settings");
        this.processingMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.processingMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.processingMenuItem);
        this.editMenu.add(this.jSeparator1);
        this.editModificationsEditMenuItem.setMnemonic('M');
        this.editModificationsEditMenuItem.setText("Modifications");
        this.editModificationsEditMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.editModificationsEditMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.editModificationsEditMenuItem);
        this.editSearchEngineLocationsMenuItem.setMnemonic('S');
        this.editSearchEngineLocationsMenuItem.setText("Software Locations");
        this.editSearchEngineLocationsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.editSearchEngineLocationsMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.editSearchEngineLocationsMenuItem);
        this.editIdSettingsFilesMenuItem.setMnemonic('I');
        this.editIdSettingsFilesMenuItem.setText("Identification Settings");
        this.editIdSettingsFilesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.editIdSettingsFilesMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.editIdSettingsFilesMenuItem);
        this.editMenu.add(this.jSeparator2);
        this.javaSettingsJMenuItem.setMnemonic('J');
        this.javaSettingsJMenuItem.setText("Java Settings");
        this.javaSettingsJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.javaSettingsJMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.javaSettingsJMenuItem);
        this.resourceSettingsMenuItem.setMnemonic('E');
        this.resourceSettingsMenuItem.setText("Resource Settings");
        this.resourceSettingsMenuItem.setToolTipText("Set paths to resource folders");
        this.resourceSettingsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.resourceSettingsMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.resourceSettingsMenuItem);
        this.privacyMenuItem.setMnemonic('P');
        this.privacyMenuItem.setText("Privacy Settings");
        this.privacyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.privacyMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.privacyMenuItem);
        this.menuBar.add(this.editMenu);
        this.helpMenu.setText("Help");
        this.helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpMenuItem.setMnemonic('H');
        this.helpMenuItem.setText("Help");
        this.helpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.helpMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpMenuItem);
        this.helpMenu.add(this.jSeparator17);
        this.logReportMenu.setMnemonic('B');
        this.logReportMenu.setText("Bug Report");
        this.logReportMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.logReportMenuActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.logReportMenu);
        this.helpMenu.add(this.jSeparator16);
        this.aboutMenuItem.setMnemonic('A');
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchGUI.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.taskEditorPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.taskEditorPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void clearSpectraButtonActionPerformed(ActionEvent evt) {
        this.mgfFiles.clear();
        this.rawFiles.clear();
        this.enableMsConvertPanel();
        this.spectraFilesTxt.setText("");
        this.validateInput(false);
    }

    private void addSpectraButtonActionPerformed(ActionEvent evt) {
        File startLocation = new File(this.lastSelectedFolder.getLastSelectedFolder());
        if (this.mgfFiles.size() > 0) {
            File temp = this.mgfFiles.get(0);
            startLocation = temp.getParentFile();
        }
        JFileChooser fc = new JFileChooser(startLocation);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File myFile) {
                String lowercaseName = myFile.getName().toLowerCase();
                for (MsFormat tempFormat : MsFormat.values()) {
                    if (!lowercaseName.endsWith(tempFormat.fileNameEnding)) continue;
                    return true;
                }
                return myFile.isDirectory();
            }

            @Override
            public String getDescription() {
                String description = "MS Files (";
                for (MsFormat tempFormat : MsFormat.values()) {
                    if (tempFormat.index > 0) {
                        description = description + ", ";
                    }
                    description = description + tempFormat.fileNameEnding;
                }
                description = description + ")";
                return description;
            }
        };
        fc.setFileFilter(filter);
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(true);
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")), true);
            progressDialog.setPrimaryProgressCounterIndeterminate(true);
            progressDialog.setTitle("Validating File(s). Please Wait...");
            final SearchGUI finalRef = this;
            final JFileChooser finalJFileChooser = fc;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        progressDialog.setVisible(true);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }, "ProgressDialog").start();
            new Thread("ValidateMgfThread"){

                @Override
                public void run() {
                    SearchGUI.this.validSpectrumTitles = true;
                    ArrayList<File> tempMgfFiles = new ArrayList<File>();
                    ArrayList<File> tempRawFiles = new ArrayList<File>();
                    for (File newFile : finalJFileChooser.getSelectedFiles()) {
                        if (newFile.isDirectory()) {
                            File[] tempFiles;
                            for (File file : tempFiles = newFile.listFiles()) {
                                String lowercaseName = file.getName().toLowerCase();
                                if (lowercaseName.endsWith(MsFormat.mgf.fileNameEnding)) {
                                    tempMgfFiles.add(file);
                                    continue;
                                }
                                for (MsFormat tempFormat : MsFormat.values()) {
                                    if (!lowercaseName.endsWith(tempFormat.fileNameEnding)) continue;
                                    tempRawFiles.add(file);
                                }
                            }
                            SearchGUI.this.lastSelectedFolder.setLastSelectedFolder(newFile.getAbsolutePath());
                            continue;
                        }
                        String lowercaseName = newFile.getName().toLowerCase();
                        if (lowercaseName.endsWith(MsFormat.mgf.fileNameEnding)) {
                            tempMgfFiles.add(newFile);
                        } else {
                            for (MsFormat msFormat : MsFormat.values()) {
                                if (!lowercaseName.endsWith(msFormat.fileNameEnding)) continue;
                                tempRawFiles.add(newFile);
                            }
                        }
                        SearchGUI.this.lastSelectedFolder.setLastSelectedFolder(newFile.getParent());
                    }
                    for (File tempRawfile : tempRawFiles) {
                        if (tempRawfile.getName().endsWith(MsFormat.wiff.fileNameEnding)) {
                            String wiffScanFilePath = tempRawfile.getAbsolutePath() + ".scan";
                            if (!new File(wiffScanFilePath).exists()) {
                                JOptionPane.showMessageDialog(finalRef, "Could not find the related .wiff.scan file for " + tempRawfile.getName() + ".\nPlease put it in the same folder as the wiff file.", "Missing Scan File", 1);
                                continue;
                            }
                            SearchGUI.this.rawFiles.add(tempRawfile);
                            continue;
                        }
                        SearchGUI.this.rawFiles.add(tempRawfile);
                    }
                    int fileCounter = 0;
                    for (File mgfFile : tempMgfFiles) {
                        progressDialog.setTitle("Validating Spectrum Files. Please Wait... (" + ++fileCounter + "/" + tempMgfFiles.size() + ")");
                        SearchGUI.this.validSpectrumTitles = SearchGUI.this.validateMgfFile(mgfFile, progressDialog);
                        if (SearchGUI.this.validSpectrumTitles) {
                            SearchGUI.this.mgfFiles.add(mgfFile);
                            SearchGUI.this.lastSelectedFolder.setLastSelectedFolder(mgfFile.getAbsolutePath());
                        }
                        if (!progressDialog.isRunCanceled()) continue;
                        SearchGUI.this.mgfFiles.clear();
                        progressDialog.setRunFinished();
                        return;
                    }
                    if (!SearchGUI.this.validSpectrumTitles) {
                        SearchGUI.this.mgfFiles.clear();
                        progressDialog.setRunFinished();
                        return;
                    }
                    if (!SearchGUI.this.verifyMgfFilesNames()) {
                        SearchGUI.this.mgfFiles.clear();
                        SearchGUI.this.spectraFilesTxt.setText("");
                        SearchGUI.this.validateInput(false);
                        progressDialog.setRunFinished();
                        return;
                    }
                    progressDialog.setRunFinished();
                    if (SearchGUI.this.mgfFiles.isEmpty() && SearchGUI.this.rawFiles.isEmpty()) {
                        JOptionPane.showMessageDialog(finalRef, "The selection contained no valid spectrum files.", "No Spectrum Files", 1);
                        return;
                    }
                    SearchGUI.this.checkProteoWizard();
                    if (SearchGUI.this.utilitiesUserPreferences.checkMgfSize().booleanValue()) {
                        SearchGUI.this.verifyMgfFilesSize();
                    }
                    int nFiles = SearchGUI.this.mgfFiles.size() + SearchGUI.this.rawFiles.size();
                    SearchGUI.this.spectraFilesTxt.setText(nFiles + " file(s) selected");
                    SearchGUI.this.msconvertCheckBox.setSelected(!SearchGUI.this.rawFiles.isEmpty());
                    SearchGUI.this.enableMsConvertPanel();
                    SearchGUI.this.validateInput(false);
                }
            }.start();
        }
    }

    private void resultFolderBrowseButtonActionPerformed(ActionEvent evt) {
        File startLocation = new File(this.lastSelectedFolder.getLastSelectedFolder());
        if (this.outputFolderTxt.getText() != null && new File(this.outputFolderTxt.getText()).exists()) {
            File temp = new File(this.outputFolderTxt.getText());
            startLocation = temp.isDirectory() ? temp : temp.getParentFile();
        }
        JFileChooser fc = new JFileChooser(startLocation);
        fc.setFileSelectionMode(1);
        fc.setMultiSelectionEnabled(false);
        int result = fc.showOpenDialog(this);
        if (result == 0) {
            File tempDir = fc.getSelectedFile();
            if (!tempDir.exists()) {
                int value = JOptionPane.showConfirmDialog(this, "The folder '" + tempDir.getAbsolutePath() + "' does not exist.\nDo you want to create it?", "Create Folder?", 0);
                if (value == 1) {
                    return;
                }
                boolean success = tempDir.mkdir();
                if (!success) {
                    JOptionPane.showMessageDialog(this, "Failed to create the folder. Please create it manually and then select it.", "File Error", 1);
                    return;
                }
            }
            this.outputFolder = fc.getSelectedFile();
            this.outputFolderTxt.setText(this.outputFolder.getAbsolutePath());
            if (this.outputFolderTxt.getText().length() > 70) {
                this.outputFolderTxt.setHorizontalAlignment(10);
            } else {
                this.outputFolderTxt.setHorizontalAlignment(0);
            }
            this.searchHandler.setPeptideShakerFile(new File(this.outputFolder, "PeptideShaker_output.cpsx"));
            this.lastSelectedFolder.setLastSelectedFolder(this.outputFolder.getAbsolutePath());
            this.validateInput(false);
        }
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        int outcome;
        ArrayList<File> spectrumFiles;
        boolean fileFound;
        block40: {
            SearchGuiOutputOption outputOption;
            block41: {
                Object outputFile;
                block39: {
                    if (!this.validateSearchEngines(true)) {
                        return;
                    }
                    if (!this.rawFiles.isEmpty() && this.msConvertParameters.getMsFormat() != MsFormat.mgf) {
                        JOptionPane.showMessageDialog(this, "Mgf is the only spectrum format compatible with SearchGUI.\n\nPlease change the output format for msconvert.", "Output Format Error", 2);
                        return;
                    }
                    SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
                    if (this.enableXTandemJCheckBox.isSelected()) {
                        for (File file : this.mgfFiles) {
                            if (!file.getAbsolutePath().contains("&")) continue;
                            JOptionPane.showMessageDialog(this, "Spectrum files with '&' in the file path (" + file.getAbsolutePath() + ")\nare not allowed in X!Tandem. Please rename of remove the file.", "Spectrum File Error", 2);
                            return;
                        }
                        for (File file : this.rawFiles) {
                            if (!file.getAbsolutePath().contains("&")) continue;
                            JOptionPane.showMessageDialog(this, "Spectrum files with '&' in the file path (" + file.getAbsolutePath() + ")\nare not allowed in X!Tandem. Please rename of remove the file.", "Spectrum File Error", 2);
                            return;
                        }
                        if (this.outputFolder.getAbsolutePath().contains("&")) {
                            JOptionPane.showMessageDialog(this, "Output folders with '&' in the file path (" + this.outputFolder.getAbsolutePath() + ")\nare not allowed in X!Tandem. Please rename of replace the folder.", "Output Folder Error", 2);
                            return;
                        }
                        if (searchParameters.getFastaFile().getAbsolutePath().contains("&")) {
                            JOptionPane.showMessageDialog(this, "Database files with '&' in the file path (" + searchParameters.getFastaFile().getAbsolutePath() + ")\nare not allowed in X!Tandem. Please rename of replace the database.", "Database File Error", 2);
                            return;
                        }
                    }
                    if (this.enableMsAmandaJCheckBox.isSelected() && Util.removeExtension(searchParameters.getFastaFile().getName()).length() > 80) {
                        JOptionPane.showMessageDialog(this, "Database files names longer than 80 characters are not allowed in MS Amanda.\nPlease rename of replace the database.", "Database File Error", 2);
                        return;
                    }
                    if (this.enableOmssaJCheckBox.isSelected() && searchParameters.getPtmSettings().getAllModifications().size() > 30) {
                        JOptionPane.showMessageDialog(this, "OMSSA cannot be operated with >30 modifications.", "Unsupported parameters", 2);
                        return;
                    }
                    if (this.enableAndromedaJCheckBox.isSelected()) {
                        try {
                            FastaIndex fastaIndex = SequenceFactory.getFastaIndex(searchParameters.getFastaFile(), false, null);
                            AndromedaProcessBuilder.getDatabaseTypeAndromedaAccessionParsingRule(fastaIndex.getMainDatabaseType());
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(this, "Database format not supported by Andromeda.", "Unsupported Fasta", 2);
                            return;
                        }
                    }
                    if (this.enableNovorJCheckBox.isSelected() && searchParameters.getPtmSettings().getFixedModifications().size() + searchParameters.getPtmSettings().getVariableModifications().size() > 10) {
                        JOptionPane.showMessageDialog(this, "Maximum ten modifications are allowed when running Novor.\nPlease remove some of the modifications or disable Novor.", "Settings Error", 2);
                        return;
                    }
                    if (this.enableDirecTagJCheckBox.isSelected()) {
                        int n;
                        boolean terminalPtmsSelected = false;
                        for (String tempPtm : searchParameters.getPtmSettings().getAllModifications()) {
                            PTM currentPtm = this.ptmFactory.getPTM(tempPtm);
                            if (!currentPtm.isCTerm() && !currentPtm.isNTerm()) continue;
                            terminalPtmsSelected = true;
                        }
                        if (terminalPtmsSelected && (n = JOptionPane.showConfirmDialog(this, "Terminal modifications are not supported for DirecTag and will be ignored.\nDo you still want to continue?", "Settings Error", 0, 2)) == 1) {
                            return;
                        }
                    }
                    OmssaParameters omssaParameters = (OmssaParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.omssa.getIndex());
                    MyriMatchParameters myriMatchParameters = (MyriMatchParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.myriMatch.getIndex());
                    TideParameters tideParameters = (TideParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.tide.getIndex());
                    CometParameters cometParameters = (CometParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.comet.getIndex());
                    if (this.peptideShakerCheckBox.isSelected() && this.enableOmssaJCheckBox.isSelected() && !omssaParameters.getSelectedOutput().equals("OMX")) {
                        JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane("The selected OMSSA output format is not compatible with <a href=\"http://compomics.github.io/projects/peptide-shaker.html\">PeptideShaker</a>. Please change to the<br>OMSSA OMX format in the Advanced Settings, or disable OMSSA or <a href=\"http://compomics.github.io/projects/peptide-shaker.html\">PeptideShaker</a>."), "Format Warning", 2);
                        return;
                    }
                    if (this.peptideShakerCheckBox.isSelected() && this.enableMyriMatchJCheckBox.isSelected() && myriMatchParameters.getOutputFormat().equals("pepXML")) {
                        JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane("The selected MyriMatch output format is not compatible with <a href=\"http://compomics.github.io/projects/peptide-shaker.html\">PeptideShaker</a>. Please change to<br>mzIdentML in the Advanced Settings, or disable MyriMatch or <a href=\"http://compomics.github.io/projects/peptide-shaker.html\">PeptideShaker</a>."), "Format Warning", 2);
                        return;
                    }
                    if (this.peptideShakerCheckBox.isSelected() && this.enableTideJCheckBox.isSelected() && !tideParameters.getTextOutput().booleanValue()) {
                        JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane("The selected Tide output format is not compatible with <a href=\"http://compomics.github.io/projects/peptide-shaker.html\">PeptideShaker</a>. Please change to<br>Tide text output in the Advanced Settings, or disable Tide or <a href=\"http://compomics.github.io/projects/peptide-shaker.html\">PeptideShaker</a>."), "Format Warning", 2);
                        return;
                    }
                    if (this.peptideShakerCheckBox.isSelected() && this.enableCometJCheckBox.isSelected() && cometParameters.getSelectedOutputFormat() != CometParameters.CometOutputFormat.PepXML) {
                        JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane("The selected Comet output format is not compatible with <a href=\"http://compomics.github.io/projects/peptide-shaker.html\">PeptideShaker</a>. Please change to<br>Comet PepXML output in the Advanced Settings, or disable Comet or <a href=\"http://compomics.github.io/projects/peptide-shaker.html\">PeptideShaker</a>."), "Format Warning", 2);
                        return;
                    }
                    fileFound = false;
                    spectrumFiles = new ArrayList<File>(this.mgfFiles);
                    spectrumFiles.addAll(this.rawFiles);
                    for (File spectrumFile : spectrumFiles) {
                        File andromedaOutputFile;
                        File tideOutputFile;
                        File cometOutputFile;
                        File myriMatchOutputFile;
                        File msAmandaOutputFile;
                        File msgfOutputFile;
                        File omssaOutputFile;
                        String spectrumFileName = spectrumFile.getName();
                        if (this.searchHandler.isOmssaEnabled() && (omssaOutputFile = new File(this.outputFolder, SearchHandler.getOMSSAFileName(spectrumFileName, omssaParameters))).exists()) {
                            fileFound = true;
                            break;
                        }
                        if (this.searchHandler.isXtandemEnabled() && this.utilitiesUserPreferences.renameXTandemFile().booleanValue() && !this.searchHandler.getXTandemFiles(this.outputFolder, spectrumFileName).isEmpty()) {
                            fileFound = true;
                            break;
                        }
                        if (this.searchHandler.isMsgfEnabled() && (msgfOutputFile = new File(this.outputFolder, SearchHandler.getMsgfFileName(spectrumFileName))).exists()) {
                            fileFound = true;
                            break;
                        }
                        if (this.searchHandler.isMsAmandaEnabled() && (msAmandaOutputFile = new File(this.outputFolder, SearchHandler.getMsAmandaFileName(spectrumFileName))).exists()) {
                            fileFound = true;
                            break;
                        }
                        if (this.searchHandler.isMyriMatchEnabled() && (myriMatchOutputFile = new File(this.outputFolder, SearchHandler.getMyriMatchFileName(spectrumFileName, myriMatchParameters))).exists()) {
                            fileFound = true;
                            break;
                        }
                        if (this.searchHandler.isCometEnabled() && (cometOutputFile = new File(this.outputFolder, SearchHandler.getCometFileName(spectrumFileName, cometParameters))).exists()) {
                            fileFound = true;
                            break;
                        }
                        if (this.searchHandler.isTideEnabled() && (tideOutputFile = new File(this.outputFolder, SearchHandler.getTideFileName(spectrumFileName, tideParameters))).exists()) {
                            fileFound = true;
                            break;
                        }
                        if (!this.searchHandler.isAndromedaEnabled() || !(andromedaOutputFile = new File(this.outputFolder, SearchHandler.getAndromedaFileName(spectrumFileName))).exists()) continue;
                        fileFound = true;
                        break;
                    }
                    this.searchHandler.setOutputTimeStamp(SearchHandler.getOutputDate());
                    outputOption = this.utilitiesUserPreferences.getOutputOption();
                    if (outputOption != SearchGuiOutputOption.grouped) break block39;
                    outputFile = SearchHandler.getDefaultOutputFile(this.outputFolder, this.utilitiesUserPreferences.isIncludeDateInOutputName());
                    if (!((File)outputFile).exists()) break block40;
                    fileFound = true;
                    break block40;
                }
                if (outputOption != SearchGuiOutputOption.algorithm) break block41;
                if (this.searchHandler.isOmssaEnabled() && ((File)(outputFile = SearchHandler.getDefaultOutputFile(this.outputFolder, Advocate.omssa.getName(), this.utilitiesUserPreferences.isIncludeDateInOutputName()))).exists()) {
                    fileFound = true;
                }
                if (this.searchHandler.isXtandemEnabled() && ((File)(outputFile = SearchHandler.getDefaultOutputFile(this.outputFolder, Advocate.xtandem.getName(), this.utilitiesUserPreferences.isIncludeDateInOutputName()))).exists()) {
                    fileFound = true;
                }
                if (this.searchHandler.isMsgfEnabled() && ((File)(outputFile = SearchHandler.getDefaultOutputFile(this.outputFolder, Advocate.msgf.getName(), this.utilitiesUserPreferences.isIncludeDateInOutputName()))).exists()) {
                    fileFound = true;
                }
                if (this.searchHandler.isMsAmandaEnabled() && ((File)(outputFile = SearchHandler.getDefaultOutputFile(this.outputFolder, Advocate.msAmanda.getName(), this.utilitiesUserPreferences.isIncludeDateInOutputName()))).exists()) {
                    fileFound = true;
                }
                if (!this.searchHandler.isMyriMatchEnabled() || !((File)(outputFile = SearchHandler.getDefaultOutputFile(this.outputFolder, Advocate.myriMatch.getName(), this.utilitiesUserPreferences.isIncludeDateInOutputName()))).exists()) break block40;
                fileFound = true;
                break block40;
            }
            if (outputOption == SearchGuiOutputOption.run) {
                for (File spectrumFile : spectrumFiles) {
                    String runName = Util.removeExtension(spectrumFile.getName());
                    File outputFile = SearchHandler.getDefaultOutputFile(this.outputFolder, runName, this.utilitiesUserPreferences.isIncludeDateInOutputName());
                    if (!outputFile.exists()) continue;
                    fileFound = true;
                    break;
                }
            }
        }
        if (fileFound && (outcome = JOptionPane.showConfirmDialog(this, "Existing output files found.\nOverwrite?", "Overwrite Files?", 0)) != 0) {
            return;
        }
        if (this.searchHandler.isXtandemEnabled() && this.utilitiesUserPreferences.renameXTandemFile().booleanValue()) {
            for (File spectrumFile : spectrumFiles) {
                String spectrumFileName = spectrumFile.getName();
                ArrayList<File> tempFiles = this.searchHandler.getXTandemFiles(this.outputFolder, spectrumFileName);
                for (File tempSpectrumFile : tempFiles) {
                    if (tempSpectrumFile.delete()) continue;
                    JOptionPane.showMessageDialog(this, new String[]{"Impossible to overwrite " + tempSpectrumFile.getName() + ". Please delete the file and retry."}, "X!Tandem File", 2);
                    return;
                }
            }
        }
        this.saveConfigurationFile();
        this.searchHandler.setIdentificationParameters(this.identificationParameters);
        this.searchHandler.setIdentificationParametersFile(this.identificationParametersFile);
        this.searchHandler.setProcessingPreferences(this.processingPreferences);
        this.searchHandler.setMgfFiles(this.mgfFiles);
        this.searchHandler.setRawFiles(this.rawFiles);
        this.searchHandler.setResultsFolder(this.outputFolder);
        this.searchHandler.setPeptideShakerEnabled(this.peptideShakerCheckBox.isSelected());
        this.searchHandler.setMsConvertParameters(this.msConvertParameters);
        if (this.utilitiesUserPreferences.isAutoUpdate().booleanValue()) {
            Util.sendGAUpdate("UA-36198780-2", "startrun-gui", "searchgui-" + new Properties().getVersion());
        }
        this.startSearch();
    }

    private void aboutButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void aboutButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void aboutButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://compomics.github.io/projects/searchgui.html");
        this.setCursor(new Cursor(0));
    }

    private void editSettingsButtonActionPerformed(ActionEvent evt) {
        this.editIdentificationParameters();
    }

    private void addSettingsButtonActionPerformed(ActionEvent evt) {
        IdentificationParametersEditionDialog identificationParametersEditionDialog = new IdentificationParametersEditionDialog(this, null, this.searchHandler.getConfigurationFile(), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")), this.lastSelectedFolder, null, true);
        if (!identificationParametersEditionDialog.isCanceled()) {
            IdentificationParameters tempIdentificationParameters = identificationParametersEditionDialog.getIdentificationParameters();
            this.identificationParametersFile = IdentificationParametersFactory.getIdentificationParametersFile(tempIdentificationParameters.getName());
            this.setIdentificationParameters(tempIdentificationParameters);
        }
    }

    private void editModificationsMenuItemActionPerformed(ActionEvent evt) {
        new ModificationsDialog((Frame)this, true);
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.saveConfigurationFile();
        SearchGUI.deleteTempFolders();
        System.exit(0);
    }

    private void advancedSettingsMenuItemActionPerformed(ActionEvent evt) {
        new AdvancedSettingsDialog(this, true);
        this.utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
    }

    private void helpMenuItemActionPerformed(ActionEvent evt) {
        new HelpDialog(this, this.getClass().getResource("/helpFiles/SearchGUI.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")), "SearchGUI - Help", 500, 50);
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        new HelpDialog(this, this.getClass().getResource("/helpFiles/AboutSearchGUI.html"), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/help.GIF")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")), "About SearchGUI", 500, 50);
    }

    private void logReportMenuActionPerformed(ActionEvent evt) {
        new BugReport(this, this.lastSelectedFolder, "SearchGUI", "searchgui", new Properties().getVersion(), "peptide-shaker", "PeptideShaker", new File(this.getJarFilePath() + "/resources/SearchGUI.log"));
    }

    private void editModificationsEditMenuItemActionPerformed(ActionEvent evt) {
        new ModificationsDialog((Frame)this, true);
    }

    private void editSearchEngineLocationsMenuItemActionPerformed(ActionEvent evt) {
        new SoftwareLocationDialog(this, true);
    }

    private void omssaButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void omssaButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void omssaButtonActionPerformed(ActionEvent evt) {
        this.enableOmssaJCheckBox.setSelected(!this.enableOmssaJCheckBox.isSelected());
        this.enableOmssaJCheckBoxActionPerformed(null);
    }

    private void xtandemButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void xtandemButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void xtandemButtonActionPerformed(ActionEvent evt) {
        this.enableXTandemJCheckBox.setSelected(!this.enableXTandemJCheckBox.isSelected());
        this.enableXTandemJCheckBoxActionPerformed(null);
    }

    private void xtandemLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void xtandemLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void xtandemLinkLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.thegpm.org/tandem/");
        this.setCursor(new Cursor(0));
    }

    private void omssaLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void omssaLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void omssaLinkLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.ncbi.nlm.nih.gov/pubmed/15473683");
        this.setCursor(new Cursor(0));
    }

    private void enableOmssaJCheckBoxActionPerformed(ActionEvent evt) {
        boolean valid;
        this.searchHandler.setOmssaEnabled(this.enableOmssaJCheckBox.isSelected());
        if (this.enableOmssaJCheckBox.isSelected() && !(valid = SearchGUI.validateSearchEngineInstallation(Advocate.omssa, this.searchHandler.getOmssaLocation(), true))) {
            new SoftwareLocationDialog(this, true);
        }
        this.validateInput(false);
    }

    private void enableXTandemJCheckBoxActionPerformed(ActionEvent evt) {
        boolean valid;
        this.searchHandler.setXtandemEnabled(this.enableXTandemJCheckBox.isSelected());
        if (this.enableXTandemJCheckBox.isSelected() && !(valid = SearchGUI.validateSearchEngineInstallation(Advocate.xtandem, this.searchHandler.getXtandemLocation(), true))) {
            new SoftwareLocationDialog(this, true);
        }
        this.validateInput(false);
    }

    private void peptideShakerButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void peptideShakerButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void peptideShakerButtonActionPerformed(ActionEvent evt) {
        this.peptideShakerCheckBox.setSelected(!this.peptideShakerCheckBox.isSelected());
        this.peptideShakerCheckBoxActionPerformed(null);
    }

    private void peptideShakerLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://compomics.github.io/projects/peptide-shaker.html");
        this.setCursor(new Cursor(0));
    }

    private void peptideShakerLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void peptideShakerLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void searchGUIPublicationLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void searchGUIPublicationLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void searchGUIPublicationLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://www.ncbi.nlm.nih.gov/pubmed/21337703");
        this.setCursor(new Cursor(0));
    }

    private void reporterButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void reporterButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void reporterButtonActionPerformed(ActionEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://compomics.github.io/projects/reporter.html");
        this.setCursor(new Cursor(0));
    }

    private void reporterLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://compomics.github.io/projects/reporter.html");
        this.setCursor(new Cursor(0));
    }

    private void reporterLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void reporterLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void editReporterSettingsLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void editReporterSettingsLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void editReporterSettingsLabelMouseClicked(MouseEvent evt) {
        JOptionPane.showMessageDialog(this, "Not yet implemented...", "Not Implemented", 2);
    }

    private void peptideShakerCheckBoxActionPerformed(ActionEvent evt) {
        this.openPeptideShakerSettings(false);
    }

    private void javaSettingsJMenuItemActionPerformed(ActionEvent evt) {
        new JavaSettingsDialog(this, this, null, "SearchGUI", true);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.exitMenuItemActionPerformed(null);
    }

    private void spectraFilesTxtMouseClicked(MouseEvent evt) {
        if (!this.mgfFiles.isEmpty() || !this.rawFiles.isEmpty()) {
            ArrayList<File> spectrumFiles = new ArrayList<File>(this.mgfFiles);
            spectrumFiles.addAll(this.rawFiles);
            FileDisplayDialog fileDisplayDialog = new FileDisplayDialog(this, spectrumFiles, true);
            if (!fileDisplayDialog.canceled()) {
                spectrumFiles = fileDisplayDialog.getSelectedFiles();
                this.spectraFilesTxt.setText(spectrumFiles.size() + " file(s) selected");
                this.mgfFiles.clear();
                this.rawFiles.clear();
                for (File file : spectrumFiles) {
                    if (file.getName().toLowerCase().endsWith("mgf")) {
                        this.mgfFiles.add(file);
                        continue;
                    }
                    this.rawFiles.add(file);
                }
                this.msconvertCheckBox.setSelected(!this.rawFiles.isEmpty());
                this.validateInput(false);
            }
        }
    }

    private void omssaSettingsButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void omssaSettingsButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void xtandemSettingsButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void xtandemSettingsButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void peptideShakerSettingsButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void peptideShakerSettingsButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void enableMsgfJCheckBoxActionPerformed(ActionEvent evt) {
        boolean valid;
        this.searchHandler.setMsgfEnabled(this.enableMsgfJCheckBox.isSelected());
        if (this.enableMsgfJCheckBox.isSelected() && !(valid = SearchGUI.validateSearchEngineInstallation(Advocate.msgf, this.searchHandler.getMsgfLocation(), true))) {
            new SoftwareLocationDialog(this, true);
        }
        this.validateInput(false);
    }

    private void msgfButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void msgfButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void msgfButtonActionPerformed(ActionEvent evt) {
        this.enableMsgfJCheckBox.setSelected(!this.enableMsgfJCheckBox.isSelected());
        this.enableMsgfJCheckBoxActionPerformed(null);
    }

    private void msgfLinkLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("https://github.com/MSGFPlus/msgfplus");
        this.setCursor(new Cursor(0));
    }

    private void msgfLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void msgfLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void msgfSettingsButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void msgfSettingsButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void enableMsAmandaJCheckBoxActionPerformed(ActionEvent evt) {
        boolean valid;
        this.searchHandler.setMsAmandaEnabled(this.enableMsAmandaJCheckBox.isSelected());
        if (this.enableMsAmandaJCheckBox.isSelected() && !(valid = SearchGUI.validateSearchEngineInstallation(Advocate.msAmanda, this.searchHandler.getMsAmandaLocation(), true))) {
            new SoftwareLocationDialog(this, true);
        }
        this.validateInput(false);
    }

    private void msAmandaButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void msAmandaButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void msAmandaButtonActionPerformed(ActionEvent evt) {
        this.enableMsAmandaJCheckBox.setSelected(!this.enableMsAmandaJCheckBox.isSelected());
        this.enableMsAmandaJCheckBoxActionPerformed(null);
    }

    private void msAmandaLinkLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://ms.imp.ac.at/?goto=msamanda");
        this.setCursor(new Cursor(0));
    }

    private void msAmandaLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void msAmandaLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void msAmandaSettingsButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void msAmandaSettingsButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void privacyMenuItemActionPerformed(ActionEvent evt) {
        new PrivacySettingsDialog((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")));
    }

    private void enableMyriMatchJCheckBoxActionPerformed(ActionEvent evt) {
        boolean valid;
        this.searchHandler.setMyriMatchEnabled(this.enableMyriMatchJCheckBox.isSelected());
        if (this.enableMyriMatchJCheckBox.isSelected() && !(valid = SearchGUI.validateSearchEngineInstallation(Advocate.myriMatch, this.searchHandler.getMyriMatchLocation(), true))) {
            new SoftwareLocationDialog(this, true);
        }
        this.validateInput(false);
    }

    private void myriMatchButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void myriMatchButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void myriMatchButtonActionPerformed(ActionEvent evt) {
        this.enableMyriMatchJCheckBox.setSelected(!this.enableMyriMatchJCheckBox.isSelected());
        this.enableMyriMatchJCheckBoxActionPerformed(null);
    }

    private void myriMatchLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void myriMatchLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void myriMatchSettingsButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void myriMatchSettingsButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void enableCometJCheckBoxActionPerformed(ActionEvent evt) {
        boolean valid;
        this.searchHandler.setCometEnabled(this.enableCometJCheckBox.isSelected());
        if (this.enableCometJCheckBox.isSelected() && !(valid = SearchGUI.validateSearchEngineInstallation(Advocate.comet, this.searchHandler.getCometLocation(), true))) {
            new SoftwareLocationDialog(this, true);
        }
        this.validateInput(false);
    }

    private void cometButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void cometButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void cometButtonActionPerformed(ActionEvent evt) {
        this.enableCometJCheckBox.setSelected(!this.enableCometJCheckBox.isSelected());
        this.enableCometJCheckBoxActionPerformed(null);
    }

    private void cometLinkLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://comet-ms.sourceforge.net");
        this.setCursor(new Cursor(0));
    }

    private void cometLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void cometLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void cometSettingsButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void cometSettingsButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void resourceSettingsMenuItemActionPerformed(ActionEvent evt) {
        this.editPathSettings();
    }

    private void enableTideJCheckBoxActionPerformed(ActionEvent evt) {
        boolean valid;
        this.searchHandler.setTideEnabled(this.enableTideJCheckBox.isSelected());
        if (this.enableTideJCheckBox.isSelected() && !(valid = SearchGUI.validateSearchEngineInstallation(Advocate.tide, this.searchHandler.getTideLocation(), true))) {
            new SoftwareLocationDialog(this, true);
        }
        this.validateInput(false);
    }

    private void tideButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void tideButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void tideButtonActionPerformed(ActionEvent evt) {
        this.enableTideJCheckBox.setSelected(!this.enableTideJCheckBox.isSelected());
        this.enableTideJCheckBoxActionPerformed(null);
    }

    private void tideLinkLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://cruxtoolkit.sourceforge.net/");
        this.setCursor(new Cursor(0));
    }

    private void tideLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void tideLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void tideSettingsButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void tideSettingsButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void enableAndromedaJCheckBoxActionPerformed(ActionEvent evt) {
        boolean valid;
        this.searchHandler.setAndromedaEnabled(this.enableAndromedaJCheckBox.isSelected());
        if (this.enableAndromedaJCheckBox.isSelected() && !(valid = SearchGUI.validateSearchEngineInstallation(Advocate.andromeda, this.searchHandler.getAndromedaLocation(), true))) {
            new SoftwareLocationDialog(this, true);
        }
        this.validateInput(false);
    }

    private void andromedaButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void andromedaButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void andromedaButtonActionPerformed(ActionEvent evt) {
        this.enableAndromedaJCheckBox.setSelected(!this.enableAndromedaJCheckBox.isSelected());
        this.enableAndromedaJCheckBoxActionPerformed(null);
    }

    private void andromedaLinkLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://coxdocs.org/doku.php?id=maxquant:andromeda:start");
        this.setCursor(new Cursor(0));
    }

    private void andromedaLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void andromedaLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void andromedaSettingsButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void andromedaSettingsButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void msconvertLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://proteowizard.sourceforge.net");
        this.setCursor(new Cursor(0));
    }

    private void msconvertLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void msconvertLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void msconvertSettingsButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void msconvertSettingsButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void msconvertCheckBoxActionPerformed(ActionEvent evt) {
        this.msconvertCheckBox.setSelected(!this.rawFiles.isEmpty());
    }

    private void processingMenuItemActionPerformed(ActionEvent evt) {
        ProcessingPreferencesDialog processingPreferencesDialog = new ProcessingPreferencesDialog((Frame)this, this.processingPreferences, true);
        if (!processingPreferencesDialog.isCanceled()) {
            this.processingPreferences = processingPreferencesDialog.getProcessingPreferences();
        }
    }

    private void settingsComboBoxActionPerformed(ActionEvent evt) {
        this.editSettingsButton.setEnabled(this.settingsComboBox.getSelectedIndex() != 0);
        if (this.settingsComboBox.getSelectedIndex() != 0) {
            this.identificationParametersFile = IdentificationParametersFactory.getIdentificationParametersFile((String)this.settingsComboBox.getSelectedItem());
            try {
                this.identificationParameters = IdentificationParameters.getIdentificationParameters(this.identificationParametersFile);
                String error = SearchHandler.loadModifications(this.identificationParameters.getSearchParameters());
                if (error != null) {
                    JOptionPane.showMessageDialog(this, error, "PTM Definition Changed", 2);
                }
                this.enableSearchEngineAndDeNovoPanels(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Failed to import search parameters from: " + this.identificationParametersFile.getAbsolutePath() + ".", "Search Parameters", 2);
                e.printStackTrace();
            }
        } else {
            this.enableSearchEngineAndDeNovoPanels(false);
        }
        this.validateInput(false);
    }

    private void msconvertSettingsButtonActionPerformed(ActionEvent evt) {
        MsConvertParametersDialog msConvertParametersDialog;
        boolean canceled = false;
        if (this.utilitiesUserPreferences.getProteoWizardPath() == null) {
            boolean bl = canceled = !this.editProteoWizardInstallation();
        }
        if (!canceled && !(msConvertParametersDialog = new MsConvertParametersDialog((Frame)this, this.msConvertParameters)).isCanceled()) {
            this.msConvertParameters = msConvertParametersDialog.getMsConvertParameters();
        }
    }

    private void xtandemSettingsButtonActionPerformed(ActionEvent evt) {
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        XtandemParameters oldXtandemParameters = (XtandemParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.xtandem.getIndex());
        XTandemSettingsDialog xtandemSettingsDialog = new XTandemSettingsDialog(this, oldXtandemParameters, searchParameters.getPtmSettings(), searchParameters.getFragmentIonAccuracyInDaltons(utilitiesUserPreferences.getRefMass()), true);
        boolean xtandemParametersSet = false;
        while (!xtandemParametersSet) {
            if (!xtandemSettingsDialog.isCancelled()) {
                XtandemParameters newXtandemParameters = xtandemSettingsDialog.getInput();
                if (!oldXtandemParameters.equals(newXtandemParameters) || xtandemSettingsDialog.modProfileEdited()) {
                    int value = JOptionPane.showConfirmDialog(this, "The search parameters have changed.\nDo you want to save the changes?", "Save Changes?", 1);
                    switch (value) {
                        case 0: {
                            try {
                                searchParameters.setIdentificationAlgorithmParameter(Advocate.xtandem.getIndex(), newXtandemParameters);
                                searchParameters.setPtmSettings(xtandemSettingsDialog.getModificationProfile());
                                this.identificationParametersFactory.updateIdentificationParameters(this.identificationParameters, this.identificationParameters);
                                xtandemParametersSet = true;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(null, "Error occurred while saving " + this.identificationParameters.getName() + ". Please verify the settings.", "File Error", 0);
                            }
                            break;
                        }
                        case 2: {
                            xtandemSettingsDialog = new XTandemSettingsDialog(this, newXtandemParameters, searchParameters.getPtmSettings(), searchParameters.getFragmentIonAccuracyInDaltons(utilitiesUserPreferences.getRefMass()), true);
                            break;
                        }
                        case 1: {
                            xtandemParametersSet = true;
                            break;
                        }
                    }
                    continue;
                }
                xtandemParametersSet = true;
                continue;
            }
            xtandemParametersSet = true;
        }
    }

    private void myriMatchSettingsButtonActionPerformed(ActionEvent evt) {
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        MyriMatchParameters oldMyriMatchParameters = (MyriMatchParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.myriMatch.getIndex());
        MyriMatchSettingsDialog myriMatchParametersDialog = new MyriMatchSettingsDialog((Frame)this, oldMyriMatchParameters, true);
        boolean myriMatchParametersSet = false;
        while (!myriMatchParametersSet) {
            if (!myriMatchParametersDialog.isCancelled()) {
                MyriMatchParameters newMyriMatchParameters = myriMatchParametersDialog.getInput();
                if (!oldMyriMatchParameters.equals(newMyriMatchParameters)) {
                    int value = JOptionPane.showConfirmDialog(this, "The search parameters have changed.\nDo you want to save the changes?", "Save Changes?", 1);
                    switch (value) {
                        case 0: {
                            try {
                                searchParameters.setIdentificationAlgorithmParameter(Advocate.myriMatch.getIndex(), newMyriMatchParameters);
                                this.identificationParametersFactory.updateIdentificationParameters(this.identificationParameters, this.identificationParameters);
                                myriMatchParametersSet = true;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(null, "Error occurred while saving " + this.identificationParameters.getName() + ". Please verify the settings.", "File Error", 0);
                            }
                            break;
                        }
                        case 2: {
                            myriMatchParametersDialog = new MyriMatchSettingsDialog((Frame)this, newMyriMatchParameters, true);
                            break;
                        }
                        case 1: {
                            myriMatchParametersSet = true;
                            break;
                        }
                    }
                    continue;
                }
                myriMatchParametersSet = true;
                continue;
            }
            myriMatchParametersSet = true;
        }
    }

    private void msAmandaSettingsButtonActionPerformed(ActionEvent evt) {
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        MsAmandaParameters oldMsAmandaParameters = (MsAmandaParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.msAmanda.getIndex());
        MsAmandaSettingsDialog msAmandaParametersDialog = new MsAmandaSettingsDialog((Frame)this, oldMsAmandaParameters, true);
        boolean msAmandaParametersSet = false;
        while (!msAmandaParametersSet) {
            if (!msAmandaParametersDialog.isCancelled()) {
                MsAmandaParameters newMsAmandaParameters = msAmandaParametersDialog.getInput();
                if (!oldMsAmandaParameters.equals(newMsAmandaParameters)) {
                    int value = JOptionPane.showConfirmDialog(this, "The search parameters have changed.\nDo you want to save the changes?", "Save Changes?", 1);
                    switch (value) {
                        case 0: {
                            try {
                                searchParameters.setIdentificationAlgorithmParameter(Advocate.msAmanda.getIndex(), newMsAmandaParameters);
                                this.identificationParametersFactory.updateIdentificationParameters(this.identificationParameters, this.identificationParameters);
                                msAmandaParametersSet = true;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(null, "Error occurred while saving " + this.identificationParameters.getName() + ". Please verify the settings.", "File Error", 0);
                            }
                            break;
                        }
                        case 2: {
                            msAmandaParametersDialog = new MsAmandaSettingsDialog((Frame)this, newMsAmandaParameters, true);
                            break;
                        }
                        case 1: {
                            msAmandaParametersSet = true;
                            break;
                        }
                    }
                    continue;
                }
                msAmandaParametersSet = true;
                continue;
            }
            msAmandaParametersSet = true;
        }
    }

    private void msgfSettingsButtonActionPerformed(ActionEvent evt) {
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        MsgfParameters oldMsgfParameters = (MsgfParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.msgf.getIndex());
        if (oldMsgfParameters == null) {
            oldMsgfParameters = new MsgfParameters();
        }
        MsgfSettingsDialog msgfParametersDialog = new MsgfSettingsDialog((Frame)this, oldMsgfParameters, true);
        boolean msgfParametersSet = false;
        while (!msgfParametersSet) {
            if (!msgfParametersDialog.isCancelled()) {
                MsgfParameters newMsgfParameters = msgfParametersDialog.getInput();
                if (!oldMsgfParameters.equals(newMsgfParameters)) {
                    int value = JOptionPane.showConfirmDialog(this, "The search parameters have changed.\nDo you want to save the changes?", "Save Changes?", 1);
                    switch (value) {
                        case 0: {
                            try {
                                searchParameters.setIdentificationAlgorithmParameter(Advocate.msgf.getIndex(), newMsgfParameters);
                                this.identificationParametersFactory.updateIdentificationParameters(this.identificationParameters, this.identificationParameters);
                                msgfParametersSet = true;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(null, "Error occurred while saving " + this.identificationParameters.getName() + ". Please verify the settings.", "File Error", 0);
                            }
                            break;
                        }
                        case 2: {
                            msgfParametersDialog = new MsgfSettingsDialog((Frame)this, newMsgfParameters, true);
                            break;
                        }
                        case 1: {
                            msgfParametersSet = true;
                            break;
                        }
                    }
                    continue;
                }
                msgfParametersSet = true;
                continue;
            }
            msgfParametersSet = true;
        }
    }

    private void omssaSettingsButtonActionPerformed(ActionEvent evt) {
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        OmssaParameters oldOmssaParameters = (OmssaParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.omssa.getIndex());
        if (oldOmssaParameters == null) {
            oldOmssaParameters = new OmssaParameters();
        }
        OmssaSettingsDialog omssaParametersDialog = new OmssaSettingsDialog((Frame)this, oldOmssaParameters, true);
        boolean omssaParametersSet = false;
        while (!omssaParametersSet) {
            if (!omssaParametersDialog.isCancelled()) {
                OmssaParameters newOmssaParameters = omssaParametersDialog.getInput();
                if (!oldOmssaParameters.equals(newOmssaParameters)) {
                    int value = JOptionPane.showConfirmDialog(this, "The search parameters have changed.\nDo you want to save the changes?", "Save Changes?", 1);
                    switch (value) {
                        case 0: {
                            try {
                                searchParameters.setIdentificationAlgorithmParameter(Advocate.omssa.getIndex(), newOmssaParameters);
                                this.identificationParametersFactory.updateIdentificationParameters(this.identificationParameters, this.identificationParameters);
                                omssaParametersSet = true;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(null, "Error occurred while saving " + this.identificationParameters.getName() + ". Please verify the settings.", "File Error", 0);
                            }
                            break;
                        }
                        case 2: {
                            omssaParametersDialog = new OmssaSettingsDialog((Frame)this, newOmssaParameters, true);
                            break;
                        }
                        case 1: {
                            omssaParametersSet = true;
                            break;
                        }
                    }
                    continue;
                }
                omssaParametersSet = true;
                continue;
            }
            omssaParametersSet = true;
        }
    }

    private void cometSettingsButtonActionPerformed(ActionEvent evt) {
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        CometParameters oldCometParameters = (CometParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.comet.getIndex());
        CometSettingsDialog cometSettingsDialog = new CometSettingsDialog((Frame)this, oldCometParameters, true);
        boolean cometParametersSet = false;
        while (!cometParametersSet) {
            if (!cometSettingsDialog.isCancelled()) {
                CometParameters newCometParameters = cometSettingsDialog.getInput();
                if (!oldCometParameters.equals(newCometParameters)) {
                    int value = JOptionPane.showConfirmDialog(this, "The search parameters have changed.\nDo you want to save the changes?", "Save Changes?", 1);
                    switch (value) {
                        case 0: {
                            try {
                                searchParameters.setIdentificationAlgorithmParameter(Advocate.comet.getIndex(), newCometParameters);
                                this.identificationParametersFactory.updateIdentificationParameters(this.identificationParameters, this.identificationParameters);
                                cometParametersSet = true;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(null, "Error occurred while saving " + this.identificationParameters.getName() + ". Please verify the settings.", "File Error", 0);
                            }
                            break;
                        }
                        case 2: {
                            cometSettingsDialog = new CometSettingsDialog((Frame)this, newCometParameters, true);
                            break;
                        }
                        case 1: {
                            cometParametersSet = true;
                            break;
                        }
                    }
                    continue;
                }
                cometParametersSet = true;
                continue;
            }
            cometParametersSet = true;
        }
    }

    private void tideSettingsButtonActionPerformed(ActionEvent evt) {
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        TideParameters oldTideParameters = (TideParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.tide.getIndex());
        if (oldTideParameters == null) {
            oldTideParameters = new TideParameters();
        }
        TideSettingsDialog tideParametersDialog = new TideSettingsDialog((Frame)this, oldTideParameters, true);
        boolean tideParametersSet = false;
        while (!tideParametersSet) {
            if (!tideParametersDialog.isCancelled()) {
                TideParameters newTideParameters = tideParametersDialog.getInput();
                if (!oldTideParameters.equals(newTideParameters)) {
                    int value = JOptionPane.showConfirmDialog(this, "The search parameters have changed.\nDo you want to save the changes?", "Save Changes?", 1);
                    switch (value) {
                        case 0: {
                            try {
                                searchParameters.setIdentificationAlgorithmParameter(Advocate.tide.getIndex(), newTideParameters);
                                this.identificationParametersFactory.updateIdentificationParameters(this.identificationParameters, this.identificationParameters);
                                tideParametersSet = true;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(null, "Error occurred while saving " + this.identificationParameters.getName() + ". Please verify the settings.", "File Error", 0);
                            }
                            break;
                        }
                        case 2: {
                            tideParametersDialog = new TideSettingsDialog((Frame)this, newTideParameters, true);
                            break;
                        }
                        case 1: {
                            tideParametersSet = true;
                            break;
                        }
                    }
                    continue;
                }
                tideParametersSet = true;
                continue;
            }
            tideParametersSet = true;
        }
    }

    private void andromedaSettingsButtonActionPerformed(ActionEvent evt) {
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        AndromedaParameters oldAndromedaParameters = (AndromedaParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.andromeda.getIndex());
        if (oldAndromedaParameters == null) {
            oldAndromedaParameters = new AndromedaParameters();
        }
        AndromedaSettingsDialog andromedaParametersDialog = new AndromedaSettingsDialog((Frame)this, oldAndromedaParameters, true);
        boolean andromedaParametersSet = false;
        while (!andromedaParametersSet) {
            if (!andromedaParametersDialog.isCancelled()) {
                AndromedaParameters newAndromedaParameters = andromedaParametersDialog.getInput();
                if (!oldAndromedaParameters.equals(newAndromedaParameters)) {
                    int value = JOptionPane.showConfirmDialog(this, "The search parameters have changed.\nDo you want to save the changes?", "Save Changes?", 1);
                    switch (value) {
                        case 0: {
                            try {
                                searchParameters.setIdentificationAlgorithmParameter(Advocate.andromeda.getIndex(), newAndromedaParameters);
                                this.identificationParametersFactory.updateIdentificationParameters(this.identificationParameters, this.identificationParameters);
                                andromedaParametersSet = true;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(null, "Error occurred while saving " + this.identificationParameters.getName() + ". Please verify the settings.", "File Error", 0);
                            }
                            break;
                        }
                        case 2: {
                            andromedaParametersDialog = new AndromedaSettingsDialog((Frame)this, newAndromedaParameters, true);
                            break;
                        }
                        case 1: {
                            andromedaParametersSet = true;
                            break;
                        }
                    }
                    continue;
                }
                andromedaParametersSet = true;
                continue;
            }
            andromedaParametersSet = true;
        }
    }

    private void peptideShakerSettingsButtonActionPerformed(ActionEvent evt) {
        this.openPeptideShakerSettings(true);
    }

    private void myriMatchLinkLabelMouseReleased(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://htmlpreview.github.io/?https://github.com/ProteoWizard/pwiz/blob/master/pwiz_tools/Bumbershoot/myrimatch/doc/index.html");
        this.setCursor(new Cursor(0));
    }

    private void editIdSettingsFilesMenuItemActionPerformed(ActionEvent evt) {
        new IdentificationParametersOverviewDialog(this);
        this.updateIdentificationSettingsDropDownMenu(false);
    }

    private void direcTagSettingsButtonActionPerformed(ActionEvent evt) {
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        DirecTagParameters oldDirecTagParameters = (DirecTagParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.direcTag.getIndex());
        DirecTagSettingsDialog direcTagParametersDialog = new DirecTagSettingsDialog((Frame)this, oldDirecTagParameters, true);
        boolean direcTagParametersSet = false;
        while (!direcTagParametersSet) {
            if (!direcTagParametersDialog.isCancelled()) {
                DirecTagParameters newDirecTagParameters = direcTagParametersDialog.getInput();
                if (!oldDirecTagParameters.equals(newDirecTagParameters)) {
                    int value = JOptionPane.showConfirmDialog(this, "The search parameters have changed.\nDo you want to save the changes?", "Save Changes?", 1);
                    switch (value) {
                        case 0: {
                            try {
                                searchParameters.setIdentificationAlgorithmParameter(Advocate.direcTag.getIndex(), newDirecTagParameters);
                                this.identificationParametersFactory.updateIdentificationParameters(this.identificationParameters, this.identificationParameters);
                                direcTagParametersSet = true;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(null, "Error occurred while saving " + this.identificationParameters.getName() + ". Please verify the settings.", "File Error", 0);
                            }
                            break;
                        }
                        case 2: {
                            direcTagParametersDialog = new DirecTagSettingsDialog((Frame)this, newDirecTagParameters, true);
                            break;
                        }
                        case 1: {
                            direcTagParametersSet = true;
                            break;
                        }
                    }
                    continue;
                }
                direcTagParametersSet = true;
                continue;
            }
            direcTagParametersSet = true;
        }
    }

    private void direcTagSettingsButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void direcTagSettingsButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void direcTagLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void direcTagLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void direcTagLinkLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://fenchurch.mc.vanderbilt.edu/bumbershoot/directag");
        this.setCursor(new Cursor(0));
    }

    private void direcTagButtonActionPerformed(ActionEvent evt) {
        this.enableDirecTagJCheckBox.setSelected(!this.enableDirecTagJCheckBox.isSelected());
        this.enableDirecTagJCheckBoxActionPerformed(null);
    }

    private void direcTagButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void direcTagButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void enableDirecTagJCheckBoxActionPerformed(ActionEvent evt) {
        boolean valid;
        this.searchHandler.setDirecTagEnabled(this.enableDirecTagJCheckBox.isSelected());
        if (this.enableDirecTagJCheckBox.isSelected() && !(valid = SearchGUI.validateSearchEngineInstallation(Advocate.direcTag, this.searchHandler.getDirecTagLocation(), true))) {
            new SoftwareLocationDialog(this, true);
        }
        this.validateInput(false);
    }

    private void novorSettingsButtonActionPerformed(ActionEvent evt) {
        SearchParameters searchParameters = this.identificationParameters.getSearchParameters();
        NovorParameters oldNovorParameters = (NovorParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.novor.getIndex());
        NovorSettingsDialog novorParametersDialog = new NovorSettingsDialog((Frame)this, oldNovorParameters, true);
        boolean novorParametersSet = false;
        while (!novorParametersSet) {
            if (!novorParametersDialog.isCancelled()) {
                NovorParameters newNovorParameters = novorParametersDialog.getInput();
                if (!oldNovorParameters.equals(newNovorParameters)) {
                    int value = JOptionPane.showConfirmDialog(this, "The search parameters have changed.\nDo you want to save the changes?", "Save Changes?", 1);
                    switch (value) {
                        case 0: {
                            try {
                                searchParameters.setIdentificationAlgorithmParameter(Advocate.novor.getIndex(), newNovorParameters);
                                this.identificationParametersFactory.updateIdentificationParameters(this.identificationParameters, this.identificationParameters);
                                novorParametersSet = true;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                JOptionPane.showMessageDialog(null, "Error occurred while saving " + this.identificationParameters.getName() + ". Please verify the settings.", "File Error", 0);
                            }
                            break;
                        }
                        case 2: {
                            novorParametersDialog = new NovorSettingsDialog((Frame)this, newNovorParameters, true);
                            break;
                        }
                        case 1: {
                            novorParametersSet = true;
                            break;
                        }
                    }
                    continue;
                }
                novorParametersSet = true;
                continue;
            }
            novorParametersSet = true;
        }
    }

    private void novorSettingsButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void novorSettingsButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void novorLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void novorLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void novorLinkLabelMouseClicked(MouseEvent evt) {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://rapidnovor.com");
        this.setCursor(new Cursor(0));
    }

    private void novorButtonActionPerformed(ActionEvent evt) {
        this.enableNovorJCheckBox.setSelected(!this.enableNovorJCheckBox.isSelected());
        this.enableNovorJCheckBoxActionPerformed(null);
    }

    private void novorButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void novorButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void enableNovorJCheckBoxActionPerformed(ActionEvent evt) {
        boolean valid;
        this.searchHandler.setNovorEnabled(this.enableNovorJCheckBox.isSelected());
        if (this.enableNovorJCheckBox.isSelected() && !(valid = SearchGUI.validateSearchEngineInstallation(Advocate.novor, this.searchHandler.getNovorLocation(), true))) {
            new SoftwareLocationDialog(this, true);
        }
        this.validateInput(false);
    }

    private void editIdentificationParameters() {
        IdentificationParametersEditionDialog identificationParametersEditionDialog = new IdentificationParametersEditionDialog(this, this.identificationParameters, this.searchHandler.getConfigurationFile(), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")), this.lastSelectedFolder, null, true);
        if (!identificationParametersEditionDialog.isCanceled()) {
            IdentificationParameters tempIdentificationParameters = identificationParametersEditionDialog.getIdentificationParameters();
            this.identificationParametersFile = IdentificationParametersFactory.getIdentificationParametersFile(tempIdentificationParameters.getName());
            this.setIdentificationParameters(tempIdentificationParameters);
        }
    }

    public void editPathSettings() {
        try {
            HashMap<PathKey, String> pathSettings = new HashMap<PathKey, String>();
            for (SearchGUIPathPreferences.SearchGUIPathKey searchGUIPathKey : SearchGUIPathPreferences.SearchGUIPathKey.values()) {
                pathSettings.put(searchGUIPathKey, SearchGUIPathPreferences.getPathPreference(searchGUIPathKey, this.getJarFilePath()));
            }
            for (Enum enum_ : UtilitiesPathPreferences.UtilitiesPathKey.values()) {
                pathSettings.put((PathKey)((Object)enum_), UtilitiesPathPreferences.getPathPreference((UtilitiesPathPreferences.UtilitiesPathKey)enum_));
            }
            PathSettingsDialog pathSettingsDialog = new PathSettingsDialog((Frame)this, "SearchGUI", pathSettings);
            if (!pathSettingsDialog.isCanceled()) {
                HashMap<PathKey, String> newSettings = pathSettingsDialog.getKeyToPathMap();
                for (PathKey pathKey : pathSettings.keySet()) {
                    String oldPath = pathSettings.get(pathKey);
                    String newPath = newSettings.get(pathKey);
                    if (!(oldPath == null && newPath != null || oldPath != null && newPath == null) && (oldPath == null || newPath == null || oldPath.equals(newPath))) continue;
                    SearchGUIPathPreferences.setPathPreference(pathKey, newPath);
                }
                File destinationFile = new File(this.getJarFilePath(), "resources/conf/paths.txt");
                try {
                    SearchGUIPathPreferences.writeConfigurationToFile(destinationFile, this.getJarFilePath());
                    this.restart();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(this, new String[]{"An error occurred while setting the configuration ", exception.getMessage()}, "Error Reading File", 2);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, new String[]{"An error occurred while setting the configuration ", e.getMessage()}, "Error Reading File", 2);
        }
    }

    private void editPeptideShakerSettings() {
        PeptideShakerSettingsDialog psSettingsDialog = new PeptideShakerSettingsDialog(this, true, this.searchHandler.getMascotFiles());
        if (!psSettingsDialog.isCanceled()) {
            this.searchHandler.setExperimentLabel(psSettingsDialog.getProjectName());
            this.searchHandler.setSampleLabel(psSettingsDialog.getSampleName());
            this.searchHandler.setReplicateNumber(psSettingsDialog.getReplicateNumber());
            this.searchHandler.setPeptideShakerFile(psSettingsDialog.getPeptideShakerOutputFile());
            this.searchHandler.setMascotFiles(psSettingsDialog.getMascotFiles());
        } else {
            this.peptideShakerCheckBox.setSelected(false);
        }
    }

    private void setOutputFolder(File aFolder) {
        if (aFolder != null) {
            this.outputFolder = aFolder;
            this.outputFolderTxt.setText(this.outputFolder.getAbsolutePath());
            if (this.outputFolderTxt.getText().length() > 70) {
                this.outputFolderTxt.setHorizontalAlignment(10);
            } else {
                this.outputFolderTxt.setHorizontalAlignment(0);
            }
        }
    }

    public File getOutputFolder() {
        return this.outputFolder;
    }

    private void setSpectrumFiles(ArrayList<File> mgfFiles, ArrayList<File> rawFiles) {
        if (mgfFiles != null) {
            this.mgfFiles = mgfFiles;
        } else {
            mgfFiles = new ArrayList();
        }
        if (rawFiles != null) {
            this.rawFiles = rawFiles;
        } else {
            rawFiles = new ArrayList();
        }
        this.spectraFilesTxt.setText(mgfFiles.size() + rawFiles.size() + " file(s) selected");
    }

    public ArrayList<File> getMgfFiles() {
        return this.mgfFiles;
    }

    public boolean validateSearchEngines(boolean showMessage) {
        boolean omssaValid = true;
        boolean xtandemValid = true;
        boolean msgfValid = true;
        boolean msAmandaValid = true;
        boolean myriMatchValid = true;
        boolean cometValid = true;
        boolean tideValid = true;
        boolean andromedaValid = true;
        boolean novorValid = true;
        boolean direcTagValid = true;
        if (this.enableOmssaJCheckBox.isSelected()) {
            omssaValid = SearchGUI.validateSearchEngineInstallation(Advocate.omssa, this.searchHandler.getOmssaLocation(), showMessage);
        }
        if (this.enableXTandemJCheckBox.isSelected()) {
            xtandemValid = SearchGUI.validateSearchEngineInstallation(Advocate.xtandem, this.searchHandler.getXtandemLocation(), showMessage);
        }
        if (this.enableMsgfJCheckBox.isSelected()) {
            msgfValid = SearchGUI.validateSearchEngineInstallation(Advocate.msgf, this.searchHandler.getMsgfLocation(), showMessage);
        }
        if (this.enableMsAmandaJCheckBox.isSelected()) {
            msAmandaValid = SearchGUI.validateSearchEngineInstallation(Advocate.msAmanda, this.searchHandler.getMsAmandaLocation(), showMessage);
        }
        if (this.enableMyriMatchJCheckBox.isSelected()) {
            myriMatchValid = SearchGUI.validateSearchEngineInstallation(Advocate.myriMatch, this.searchHandler.getMyriMatchLocation(), showMessage);
        }
        if (this.enableCometJCheckBox.isSelected()) {
            cometValid = SearchGUI.validateSearchEngineInstallation(Advocate.comet, this.searchHandler.getCometLocation(), showMessage);
        }
        if (this.enableTideJCheckBox.isSelected()) {
            tideValid = SearchGUI.validateSearchEngineInstallation(Advocate.tide, this.searchHandler.getTideLocation(), showMessage);
        }
        if (this.enableAndromedaJCheckBox.isSelected()) {
            andromedaValid = SearchGUI.validateSearchEngineInstallation(Advocate.andromeda, this.searchHandler.getAndromedaLocation(), showMessage);
        }
        if (this.enableNovorJCheckBox.isSelected()) {
            novorValid = SearchGUI.validateSearchEngineInstallation(Advocate.novor, this.searchHandler.getNovorLocation(), showMessage);
        }
        if (this.enableDirecTagJCheckBox.isSelected()) {
            direcTagValid = SearchGUI.validateSearchEngineInstallation(Advocate.direcTag, this.searchHandler.getDirecTagLocation(), showMessage);
        }
        if (!(omssaValid && xtandemValid && msgfValid && msAmandaValid && myriMatchValid && cometValid && tideValid && andromedaValid && novorValid && direcTagValid)) {
            new SoftwareLocationDialog(this, true);
        }
        return omssaValid && xtandemValid && msgfValid && msAmandaValid && myriMatchValid && cometValid && tideValid && andromedaValid && novorValid && direcTagValid;
    }

    private boolean validateInput(boolean showMessage) {
        boolean valid = true;
        if (!(this.enableOmssaJCheckBox.isSelected() || this.enableXTandemJCheckBox.isSelected() || this.enableMsgfJCheckBox.isSelected() || this.enableMsAmandaJCheckBox.isSelected() || this.enableMyriMatchJCheckBox.isSelected() || this.enableCometJCheckBox.isSelected() || this.enableTideJCheckBox.isSelected() || this.enableAndromedaJCheckBox.isSelected() || this.enableNovorJCheckBox.isSelected() || this.enableDirecTagJCheckBox.isSelected())) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to select at least one search engine or de novo algorithm.", "Input Error", 2);
            }
            valid = false;
        }
        if (this.mgfFiles.isEmpty() && this.rawFiles.isEmpty()) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to select at least one spectrum file.", "Spectra Files Not Found", 2);
            }
            this.spectraFilesLabel.setForeground(Color.RED);
            this.spectraFilesLabel.setToolTipText("Please select at least one spectrum file");
            this.spectraFilesTxt.setToolTipText(null);
            valid = false;
            this.spectraFilesTxt.setCursor(new Cursor(0));
        } else {
            this.spectraFilesLabel.setToolTipText(null);
            this.spectraFilesTxt.setToolTipText("Click to see the selected files");
            this.spectraFilesTxt.setCursor(new Cursor(12));
            this.spectraFilesLabel.setForeground(Color.BLACK);
        }
        if (!this.validateParametersInput(showMessage)) {
            valid = false;
        }
        if (this.outputFolderTxt.getText() == null || this.outputFolderTxt.getText().trim().equals("")) {
            if (showMessage && valid) {
                JOptionPane.showMessageDialog(this, "You need to specify an output folder.", "Output Folder Not Found", 2);
            }
            this.resultFolderLbl.setForeground(Color.RED);
            this.resultFolderLbl.setToolTipText("Please select an output folder");
            valid = false;
        } else if (!new File(this.outputFolderTxt.getText()).exists()) {
            int value = JOptionPane.showConfirmDialog(this, "The selected output folder does not exist. Do you want to create it?", "Folder Not Found", 0);
            if (value == 0) {
                boolean success = new File(this.outputFolderTxt.getText()).mkdir();
                if (!success) {
                    JOptionPane.showMessageDialog(this, "Failed to create the output folder. Please create it manually and re-select it.", "File Error", 0);
                    valid = false;
                } else {
                    this.resultFolderLbl.setForeground(Color.BLACK);
                    this.resultFolderLbl.setToolTipText(null);
                }
            }
        } else {
            this.resultFolderLbl.setForeground(Color.BLACK);
            this.resultFolderLbl.setToolTipText(null);
        }
        this.searchButton.setEnabled(valid);
        return valid;
    }

    public boolean validateParametersInput(boolean showMessage) {
        SearchParameters searchParameters;
        SearchSettingsDialog settingsDialog;
        boolean valid;
        if (this.identificationParameters == null || this.identificationParametersFile == null || this.searchHandler == null) {
            return false;
        }
        if (this.settingsComboBox.getSelectedIndex() == 0) {
            this.searchSettingsLbl.setForeground(Color.RED);
            this.searchSettingsLbl.setToolTipText("Please check the search settings");
            return false;
        }
        String parametersName = this.identificationParameters.getName();
        if (parametersName == null) {
            parametersName = Util.removeExtension(this.identificationParametersFile.getName());
        }
        if (!(valid = (settingsDialog = new SearchSettingsDialog(this, searchParameters = this.identificationParameters.getSearchParameters(), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")), false, true, this.searchHandler.getConfigurationFile(), this.lastSelectedFolder, parametersName, true)).validateParametersInput(false))) {
            if (showMessage) {
                settingsDialog.validateParametersInput(true);
                this.editIdentificationParameters();
            } else {
                this.searchSettingsLbl.setForeground(Color.RED);
                this.searchSettingsLbl.setToolTipText("Please check the search settings");
            }
        } else {
            searchParameters.setRefMass(this.utilitiesUserPreferences.getRefMass());
            this.searchSettingsLbl.setToolTipText(null);
            this.searchSettingsLbl.setForeground(Color.BLACK);
        }
        return valid;
    }

    public boolean verifyMgfFilesNames() {
        for (File file1 : this.mgfFiles) {
            for (File file2 : this.mgfFiles) {
                if (file1 == file2 || !file1.getName().equals(file2.getName())) continue;
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")));
                JOptionPane.showMessageDialog(this, "The following files have the same name: \n" + file1.getAbsolutePath() + "\n" + file2.getAbsolutePath() + "\n\nPlease select files with unique file names.", "Identical File Names!", 2);
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
                return false;
            }
        }
        return true;
    }

    private boolean validateMgfFile(File currentSpectrumFile, WaitingHandler waitingHandler) {
        boolean canceled = false;
        try {
            int result;
            Object[] options;
            this.spectrumFactory.addSpectra(currentSpectrumFile, waitingHandler);
            if (waitingHandler.isRunCanceled()) {
                return false;
            }
            File indexFile = new File(currentSpectrumFile.getParent(), currentSpectrumFile.getName() + ".cui");
            if (this.spectrumFactory.getIndex(indexFile).getSpectrumTitles().size() < this.spectrumFactory.getIndex(indexFile).getNSpectra()) {
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")));
                String errorText = this.spectrumFactory.getIndex(indexFile).getSpectrumTitles().isEmpty() ? "No spectrum titles found in file: " : "Spectrum titles missing in file: ";
                options = new Object[]{"Yes", "No", "Cancel"};
                result = JOptionPane.showOptionDialog(this, errorText + " '" + currentSpectrumFile.getName() + "'.\nSpectrum titles are mandatory in SearchGUI and PeptideShaker.\nAdd the missing spectrum titles?", "Spectrum Titles?", 1, 3, null, options, options[0]);
                if (result != 0) {
                    this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
                    return false;
                }
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
                progressDialog.setTitle("Adding Missing Spectrum Titles. Please Wait...");
                this.spectrumFactory.closeFiles();
                MgfReader.addMissingSpectrumTitles(currentSpectrumFile, waitingHandler);
                progressDialog.setTitle("Indexing File. Please Wait...");
                this.spectrumFactory.addSpectra(currentSpectrumFile, waitingHandler);
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
            }
            if (this.utilitiesUserPreferences.checkPeakPicking().booleanValue() && !this.spectrumFactory.getIndex(indexFile).isPeakPicked().booleanValue()) {
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")));
                int result2 = JOptionPane.showConfirmDialog(this, JOptionEditorPane.getJOptionEditorPane("The file '" + currentSpectrumFile.getName() + "' contains zero intensity peaks.<br><br>Please make sure that the file is peak picked.<br>See <a href=\"http://compomics.com/bioinformatics-for-proteomics\">Bioinformatics for Proteomics - Chapter 1.2</a> for more help.<br><br>Do you want to continue with this mgf file anyway?"), "Remove zero intensities?", 1);
                if (result2 != 0) {
                    this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
                    return false;
                }
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
                progressDialog.setTitle("Removing Zero Intensities. Please Wait...");
                this.spectrumFactory.closeFiles();
                MgfReader.removeZeroes(currentSpectrumFile, waitingHandler);
                progressDialog.setTitle("Indexing File. Please Wait...");
                this.spectrumFactory.addSpectra(currentSpectrumFile, waitingHandler);
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
            }
            if (canceled) {
                return false;
            }
            if (this.spectrumFactory.getIndex(indexFile).getMaxPeakCount() == 0) {
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")));
                JOptionPane.showMessageDialog(this, "No MS2 spectra found in file: " + currentSpectrumFile.getName() + "!\nFile will be ignored.", "No MS2 Spectra", 2);
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
                return false;
            }
            HashMap<String, Integer> duplicatedSpectrumTitles = this.spectrumFactory.getIndex(indexFile).getDuplicatedSpectrumTitles();
            if (this.utilitiesUserPreferences.checkDuplicateTitles().booleanValue() && duplicatedSpectrumTitles != null && duplicatedSpectrumTitles.size() > 0) {
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")));
                options = new Object[]{"Rename", "Delete", "Ignore"};
                result = JOptionPane.showOptionDialog(this, "The file '" + currentSpectrumFile.getAbsolutePath() + "' contains duplicate spectrum titles!\nExample: '" + duplicatedSpectrumTitles.keySet().iterator().next() + "'.\nFor the complete list see the SearchGUI log file.\n\nWe strongly recommend having unique spectrum titles. Fix duplicated titles?", "Duplicated Spectrum Titles", 1, 3, null, options, options[0]);
                switch (result) {
                    case 0: {
                        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
                        progressDialog.setTitle("Renaming Duplicated Spectrum Titles. Please Wait...");
                        this.spectrumFactory.closeFiles();
                        MgfReader.renameDuplicateSpectrumTitles(currentSpectrumFile, waitingHandler);
                        progressDialog.setTitle("Indexing File. Please Wait...");
                        this.spectrumFactory.addSpectra(currentSpectrumFile, waitingHandler);
                        break;
                    }
                    case 1: {
                        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
                        progressDialog.setTitle("Deleting Duplicated Spectrum Titles. Please Wait...");
                        this.spectrumFactory.closeFiles();
                        MgfReader.removeDuplicateSpectrumTitles(currentSpectrumFile, waitingHandler);
                        progressDialog.setTitle("Indexing File. Please Wait...");
                        this.spectrumFactory.addSpectra(currentSpectrumFile, waitingHandler);
                        break;
                    }
                }
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
            }
            if (this.utilitiesUserPreferences.isCheckSpectrumCharges().booleanValue() && this.spectrumFactory.getIndex(indexFile).isPrecursorChargesMissing().booleanValue()) {
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")));
                int value = JOptionPane.showConfirmDialog(this, "The file '" + currentSpectrumFile.getName() + "' contains spectra without precursor charges.\nSome search engines will ignore such spectra. Do you want to add a default range of charges?\n", "Missing Precursor Charges", 1, 3);
                switch (value) {
                    case 0: {
                        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
                        progressDialog.setTitle("Replacing Missing Charges. Please Wait...");
                        this.spectrumFactory.closeFiles();
                        MgfReader.addMissingPrecursorCharges(currentSpectrumFile, waitingHandler);
                        progressDialog.setTitle("Indexing File. Please Wait...");
                        this.spectrumFactory.addSpectra(currentSpectrumFile, waitingHandler);
                        break;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
                        return false;
                    }
                }
                this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")));
            }
        }
        catch (FileNotFoundException e) {
            canceled = true;
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Mgf File Error", 2);
        }
        catch (IOException e) {
            canceled = true;
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Mgf File Error", 2);
        }
        catch (ClassNotFoundException e) {
            canceled = true;
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "An error occurred while validating the mgf file: " + e.getMessage(), "Mgf Validation Error", 2);
        }
        catch (Exception e) {
            canceled = true;
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "An error occurred while validating the mgf file: " + e.getMessage(), "Mgf Validation Error", 2);
        }
        return !canceled;
    }

    private void verifyMgfFilesSize() {
        ArrayList<File> fatFiles = new ArrayList<File>();
        for (File file : this.mgfFiles) {
            if (file.length() <= (long)this.utilitiesUserPreferences.getMgfMaxSize() * 0x100000L) continue;
            fatFiles.add(file);
        }
        if (!fatFiles.isEmpty()) {
            String message = "";
            if (fatFiles.size() == 1) {
                message = message + "The file " + ((File)fatFiles.get(0)).getName() + "\nis rather large and can thus impair the search and parsing of the result files.\nSplit into smaller files?";
            } else if (fatFiles.size() <= 6) {
                message = message + "The files\n";
                for (File file : fatFiles) {
                    message = message + file.getName() + "\n";
                }
                message = message + " are rather large and can thus impair the search and parsing of the result files.\nSplit into smaller files?";
            } else {
                message = message + "Some files are rather large and can thus impair the search and parsing of the result files.\nSplit into smaller files?";
            }
            int n = JOptionPane.showConfirmDialog(this, message, "Large MGF Files", 0, 2);
            if (n == 0) {
                for (File file : fatFiles) {
                    String splittedName = file.getName().substring(0, file.getName().lastIndexOf("."));
                    String currentName = splittedName + MODIFICATION_USE_SEPARATOR + 1 + ".mgf";
                    File testFile = new File(file.getParent(), currentName);
                    if (!testFile.exists()) continue;
                    int n2 = JOptionPane.showConfirmDialog(this, "Split files seem to alredy exist. Overwrite existing mgf files?", "Existing MGF Files", 0, 2);
                    if (n2 == 0) break;
                    return;
                }
                this.splitFiles(fatFiles);
            }
        }
    }

    public void splitFiles(ArrayList<File> files) {
        progressDialog = new ProgressDialogX((Frame)this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")), true);
        progressDialog.setPrimaryProgressCounterIndeterminate(true);
        progressDialog.setTitle("Splitting MGF File(s). Please Wait...");
        final SearchGUI finalRef = this;
        final ArrayList<File> originalMgfFiles = new ArrayList<File>(files);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    progressDialog.setVisible(true);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }, "ProgressDialog").start();
        new Thread("SplitThread"){

            @Override
            public void run() {
                for (File originalFile : originalMgfFiles) {
                    int i;
                    ArrayList<MgfIndex> indexes;
                    if (progressDialog.isRunCanceled()) break;
                    progressDialog.setTitle("Splitting " + originalFile.getName() + ". Please Wait...");
                    progressDialog.setPrimaryProgressCounterIndeterminate(false);
                    try {
                        indexes = SearchGUI.this.mgfReader.splitFile(originalFile, SearchGUI.this.utilitiesUserPreferences.getMgfNSpectra(), progressDialog);
                    }
                    catch (FileNotFoundException e) {
                        progressDialog.setRunFinished();
                        JOptionPane.showMessageDialog(finalRef, new String[]{"Mgf Splitting Error.", "File " + originalFile.getName() + " not found."}, "Mgf Splitting Error", 2);
                        e.printStackTrace();
                        return;
                    }
                    catch (IOException e) {
                        progressDialog.setRunFinished();
                        JOptionPane.showMessageDialog(finalRef, new String[]{"Mgf Splitting Error.", "An error occurred while reading/writing the mgf file."}, "Mgf Splitting Error", 2);
                        e.printStackTrace();
                        return;
                    }
                    catch (OutOfMemoryError error) {
                        Runtime.getRuntime().gc();
                        progressDialog.setRunFinished();
                        JOptionPane.showMessageDialog(finalRef, "SearchGUI used up all the available memory and had to be stopped.\nMemory boundaries are set in the Edit menu (Edit > Java Options).", "Out Of Memory Error", 0);
                        System.out.println("Ran out of memory!");
                        error.printStackTrace();
                        return;
                    }
                    if (progressDialog.isRunCanceled()) {
                        progressDialog.setRunFinished();
                        return;
                    }
                    try {
                        if (indexes != null && !indexes.isEmpty()) {
                            progressDialog.setPrimaryProgressCounterIndeterminate(false);
                            progressDialog.setMaxPrimaryProgressCounter(indexes.size());
                            progressDialog.setTitle("Writing Indexes. Please Wait...");
                            for (i = 0; i < indexes.size() && !progressDialog.isRunCanceled(); ++i) {
                                SearchGUI.this.spectrumFactory.writeIndex(indexes.get(i), originalFile.getParentFile());
                                progressDialog.setValue(i);
                            }
                        }
                    }
                    catch (IOException e) {
                        progressDialog.setRunFinished();
                        JOptionPane.showMessageDialog(finalRef, new String[]{"MGF Splitting Error.", "An error occurred while writing an mgf index."}, "MGF Splitting Error", 2);
                        e.printStackTrace();
                        return;
                    }
                    if (progressDialog.isRunCanceled()) {
                        progressDialog.setRunFinished();
                        return;
                    }
                    SearchGUI.this.mgfFiles.remove(originalFile);
                    for (i = 0; i < indexes.size() && !progressDialog.isRunCanceled(); ++i) {
                        File newFile = new File(originalFile.getParent(), indexes.get(i).getFileName());
                        SearchGUI.this.mgfFiles.add(newFile);
                    }
                }
                if (progressDialog.isRunCanceled()) {
                    progressDialog.setRunFinished();
                } else {
                    progressDialog.setRunFinished();
                    SearchGUI.this.spectraFilesTxt.setText(SearchGUI.this.mgfFiles.size() + " file(s) selected");
                    JOptionPane.showMessageDialog(finalRef, "MGF file(s) split and selected.", "Files Split", 1);
                }
            }
        }.start();
    }

    public boolean settingsDisplayed() {
        return this.settingsTabDisplayed;
    }

    public void setSettingsDisplayed(boolean settingsDisplayed) {
        this.settingsTabDisplayed = settingsDisplayed;
    }

    public static void main(String[] args) {
        boolean numbusLookAndFeelSet = false;
        try {
            numbusLookAndFeelSet = UtilitiesGUIDefaults.setLookAndFeel();
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            UIDefaults defaults = lookAndFeel.getDefaults();
            defaults.put("ScrollBar.minimumThumbSize", new Dimension(30, 30));
        }
        catch (Exception lookAndFeel) {
            // empty catch block
        }
        if (!numbusLookAndFeelSet) {
            JOptionPane.showMessageDialog(null, "Failed to set the default look and feel. Using backup look and feel.\nSearchGUI will work but not look as good as it should...", "Look and Feel", 2);
        }
        if (!System.getProperty("java.version").startsWith("1.6")) {
            TITLED_BORDER_HORIZONTAL_PADDING = "   ";
        }
        ArrayList<File> spectrumFiles = null;
        ArrayList<File> rawFiles = null;
        File searchParametersFile = null;
        File outputFolder = null;
        String currentSpecies = null;
        String currentSpeciesType = null;
        String currentProjectName = null;
        boolean spectrum = false;
        boolean raw = false;
        boolean parameters = false;
        boolean output = false;
        boolean species = false;
        boolean speciesType = false;
        boolean projectName = false;
        for (String arg : args) {
            ArrayList<String> extensions;
            if (spectrum) {
                try {
                    extensions = new ArrayList<String>();
                    extensions.add(".mgf");
                    spectrumFiles = CommandLineUtils.getFiles(arg, extensions);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Failed importing spectrum files from command line option " + arg + ".", "Spectrum Files", 2);
                    e.printStackTrace();
                }
                spectrum = false;
            }
            if (raw) {
                try {
                    extensions = new ArrayList();
                    for (MsFormat format : MsFormat.values()) {
                        if (format == MsFormat.mgf) continue;
                        extensions.add(format.fileNameEnding);
                    }
                    rawFiles = CommandLineUtils.getFiles(arg, extensions);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Failed importing raw files from command line option " + arg + ".", "Raw Files", 2);
                    e.printStackTrace();
                }
                raw = false;
            }
            if (parameters) {
                searchParametersFile = new File(arg);
                try {
                    IdentificationParameters.getIdentificationParameters(searchParametersFile);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Failed to import search parameters from: " + searchParametersFile.getAbsolutePath() + ".", "Search Parameters", 2);
                    e.printStackTrace();
                }
                parameters = false;
            }
            if (output) {
                outputFolder = new File(arg);
                output = false;
            }
            if (species) {
                currentSpecies = arg;
                species = false;
            }
            if (speciesType) {
                currentSpeciesType = arg;
                speciesType = false;
            }
            if (projectName) {
                currentProjectName = arg;
                projectName = false;
            }
            if (arg.equals("-mgf")) {
                spectrum = true;
            }
            if (arg.equals("-raw")) {
                raw = true;
            }
            if (arg.equals("-identification_parameters")) {
                parameters = true;
            }
            if (arg.equals("-output_folder")) {
                output = true;
            }
            if (arg.equals("-species")) {
                species = true;
            }
            if (arg.equals("-species_type")) {
                speciesType = true;
            }
            if (!arg.equals("-project_name")) continue;
            projectName = true;
        }
        new SearchGUI(spectrumFiles, rawFiles, searchParametersFile, outputFolder, currentSpecies, currentSpeciesType, currentProjectName);
    }

    public LastSelectedFolder getLastSelectedFolder() {
        if (this.lastSelectedFolder == null) {
            this.lastSelectedFolder = new LastSelectedFolder();
            this.utilitiesUserPreferences.setLastSelectedFolder(this.lastSelectedFolder);
        }
        return this.lastSelectedFolder;
    }

    public void setLastSelectedFolder(LastSelectedFolder lastSelectedFolder) {
        this.lastSelectedFolder = lastSelectedFolder;
    }

    private void addShortcutAtDeskTop() {
        String jarFilePath = this.getJarFilePath();
        String versionNumber = new Properties().getVersion();
        if (!jarFilePath.equalsIgnoreCase(".")) {
            if (jarFilePath.startsWith("\\") && !jarFilePath.startsWith("\\\\")) {
                jarFilePath = jarFilePath.substring(1);
            }
            String iconFileLocation = jarFilePath + "\\resources\\searchgui.ico";
            String jarFileLocation = jarFilePath + "\\SearchGUI-" + versionNumber + ".jar";
            try {
                JShellLink link = new JShellLink();
                link.setFolder(JShellLink.getDirectory((String)"desktop"));
                link.setName("SearchGUI " + versionNumber);
                link.setIconLocation(iconFileLocation);
                link.setPath(jarFileLocation);
                link.save();
            }
            catch (Exception e) {
                System.out.println("An error occurred when trying to create a desktop shortcut...");
                e.printStackTrace();
            }
        }
    }

    private void setUpLogFile() {
        if (useLogFile && !this.getJarFilePath().equalsIgnoreCase(".")) {
            try {
                String path = this.getJarFilePath() + "/resources/SearchGUI.log";
                File file = new File(path);
                System.setOut(new PrintStream(new FileOutputStream(file, true)));
                System.setErr(new PrintStream(new FileOutputStream(file, true)));
                if (!file.exists()) {
                    boolean fileCreated = file.createNewFile();
                    if (fileCreated) {
                        FileWriter w = new FileWriter(file);
                        BufferedWriter bw = new BufferedWriter(w);
                        bw.close();
                        w.close();
                    } else {
                        JOptionPane.showMessageDialog(this, "Failed to create the file log file.\nPlease contact the developers.", "File Error", 0);
                    }
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "An error occurred when trying to create the SearchGUI log file.", "Error Creating Log File", 0);
                e.printStackTrace();
            }
        }
    }

    public void startSearch() {
        if (this.validateInput(true)) {
            this.waitingDialog = new WaitingDialog(this, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")), false, this.getTips(), "Search", "SearchGUI", new Properties().getVersion(), true);
            this.waitingDialog.addWaitingActionListener(new WaitingActionListener(){

                @Override
                public void cancelPressed() {
                    SearchGUI.this.searchHandler.cancelSearch();
                }
            });
            this.waitingDialog.setLocationRelativeTo(this);
            try {
                this.searchHandler.startSearch(this.waitingDialog);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private static void deleteTempFolders() {
        try {
            TempFilesManager.deleteTempFolders();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveConfigurationFile() {
        File folder = new File(this.getJarFilePath() + File.separator + "resources" + File.separator + "conf" + File.separator);
        if (!folder.exists()) {
            JOptionPane.showMessageDialog(this, new String[]{"Unable to find folder: '" + folder.getAbsolutePath() + "'!", "Could not save search engine locations."}, "Folder Not Found", 2);
        } else {
            File output = new File(folder, "searchGUI_configuration.txt");
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(output));
                bw.write("OMSSA Location:" + System.getProperty("line.separator"));
                bw.write(this.searchHandler.getOmssaLocation() + System.getProperty("line.separator") + this.searchHandler.isOmssaEnabled() + System.getProperty("line.separator"));
                bw.write("X!Tandem Location:" + System.getProperty("line.separator"));
                bw.write(this.searchHandler.getXtandemLocation() + System.getProperty("line.separator") + this.searchHandler.isXtandemEnabled() + System.getProperty("line.separator"));
                bw.write("MS-GF+ Location:" + System.getProperty("line.separator"));
                bw.write(this.searchHandler.getMsgfLocation() + System.getProperty("line.separator") + this.searchHandler.isMsgfEnabled() + System.getProperty("line.separator"));
                bw.write("MS Amanda Location:" + System.getProperty("line.separator"));
                bw.write(this.searchHandler.getMsAmandaLocation() + System.getProperty("line.separator") + this.searchHandler.isMsAmandaEnabled() + System.getProperty("line.separator"));
                bw.write("MyriMatch Location:" + System.getProperty("line.separator"));
                bw.write(this.searchHandler.getMyriMatchLocation() + System.getProperty("line.separator") + this.searchHandler.isMyriMatchEnabled() + System.getProperty("line.separator"));
                bw.write("Comet Location:" + System.getProperty("line.separator"));
                bw.write(this.searchHandler.getCometLocation() + System.getProperty("line.separator") + this.searchHandler.isCometEnabled() + System.getProperty("line.separator"));
                bw.write("Tide Location:" + System.getProperty("line.separator"));
                bw.write(this.searchHandler.getTideLocation() + System.getProperty("line.separator") + this.searchHandler.isTideEnabled() + System.getProperty("line.separator"));
                bw.write("Andromeda Location:" + System.getProperty("line.separator"));
                bw.write(this.searchHandler.getAndromedaLocation() + System.getProperty("line.separator") + this.searchHandler.isAndromedaEnabled() + System.getProperty("line.separator"));
                bw.write("Novor Location:" + System.getProperty("line.separator"));
                bw.write(this.searchHandler.getNovorLocation() + System.getProperty("line.separator") + this.searchHandler.isNovorEnabled() + System.getProperty("line.separator"));
                bw.write("DirecTag Location:" + System.getProperty("line.separator"));
                bw.write(this.searchHandler.getDirecTagLocation() + System.getProperty("line.separator") + this.searchHandler.isDirecTagEnabled() + System.getProperty("line.separator"));
                bw.write("makeblastdb Location:" + System.getProperty("line.separator"));
                bw.write(this.searchHandler.getMakeblastdbLocation() + System.getProperty("line.separator") + System.getProperty("line.separator"));
                bw.write("Modification use:" + System.getProperty("line.separator"));
                bw.write(this.getModificationUseAsString() + System.getProperty("line.separator"));
                bw.flush();
                bw.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                JOptionPane.showMessageDialog(this, new String[]{"Unable to write file: '" + ioe.getMessage() + "'!", "Could not save search engine locations."}, "Search Engine Location Error", 2);
            }
        }
    }

    public SearchHandler getSearchHandler() {
        return this.searchHandler;
    }

    public void enableSearchEngines(boolean enableOmssa, boolean enbleXTandem, boolean enableMsgf, boolean enableMsAmanda, boolean enableMyriMatch, boolean enableComet, boolean enableTide, boolean enableAndromeda, boolean enableNovor, boolean enableDirecTag) {
        this.enableOmssaJCheckBox.setSelected(enableOmssa);
        this.enableXTandemJCheckBox.setSelected(enbleXTandem);
        this.enableMsgfJCheckBox.setSelected(enableMsgf);
        this.enableMsAmandaJCheckBox.setSelected(enableMsAmanda);
        this.enableMyriMatchJCheckBox.setSelected(enableMyriMatch);
        this.enableCometJCheckBox.setSelected(enableComet);
        this.enableTideJCheckBox.setSelected(enableTide);
        this.enableAndromedaJCheckBox.setSelected(enableAndromeda);
        this.enableNovorJCheckBox.setSelected(enableNovor);
        this.enableDirecTagJCheckBox.setSelected(enableDirecTag);
        this.searchHandler.setOmssaEnabled(enableOmssa);
        this.searchHandler.setXtandemEnabled(enbleXTandem);
        this.searchHandler.setMsgfEnabled(enableMsgf);
        this.searchHandler.setMsAmandaEnabled(enableMsAmanda);
        this.searchHandler.setMyriMatchEnabled(enableMyriMatch);
        this.searchHandler.setCometEnabled(enableComet);
        this.searchHandler.setTideEnabled(enableTide);
        this.searchHandler.setAndromedaEnabled(enableAndromeda);
        this.searchHandler.setNovorEnabled(enableNovor);
        this.searchHandler.setDirecTagEnabled(enableDirecTag);
        this.validateInput(false);
    }

    public IdentificationParameters getIdentificationParameters() {
        return this.identificationParameters;
    }

    public void setIdentificationParameters(IdentificationParameters identificationParameters) {
        this.identificationParameters = identificationParameters;
        Vector<String> parameterList = new Vector<String>();
        parameterList.add("-- Select --");
        for (String tempParameters : this.identificationParametersFactory.getParametersList()) {
            parameterList.add(tempParameters);
        }
        this.settingsComboBox.setModel(new DefaultComboBoxModel(parameterList));
        this.settingsComboBox.setSelectedItem(identificationParameters.getName());
        this.validateInput(false);
    }

    public String getJarFilePath() {
        return CompomicsWrapper.getJarFilePath(this.getClass().getResource("SearchGUI.class").getPath(), "SearchGUI");
    }

    public void setPathConfiguration() throws IOException {
        File pathConfigurationFile = new File(this.getJarFilePath(), "resources/conf/paths.txt");
        if (pathConfigurationFile.exists()) {
            SearchGUIPathPreferences.loadPathPreferencesFromFile(pathConfigurationFile);
        }
    }

    @Override
    public void restart() {
        this.dispose();
        new SearchGUIWrapper();
        System.exit(0);
    }

    @Override
    public UtilitiesUserPreferences getUtilitiesUserPreferences() {
        return this.utilitiesUserPreferences;
    }

    private void loadModificationUse(String aLine) {
        int start;
        ArrayList<String> modificationUses = new ArrayList<String>();
        while ((start = aLine.indexOf(MODIFICATION_SEPARATOR)) >= 0) {
            String name = aLine.substring(0, start);
            aLine = aLine.substring(start + 2);
            if (name.trim().equals("")) continue;
            modificationUses.add(name);
        }
        for (String name : modificationUses) {
            start = name.indexOf(MODIFICATION_USE_SEPARATOR);
            String modificationName = name;
            if (start != -1) {
                modificationName = name.substring(0, start);
            }
            if (!this.ptmFactory.containsPTM(modificationName)) continue;
            this.modificationUse.add(modificationName);
        }
    }

    public String getModificationUseAsString() {
        String result = "";
        for (String name : this.modificationUse) {
            result = result + name + MODIFICATION_SEPARATOR;
        }
        return result;
    }

    public ArrayList<String> getModificationUse() {
        return this.modificationUse;
    }

    public static boolean validateSearchEngineInstallation(Advocate advocate, File searchEngineLocation, boolean feedBackInDialog) {
        if (advocate == Advocate.omssa) {
            return SearchGUI.validateSearchEngineInstallation(Advocate.omssa, "omssacl", "-ml", null, searchEngineLocation, null, false, feedBackInDialog);
        }
        if (advocate == Advocate.xtandem) {
            return SearchGUI.validateSearchEngineInstallation(Advocate.xtandem, "tandem", null, null, searchEngineLocation, null, false, feedBackInDialog);
        }
        if (advocate == Advocate.msgf) {
            return SearchGUI.validateSearchEngineInstallation(Advocate.msgf, "MSGFPlus.jar", null, null, searchEngineLocation, null, true, feedBackInDialog);
        }
        if (advocate == Advocate.msAmanda) {
            String operatingSystem = System.getProperty("os.name").toLowerCase();
            String mono = null;
            if (!operatingSystem.contains("windows")) {
                mono = "mono";
            }
            return SearchGUI.validateSearchEngineInstallation(Advocate.msAmanda, "MSAmanda.exe", null, mono, searchEngineLocation, null, false, feedBackInDialog, msAmandaErrorMessage);
        }
        if (advocate == Advocate.myriMatch) {
            return SearchGUI.validateSearchEngineInstallation(Advocate.myriMatch, "myrimatch", null, null, searchEngineLocation, "Usage: \"myrimatch\"", false, feedBackInDialog);
        }
        if (advocate == Advocate.comet) {
            return SearchGUI.validateSearchEngineInstallation(Advocate.comet, "comet.exe", null, null, searchEngineLocation, null, false, feedBackInDialog);
        }
        if (advocate == Advocate.tide) {
            return SearchGUI.validateSearchEngineInstallation(Advocate.tide, "crux", null, null, searchEngineLocation, null, false, feedBackInDialog);
        }
        if (advocate == Advocate.andromeda) {
            return SearchGUI.validateSearchEngineInstallation(Advocate.andromeda, "AndromedaCmd.exe", null, null, searchEngineLocation, null, false, feedBackInDialog);
        }
        if (advocate == Advocate.novor) {
            return SearchGUI.validateSearchEngineInstallation(Advocate.novor, "novor.jar", null, null, searchEngineLocation, null, true, feedBackInDialog);
        }
        if (advocate == Advocate.direcTag) {
            return SearchGUI.validateSearchEngineInstallation(Advocate.direcTag, "directag", null, null, searchEngineLocation, "Usage: \"directag\"", false, feedBackInDialog);
        }
        return false;
    }

    private static boolean validateSearchEngineInstallation(Advocate advocate, String executable, String executableOption, String executableWrapper, File searchEngineLocation, String ignorableOutput, boolean isJava, boolean feedBackInDialog) {
        return SearchGUI.validateSearchEngineInstallation(advocate, executable, executableOption, executableWrapper, searchEngineLocation, ignorableOutput, isJava, feedBackInDialog, null);
    }

    private static boolean validateSearchEngineInstallation(Advocate advocate, String executable, String executableOption, String executableWrapper, File searchEngineLocation, String ignorableOutput, boolean isJava, boolean feedBackInDialog, String customErrorMessage) {
        boolean error = false;
        if (searchEngineLocation != null) {
            try {
                ArrayList<String> process_name_array = new ArrayList<String>();
                if (isJava) {
                    UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
                    CompomicsWrapper wrapper = new CompomicsWrapper();
                    if (utilitiesUserPreferences.getSearchGuiPath() != null) {
                        ArrayList<String> javaHomeAndOptions = wrapper.getJavaHomeAndOptions(utilitiesUserPreferences.getSearchGuiPath());
                        process_name_array.add(javaHomeAndOptions.get(0));
                    } else {
                        process_name_array.add("java");
                    }
                    process_name_array.add("-jar");
                }
                if (executableWrapper != null) {
                    process_name_array.add(executableWrapper);
                }
                process_name_array.add(searchEngineLocation + File.separator + executable);
                if (executableOption != null) {
                    process_name_array.add(executableOption);
                }
                ProcessBuilder pb = new ProcessBuilder(process_name_array);
                pb.directory(searchEngineLocation);
                Process p = pb.start();
                InputStream stderr = p.getErrorStream();
                InputStreamReader isr = new InputStreamReader(stderr);
                BufferedReader br = new BufferedReader(isr);
                String errorMessage = "";
                if (br.ready()) {
                    String line = br.readLine();
                    while (line != null) {
                        System.out.println(line);
                        errorMessage = errorMessage + line + "\n";
                        line = br.readLine();
                        error = true;
                    }
                }
                br.close();
                isr.close();
                stderr.close();
                if (ignorableOutput != null && errorMessage.contains(ignorableOutput)) {
                    error = false;
                }
                if (error) {
                    System.out.println(advocate + " startup error: " + errorMessage);
                    if (feedBackInDialog) {
                        if (customErrorMessage != null) {
                            JOptionPane.showMessageDialog(null, JOptionEditorPane.getJOptionEditorPane(customErrorMessage), advocate + " - Startup Failed", 1);
                        } else {
                            JOptionPane.showMessageDialog(null, JOptionEditorPane.getJOptionEditorPane(SearchGUI.getDefaultSearchEngineStartupErrorMessage(advocate.getName())), advocate + " - Startup Failed", 1);
                        }
                    }
                } else {
                    p.destroy();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                error = true;
                if (feedBackInDialog) {
                    if (customErrorMessage != null) {
                        JOptionPane.showMessageDialog(null, JOptionEditorPane.getJOptionEditorPane(customErrorMessage), advocate + " - Startup Failed", 1);
                    } else {
                        JOptionPane.showMessageDialog(null, JOptionEditorPane.getJOptionEditorPane(SearchGUI.getDefaultSearchEngineStartupErrorMessage(advocate.getName())), advocate + " - Startup Failed", 1);
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                System.exit(0);
            }
        }
        return !error;
    }

    private static String getDefaultSearchEngineStartupErrorMessage(String searchEngineName) {
        return "Make sure that " + searchEngineName + " is installed correctly and that you have selected<br>the correct version of " + searchEngineName + " for your system. See the <a href=\"http://compomics.github.io/projects/searchgui.html#troubleshooting\">TroubleShooting</a><br>section at the SearchGUI web page for help, and the SearchGUI<br>log for details about the error.";
    }

    public ArrayList<String> getTips() {
        ArrayList<String> tips;
        try {
            String line;
            InputStream stream = this.getClass().getResource("/tips.txt").openStream();
            InputStreamReader streamReader = new InputStreamReader(stream);
            BufferedReader b = new BufferedReader(streamReader);
            tips = new ArrayList();
            while ((line = b.readLine()) != null) {
                tips.add(line);
            }
            b.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "An error occurred when reading the tip of the day.", "File Error", 0);
            e.printStackTrace();
            tips = new ArrayList<String>();
        }
        return tips;
    }

    public boolean checkForNewVersion() {
        try {
            File jarFile = new File(SearchGUI.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            MavenJarFile oldMavenJarFile = new MavenJarFile(jarFile.toURI());
            URL jarRepository = new URL("http", "genesis.ugent.be", "/maven2/");
            return CompomicsWrapper.checkForNewDeployedVersion("SearchGUI", oldMavenJarFile, jarRepository, "searchgui.ico", false, true, true, Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui.gif")), Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/icons/searchgui-orange.gif")), true);
        }
        catch (UnknownHostException ex) {
            System.out.println("Checking for new version failed. No internet connection.");
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void openPeptideShakerSettings(boolean openAlways) {
        boolean checkPeptideShaker = true;
        if (this.peptideShakerCheckBox.isSelected()) {
            OmssaParameters omssaParameters = (OmssaParameters)this.identificationParameters.getSearchParameters().getIdentificationAlgorithmParameter(Advocate.omssa.getIndex());
            if (this.enableOmssaJCheckBox.isSelected() && !omssaParameters.getSelectedOutput().equals("OMX")) {
                JOptionPane.showMessageDialog(this, JOptionEditorPane.getJOptionEditorPane("The selected OMSSA output format is not compatible with <a href=\"http://compomics.github.io/projects/peptide-shaker.html\">PeptideShaker</a>. Please change to the<br>OMSSA OMX format in the Advanced Settings, or disable OMSSA or <a href=\"http://compomics.github.io/projects/peptide-shaker.html\">PeptideShaker</a>."), "Format Warning", 0);
                this.peptideShakerCheckBox.setSelected(false);
                checkPeptideShaker = false;
            }
        }
        if (this.peptideShakerCheckBox.isSelected() && checkPeptideShaker || openAlways) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    block7: {
                        if (SearchGUI.this.utilitiesUserPreferences.getPeptideShakerPath() == null || !new File(SearchGUI.this.utilitiesUserPreferences.getPeptideShakerPath()).exists()) {
                            try {
                                PeptideShakerSetupDialog peptideShakerSetupDialog = new PeptideShakerSetupDialog(SearchGUI.this, true);
                                boolean canceled = peptideShakerSetupDialog.isDialogCanceled();
                                if (!canceled) {
                                    try {
                                        SearchGUI.this.utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
                                    }
                                    catch (Exception e) {
                                        JOptionPane.showMessageDialog(null, "An error occurred when reading the user preferences.", "File Error", 0);
                                        e.printStackTrace();
                                    }
                                    SearchGUI.this.editPeptideShakerSettings();
                                    break block7;
                                }
                                SearchGUI.this.peptideShakerCheckBox.setSelected(false);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            SearchGUI.this.editPeptideShakerSettings();
                        }
                    }
                }
            }, "PeptideShakerDownload").start();
        }
    }

    public boolean editProteoWizardInstallation() {
        boolean canceled = false;
        try {
            ProteoWizardSetupDialog proteoWizardSetupDialog = new ProteoWizardSetupDialog(this, true);
            canceled = proteoWizardSetupDialog.isDialogCanceled();
            if (!canceled) {
                try {
                    this.utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "An error occurred when reading the user preferences.", "File Error", 0);
                    e.printStackTrace();
                }
            } else {
                this.msconvertCheckBox.setSelected(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return !canceled;
    }

    private void checkProteoWizard() {
        boolean folderSet;
        if (!this.rawFiles.isEmpty() && this.utilitiesUserPreferences.getProteoWizardPath() == null && !(folderSet = this.editProteoWizardInstallation())) {
            JOptionPane.showMessageDialog(this, "ProteoWizard folder not set. Raw file(s) not selected.", "Raw File Error", 2);
            this.rawFiles.clear();
        }
    }

    private void enableMsConvertPanel() {
        this.msconvertSettingsButton.setEnabled(!this.rawFiles.isEmpty());
        this.msconvertCheckBox.setEnabled(!this.rawFiles.isEmpty());
        this.msconvertButton.setEnabled(!this.rawFiles.isEmpty());
        this.msconvertLabel.setEnabled(!this.rawFiles.isEmpty());
        this.msconvertCheckBox.setSelected(!this.rawFiles.isEmpty());
    }

    private void enableSearchEngineAndDeNovoPanels(boolean enable) {
        this.xtandemSettingsButton.setEnabled(enable);
        this.msAmandaSettingsButton.setEnabled(enable);
        this.msgfSettingsButton.setEnabled(enable);
        this.omssaSettingsButton.setEnabled(enable);
        this.tideSettingsButton.setEnabled(enable);
        this.enableXTandemJCheckBox.setEnabled(enable);
        this.enableMsAmandaJCheckBox.setEnabled(enable);
        this.enableMsgfJCheckBox.setEnabled(enable);
        this.enableOmssaJCheckBox.setEnabled(enable);
        this.enableTideJCheckBox.setEnabled(enable);
        this.xtandemButton.setEnabled(enable);
        this.msAmandaButton.setEnabled(enable);
        this.msgfButton.setEnabled(enable);
        this.omssaButton.setEnabled(enable);
        this.tideButton.setEnabled(enable);
        this.xtandemLinkLabel.setEnabled(enable);
        this.msAmandaLinkLabel.setEnabled(enable);
        this.msgfLinkLabel.setEnabled(enable);
        this.omssaLinkLabel.setEnabled(enable);
        this.tideLinkLabel.setEnabled(enable);
        this.novorSettingsButton.setEnabled(enable);
        this.enableNovorJCheckBox.setEnabled(enable);
        this.novorButton.setEnabled(enable);
        this.novorLinkLabel.setEnabled(enable);
        this.peptideShakerSettingsButton.setEnabled(enable);
        this.peptideShakerCheckBox.setEnabled(enable);
        this.peptideShakerButton.setEnabled(enable);
        this.peptideShakerLabel.setEnabled(enable);
        String operatingSystem = System.getProperty("os.name").toLowerCase();
        if (!operatingSystem.contains("mac os")) {
            this.myriMatchSettingsButton.setEnabled(enable);
            this.myriMatchButton.setEnabled(enable);
            this.myriMatchLinkLabel.setEnabled(enable);
            this.enableMyriMatchJCheckBox.setEnabled(enable);
            this.cometSettingsButton.setEnabled(enable);
            this.enableCometJCheckBox.setEnabled(enable);
            this.cometButton.setEnabled(enable);
            this.cometLinkLabel.setEnabled(enable);
            this.direcTagSettingsButton.setEnabled(enable);
            this.direcTagButton.setEnabled(enable);
            this.direcTagLinkLabel.setEnabled(enable);
            this.enableDirecTagJCheckBox.setEnabled(enable);
        }
        if (operatingSystem.contains("windows")) {
            this.andromedaSettingsButton.setEnabled(enable);
            this.enableAndromedaJCheckBox.setEnabled(enable);
            this.andromedaButton.setEnabled(enable);
            this.andromedaLinkLabel.setEnabled(enable);
        }
    }

    static {
        TITLED_BORDER_HORIZONTAL_PADDING = "";
        useLogFile = true;
        msAmandaErrorMessage = "Make sure that MS Amanda is installed correctly and that you have selected<br>the correct version of MS Amanda for your system. Note that for Mac and Linux<br><a href=\"http://www.mono-project.com/download/\">Mono</a> has to be installed. See the <a href=\"http://compomics.github.io/projects/searchgui.html#troubleshooting\">TroubleShooting</a> section at the SearchGUI<br>web page for help, and the SearchGUI log for details about the error.";
    }
}

