/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.preferences;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.settings.PathKey;
import com.compomics.software.settings.UtilitiesPathPreferences;
import eu.isas.searchgui.SearchHandler;
import eu.isas.searchgui.processbuilders.AndromedaProcessBuilder;
import eu.isas.searchgui.processbuilders.CometProcessBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class SearchGUIPathPreferences {
    public static void loadPathPreferencesFromFile(File inputFile) throws FileNotFoundException, IOException {
        BufferedReader br = new BufferedReader(new FileReader(inputFile));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                SearchGUIPathPreferences.loadPathPreferenceFromLine(line);
            }
        }
        finally {
            br.close();
        }
    }

    public static void loadPathPreferenceFromLine(String line) throws FileNotFoundException {
        String id = UtilitiesPathPreferences.getPathID(line);
        if (id.equals("")) {
            throw new IllegalArgumentException("Impossible to parse path in " + line + ".");
        }
        SearchGUIPathKey searchGUIPathKey = SearchGUIPathKey.getKeyFromId(id);
        if (searchGUIPathKey == null) {
            UtilitiesPathPreferences.loadPathPreferenceFromLine(line);
        } else {
            String path = UtilitiesPathPreferences.getPath(line);
            if (!path.equals("default")) {
                File file = new File(path);
                if (!file.exists()) {
                    throw new FileNotFoundException("File " + path + " not found.");
                }
                if (searchGUIPathKey.isDirectory && !file.isDirectory()) {
                    throw new FileNotFoundException("Found a file when expecting a directory for " + searchGUIPathKey.id + ".");
                }
                SearchGUIPathPreferences.setPathPreference(searchGUIPathKey, path);
            }
        }
    }

    public static void setPathPreference(SearchGUIPathKey searchGUIPathKey, String path) {
        switch (searchGUIPathKey) {
            case tempDirectory: {
                SearchHandler.setTempFolderPath(path);
                break;
            }
            case cometDirectory: {
                CometProcessBuilder.setTempFolder(path);
                break;
            }
            case andromedaDirectory: {
                AndromedaProcessBuilder.setTempFolderPath(path);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Path " + searchGUIPathKey.id + " not implemented.");
            }
        }
    }

    public static void setPathPreference(PathKey pathKey, String path) {
        if (pathKey instanceof SearchGUIPathKey) {
            SearchGUIPathPreferences.setPathPreference((SearchGUIPathKey)pathKey, path);
        } else if (pathKey instanceof UtilitiesPathPreferences.UtilitiesPathKey) {
            UtilitiesPathPreferences.UtilitiesPathKey utilitiesPathKey = (UtilitiesPathPreferences.UtilitiesPathKey)pathKey;
            UtilitiesPathPreferences.setPathPreference(utilitiesPathKey, path);
        } else {
            throw new UnsupportedOperationException("Path " + pathKey.getId() + " not implemented.");
        }
    }

    public static String getPathPreference(SearchGUIPathKey searchGUIPathKey, String jarFilePath) {
        switch (searchGUIPathKey) {
            case tempDirectory: {
                return SearchHandler.getTempFolderPath(jarFilePath);
            }
            case cometDirectory: {
                return CometProcessBuilder.getTempFolder();
            }
            case andromedaDirectory: {
                return AndromedaProcessBuilder.getTempFolderPath();
            }
        }
        throw new UnsupportedOperationException("Path " + searchGUIPathKey.id + " not implemented.");
    }

    public static void setAllPathsIn(String path) throws FileNotFoundException {
        for (SearchGUIPathKey searchGUIPathKey : SearchGUIPathKey.values()) {
            String subDirectory = searchGUIPathKey.defaultSubDirectory;
            File newFile = new File(path, subDirectory);
            if (!newFile.exists()) {
                newFile.mkdirs();
            }
            if (!newFile.exists()) {
                throw new FileNotFoundException(newFile.getAbsolutePath() + " could not be created.");
            }
            SearchGUIPathPreferences.setPathPreference(searchGUIPathKey, newFile.getAbsolutePath());
        }
        UtilitiesPathPreferences.setAllPathsIn(path);
    }

    public static void writeConfigurationToFile(File file, String jarFilePath) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        try {
            SearchGUIPathPreferences.writeConfigurationToFile(bw, jarFilePath);
        }
        finally {
            bw.close();
        }
    }

    public static void writeConfigurationToFile(BufferedWriter bw, String jarFilePath) throws IOException {
        for (SearchGUIPathKey pathKey : SearchGUIPathKey.values()) {
            SearchGUIPathPreferences.writePathToFile(bw, pathKey, jarFilePath);
        }
        UtilitiesPathPreferences.writeConfigurationToFile(bw);
    }

    public static void writePathToFile(BufferedWriter bw, SearchGUIPathKey pathKey, String jarFilePath) throws IOException {
        bw.write(pathKey.id + "=");
        switch (pathKey) {
            case tempDirectory: {
                String toWrite = SearchHandler.getTempFolderPath(jarFilePath);
                if (toWrite == null) {
                    toWrite = "default";
                }
                bw.write(toWrite);
                break;
            }
            case cometDirectory: {
                String toWrite = CometProcessBuilder.getTempFolder();
                if (toWrite == null) {
                    toWrite = "default";
                }
                bw.write(toWrite);
                break;
            }
            case andromedaDirectory: {
                String toWrite = AndromedaProcessBuilder.getTempFolderPath();
                if (toWrite == null) {
                    toWrite = "default";
                }
                bw.write(toWrite);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Path " + pathKey.id + " not implemented.");
            }
        }
        bw.newLine();
    }

    public static ArrayList<PathKey> getErrorKeys(String jarFilePath) throws IOException {
        ArrayList<PathKey> result = new ArrayList<PathKey>();
        for (SearchGUIPathKey pathKey : SearchGUIPathKey.values()) {
            String folder = SearchGUIPathPreferences.getPathPreference(pathKey, jarFilePath);
            if (folder == null || UtilitiesPathPreferences.testPath(folder)) continue;
            result.add(pathKey);
        }
        result.addAll(UtilitiesPathPreferences.getErrorKeys());
        return result;
    }

    public String getJarFilePath() {
        return CompomicsWrapper.getJarFilePath(this.getClass().getResource("SearchGUIPathPreferences.class").getPath(), "SearchGUI");
    }

    public static enum SearchGUIPathKey implements PathKey
    {
        tempDirectory("searchgui_temp", "Folder where SearchGUI temporary files are stored.", "", true),
        cometDirectory("comet_temp", "Folder where Comet temporary files are stored.", "", true),
        andromedaDirectory("andromeda_temp", "Folder where Andromeda temporary files are stored.", "", true);

        private String id;
        private String description;
        private String defaultSubDirectory;
        private boolean isDirectory;

        private SearchGUIPathKey(String id, String description, String defaultSubDirectory, boolean isDirectory) {
            this.id = id;
            this.description = description;
            this.defaultSubDirectory = defaultSubDirectory;
            this.isDirectory = isDirectory;
        }

        public static SearchGUIPathKey getKeyFromId(String id) {
            for (SearchGUIPathKey pathKey : SearchGUIPathKey.values()) {
                if (!pathKey.id.equals(id)) continue;
                return pathKey;
            }
            return null;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

