/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.util.Util;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.EnzymeFactory;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.CometParameters;
import com.compomics.util.preferences.DigestionPreferences;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class CometProcessBuilder
extends SearchGUIProcessBuilder {
    private File cometFolder;
    private static String cometTempFolderPath;
    private static String cometTempSubFolderName;
    public static final String EXECUTABLE_FILE_NAME = "comet.exe";
    private final String COMET_VERSION = "2018.01";
    private File spectrumFile;
    private SearchParameters searchParameters;
    private CometParameters cometParameters;
    private int nThreads;
    private PTMFactory ptmFactory = PTMFactory.getInstance();
    private Double refMass;

    public CometProcessBuilder(File cometFolder, SearchParameters searchParameters, File spectrumFile, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, int nThreads, Double refMass) throws IOException {
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.cometFolder = cometFolder;
        this.searchParameters = searchParameters;
        this.cometParameters = (CometParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.comet.getIndex());
        this.spectrumFile = spectrumFile;
        this.nThreads = nThreads;
        this.refMass = refMass;
        this.createParametersFile();
        File comet = new File(cometFolder.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        comet.setExecutable(true);
        this.process_name_array.add(comet.getAbsolutePath());
        if (cometTempFolderPath != null && !cometFolder.getAbsolutePath().equalsIgnoreCase(cometTempFolderPath)) {
            String path = new File(cometTempFolderPath, "comet.params").getPath();
            this.process_name_array.add("-P" + path);
        }
        this.process_name_array.add(spectrumFile.getAbsolutePath());
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "comet command: ");
        for (Object currentElement : this.process_name_array) {
            System.out.print(currentElement + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(cometFolder);
        this.pb.redirectErrorStream(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createParametersFile() throws IOException {
        File cometTempFolder = cometTempFolderPath == null ? this.cometFolder : new File(cometTempFolderPath);
        if (!cometTempFolder.exists()) {
            cometTempFolder.mkdirs();
        }
        BufferedWriter br = new BufferedWriter(new FileWriter(new File(cometTempFolder, "comet.params")));
        String precursorToleranceType = this.searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.DA ? "0" : "2";
        String theoretical_Fragment_ions = this.cometParameters.getTheoreticalFragmentIonsSumOnly() != false ? "1" : "0";
        String clip_nterm_methionine = this.cometParameters.getRemoveMethionine() != false ? "1" : "0";
        int enzymeId = -1;
        Integer nMissedCleavages = 2;
        DigestionPreferences digestionPreferences = this.searchParameters.getDigestionPreferences();
        Integer enzymeType = this.cometParameters.getEnzymeType();
        ArrayList<Enzyme> enzymes = EnzymeFactory.getInstance().getEnzymes();
        if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.enzyme) {
            DigestionPreferences.Specificity specificity;
            Enzyme enzyme = digestionPreferences.getEnzymes().get(0);
            String enzymeName = enzyme.getName();
            nMissedCleavages = digestionPreferences.getnMissedCleavages(enzymeName);
            if (nMissedCleavages > 5) {
                nMissedCleavages = 5;
            }
            if (null != (specificity = digestionPreferences.getSpecificity(enzymeName))) {
                switch (specificity) {
                    case semiSpecific: {
                        enzymeType = 1;
                        break;
                    }
                    case specific: {
                        enzymeType = 2;
                        break;
                    }
                    case specificNTermOnly: {
                        enzymeType = 8;
                        break;
                    }
                    case specificCTermOnly: {
                        enzymeType = 9;
                        break;
                    }
                }
            }
            boolean found = false;
            for (int i = 1; i < enzymes.size(); ++i) {
                Enzyme tempEnzyme = enzymes.get(i - 1);
                if (!enzyme.equals(tempEnzyme)) continue;
                enzymeId = i;
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalArgumentException("No index found for enzyme " + enzymeName + ".");
            }
        } else if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.wholeProtein) {
            enzymeType = 2;
            enzymeId = enzymes.size() + 1;
        } else {
            enzymeType = 1;
            enzymeId = enzymes.size() + 2;
        }
        try {
            br.write("# comet_version 2018.01" + System.getProperty("line.separator") + "# Comet MS/MS search engine parameters file." + System.getProperty("line.separator") + "# Everything following the '#' symbol is treated as a comment." + System.getProperty("line.separator") + System.getProperty("line.separator") + "database_name = " + this.searchParameters.getFastaFile().getAbsolutePath() + System.getProperty("line.separator") + "decoy_search = 0 # 0=no (default), 1=concatenated search, 2=separate search" + System.getProperty("line.separator") + "num_threads = " + this.nThreads + " # 0=poll CPU to set num threads; else specify num threads directly (max 128)" + System.getProperty("line.separator") + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "# masses" + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "peptide_mass_tolerance = " + this.searchParameters.getPrecursorAccuracy() + System.getProperty("line.separator") + "peptide_mass_units = " + precursorToleranceType + "           # 0=amu, 1=mmu, 2=ppm" + System.getProperty("line.separator") + "mass_type_parent = 1                   # 0=average masses, 1=monoisotopic masses" + System.getProperty("line.separator") + "mass_type_fragment = 1                 # 0=average masses, 1=monoisotopic masses" + System.getProperty("line.separator") + "precursor_tolerance_type = 0           # 0=MH+ (default), 1=precursor m/z; only valid for amu/mmu tolerances" + System.getProperty("line.separator") + "isotope_error = " + this.cometParameters.getIsotopeCorrection() + "           # 0=off, 1=on -1/0/1/2/3 (standard C13 error), 2= -8/-4/0/4/8 (for +4/+8 labeling)" + System.getProperty("line.separator") + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "# search enzyme" + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "search_enzyme_number = " + enzymeId + "           # choose from list at end of this params file" + System.getProperty("line.separator") + "num_enzyme_termini = " + enzymeType + "           # valid values are 1 (semi-digested), 2 (fully digested, default), 8 N-term, 9 C-term" + System.getProperty("line.separator") + "allowed_missed_cleavage = " + nMissedCleavages + "           # maximum value is 5; for enzyme search" + System.getProperty("line.separator") + System.getProperty("line.separator") + this.getVariableModifications() + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "# fragment ions" + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "# ion trap ms/ms:  1.0005 tolerance, 0.4 offset (mono masses), theoretical_fragment_ions = 1" + System.getProperty("line.separator") + "# high res ms/ms:    0.02 tolerance, 0.0 offset (mono masses), theoretical_fragment_ions = 0" + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "fragment_bin_tol = " + this.searchParameters.getFragmentIonAccuracyInDaltons(this.refMass) + " # binning to use on fragment ions" + System.getProperty("line.separator") + "fragment_bin_offset = " + this.cometParameters.getFragmentBinOffset() + " # offset position to start the binning (0.0 to 1.0)" + System.getProperty("line.separator") + "theoretical_fragment_ions = " + theoretical_Fragment_ions + " # 0=use flanking peaks, 1=M peak only" + System.getProperty("line.separator") + this.getIonsSearched() + "use_NL_ions = 1 # 0=no, 1=yes to consider NH3/H2O neutral loss peaks" + System.getProperty("line.separator") + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "# output" + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "output_sqtstream = 0                   # 0=no, 1=yes  write sqt to standard output" + System.getProperty("line.separator") + "output_sqtfile = " + this.outputFormat(CometParameters.CometOutputFormat.SQT) + "                 # 0=no, 1=yes  write sqt file" + System.getProperty("line.separator") + "output_txtfile = " + this.outputFormat(CometParameters.CometOutputFormat.TXT) + "                 # 0=no, 1=yes  write tab-delimited txt file" + System.getProperty("line.separator") + "output_pepxmlfile = " + this.outputFormat(CometParameters.CometOutputFormat.PepXML) + "                 # 0=no, 1=yes  write pep.xml file" + System.getProperty("line.separator") + "output_percolatorfile = " + this.outputFormat(CometParameters.CometOutputFormat.Percolator) + "                 # 0=no, 1=yes  write Percolator tab-delimited input file" + System.getProperty("line.separator") + "output_outfiles = 0                 # 0=no, 1=yes  write .out files" + System.getProperty("line.separator") + "print_expect_score = " + Util.convertBooleanToInteger(this.cometParameters.getPrintExpectScore()) + "                 # 0=no, 1=yes to replace Sp with expect in out & sqt" + System.getProperty("line.separator") + "num_output_lines = " + this.cometParameters.getNumberOfSpectrumMatches() + "                 # num peptide results to show" + System.getProperty("line.separator") + "show_fragment_ions = 0                 # 0=no, 1=yes for out files only" + System.getProperty("line.separator") + "sample_enzyme_number = " + enzymeId + "               # Sample enzyme which is possibly different than the one applied to the search." + System.getProperty("line.separator") + "                                       # Used to calculate NTT & NMC in pepXML output (default=1 for trypsin)." + System.getProperty("line.separator") + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "# mzXML parameters" + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "scan_range = 0 0                       # start and scan scan range to search; 0 as 1st entry ignores parameter" + System.getProperty("line.separator") + "precursor_charge = 0 0                 # precursor charge range to analyze; does not override any existing charge; 0 as 1st entry ignores parameter" + System.getProperty("line.separator") + "override_charge = 0                    # whether to override existing precursor charge state information when present in the files with the charge range specified by the \"precursor_charge\" parameter - valid values are 0, 1, 2 or 3" + System.getProperty("line.separator") + "ms_level = 2                           # MS level to analyze, valid are levels 2 (default) or 3" + System.getProperty("line.separator") + "activation_method = ALL                # activation method; used if activation method set; allowed ALL, CID, ECD, ETD, PQD, HCD, IRMPD" + System.getProperty("line.separator") + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "# misc parameters" + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "digest_mass_range = " + this.cometParameters.getMinPrecursorMass() + " " + this.cometParameters.getMaxPrecursorMass() + "                 # MH+ peptide mass range to analyze" + System.getProperty("line.separator") + "num_results = " + this.cometParameters.getNumberOfSpectrumMatches() + "                 # number of search hits to store internally" + System.getProperty("line.separator") + "skip_researching = 1                   # for '.out' file output only, 0=search everything again (default), 1=don't search if .out exists" + System.getProperty("line.separator") + "max_fragment_charge = " + this.cometParameters.getMaxFragmentCharge() + "                 # set maximum fragment charge state to analyze (allowed max 5)" + System.getProperty("line.separator") + "max_precursor_charge = " + this.searchParameters.getMaxChargeSearched() + "                 # set maximum precursor charge state to analyze (allowed max 9)" + System.getProperty("line.separator") + "nucleotide_reading_frame = 0           # 0=proteinDB, 1-6, 7=forward three, 8=reverse three, 9=all six" + System.getProperty("line.separator") + "clip_nterm_methionine = " + clip_nterm_methionine + "                 # 0=leave sequences as-is; 1=also consider sequence w/o N-term methionine" + System.getProperty("line.separator") + "spectrum_batch_size = " + this.cometParameters.getBatchSize() + "                 # max. # of spectra to search at a time; 0 to search the entire scan range in one loop" + System.getProperty("line.separator") + "decoy_prefix = DECOY_                  # decoy entries are denoted by this string which is pre-pended to each protein accession" + System.getProperty("line.separator") + "output_suffix = .comet                 # add a suffix to output base names i.e. suffix \"-C\" generates base-C.pep.xml from base.mzXML input" + System.getProperty("line.separator") + "mass_offsets =                         # one or more mass offsets to search (values substracted from deconvoluted precursor mass)" + System.getProperty("line.separator") + "skip_updatecheck = 1" + System.getProperty("line.separator") + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "# spectral processing" + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "minimum_peaks = " + this.cometParameters.getMinPeaks() + "                 # required minimum number of peaks in spectrum to search (default 10)" + System.getProperty("line.separator") + "minimum_intensity = " + this.cometParameters.getMinPeakIntensity() + "                 # minimum intensity value to read in" + System.getProperty("line.separator") + "remove_precursor_peak = " + this.cometParameters.getRemovePrecursor() + "                 # 0=no, 1=yes, 2=all charge reduced precursor peaks (for ETD)" + System.getProperty("line.separator") + "remove_precursor_tolerance = " + this.cometParameters.getRemovePrecursorTolerance() + "                 # +- Da tolerance for precursor removal" + System.getProperty("line.separator") + "clear_mz_range = " + this.cometParameters.getLowerClearMzRange() + " " + this.cometParameters.getUpperClearMzRange() + "                 # for iTRAQ/TMT type data; will clear out all peaks in the specified m/z range" + System.getProperty("line.separator") + System.getProperty("line.separator") + this.getFixedModifications() + this.getEnzymeListing());
        }
        finally {
            br.close();
        }
    }

    private String getIonsSearched() {
        StringBuilder ions = new StringBuilder();
        ions.append("use_A_ions = ");
        if (this.searchParameters.getForwardIons().contains(0)) {
            ions.append("1");
        } else {
            ions.append("0");
        }
        ions.append(System.getProperty("line.separator"));
        ions.append("use_B_ions = ");
        if (this.searchParameters.getForwardIons().contains(1)) {
            ions.append("1");
        } else {
            ions.append("0");
        }
        ions.append(System.getProperty("line.separator"));
        ions.append("use_C_ions = ");
        if (this.searchParameters.getForwardIons().contains(2)) {
            ions.append("1");
        } else {
            ions.append("0");
        }
        ions.append(System.getProperty("line.separator"));
        ions.append("use_X_ions = ");
        if (this.searchParameters.getRewindIons().contains(3)) {
            ions.append("1");
        } else {
            ions.append("0");
        }
        ions.append(System.getProperty("line.separator"));
        ions.append("use_Y_ions = ");
        if (this.searchParameters.getRewindIons().contains(4)) {
            ions.append("1");
        } else {
            ions.append("0");
        }
        ions.append(System.getProperty("line.separator"));
        ions.append("use_Z_ions = ");
        if (this.searchParameters.getRewindIons().contains(5)) {
            ions.append("1");
        } else {
            ions.append("0");
        }
        ions.append(System.getProperty("line.separator"));
        return ions.toString();
    }

    private String getVariableModifications() {
        StringBuilder result = new StringBuilder("#" + System.getProperty("line.separator") + "# Up to 9 variable modifications are supported" + System.getProperty("line.separator") + "# format:  <mass> <residues> <0=variable/1=binary set> <max_mods_per_peptide> <term_distance> <n/c-term> <required>" + System.getProperty("line.separator") + "#     e.g. 79.966331 STY 0 3 -1 0 0" + System.getProperty("line.separator") + "#" + System.getProperty("line.separator"));
        int cpt = 0;
        for (String ptmName : this.searchParameters.getPtmSettings().getVariableModifications()) {
            PTM ptm = this.ptmFactory.getPTM(ptmName);
            result.append("variable_mod");
            if (++cpt < 10) {
                result.append("0");
            }
            result.append(cpt);
            result.append(" = ");
            result.append(ptm.getRoundedMass());
            result.append(" ");
            StringBuilder ptmCometPattern = new StringBuilder();
            AminoAcidPattern ptmPattern = ptm.getPattern();
            if (ptmPattern != null && ptmPattern.length() > 0) {
                for (Character aminoAcid : ptmPattern.getAminoAcidsAtTarget()) {
                    ptmCometPattern.append(aminoAcid);
                }
            }
            if (ptmCometPattern.length() == 0) {
                if (ptm.isCTerm()) {
                    result.append("c");
                } else if (ptm.isNTerm()) {
                    result.append("n");
                } else {
                    result.append("X");
                }
            } else {
                result.append((CharSequence)ptmCometPattern);
            }
            result.append(" 0 ");
            if (ptm.isNTerm() || ptm.isCTerm()) {
                result.append("1 ");
            } else {
                result.append("3 ");
            }
            if (ptm.isNTerm() || ptm.isCTerm()) {
                result.append("0 ");
            } else {
                result.append("-1 ");
            }
            if (ptm.isNTerm()) {
                if (ptm.getType() == 1 || ptm.getType() == 2) {
                    result.append("0 ");
                } else if (ptm.getType() == 5 || ptm.getType() == 6) {
                    result.append("2 ");
                }
            } else if (ptm.isCTerm()) {
                if (ptm.getType() == 3 || ptm.getType() == 4) {
                    result.append("1 ");
                } else if (ptm.getType() == 7 || ptm.getType() == 8) {
                    result.append("3 ");
                }
            } else {
                result.append("0 ");
            }
            result.append("0");
            result.append(System.getProperty("line.separator"));
        }
        while (++cpt < 10) {
            result.append("variable_mod");
            if (cpt < 10) {
                result.append("0");
            }
            result.append(cpt);
            result.append(" = 0.0 X 0 3 -1 0 0");
            result.append(System.getProperty("line.separator"));
        }
        result.append("max_variable_mods_in_peptide = ").append(this.cometParameters.getMaxVariableMods()).append(System.getProperty("line.separator"));
        if (this.cometParameters.getRequireVariableMods()) {
            result.append("require_variable_mod = 1").append(System.getProperty("line.separator"));
        } else {
            result.append("require_variable_mod = 0").append(System.getProperty("line.separator"));
        }
        return result.toString();
    }

    private String getFixedModifications() {
        HashMap<Character, Double> residueToModificationMap = new HashMap<Character, Double>();
        double proteinCtermModification = 0.0;
        double proteinNtermModification = 0.0;
        double peptideCtermModification = 0.0;
        double peptideNTermModification = 0.0;
        block7: for (String ptmName : this.searchParameters.getPtmSettings().getFixedModifications()) {
            PTM ptm = this.ptmFactory.getPTM(ptmName);
            switch (ptm.getType()) {
                case 0: {
                    for (Character aminoAcid : ptm.getPattern().getAminoAcidsAtTarget()) {
                        Double modification = (Double)residueToModificationMap.get(aminoAcid);
                        if (modification == null) {
                            residueToModificationMap.put(aminoAcid, ptm.getRoundedMass());
                            continue;
                        }
                        residueToModificationMap.put(aminoAcid, modification + ptm.getRoundedMass());
                    }
                    continue block7;
                }
                case 3: {
                    proteinCtermModification += ptm.getRoundedMass();
                    break;
                }
                case 1: {
                    proteinNtermModification += ptm.getRoundedMass();
                    break;
                }
                case 7: {
                    peptideCtermModification += ptm.getRoundedMass();
                    break;
                }
                case 5: {
                    peptideNTermModification += ptm.getRoundedMass();
                    break;
                }
            }
        }
        StringBuilder result = new StringBuilder();
        result.append("#").append(System.getProperty("line.separator")).append("# additional modifications").append(System.getProperty("line.separator"));
        result.append("#").append(System.getProperty("line.separator"));
        result.append(System.getProperty("line.separator"));
        result.append("add_Cterm_peptide = ").append(peptideCtermModification).append(System.getProperty("line.separator"));
        result.append("add_Nterm_peptide = ").append(peptideNTermModification).append(System.getProperty("line.separator"));
        result.append("add_Cterm_protein = ").append(proteinCtermModification).append(System.getProperty("line.separator"));
        result.append("add_Nterm_protein = ").append(proteinNtermModification).append(System.getProperty("line.separator"));
        result.append(System.getProperty("line.separator"));
        Double modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('G'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_G_glycine = ").append(modifiedMass).append("                 # added to G - avg.  57.0513, mono.  57.02146").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('A'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_A_alanine = ").append(modifiedMass).append("                 # added to A - avg.  71.0779, mono.  71.03711").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('S'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_S_serine = ").append(modifiedMass).append("                 # added to S - avg.  87.0773, mono.  87.03203").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('P'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_P_proline = ").append(modifiedMass).append("                 # added to P - avg.  97.1152, mono.  97.05276").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('V'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_V_valine = ").append(modifiedMass).append("                 # added to V - avg.  99.1311, mono.  99.06841").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('T'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_T_threonine = ").append(modifiedMass).append("                 # added to T - avg. 101.1038, mono. 101.04768").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('C'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_C_cysteine = ").append(modifiedMass).append("                 # added to C - avg. 103.1429, mono. 103.00918").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('L'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_L_leucine = ").append(modifiedMass).append("                 # added to L - avg. 113.1576, mono. 113.08406").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('I'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_I_isoleucine = ").append(modifiedMass).append("                 # added to I - avg. 113.1576, mono. 113.08406").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('N'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_N_asparagine = ").append(modifiedMass).append("                 # added to N - avg. 114.1026, mono. 114.04293").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('D'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_D_aspartic_acid = ").append(modifiedMass).append("                 # added to D - avg. 115.0874, mono. 115.02694").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('Q'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_Q_glutamine = ").append(modifiedMass).append("                 # added to Q - avg. 128.1292, mono. 128.05858").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('K'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_K_lysine = ").append(modifiedMass).append("                 # added to K - avg. 128.1723, mono. 128.09496").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('E'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_E_glutamic_acid = ").append(modifiedMass).append("                 # added to E - avg. 129.1140, mono. 129.04259").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('M'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_M_methionine = ").append(modifiedMass).append("                 # added to M - avg. 131.1961, mono. 131.04048").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('O'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_O_ornithine = ").append(modifiedMass).append("                 # added to O - avg. 132.1610, mono  132.08988").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('H'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_H_histidine = ").append(modifiedMass).append("                 # added to H - avg. 137.1393, mono. 137.05891").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('F'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_F_phenylalanine = ").append(modifiedMass).append("                 # added to F - avg. 147.1739, mono. 147.06841").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('R'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_R_arginine = ").append(modifiedMass).append("                 # added to R - avg. 156.1857, mono. 156.10111").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('Y'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_Y_tyrosine = ").append(modifiedMass).append("                 # added to Y - avg. 163.0633, mono. 163.06333").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('W'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_W_tryptophan = ").append(modifiedMass).append("                 # added to W - avg. 186.0793, mono. 186.07931").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('B'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_B_user_amino_acid = ").append(modifiedMass).append("                 # added to B - avg.   0.0000, mono.   0.00000").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('J'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_J_user_amino_acid = ").append(modifiedMass).append("                 # added to J - avg. 113.1576, mono. 113.08406").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('U'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_U_selenocysteine = ").append(modifiedMass).append("                 # added to U - avg.   0.0000, mono.   0.00000").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('X'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_X_user_amino_acid = ").append(modifiedMass).append("                 # added to X - avg.   0.0000, mono.   0.00000").append(System.getProperty("line.separator"));
        modifiedMass = (Double)residueToModificationMap.get(Character.valueOf('Z'));
        if (modifiedMass == null) {
            modifiedMass = 0.0;
        }
        result.append("add_Z_user_amino_acid = ").append(modifiedMass).append("                 # added to Z - avg.   0.0000, mono.   0.00000").append(System.getProperty("line.separator"));
        result.append(System.getProperty("line.separator"));
        return result.toString();
    }

    private String getEnzymeListing() {
        String enzymesAsString = "#" + System.getProperty("line.separator") + "# COMET_ENZYME_INFO _must_ be at the end of this parameters file" + System.getProperty("line.separator") + "#" + System.getProperty("line.separator") + "[COMET_ENZYME_INFO]" + System.getProperty("line.separator");
        EnzymeFactory enzymeFactory = EnzymeFactory.getInstance();
        HashMap<Integer, String> enzymeMap = new HashMap<Integer, String>(enzymeFactory.getEnzymes().size() + 2);
        ArrayList<Enzyme> enzymes = enzymeFactory.getEnzymes();
        for (int i = 1; i <= enzymes.size(); ++i) {
            String cleavageType;
            Enzyme enzyme = enzymes.get(i - 1);
            String cleavageSite = "";
            String restriction = "-";
            if (enzyme.getAminoAcidBefore().isEmpty()) {
                cleavageType = "0";
                for (Character character : enzyme.getAminoAcidAfter()) {
                    cleavageSite = cleavageSite + character;
                }
                if (!enzyme.getRestrictionBefore().isEmpty()) {
                    restriction = "";
                    for (Character character : enzyme.getRestrictionBefore()) {
                        restriction = restriction + character;
                    }
                }
            } else {
                cleavageType = "1";
                for (Character character : enzyme.getAminoAcidBefore()) {
                    cleavageSite = cleavageSite + character;
                }
                if (!enzyme.getRestrictionAfter().isEmpty()) {
                    restriction = "";
                    for (Character character : enzyme.getRestrictionAfter()) {
                        restriction = restriction + character;
                    }
                }
            }
            String currentEnzymeAsString = i + ". " + enzyme.getName().replaceAll(" ", "_") + " " + cleavageType + " " + cleavageSite + " " + restriction + System.getProperty("line.separator");
            enzymeMap.put(i, currentEnzymeAsString);
        }
        int id = enzymes.size() + 1;
        String enzymeAsString = id + ". Whole_Protein 0 $ - " + System.getProperty("line.separator");
        enzymeMap.put(id, enzymeAsString);
        enzymeAsString = ++id + ". Unspecific 0 - - " + System.getProperty("line.separator");
        enzymeMap.put(id, enzymeAsString);
        Iterator keys = enzymeMap.keySet().iterator();
        while (keys.hasNext()) {
            enzymesAsString = enzymesAsString + (String)enzymeMap.get(keys.next());
        }
        return enzymesAsString;
    }

    @Override
    public String getType() {
        return "Comet";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.spectrumFile.getName();
    }

    public static String getTempFolder() {
        return cometTempFolderPath;
    }

    public static void setTempFolder(String cometTempFolder) {
        cometTempFolderPath = cometTempFolder;
    }

    private int outputFormat(CometParameters.CometOutputFormat cometOutputFormat) {
        if (this.cometParameters.getSelectedOutputFormat() == cometOutputFormat) {
            return 1;
        }
        return 0;
    }

    static {
        cometTempSubFolderName = "temp";
    }
}

