/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.DirecTagParameters;
import com.compomics.util.preferences.IdentificationParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.File;
import java.util.ArrayList;

public class DirecTagProcessBuilder
extends SearchGUIProcessBuilder {
    public static final String EXECUTABLE_FILE_NAME = "directag";
    private File spectrumFile;
    private PTMFactory ptmFactory = PTMFactory.getInstance();
    private int modIndex = 0;

    public DirecTagProcessBuilder(File exeFolder, File spectrumFile, int nThreads, File outputFolder, SearchParameters searchParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) {
        this.spectrumFile = spectrumFile;
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        DirecTagParameters direcTagParameters = (DirecTagParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.direcTag.getIndex());
        this.process_name_array.add(exeFolder.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        this.process_name_array.trimToSize();
        this.process_name_array.add(spectrumFile.getAbsolutePath());
        this.process_name_array.add("-cpus");
        this.process_name_array.add(Integer.toString(nThreads));
        String fixedModsAsString = "";
        ArrayList<String> fixedPtms = searchParameters.getPtmSettings().getFixedModifications();
        for (String ptmName : fixedPtms) {
            PTM ptm = this.ptmFactory.getPTM(ptmName);
            if (ptm.getType() != 0) continue;
            fixedModsAsString = fixedModsAsString + this.getFixedPtmFormattedForDirecTag(ptmName);
        }
        if (!(fixedModsAsString = fixedModsAsString.trim()).isEmpty()) {
            this.process_name_array.add("-StaticMods");
            this.process_name_array.add(CommandLineUtils.getQuoteType() + fixedModsAsString + CommandLineUtils.getQuoteType());
        }
        ArrayList<String> utilitiesPtms = new ArrayList<String>();
        String variableModsAsString = "";
        ArrayList<String> variablePtms = searchParameters.getPtmSettings().getVariableModifications();
        for (String ptmName : variablePtms) {
            PTM ptm = this.ptmFactory.getPTM(ptmName);
            if (ptm.getType() != 0) continue;
            variableModsAsString = variableModsAsString + this.getVariablePtmFormattedForDirecTag(ptmName, utilitiesPtms);
        }
        if (!(variableModsAsString = variableModsAsString.trim()).isEmpty()) {
            this.process_name_array.add("-DynamicMods");
            this.process_name_array.add(CommandLineUtils.getQuoteType() + variableModsAsString + CommandLineUtils.getQuoteType());
            direcTagParameters.setPtms(utilitiesPtms);
        }
        double tolerance = searchParameters.getFragmentIonAccuracy();
        if (searchParameters.getFragmentAccuracyType() == SearchParameters.MassAccuracyType.PPM) {
            tolerance = IdentificationParameters.getDaTolerance(tolerance, 1000.0);
        }
        this.process_name_array.add("-FragmentMzTolerance");
        this.process_name_array.add(String.valueOf(tolerance));
        tolerance = searchParameters.getPrecursorAccuracy();
        if (searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.PPM) {
            tolerance = IdentificationParameters.getDaTolerance(tolerance, 1000.0);
        }
        this.process_name_array.add("-PrecursorMzTolerance");
        this.process_name_array.add(String.valueOf(tolerance));
        this.process_name_array.add("-TagLength");
        this.process_name_array.add(String.valueOf(direcTagParameters.getTagLength()));
        this.process_name_array.add("-MaxTagCount");
        this.process_name_array.add(String.valueOf(direcTagParameters.getMaxTagCount()));
        this.process_name_array.add("-MaxPeakCount");
        this.process_name_array.add("100");
        this.process_name_array.add("-NumIntensityClasses");
        this.process_name_array.add(String.valueOf(direcTagParameters.getNumIntensityClasses()));
        this.process_name_array.add("-TicCutoffPercentage");
        this.process_name_array.add(String.valueOf(direcTagParameters.getTicCutoffPercentage() / 100.0));
        this.process_name_array.add("-AdjustPrecursorMass");
        this.process_name_array.add(String.valueOf(direcTagParameters.isAdjustPrecursorMass()));
        this.process_name_array.add("-MinPrecursorAdjustment");
        this.process_name_array.add(String.valueOf(direcTagParameters.getMinPrecursorAdjustment()));
        this.process_name_array.add("-MaxPrecursorAdjustment");
        this.process_name_array.add(String.valueOf(direcTagParameters.getMaxPrecursorAdjustment()));
        this.process_name_array.add("-PrecursorAdjustmentStep");
        this.process_name_array.add(String.valueOf(direcTagParameters.getPrecursorAdjustmentStep()));
        this.process_name_array.add("-NumChargeStates");
        this.process_name_array.add(String.valueOf(direcTagParameters.getNumChargeStates()));
        if (!direcTagParameters.getOutputSuffix().trim().isEmpty()) {
            this.process_name_array.add("-OutputSuffix");
            this.process_name_array.add(direcTagParameters.getOutputSuffix());
        }
        this.process_name_array.add("-UseChargeStateFromMS");
        this.process_name_array.add(String.valueOf(direcTagParameters.isUseChargeStateFromMS()));
        this.process_name_array.add("-DuplicateSpectra");
        this.process_name_array.add(String.valueOf(direcTagParameters.isDuplicateSpectra()));
        this.process_name_array.add("-DeisotopingMode");
        this.process_name_array.add(String.valueOf(direcTagParameters.getDeisotopingMode()));
        this.process_name_array.add("-IsotopeMzTolerance");
        this.process_name_array.add(String.valueOf(direcTagParameters.getIsotopeMzTolerance()));
        this.process_name_array.add("-IsotopeMzTolerance");
        this.process_name_array.add(String.valueOf(direcTagParameters.getComplementMzTolerance()));
        this.process_name_array.add("-MaxDynamicMods");
        this.process_name_array.add(String.valueOf(direcTagParameters.getMaxDynamicMods()));
        this.process_name_array.add("-IntensityScoreWeight");
        this.process_name_array.add(String.valueOf(direcTagParameters.getIntensityScoreWeight()));
        this.process_name_array.add("-MzFidelityScoreWeight");
        this.process_name_array.add(String.valueOf(direcTagParameters.getMzFidelityScoreWeight()));
        this.process_name_array.add("-ComplementScoreWeight");
        this.process_name_array.add(String.valueOf(direcTagParameters.getComplementScoreWeight()));
        this.process_name_array.add("-workdir");
        this.process_name_array.add(outputFolder.getAbsolutePath());
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "directag command: ");
        for (Object element : this.process_name_array) {
            System.out.print(element + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(exeFolder);
        this.pb.redirectErrorStream(true);
    }

    private String getVariablePtmFormattedForDirecTag(String ptmName, ArrayList<String> utilitiesPtms) {
        PTM tempPtm = this.ptmFactory.getPTM(ptmName);
        String ptmAsString = "";
        if (tempPtm.getPattern() != null && !tempPtm.getPattern().getAminoAcidsAtTarget().isEmpty()) {
            for (Character aa : tempPtm.getPattern().getAminoAcidsAtTarget()) {
                ptmAsString = ptmAsString + " " + aa + " " + this.modIndex++ + " " + tempPtm.getRoundedMass();
                utilitiesPtms.add(ptmName);
            }
        }
        return ptmAsString;
    }

    private String getFixedPtmFormattedForDirecTag(String ptmName) {
        PTM tempPtm = this.ptmFactory.getPTM(ptmName);
        String ptmAsString = "";
        if (tempPtm.getPattern() != null && !tempPtm.getPattern().getAminoAcidsAtTarget().isEmpty()) {
            for (Character aa : tempPtm.getPattern().getAminoAcidsAtTarget()) {
                ptmAsString = ptmAsString + " " + aa + " " + tempPtm.getRoundedMass();
            }
        }
        return ptmAsString;
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.spectrumFile.getName();
    }

    @Override
    public String getType() {
        return "DirecTag";
    }
}

