/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.EnzymeFactory;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.PtmSettings;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.MsAmandaParameters;
import com.compomics.util.preferences.DigestionPreferences;
import com.compomics.util.pride.CvTerm;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class MsAmandaProcessBuilder
extends SearchGUIProcessBuilder {
    private final String SETTINGS_FILE = "settings_SearchGUI.xml";
    private final String ENZYMES_FILE = "enzymes_SearchGUI.xml";
    private final String INSTRUMENTS_FILE = "instruments_SearchGUI.xml";
    private final String UNIMOD_FILE = "unimod.xml";
    private File msAmandaFolder;
    public static final String EXECUTABLE_FILE_NAME = "MSAmanda.exe";
    private File database;
    private String spectrumFilePath;
    private Double fragmentMassError;
    private Double precursorMassError;
    private String precursorUnit;
    private String fragmentUnit;
    private int minCharge;
    private int maxCharge;
    private int missedCleavages;
    private String instrument;
    private PTMFactory ptmFactory = PTMFactory.getInstance();
    private String modificationsAsString;
    private String enzymeName;
    private String enzymeSpecificity;
    private int maxRank;
    private boolean monoisotopic = true;
    private boolean generateDecoys;
    private Boolean lowMemoryMode = true;
    private Boolean performDeisotoping = true;
    private Integer maxModifications = 3;
    private Integer maxVariableModifications = 4;
    private Integer maxModificationSites = 6;
    private Integer maxNeutralLosses = 1;
    private Integer maxNeutralLossesPerModification = 2;
    private Integer minPeptideLength = 6;
    private Integer maxLoadedProteins = 100000;
    private Integer maxLoadedSpectra = 2000;
    private String msAmandaTempFolder = "DEFAULT";
    private MsAmandaParameters msAmandaParameters;

    public MsAmandaProcessBuilder(File msAmandaDirectory, String mgfPath, String outputPath, SearchParameters searchParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, int nThreads) {
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.msAmandaParameters = (MsAmandaParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.msAmanda.getIndex());
        this.msAmandaFolder = msAmandaDirectory;
        this.spectrumFilePath = mgfPath;
        this.database = searchParameters.getFastaFile().getAbsoluteFile();
        this.maxRank = this.msAmandaParameters.getMaxRank();
        this.generateDecoys = this.msAmandaParameters.generateDecoy();
        this.monoisotopic = this.msAmandaParameters.isMonoIsotopic();
        this.fragmentMassError = searchParameters.getFragmentIonAccuracy();
        this.precursorMassError = searchParameters.getPrecursorAccuracy();
        if (searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.PPM) {
            this.precursorUnit = "ppm";
        } else if (searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.DA) {
            this.precursorUnit = "Da";
        }
        if (searchParameters.getFragmentAccuracyType() == SearchParameters.MassAccuracyType.PPM) {
            this.fragmentUnit = "ppm";
        } else if (searchParameters.getFragmentAccuracyType() == SearchParameters.MassAccuracyType.DA) {
            this.fragmentUnit = "Da";
        }
        this.minCharge = searchParameters.getMinChargeSearched().value;
        this.maxCharge = searchParameters.getMaxChargeSearched().value;
        DigestionPreferences digestionPreferences = searchParameters.getDigestionPreferences();
        if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.enzyme) {
            Enzyme enzyme = digestionPreferences.getEnzymes().get(0);
            this.enzymeName = enzyme.getName();
            DigestionPreferences.Specificity specificity = digestionPreferences.getSpecificity(this.enzymeName);
            if (specificity == DigestionPreferences.Specificity.specific) {
                this.enzymeSpecificity = "FULL";
            } else if (specificity == DigestionPreferences.Specificity.semiSpecific) {
                this.enzymeSpecificity = "SEMI";
            } else if (specificity == DigestionPreferences.Specificity.specificCTermOnly) {
                this.enzymeSpecificity = "SEMI(C)";
            } else if (specificity == DigestionPreferences.Specificity.specificNTermOnly) {
                this.enzymeSpecificity = "SEMI(N)";
            }
            this.missedCleavages = digestionPreferences.getnMissedCleavages(this.enzymeName);
        } else if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.unSpecific) {
            this.enzymeName = digestionPreferences.getCleavagePreference().toString();
            this.enzymeSpecificity = "FULL";
            this.missedCleavages = 50;
        } else {
            this.enzymeName = digestionPreferences.getCleavagePreference().toString();
            this.enzymeSpecificity = "FULL";
            this.missedCleavages = 0;
        }
        this.modificationsAsString = this.getModificationsAsString(searchParameters.getPtmSettings());
        this.instrument = this.msAmandaParameters.getInstrumentID();
        this.createEnzymeFile();
        this.createSettingsFile();
        File msAmanda = new File(this.msAmandaFolder.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        msAmanda.setExecutable(true);
        String operatingSystem = System.getProperty("os.name").toLowerCase();
        if (!operatingSystem.contains("windows")) {
            this.process_name_array.add("mono");
        }
        this.process_name_array.add(msAmanda.getAbsolutePath());
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument(new File(this.spectrumFilePath)));
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument(this.database));
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument(new File(this.msAmandaFolder, "settings_SearchGUI.xml")));
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument(new File(outputPath)));
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "ms amanda command: ");
        for (Object processElement : this.process_name_array) {
            System.out.print(processElement + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(msAmandaDirectory);
        this.pb.redirectErrorStream(true);
    }

    private void createEnzymeFile() {
        File enzymeFile = new File(this.msAmandaFolder, "enzymes_SearchGUI.xml");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(enzymeFile));
            bw.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>" + System.getProperty("line.separator"));
            bw.write("<enzymes>" + System.getProperty("line.separator"));
            EnzymeFactory enzymeFactory = EnzymeFactory.getInstance();
            for (Enzyme enzyme : enzymeFactory.getEnzymes()) {
                String cleavageType;
                bw.write("  <enzyme>" + System.getProperty("line.separator"));
                bw.write("    <name>" + enzyme.getName() + "</name>" + System.getProperty("line.separator"));
                String cleavageSite = "";
                String restriction = "";
                if (enzyme.getAminoAcidBefore().isEmpty()) {
                    cleavageType = "before";
                    for (Character character : enzyme.getAminoAcidAfter()) {
                        cleavageSite = cleavageSite + character;
                    }
                    if (!enzyme.getRestrictionBefore().isEmpty()) {
                        restriction = "";
                        for (Character character : enzyme.getRestrictionBefore()) {
                            restriction = restriction + character;
                        }
                    }
                } else {
                    cleavageType = "after";
                    for (Character character : enzyme.getAminoAcidBefore()) {
                        cleavageSite = cleavageSite + character;
                    }
                    if (!enzyme.getRestrictionAfter().isEmpty()) {
                        restriction = "";
                        for (Character character : enzyme.getRestrictionAfter()) {
                            restriction = restriction + character;
                        }
                    }
                }
                bw.write("    <cleavage_sites>" + cleavageSite + "</cleavage_sites>" + System.getProperty("line.separator"));
                if (!restriction.isEmpty()) {
                    bw.write("    <inhibitors>" + restriction + "</inhibitors>" + System.getProperty("line.separator"));
                }
                bw.write("    <position>" + cleavageType + "</position>" + System.getProperty("line.separator"));
                bw.write("  </enzyme>" + System.getProperty("line.separator"));
            }
            bw.write("  <enzyme>" + System.getProperty("line.separator"));
            bw.write("    <name>" + (Object)((Object)DigestionPreferences.CleavagePreference.wholeProtein) + "</name>" + System.getProperty("line.separator"));
            bw.write("    <cleavage_sites></cleavage_sites>" + System.getProperty("line.separator"));
            bw.write("  </enzyme>" + System.getProperty("line.separator"));
            bw.write("  <enzyme>" + System.getProperty("line.separator"));
            bw.write("    <name>" + (Object)((Object)DigestionPreferences.CleavagePreference.unSpecific) + "</name>" + System.getProperty("line.separator"));
            bw.write("    <cleavage_sites>X</cleavage_sites>" + System.getProperty("line.separator"));
            bw.write("  </enzyme>" + System.getProperty("line.separator"));
            bw.write("</enzymes>" + System.getProperty("line.separator"));
            bw.flush();
            bw.close();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not create MS Amanda enzyme file. Unable to write file: '" + ioe.getMessage() + "'!");
        }
    }

    private void createSettingsFile() throws IllegalArgumentException {
        File settingsFile = new File(this.msAmandaFolder, "settings_SearchGUI.xml");
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(settingsFile));
            bw.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>" + System.getProperty("line.separator") + "<settings>" + System.getProperty("line.separator") + "\t<search_settings>" + System.getProperty("line.separator") + "\t\t<enzyme specificity=\"" + this.enzymeSpecificity + "\">" + this.enzymeName + "</enzyme>" + System.getProperty("line.separator") + "\t\t<missed_cleavages>" + this.missedCleavages + "</missed_cleavages>" + System.getProperty("line.separator") + this.modificationsAsString + "\t\t<instrument>" + this.instrument + "</instrument>" + System.getProperty("line.separator") + "\t\t<ms1_tol unit=\"" + this.precursorUnit + "\">" + this.precursorMassError + "</ms1_tol> " + System.getProperty("line.separator") + "\t\t<ms2_tol unit=\"" + this.fragmentUnit + "\">" + this.fragmentMassError + "</ms2_tol> " + System.getProperty("line.separator") + "\t\t<max_rank>" + this.maxRank + "</max_rank> " + System.getProperty("line.separator") + "\t\t<generate_decoy>" + this.generateDecoys + "</generate_decoy> " + System.getProperty("line.separator") + "\t</search_settings> " + System.getProperty("line.separator") + System.getProperty("line.separator") + "\t<basic_settings> " + System.getProperty("line.separator") + "\t\t<instruments_file>" + new File(this.msAmandaFolder, "instruments_SearchGUI.xml").getAbsolutePath() + "</instruments_file> " + System.getProperty("line.separator") + "\t\t<unimod_file>" + new File(this.msAmandaFolder, "unimod.xml").getAbsolutePath() + "</unimod_file> " + System.getProperty("line.separator") + "\t\t<enzyme_file>" + new File(this.msAmandaFolder, "enzymes_SearchGUI.xml").getAbsolutePath() + "</enzyme_file> " + System.getProperty("line.separator") + "\t\t<monoisotopic>" + this.monoisotopic + "</monoisotopic> " + System.getProperty("line.separator") + "\t\t<considered_charges>" + this.getChargeRangeAsString() + "</considered_charges> " + System.getProperty("line.separator") + "\t\t<data_folder>" + this.msAmandaTempFolder + "</data_folder> " + System.getProperty("line.separator") + "\t</basic_settings> " + System.getProperty("line.separator") + "</settings>" + System.getProperty("line.separator"));
            bw.flush();
            bw.close();
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not create MS Amanda settings file. Unable to write file: '" + ioe.getMessage() + "'!");
        }
    }

    @Override
    public String getType() {
        return "MS Amanda";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.spectrumFilePath;
    }

    private String getModificationsAsString(PtmSettings modificationProfile) {
        PTM ptm;
        String temp = "\t\t<modifications>" + System.getProperty("line.separator");
        for (String ptmName : modificationProfile.getFixedModifications()) {
            ptm = this.ptmFactory.getPTM(ptmName);
            temp = temp + this.getModificationAsString(ptm, true) + System.getProperty("line.separator");
        }
        for (String ptmName : modificationProfile.getVariableModifications()) {
            ptm = this.ptmFactory.getPTM(ptmName);
            temp = temp + this.getModificationAsString(ptm, false) + System.getProperty("line.separator");
        }
        temp = temp + "\t\t</modifications>" + System.getProperty("line.separator");
        return temp;
    }

    private String getModificationAsString(PTM ptm, boolean fixed) {
        CvTerm cvTerm;
        String nTermTag = "";
        String cTermTag = "";
        String proteinTag = "";
        String fixedTag = "";
        if (fixed) {
            fixedTag = " fix=\"true\"";
        }
        switch (ptm.getType()) {
            case 0: {
                break;
            }
            case 3: 
            case 4: {
                cTermTag = " cterm=\"true\"";
                break;
            }
            case 7: 
            case 8: {
                cTermTag = " cterm=\"true\"";
                break;
            }
            case 1: 
            case 2: {
                proteinTag = " protein=\"true\"";
                nTermTag = " nterm=\"true\"";
                break;
            }
            case 5: 
            case 6: {
                nTermTag = " nterm=\"true\"";
            }
        }
        String aminoAcidsAtTarget = "";
        if (ptm.getType() == 0 || ptm.getType() == 4 || ptm.getType() == 8 || ptm.getType() == 2 || ptm.getType() == 6) {
            for (Character aa : ptm.getPattern().getAminoAcidsAtTarget()) {
                if (!aminoAcidsAtTarget.isEmpty()) {
                    aminoAcidsAtTarget = aminoAcidsAtTarget + ",";
                }
                aminoAcidsAtTarget = aminoAcidsAtTarget + aa;
            }
        }
        if (!aminoAcidsAtTarget.isEmpty()) {
            aminoAcidsAtTarget = "(" + aminoAcidsAtTarget + ")";
        }
        if ((cvTerm = ptm.getCvTerm()) != null) {
            return "\t\t\t<modification" + fixedTag + nTermTag + cTermTag + proteinTag + ">" + cvTerm.getName() + aminoAcidsAtTarget + "</modification>";
        }
        return "\t\t\t<modification delta_mass=\"" + ptm.getRoundedMass() + "\"" + fixedTag + nTermTag + cTermTag + proteinTag + ">" + ptm.getName() + aminoAcidsAtTarget + "</modification>";
    }

    private String getChargeRangeAsString() {
        String charges = "";
        for (int i = this.minCharge; i <= this.maxCharge; ++i) {
            if (!charges.isEmpty()) {
                charges = charges + ",";
            }
            charges = charges + i + "+";
        }
        return charges;
    }
}

