/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.massspectrometry.proteowizard.MsConvertParameters;
import com.compomics.util.experiment.massspectrometry.proteowizard.MsFormat;
import com.compomics.util.experiment.massspectrometry.proteowizard.ProteoWizardFilter;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class MsConvertProcessBuilder
extends SearchGUIProcessBuilder {
    private File rawFile;
    private File destinationFolder;
    private MsConvertParameters msConvertParameters;
    private static boolean displayProgress = true;

    public MsConvertProcessBuilder(WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, File rawFile, File destinationFolder, MsConvertParameters msConvertParameters) throws FileNotFoundException, IOException, ClassNotFoundException {
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.rawFile = rawFile;
        this.destinationFolder = destinationFolder;
        this.msConvertParameters = msConvertParameters;
        this.setUpProcessBuilder();
    }

    private void setUpProcessBuilder() throws FileNotFoundException, IOException, ClassNotFoundException {
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        String proteoWizardPath = utilitiesUserPreferences.getProteoWizardPath();
        if (proteoWizardPath == null) {
            throw new IllegalArgumentException("ProteoWizard path not set.");
        }
        File proteoWizardFolder = new File(proteoWizardPath, "msconvert");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument(proteoWizardFolder));
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument(this.rawFile));
        MsFormat msFormat = this.msConvertParameters.getMsFormat();
        if (msFormat == null) {
            msFormat = MsFormat.mgf;
        }
        this.process_name_array.add("--" + msFormat.commandLineOption);
        this.process_name_array.add("-o");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument(this.destinationFolder));
        if (this.rawFile.getName().lastIndexOf(".") != -1) {
            this.process_name_array.add("--outfile");
            this.process_name_array.add(this.rawFile.getName().substring(0, this.rawFile.getName().lastIndexOf(".")) + msFormat.fileNameEnding);
        }
        if (displayProgress) {
            this.process_name_array.add("-v");
        }
        for (Integer filterId : this.msConvertParameters.getFilters()) {
            ProteoWizardFilter proteoWizardFilter = ProteoWizardFilter.getFilter(filterId);
            if (proteoWizardFilter == null) {
                throw new IllegalArgumentException("Filter of index " + filterId + " not recognized.");
            }
            String commandLine = "\"" + proteoWizardFilter.name;
            String value = this.msConvertParameters.getValue(filterId);
            if (value != null) {
                commandLine = commandLine + " " + value;
            }
            commandLine = commandLine + "\"";
            this.process_name_array.add("--filter");
            this.process_name_array.add(commandLine);
        }
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "msconvert command: ");
        for (Integer current_entry : this.process_name_array) {
            System.out.print(current_entry + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.redirectErrorStream(true);
    }

    @Override
    public void startProcess() throws IOException {
        if (!this.waitingHandler.isRunCanceled()) {
            this.waitingHandler.appendReport("Processing " + this.rawFile.getName() + " with msconvert.", true, true);
            this.waitingHandler.appendReportEndLine();
            super.startProcess();
        }
    }

    @Override
    public String getType() {
        return "msconvert";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.rawFile.getName();
    }
}

