/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.EnzymeFactory;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.MsgfParameters;
import com.compomics.util.preferences.DigestionPreferences;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.pride.CvTerm;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MsgfProcessBuilder
extends SearchGUIProcessBuilder {
    private File msgfModFile;
    private File msgfEnzymesFile;
    private HashMap<String, Integer> enzymeMap = new HashMap();
    private PTMFactory ptmFactory = PTMFactory.getInstance();
    private final String MOD_FILE = "Mods.txt";
    private final String ENZYMES_FILE = "enzymes.txt";
    private final String PARAMS_FOLDER_NAME = "params";
    public static final String EXECUTABLE_FILE_NAME = "MSGFPlus.jar";
    private String spectrumFile;
    private MsgfParameters msgfParameters;
    private SearchParameters searchParameters;

    public MsgfProcessBuilder(File msgfDirectory, String mgfFile, File outputFile, SearchParameters searchParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, int nThreads, boolean isCommandLine) throws IOException, FileNotFoundException, ClassNotFoundException {
        this.searchParameters = searchParameters;
        this.msgfParameters = (MsgfParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.msgf.getIndex());
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.spectrumFile = mgfFile;
        File msgfExecutable = new File(msgfDirectory.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        msgfExecutable.setExecutable(true);
        File parametersFolder = new File(msgfDirectory, "params");
        if (!parametersFolder.exists()) {
            parametersFolder.mkdir();
        }
        this.msgfModFile = new File(parametersFolder, "Mods.txt");
        this.createModificationsFile();
        this.msgfEnzymesFile = new File(parametersFolder, "enzymes.txt");
        this.createEnzymesFile();
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        CompomicsWrapper wrapper = new CompomicsWrapper();
        ArrayList<String> javaHomeAndOptions = wrapper.getJavaHomeAndOptions(utilitiesUserPreferences.getSearchGuiPath());
        this.process_name_array.add(javaHomeAndOptions.get(0));
        if (!isCommandLine) {
            for (int i = 1; i < javaHomeAndOptions.size(); ++i) {
                this.process_name_array.add(javaHomeAndOptions.get(i));
            }
        } else {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            List<String> aList = bean.getInputArguments();
            for (String element : aList) {
                this.process_name_array.add(element);
            }
        }
        this.process_name_array.add("-jar");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument(new File(msgfDirectory, EXECUTABLE_FILE_NAME)));
        this.process_name_array.add("-s");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument(new File(mgfFile)));
        this.process_name_array.add("-d");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument(searchParameters.getFastaFile()));
        this.process_name_array.add("-o");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument(outputFile));
        Double precursorMassError = searchParameters.getPrecursorAccuracy();
        String precursorMassErrorUnit = "ppm";
        if (searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.DA) {
            precursorMassErrorUnit = "Da";
        }
        this.process_name_array.add("-t");
        this.process_name_array.add(precursorMassError + precursorMassErrorUnit);
        this.process_name_array.add("-tda");
        if (this.msgfParameters.searchDecoyDatabase()) {
            this.process_name_array.add("1");
        } else {
            this.process_name_array.add("0");
        }
        this.process_name_array.add("-mod");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument(this.msgfModFile));
        this.process_name_array.add("-minCharge");
        this.process_name_array.add("" + searchParameters.getMinChargeSearched().value);
        this.process_name_array.add("-maxCharge");
        this.process_name_array.add("" + searchParameters.getMaxChargeSearched().value);
        this.process_name_array.add("-inst");
        this.process_name_array.add("" + this.msgfParameters.getInstrumentID());
        this.process_name_array.add("-thread");
        this.process_name_array.add("" + nThreads);
        if (this.msgfParameters.getNumberOfTasks() != null) {
            this.process_name_array.add("-tasks");
            this.process_name_array.add("" + this.msgfParameters.getNumberOfTasks());
        }
        this.process_name_array.add("-m");
        this.process_name_array.add("" + this.msgfParameters.getFragmentationType());
        Integer msgfEnzyme = this.getEnzymeMapping(searchParameters.getDigestionPreferences());
        if (msgfEnzyme != null) {
            this.process_name_array.add("-e");
            this.process_name_array.add(msgfEnzyme.toString());
        }
        this.process_name_array.add("-ntt");
        this.process_name_array.add("" + this.msgfParameters.getNumberTolerableTermini());
        this.process_name_array.add("-protocol");
        this.process_name_array.add("" + this.msgfParameters.getProtocol());
        this.process_name_array.add("-minLength");
        this.process_name_array.add("" + this.msgfParameters.getMinPeptideLength());
        this.process_name_array.add("-maxLength");
        this.process_name_array.add("" + this.msgfParameters.getMaxPeptideLength());
        this.process_name_array.add("-n");
        this.process_name_array.add("" + this.msgfParameters.getNumberOfSpectrumMatches());
        this.process_name_array.add("-addFeatures");
        if (this.msgfParameters.isAdditionalOutput()) {
            this.process_name_array.add("1");
        } else {
            this.process_name_array.add("0");
        }
        this.process_name_array.add("-ti");
        this.process_name_array.add(CommandLineUtils.getQuoteType() + searchParameters.getMinIsotopicCorrection() + "," + searchParameters.getMaxIsotopicCorrection() + CommandLineUtils.getQuoteType());
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "ms-gf+ command: ");
        for (Object element : this.process_name_array) {
            System.out.print(element + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(msgfDirectory);
        this.pb.redirectErrorStream(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createModificationsFile() throws IOException {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.msgfModFile));
            try {
                bw.write("#max number of modifications per peptide\n");
                bw.write("NumMods=" + this.msgfParameters.getNumberOfPtmsPerPeptide() + "\n\n");
                bw.write("#fixed modifications\n");
                ArrayList<String> fixedPtms = this.searchParameters.getPtmSettings().getFixedModifications();
                for (String ptmName : fixedPtms) {
                    bw.write(this.getPtmFormattedForMsgf(ptmName, true) + "\n");
                }
                bw.write("\n");
                bw.write("#variable modifications\n");
                ArrayList<String> variablePtms = this.searchParameters.getPtmSettings().getVariableModifications();
                for (String ptmName : variablePtms) {
                    bw.write(this.getPtmFormattedForMsgf(ptmName, false) + "\n");
                }
                bw.flush();
            }
            finally {
                bw.close();
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not create MS-GF+ modifications file. Unable to write file: '" + ioe.getMessage() + "'!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEnzymesFile() throws IOException {
        this.enzymeMap = new HashMap();
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.msgfEnzymesFile));
            try {
                EnzymeFactory enzymeFactory = EnzymeFactory.getInstance();
                int enzymeCounter = 10;
                for (Enzyme enzyme : enzymeFactory.getEnzymes()) {
                    String cleavageType;
                    String enzymeName = enzyme.getName();
                    Integer enzymeIndex = this.getEnzymeMapping(enzyme);
                    if (enzymeIndex != null) continue;
                    String cleavageSite = "";
                    if (!enzyme.getAminoAcidBefore().isEmpty()) {
                        cleavageType = "C";
                        for (Character character : enzyme.getAminoAcidBefore()) {
                            cleavageSite = cleavageSite + character;
                        }
                    } else {
                        cleavageType = "N";
                        for (Character character : enzyme.getAminoAcidAfter()) {
                            cleavageSite = cleavageSite + character;
                        }
                    }
                    String nameWithoutComma = enzymeName;
                    nameWithoutComma = nameWithoutComma.replaceAll(",", "");
                    String nameWithoutCommaAndSpaces = nameWithoutComma.replaceAll(" ", "_");
                    bw.write(nameWithoutCommaAndSpaces + ",");
                    bw.write(cleavageSite + ",");
                    bw.write(cleavageType + ",");
                    bw.write(nameWithoutComma + System.getProperty("line.separator"));
                    this.enzymeMap.put(enzymeName, enzymeCounter++);
                }
            }
            finally {
                bw.close();
            }
        }
        catch (IOException ioe) {
            throw new IOException("Could not create MS-GF+ enzymes file. Unable to write file: '" + ioe.getMessage() + "'.");
        }
    }

    private String getPtmFormattedForMsgf(String ptmName, boolean fixed) {
        PTM tempPtm = this.ptmFactory.getPTM(ptmName);
        String aminoAcidsAtTarget = "";
        if (tempPtm.getPattern() != null) {
            for (Character aa : tempPtm.getPattern().getAminoAcidsAtTarget()) {
                aminoAcidsAtTarget = aminoAcidsAtTarget + aa;
            }
        }
        if (aminoAcidsAtTarget.length() == 0) {
            aminoAcidsAtTarget = "*";
        }
        String position = "";
        switch (tempPtm.getType()) {
            case 0: {
                position = "any";
                break;
            }
            case 3: 
            case 4: {
                position = "Prot-C-term";
                break;
            }
            case 7: 
            case 8: {
                position = "C-term";
                break;
            }
            case 1: 
            case 2: {
                position = "Prot-N-term";
                break;
            }
            case 5: 
            case 6: {
                position = "N-term";
            }
        }
        String ptmCvTermName = ptmName;
        CvTerm cvTerm = tempPtm.getCvTerm();
        if (cvTerm != null) {
            ptmCvTermName = cvTerm.getName();
        }
        String ptmType = "fix";
        if (!fixed) {
            ptmType = "opt";
        }
        return tempPtm.getRoundedMass() + "," + aminoAcidsAtTarget + "," + ptmType + "," + position + "," + ptmCvTermName;
    }

    @Override
    public String getType() {
        return "MS-GF+";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.spectrumFile;
    }

    private Integer getEnzymeMapping(DigestionPreferences digestionPreferences) {
        if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.wholeProtein) {
            return 9;
        }
        if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.unSpecific) {
            return 0;
        }
        if (digestionPreferences.getEnzymes().size() > 1) {
            return 0;
        }
        Enzyme enzyme = digestionPreferences.getEnzymes().get(0);
        return this.getEnzymeMapping(enzyme);
    }

    private Integer getEnzymeMapping(Enzyme enzyme) {
        String enzymeName = enzyme.getName();
        if (enzymeName.equalsIgnoreCase("Trypsin")) {
            return 1;
        }
        if (enzymeName.equalsIgnoreCase("Chymotrypsin")) {
            return 2;
        }
        if (enzymeName.equalsIgnoreCase("Lys-C")) {
            return 3;
        }
        if (enzymeName.equalsIgnoreCase("Lys-N")) {
            return 4;
        }
        if (enzymeName.equalsIgnoreCase("Glu-C")) {
            return 5;
        }
        if (enzymeName.equalsIgnoreCase("Arg-C")) {
            return 6;
        }
        if (enzymeName.equalsIgnoreCase("Asp-N")) {
            return 7;
        }
        return this.enzymeMap.get(enzyme.getName());
    }
}

