/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.MyriMatchParameters;
import com.compomics.util.preferences.DigestionPreferences;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class MyriMatchProcessBuilder
extends SearchGUIProcessBuilder {
    private PTMFactory ptmFactory = PTMFactory.getInstance();
    public static final String EXECUTABLE_FILE_NAME = "myrimatch";
    private String spectrumFile;
    private MyriMatchParameters myriMatchParameters;
    private SearchParameters searchParameters;
    private final int statusUpdateFrecuencyInSeconds = 10;

    public MyriMatchProcessBuilder(File myriMatchDirectory, String mgfFile, File outputFolder, SearchParameters searchParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, int nThreads) {
        this.searchParameters = searchParameters;
        this.exceptionHandler = exceptionHandler;
        this.myriMatchParameters = (MyriMatchParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.myriMatch.getIndex());
        this.waitingHandler = waitingHandler;
        this.spectrumFile = mgfFile;
        File myriMatchExecutable = new File(myriMatchDirectory.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        myriMatchExecutable.setExecutable(true);
        this.process_name_array.add(myriMatchDirectory.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        this.process_name_array.add("-cpus");
        this.process_name_array.add(Integer.toString(nThreads));
        this.process_name_array.add("-ProteinDatabase");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument(searchParameters.getFastaFile()));
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument(new File(mgfFile)));
        this.process_name_array.add("-OutputFormat");
        if (this.myriMatchParameters.getOutputFormat().equalsIgnoreCase("mzIdentML")) {
            this.process_name_array.add("mzIdentML");
        } else {
            this.process_name_array.add("pepXML");
        }
        this.process_name_array.add("-workdir");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument(outputFolder));
        this.process_name_array.add("-OutputSuffix");
        this.process_name_array.add(".myrimatch");
        this.process_name_array.add("-DecoyPrefix");
        this.process_name_array.add("\"\"");
        this.process_name_array.add("-MinPeptideLength");
        this.process_name_array.add("" + this.myriMatchParameters.getMinPeptideLength());
        this.process_name_array.add("-MaxPeptideLength");
        this.process_name_array.add("" + this.myriMatchParameters.getMaxPeptideLength());
        this.process_name_array.add("-MaxResultRank");
        this.process_name_array.add("" + this.myriMatchParameters.getNumberOfSpectrumMatches());
        this.process_name_array.add("-SpectrumListFilters");
        this.process_name_array.add("\"\"");
        this.process_name_array.add("-FragmentMzTolerance");
        String fragemtnTolerance = searchParameters.getFragmentIonAccuracy().toString();
        fragemtnTolerance = searchParameters.getFragmentAccuracyType() == SearchParameters.MassAccuracyType.DA ? fragemtnTolerance + " daltons" : fragemtnTolerance + " ppm";
        this.process_name_array.add("\"" + fragemtnTolerance + "\"");
        this.process_name_array.add("-MonoPrecursorMzTolerance");
        String precursorTolerance = searchParameters.getPrecursorAccuracy().toString();
        precursorTolerance = searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.DA ? precursorTolerance + " daltons" : precursorTolerance + " ppm";
        this.process_name_array.add("\"" + precursorTolerance + "\"");
        this.process_name_array.add("-PrecursorMzToleranceRule");
        this.process_name_array.add("\"mono\"");
        HashMap<String, ArrayList<String>> filteredPtms = this.filterFixedPtms();
        if (!filteredPtms.get("Fixed").isEmpty()) {
            this.process_name_array.add("-StaticMods");
            this.process_name_array.add(this.getFixedModificationsAsString(filteredPtms.get("Fixed")));
        }
        if (!filteredPtms.get("Variable").isEmpty()) {
            this.process_name_array.add("-DynamicMods");
            this.process_name_array.add(this.getVariableModificationsAsString(filteredPtms.get("Variable")));
        }
        this.process_name_array.add("-MaxDynamicMods");
        this.process_name_array.add("" + this.myriMatchParameters.getMaxDynamicMods());
        this.process_name_array.add("-StatusUpdateFrequency");
        this.process_name_array.add("10");
        this.process_name_array.add("-NumChargeStates");
        this.process_name_array.add("" + searchParameters.getMaxChargeSearched());
        this.process_name_array.add("-TicCutoffPercentage");
        this.process_name_array.add("" + this.myriMatchParameters.getTicCutoffPercentage());
        this.process_name_array.add("-MinPeptideMass");
        this.process_name_array.add("" + this.myriMatchParameters.getMinPrecursorMass());
        this.process_name_array.add("-MaxPeptideMass");
        this.process_name_array.add("" + this.myriMatchParameters.getMaxPrecursorMass());
        this.process_name_array.add("-UseSmartPlusThreeModel");
        this.process_name_array.add("" + this.myriMatchParameters.getUseSmartPlusThreeModel());
        this.process_name_array.add("-ComputeXCorr");
        this.process_name_array.add("" + this.myriMatchParameters.getComputeXCorr());
        this.process_name_array.add("-NumIntensityClasses");
        this.process_name_array.add("" + this.myriMatchParameters.getNumIntensityClasses());
        this.process_name_array.add("-ClassSizeMultiplier");
        this.process_name_array.add("" + this.myriMatchParameters.getClassSizeMultiplier());
        this.process_name_array.add("-NumBatches");
        this.process_name_array.add("" + this.myriMatchParameters.getNumberOfBatches());
        this.process_name_array.add("-MaxPeakCount");
        this.process_name_array.add("" + this.myriMatchParameters.getMaxPeakCount());
        this.process_name_array.add("-MonoisotopeAdjustmentSet");
        boolean precursorsToleranceWide = false;
        if (searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.DA && searchParameters.getPrecursorAccuracy() >= 0.2 || searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.PPM && searchParameters.getPrecursorAccuracy() >= 200.0) {
            precursorsToleranceWide = true;
        }
        if (precursorsToleranceWide) {
            this.process_name_array.add("0");
        } else {
            this.process_name_array.add("[" + searchParameters.getMinIsotopicCorrection() + "," + searchParameters.getMaxIsotopicCorrection() + "]");
        }
        this.process_name_array.add("-FragmentationAutoRule");
        this.process_name_array.add("false");
        this.process_name_array.add("-FragmentationRule");
        if (this.myriMatchParameters.getFragmentationRule().equalsIgnoreCase("HCD")) {
            this.process_name_array.add("\"manual:b,y\"");
        } else {
            this.process_name_array.add("\"" + this.myriMatchParameters.getFragmentationRule().toLowerCase() + "\"");
        }
        this.process_name_array.add("-CleavageRules");
        DigestionPreferences digestionPreferences = searchParameters.getDigestionPreferences();
        if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.unSpecific) {
            this.process_name_array.add("\"Trypsin\"");
        } else {
            String myriMatchEnzyme = MyriMatchParameters.enzymeMapping(digestionPreferences);
            this.process_name_array.add("\"" + myriMatchEnzyme + "\"");
        }
        this.process_name_array.add("-MinTerminiCleavages");
        if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.unSpecific) {
            this.process_name_array.add("0");
        } else if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.wholeProtein) {
            this.process_name_array.add("0");
        } else {
            boolean semiSpecific = false;
            for (Enzyme enzyme : digestionPreferences.getEnzymes()) {
                if (digestionPreferences.getSpecificity(enzyme.getName()) != DigestionPreferences.Specificity.semiSpecific && digestionPreferences.getSpecificity(enzyme.getName()) != DigestionPreferences.Specificity.specificCTermOnly && digestionPreferences.getSpecificity(enzyme.getName()) != DigestionPreferences.Specificity.specificNTermOnly) continue;
                semiSpecific = true;
                break;
            }
            if (semiSpecific) {
                this.process_name_array.add("1");
            } else {
                this.process_name_array.add("" + this.myriMatchParameters.getMinTerminiCleavages());
            }
        }
        if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.enzyme) {
            this.process_name_array.add("-MaxMissedCleavages");
            Integer missedCleavages = null;
            for (Enzyme enzyme : digestionPreferences.getEnzymes()) {
                int enzymeMissedCleavages = digestionPreferences.getnMissedCleavages(enzyme.getName());
                if (missedCleavages != null && enzymeMissedCleavages <= missedCleavages) continue;
                missedCleavages = enzymeMissedCleavages;
            }
            this.process_name_array.add("" + missedCleavages);
        }
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "myrimatch command: ");
        for (Object element : this.process_name_array) {
            System.out.print(element + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(myriMatchDirectory);
        this.pb.redirectErrorStream(true);
    }

    private String getFixedModificationsAsString(ArrayList<String> fixedPtms) {
        String fixedModifications = "";
        for (String ptmName : fixedPtms) {
            PTM tempPtm = this.ptmFactory.getPTM(ptmName);
            if (tempPtm.getType() == 0) {
                for (Character aa : tempPtm.getPattern().getAminoAcidsAtTarget()) {
                    fixedModifications = fixedModifications + aa + " " + tempPtm.getRoundedMass() + " ";
                }
                continue;
            }
            if (tempPtm.getType() == 5) {
                fixedModifications = fixedModifications + "( " + tempPtm.getRoundedMass() + " ";
                continue;
            }
            if (tempPtm.getType() != 7) continue;
            fixedModifications = fixedModifications + ") " + tempPtm.getRoundedMass() + " ";
        }
        fixedModifications = fixedModifications.trim();
        fixedModifications = "\"" + fixedModifications + "\"";
        return fixedModifications;
    }

    private String getVariableModificationsAsString(ArrayList<String> variablePtms) {
        String variableModifications = "";
        char[] symbols = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '*', '^', '@', '|', '\u00a7', '+', '-', '&', '%', '='};
        int symbolsCounter = 0;
        for (String ptmName : variablePtms) {
            PTM tempPtm = this.ptmFactory.getPTM(ptmName);
            String nTerm = "";
            String cTerm = "";
            switch (tempPtm.getType()) {
                case 1: 
                case 5: {
                    nTerm = "(";
                    break;
                }
                case 2: 
                case 6: {
                    nTerm = "(!";
                    break;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    cTerm = ")";
                    break;
                }
            }
            String aminoAcidsAtTarget = "";
            if (tempPtm.getPattern() != null) {
                for (Character aa : tempPtm.getPattern().getAminoAcidsAtTarget()) {
                    aminoAcidsAtTarget = aminoAcidsAtTarget + aa;
                }
            }
            if (aminoAcidsAtTarget.length() > 1) {
                aminoAcidsAtTarget = "[" + aminoAcidsAtTarget + "]";
            }
            variableModifications = variableModifications + nTerm + aminoAcidsAtTarget + cTerm + " " + symbols[symbolsCounter++] + " " + tempPtm.getRoundedMass() + " ";
        }
        variableModifications = variableModifications.trim();
        variableModifications = "\"" + variableModifications + "\"";
        return variableModifications;
    }

    @Override
    public String getType() {
        return "MyriMatch";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.spectrumFile;
    }

    private HashMap<String, ArrayList<String>> filterFixedPtms() {
        HashMap<String, ArrayList<String>> newPtms = new HashMap<String, ArrayList<String>>();
        ArrayList<String> filteredFixedPtms = new ArrayList<String>();
        ArrayList<String> variablePtms = new ArrayList<String>();
        variablePtms.addAll(this.searchParameters.getPtmSettings().getVariableModifications());
        for (String ptmName : this.searchParameters.getPtmSettings().getFixedModifications()) {
            PTM tempPtm = this.ptmFactory.getPTM(ptmName);
            switch (tempPtm.getType()) {
                case 0: 
                case 5: 
                case 7: {
                    filteredFixedPtms.add(ptmName);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: {
                    variablePtms.add(ptmName);
                    break;
                }
            }
        }
        newPtms.put("Fixed", filteredFixedPtms);
        newPtms.put("Variable", variablePtms);
        return newPtms;
    }
}

