/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.NovorParameters;
import com.compomics.util.preferences.IdentificationParameters;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;

public class NovorProcessBuilder
extends SearchGUIProcessBuilder {
    public static final String EXECUTABLE_FILE_NAME = "novor.jar";
    private File spectrumFile;
    private SearchParameters searchParameters;
    private File novorFolder;
    private String parameterFileName = "novor_params.txt";
    private String modsFileName = "novor_mods.txt";
    private PTMFactory ptmFactory = PTMFactory.getInstance();
    private HashMap<String, String> novorPtmMap;

    public NovorProcessBuilder(File novorFolder, File mgfFile, File outputFile, SearchParameters searchParameters, boolean isCommandLine, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) throws IOException, FileNotFoundException, ClassNotFoundException {
        this.novorFolder = novorFolder;
        this.spectrumFile = mgfFile;
        this.searchParameters = searchParameters;
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        File novorExecutable = new File(novorFolder.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        novorExecutable.setExecutable(true);
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        CompomicsWrapper wrapper = new CompomicsWrapper();
        ArrayList<String> javaHomeAndOptions = wrapper.getJavaHomeAndOptions(utilitiesUserPreferences.getSearchGuiPath());
        this.process_name_array.add(javaHomeAndOptions.get(0));
        if (!isCommandLine) {
            for (int i = 1; i < javaHomeAndOptions.size(); ++i) {
                this.process_name_array.add(javaHomeAndOptions.get(i));
            }
        } else {
            RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
            List<String> aList = bean.getInputArguments();
            for (String element : aList) {
                this.process_name_array.add(element);
            }
        }
        this.process_name_array.add("-jar");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument(new File(novorFolder, EXECUTABLE_FILE_NAME)));
        this.createParameterFile();
        this.process_name_array.add("-p");
        this.process_name_array.add(novorFolder.getAbsolutePath() + File.separator + this.parameterFileName);
        this.process_name_array.add("-m");
        this.process_name_array.add(novorFolder.getAbsolutePath() + File.separator + this.modsFileName);
        this.process_name_array.add("-o");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument(outputFile));
        this.process_name_array.add("-f");
        this.process_name_array.add(CommandLineUtils.getCommandLineArgument(this.spectrumFile));
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "novor command: ");
        for (Object element : this.process_name_array) {
            System.out.print(element + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(novorFolder);
        this.pb.redirectErrorStream(true);
    }

    private void createParameterFile() {
        NovorParameters novorParameters = (NovorParameters)this.searchParameters.getIdentificationAlgorithmParameter(Advocate.novor.getIndex());
        try {
            PTM ptm;
            FileWriter parameterWriter = new FileWriter(this.novorFolder.getAbsolutePath() + File.separator + this.parameterFileName);
            BufferedWriter bufferedParameterWriter = new BufferedWriter(parameterWriter);
            bufferedParameterWriter.write("# Search parameters" + System.getProperty("line.separator"));
            bufferedParameterWriter.write("enzyme = Trypsin" + System.getProperty("line.separator"));
            bufferedParameterWriter.write("fragmentation = " + novorParameters.getFragmentationMethod() + System.getProperty("line.separator"));
            bufferedParameterWriter.write("massAnalyzer = " + novorParameters.getMassAnalyzer() + System.getProperty("line.separator"));
            bufferedParameterWriter.write("fragmentIonErrorTol = ");
            if (this.searchParameters.getFragmentAccuracyType() == SearchParameters.MassAccuracyType.DA) {
                bufferedParameterWriter.write(this.searchParameters.getFragmentIonAccuracy() + "Da" + System.getProperty("line.separator"));
            } else {
                double convertedTolerance = IdentificationParameters.getDaTolerance(this.searchParameters.getFragmentIonAccuracy(), 1000.0);
                bufferedParameterWriter.write(convertedTolerance + "Da" + System.getProperty("line.separator"));
            }
            bufferedParameterWriter.write("precursorErrorTol = " + this.searchParameters.getPrecursorAccuracy());
            if (this.searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.DA) {
                bufferedParameterWriter.write("Da" + System.getProperty("line.separator"));
            } else {
                bufferedParameterWriter.write("ppm" + System.getProperty("line.separator"));
            }
            bufferedParameterWriter.write(System.getProperty("line.separator"));
            FileWriter modsWriter = new FileWriter(this.novorFolder.getAbsolutePath() + File.separator + this.modsFileName);
            BufferedWriter bufferedModsWriter = new BufferedWriter(modsWriter);
            this.novorPtmMap = new HashMap();
            if (!this.searchParameters.getPtmSettings().getVariableModifications().isEmpty()) {
                bufferedParameterWriter.write("# Variable modifications" + System.getProperty("line.separator"));
                String variableModsAsString = "";
                for (String variableModification : this.searchParameters.getPtmSettings().getVariableModifications()) {
                    ptm = this.ptmFactory.getPTM(variableModification);
                    this.addModification(bufferedModsWriter, ptm);
                    if (!variableModsAsString.isEmpty()) {
                        variableModsAsString = variableModsAsString + ", ";
                    }
                    variableModsAsString = variableModsAsString + ptm.getName();
                }
                variableModsAsString = "variableModifications = " + variableModsAsString;
                bufferedParameterWriter.write(variableModsAsString + System.getProperty("line.separator") + System.getProperty("line.separator"));
            }
            if (!this.searchParameters.getPtmSettings().getFixedModifications().isEmpty()) {
                bufferedParameterWriter.write("# Fixed modifications" + System.getProperty("line.separator"));
                String fixedModsAsString = "";
                for (String fixedModification : this.searchParameters.getPtmSettings().getFixedModifications()) {
                    ptm = this.ptmFactory.getPTM(fixedModification);
                    this.addModification(bufferedModsWriter, ptm);
                    if (!fixedModsAsString.isEmpty()) {
                        fixedModsAsString = fixedModsAsString + ", ";
                    }
                    fixedModsAsString = fixedModsAsString + ptm.getName();
                }
                fixedModsAsString = "fixedModifications = " + fixedModsAsString;
                bufferedParameterWriter.write(fixedModsAsString + System.getProperty("line.separator") + System.getProperty("line.separator"));
            }
            novorParameters.setNovorPtmMap(this.novorPtmMap);
            bufferedModsWriter.close();
            modsWriter.close();
            bufferedParameterWriter.write("# The residue which will not be used in de novo algorithm." + System.getProperty("line.separator"));
            bufferedParameterWriter.write("# I is disabled as default because it is the same as L" + System.getProperty("line.separator"));
            bufferedParameterWriter.write("# U is disabled because it is very rare" + System.getProperty("line.separator"));
            bufferedParameterWriter.write("forbiddenResidues = I,U" + System.getProperty("line.separator"));
            bufferedParameterWriter.close();
            modsWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, new String[]{"Unable to write file: '" + e.getMessage() + "'!", "Could not save Novr+ parameter file."}, "Novor Parameter File Error", 2);
        }
    }

    private void addModification(BufferedWriter bufferedModsWriter, PTM ptm) throws IOException {
        bufferedModsWriter.write(ptm.getName() + ", ");
        bufferedModsWriter.write(this.novorPtmMap.keySet().size() + ", ");
        this.novorPtmMap.put("" + this.novorPtmMap.keySet().size(), ptm.getName());
        bufferedModsWriter.write(ptm.getName() + ", ");
        if (ptm.isNTerm()) {
            if (ptm.getType() == 2 || ptm.getType() == 6) {
                bufferedModsWriter.write("nr-, ");
            } else {
                bufferedModsWriter.write("n--, ");
            }
        } else if (ptm.isCTerm()) {
            if (ptm.getType() == 4 || ptm.getType() == 8) {
                bufferedModsWriter.write("-rc, ");
            } else {
                bufferedModsWriter.write("--c, ");
            }
        } else {
            bufferedModsWriter.write("-r-, ");
        }
        if (ptm.getPattern() != null) {
            for (Character target : ptm.getPattern().getAminoAcidsAtTarget()) {
                bufferedModsWriter.write(target.charValue());
            }
            bufferedModsWriter.write(", ");
        } else {
            bufferedModsWriter.write("*, ");
        }
        bufferedModsWriter.write(", ");
        bufferedModsWriter.write("" + ptm.getRoundedMass());
        bufferedModsWriter.write(System.getProperty("line.separator"));
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.spectrumFile.getName();
    }

    @Override
    public String getType() {
        return "Novor";
    }
}

