/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.PtmSettings;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.OmssaParameters;
import com.compomics.util.preferences.DigestionPreferences;
import com.compomics.util.preferences.IdentificationParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class OmssaclProcessBuilder
extends SearchGUIProcessBuilder {
    private String spectraFile;
    private PtmSettings modificationProfile;
    public static final String EXECUTABLE_FILE_NAME = "omssacl";

    /*
     * WARNING - void declaration
     */
    public OmssaclProcessBuilder(File omssacl_directory, String spectraFile, File outputFile, SearchParameters searchParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, Double refMass, int nThreads) throws IOException, ClassNotFoundException {
        void var17_26;
        void var17_21;
        this.spectraFile = spectraFile;
        this.waitingHandler = waitingHandler;
        this.modificationProfile = searchParameters.getPtmSettings();
        OmssaParameters omssaParameters = (OmssaParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.omssa.getIndex());
        File seqDBFile = searchParameters.getFastaFile();
        File dbFilePath = seqDBFile.getParentFile();
        File omssaFile = new File(omssacl_directory.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        omssaFile.setExecutable(true);
        this.process_name_array.add(omssacl_directory.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        this.process_name_array.add("-w");
        this.process_name_array.add("-to");
        this.process_name_array.add(searchParameters.getFragmentIonAccuracyInDaltons(refMass).toString());
        this.process_name_array.add("-te");
        this.process_name_array.add(searchParameters.getPrecursorAccuracy().toString());
        if (searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.PPM) {
            this.process_name_array.add("-teppm");
        }
        DigestionPreferences digestionPreferences = searchParameters.getDigestionPreferences();
        int enzymeIndex = this.getEnzymeIndex(digestionPreferences);
        this.process_name_array.add("-e");
        this.process_name_array.add(Integer.toString(enzymeIndex));
        Integer missedCleavages = null;
        if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.enzyme) {
            for (Enzyme enzyme : digestionPreferences.getEnzymes()) {
                int enzymeMissedCleavages = digestionPreferences.getnMissedCleavages(enzyme.getName());
                if (missedCleavages != null && enzymeMissedCleavages <= missedCleavages) continue;
                missedCleavages = enzymeMissedCleavages;
            }
        }
        if (missedCleavages != null) {
            this.process_name_array.add("-v");
            this.process_name_array.add(Integer.toString(missedCleavages));
        }
        if (searchParameters.getMinChargeSearched() != null) {
            this.process_name_array.add("-zl");
            this.process_name_array.add(Integer.toString(searchParameters.getMinChargeSearched().value));
        }
        if (searchParameters.getMaxChargeSearched() != null) {
            this.process_name_array.add("-zh");
            this.process_name_array.add(Integer.toString(searchParameters.getMaxChargeSearched().value));
        }
        if (omssaParameters.getMinimalChargeForMultipleChargedFragments() != null) {
            this.process_name_array.add("-zt");
            this.process_name_array.add(Integer.toString(omssaParameters.getMinimalChargeForMultipleChargedFragments().value));
        }
        if (omssaParameters.isMemoryMappedSequenceLibraries() != null && omssaParameters.isMemoryMappedSequenceLibraries().booleanValue()) {
            this.process_name_array.add("-umm");
        }
        if (searchParameters.getMaxIsotopicCorrection() > 0) {
            this.process_name_array.add("-ti");
            this.process_name_array.add(Integer.toString(searchParameters.getMaxIsotopicCorrection()));
        }
        if (omssaParameters.getNeutronThreshold() != null) {
            this.process_name_array.add("-tex");
            this.process_name_array.add(Double.toString(omssaParameters.getNeutronThreshold()));
        }
        if (omssaParameters.getLowIntensityCutOff() != null) {
            this.process_name_array.add("-cl");
            this.process_name_array.add(Double.toString(omssaParameters.getLowIntensityCutOff()));
        }
        if (omssaParameters.getHighIntensityCutOff() != null) {
            this.process_name_array.add("-ch");
            this.process_name_array.add(Double.toString(omssaParameters.getHighIntensityCutOff()));
        }
        if (omssaParameters.getIntensityCutOffIncrement() != null) {
            this.process_name_array.add("-ci");
            this.process_name_array.add(Double.toString(omssaParameters.getIntensityCutOffIncrement()));
        }
        if (omssaParameters.getSingleChargeWindow() != null) {
            this.process_name_array.add("-w1");
            this.process_name_array.add(Integer.toString(omssaParameters.getSingleChargeWindow()));
        }
        if (omssaParameters.getDoubleChargeWindow() != null) {
            this.process_name_array.add("-w2");
            this.process_name_array.add(Integer.toString(omssaParameters.getDoubleChargeWindow()));
        }
        if (omssaParameters.getnPeaksInSingleChargeWindow() != null) {
            this.process_name_array.add("-h1");
            this.process_name_array.add(Integer.toString(omssaParameters.getnPeaksInSingleChargeWindow()));
        }
        if (omssaParameters.getnPeaksInDoubleChargeWindow() != null) {
            this.process_name_array.add("-h2");
            this.process_name_array.add(Integer.toString(omssaParameters.getnPeaksInDoubleChargeWindow()));
        }
        if (omssaParameters.getMaxHitsPerSpectrumPerCharge() != null) {
            this.process_name_array.add("-hl");
            this.process_name_array.add(Integer.toString(omssaParameters.getMaxHitsPerSpectrumPerCharge()));
        }
        if (omssaParameters.getHitListLength() != null && omssaParameters.getHitListLength() > 0) {
            this.process_name_array.add("-hc");
            this.process_name_array.add(Integer.toString(omssaParameters.getMaxHitsPerSpectrumPerCharge()));
        }
        if (omssaParameters.getMinAnnotatedPeaks() != null) {
            this.process_name_array.add("-hm");
            this.process_name_array.add(Integer.toString(omssaParameters.getMinAnnotatedPeaks()));
        }
        if (omssaParameters.getMinPeaks() != null) {
            this.process_name_array.add("-hs");
            this.process_name_array.add(Integer.toString(omssaParameters.getMinPeaks()));
        }
        if (omssaParameters.getnAnnotatedMostIntensePeaks() != null) {
            this.process_name_array.add("-ht");
            this.process_name_array.add(Integer.toString(omssaParameters.getnAnnotatedMostIntensePeaks()));
        }
        if (omssaParameters.isCleaveNterMethionine() != null && !omssaParameters.isCleaveNterMethionine().booleanValue()) {
            this.process_name_array.add("-mnm");
        }
        if (omssaParameters.getMaxMzLadders() != null) {
            this.process_name_array.add("-mm");
            this.process_name_array.add(Integer.toString(omssaParameters.getMaxMzLadders()));
        }
        if (omssaParameters.getMaxFragmentCharge() != null) {
            this.process_name_array.add("-zoh");
            this.process_name_array.add(Integer.toString(omssaParameters.getMaxFragmentCharge()));
        }
        if (omssaParameters.getFractionOfPeaksForChargeEstimation() != null) {
            this.process_name_array.add("-z1");
            this.process_name_array.add(Double.toString(omssaParameters.getFractionOfPeaksForChargeEstimation()));
        }
        if (omssaParameters.isDetermineChargePlusOneAlgorithmically() != null && !omssaParameters.isDetermineChargePlusOneAlgorithmically().booleanValue()) {
            this.process_name_array.add("-zc");
            this.process_name_array.add(Integer.toString(0));
        }
        if (omssaParameters.isSearchPositiveIons() != null && !omssaParameters.isSearchPositiveIons().booleanValue()) {
            this.process_name_array.add("-zn");
            this.process_name_array.add(Integer.toString(-1));
        }
        if (omssaParameters.getMinPrecPerSpectrum() != null) {
            this.process_name_array.add("-pc");
            this.process_name_array.add(Integer.toString(omssaParameters.getMinPrecPerSpectrum()));
        }
        if (omssaParameters.isSearchForwardFragmentFirst() != null && !omssaParameters.isSearchForwardFragmentFirst().booleanValue()) {
            this.process_name_array.add("-sb1");
            this.process_name_array.add(Integer.toString(0));
        }
        if (omssaParameters.isSearchRewindFragments() != null && !omssaParameters.isSearchRewindFragments().booleanValue()) {
            this.process_name_array.add("-sct");
            this.process_name_array.add(Integer.toString(1));
        }
        if (omssaParameters.getMaxFragmentPerSeries() != null) {
            this.process_name_array.add("-sp");
            this.process_name_array.add(Integer.toString(omssaParameters.getMaxFragmentPerSeries()));
        }
        if (omssaParameters.isUseCorrelationCorrectionScore() != null && !omssaParameters.isUseCorrelationCorrectionScore().booleanValue()) {
            this.process_name_array.add("-scorr");
            this.process_name_array.add(Integer.toString(1));
        }
        if (omssaParameters.getConsecutiveIonProbability() != null) {
            this.process_name_array.add("-scorp");
            this.process_name_array.add(Double.toString(omssaParameters.getConsecutiveIonProbability()));
        }
        if (omssaParameters.getIterativeSequenceEvalue() != null) {
            this.process_name_array.add("-is");
            this.process_name_array.add(Double.toString(omssaParameters.getIterativeSequenceEvalue()));
        }
        if (omssaParameters.getIterativeReplaceEvalue() != null) {
            this.process_name_array.add("-ir");
            this.process_name_array.add(Double.toString(omssaParameters.getIterativeReplaceEvalue()));
        }
        if (omssaParameters.getIterativeSpectrumEvalue() != null) {
            this.process_name_array.add("-ii");
            this.process_name_array.add(Double.toString(omssaParameters.getIterativeSpectrumEvalue()));
        }
        this.process_name_array.add("-he");
        this.process_name_array.add(Double.toString(omssaParameters.getMaxEValue()));
        this.process_name_array.add("-tez");
        if (omssaParameters.isScalePrecursor().booleanValue()) {
            this.process_name_array.add("1");
        } else {
            this.process_name_array.add("0");
        }
        this.process_name_array.add("-zcc");
        if (omssaParameters.isEstimateCharge().booleanValue()) {
            this.process_name_array.add("2");
        } else {
            this.process_name_array.add("1");
        }
        this.process_name_array.add("-cp");
        if (omssaParameters.isRemovePrecursor().booleanValue()) {
            this.process_name_array.add("1");
        } else {
            this.process_name_array.add("0");
        }
        if (omssaParameters.getMinPeptideLength() != null) {
            this.process_name_array.add("-no");
            this.process_name_array.add(omssaParameters.getMinPeptideLength().toString());
        }
        if (omssaParameters.getMaxPeptideLength() != null) {
            this.process_name_array.add("-nox");
            this.process_name_array.add(omssaParameters.getMaxPeptideLength().toString());
        }
        this.process_name_array.add("-tom");
        this.process_name_array.add("0");
        this.process_name_array.add("-tem");
        this.process_name_array.add("0");
        this.process_name_array.add("-i");
        StringBuilder ions = new StringBuilder();
        for (Integer ion : searchParameters.getForwardIons()) {
            if (ions.length() > 0) {
                ions.append(",");
            }
            ions.append(this.getIonId(PeptideFragmentIon.getSubTypeAsString(ion)));
        }
        for (Integer ion : searchParameters.getRewindIons()) {
            if (ions.length() > 0) {
                ions.append(",");
            }
            ions.append(this.getIonId(PeptideFragmentIon.getSubTypeAsString(ion)));
        }
        this.process_name_array.add(ions.toString());
        String string = "";
        for (Integer index : this.getSearchedModificationsIds(this.modificationProfile.getFixedModifications(), omssaParameters)) {
            void var17_23;
            if (!var17_21.equals("")) {
                String string2 = (String)var17_21 + ",";
            }
            String string3 = (String)var17_23 + index;
        }
        if (!var17_21.equals("")) {
            this.process_name_array.add("-mf");
            this.process_name_array.add(var17_21);
        }
        String string4 = "";
        for (Integer index : this.getSearchedModificationsIds(this.modificationProfile.getVariableModifications(), omssaParameters)) {
            void var17_28;
            if (!var17_26.equals("")) {
                String string5 = (String)var17_26 + ",";
            }
            String string6 = (String)var17_28 + index;
        }
        if (!var17_26.equals("")) {
            this.process_name_array.add("-mv");
            this.process_name_array.add(var17_26);
        }
        this.process_name_array.add("-d");
        this.process_name_array.add(seqDBFile.getName());
        if (spectraFile != null) {
            if (spectraFile.toLowerCase().endsWith(".mgf")) {
                this.process_name_array.add("-fm");
            } else if (spectraFile.toLowerCase().endsWith(".pkl")) {
                this.process_name_array.add("-fp");
            } else if (spectraFile.toLowerCase().endsWith(".dta")) {
                this.process_name_array.add("-f");
            }
            this.process_name_array.add(spectraFile);
        }
        if (outputFile != null) {
            if (omssaParameters.getSelectedOutput().equals("OMX")) {
                this.process_name_array.add("-ox");
            } else if (omssaParameters.getSelectedOutput().equals("CSV")) {
                this.process_name_array.add("-oc");
            } else {
                this.process_name_array.add("-op");
            }
            this.process_name_array.add(CommandLineUtils.getCommandLineArgument(outputFile));
        }
        this.process_name_array.add("-nt");
        this.process_name_array.add(Integer.toString(nThreads));
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "omssa command: ");
        for (int i = 0; i < this.process_name_array.size(); ++i) {
            System.out.print(this.process_name_array.get(i) + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(dbFilePath);
        this.pb.redirectErrorStream(true);
    }

    @Override
    public String getType() {
        return "OMSSA";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.spectraFile;
    }

    public int getIonId(String letter) {
        if (letter.equals("a")) {
            return 0;
        }
        if (letter.equals("b")) {
            return 1;
        }
        if (letter.equals("c")) {
            return 2;
        }
        if (letter.equals("x")) {
            return 3;
        }
        if (letter.equals("y")) {
            return 4;
        }
        if (letter.equals("z")) {
            return 5;
        }
        return -1;
    }

    public ArrayList<Integer> getSearchedModificationsIds(ArrayList<String> modificationsNames, OmssaParameters omssaParameters) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String modName : modificationsNames) {
            Integer index = omssaParameters.getPtmIndex(modName);
            if (index == null) {
                throw new IllegalArgumentException("No OMSSA index found for modification " + modName);
            }
            if (result.contains(index)) continue;
            result.add(index);
        }
        Collections.sort(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOmssaUserModificationsFile(File omssaFile, IdentificationParameters identificationParameters, File identificationParametersFile) throws IOException, ClassNotFoundException {
        PTMFactory ptmFactory = PTMFactory.getInstance();
        SearchParameters searchParameters = identificationParameters.getSearchParameters();
        PtmSettings modificationProfile = searchParameters.getPtmSettings();
        OmssaParameters omssaParameters = (OmssaParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.omssa.getIndex());
        omssaParameters.setPtmIndexes(modificationProfile);
        IdentificationParameters.saveIdentificationParameters(identificationParameters, identificationParametersFile);
        HashMap<Integer, String> ptmIndexes = omssaParameters.getPtmIndexes();
        ArrayList<Integer> indexes = new ArrayList<Integer>(ptmIndexes.keySet());
        Collections.sort(indexes);
        BufferedWriter bw = new BufferedWriter(new FileWriter(omssaFile));
        try {
            String toWrite = "<?xml version=\"1.0\"?>\n<MSModSpecSet\nxmlns=\"http://www.ncbi.nlm.nih.gov\"\nxmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\nxs:schemaLocation=\"http://www.ncbi.nlm.nih.gov OMSSA.xsd\"\n>\n\n";
            bw.write(toWrite);
            int cpt = 1;
            for (Integer index : indexes) {
                String ptmName = ptmIndexes.get(index);
                PTM ptm = ptmFactory.getPTM(ptmName);
                toWrite = OmssaclProcessBuilder.getOmssaUserModBloc(ptm, cpt, index);
                bw.write(toWrite);
                ++cpt;
            }
            toWrite = "</MSModSpecSet>";
            bw.write(toWrite);
        }
        finally {
            bw.close();
        }
    }

    public static String getOmssaUserModBloc(PTM ptm, int cpt, int omssaIndex) {
        String result = "\t<MSModSpec>\n";
        result = result + "\t\t<MSModSpec_mod>\n";
        result = result + "\t\t\t<MSMod value=\"usermod" + cpt + "\">" + omssaIndex + "</MSMod>\n";
        result = result + "\t\t</MSModSpec_mod>\n\t\t<MSModSpec_type>\n";
        switch (ptm.getType()) {
            case 0: {
                result = result + "\t\t\t<MSModType value=\"modaa\">0</MSModType>\n";
                break;
            }
            case 1: {
                result = result + "\t\t\t<MSModType value=\"modn\">1</MSModType>\n";
                break;
            }
            case 2: {
                result = result + "\t\t\t<MSModType value=\"modnaa\">2</MSModType>\n";
                break;
            }
            case 5: {
                result = result + "\t\t\t<MSModType value=\"modnp\">5</MSModType>\n";
                break;
            }
            case 6: {
                result = result + "\t\t\t<MSModType value=\"modnpaa\">6</MSModType>\n";
                break;
            }
            case 3: {
                result = result + "\t\t\t<MSModType value=\"modc\">3</MSModType>\n";
                break;
            }
            case 4: {
                result = result + "\t\t\t<MSModType value=\"modcaa\">4</MSModType>\n";
                break;
            }
            case 7: {
                result = result + "\t\t\t<MSModType value=\"modcp\">7</MSModType>\n";
                break;
            }
            case 8: {
                result = result + "\t\t\t<MSModType value=\"modcpaa\">8</MSModType>\n";
                break;
            }
            default: {
                throw new IllegalArgumentException("Export not implemented for PTM of type " + ptm.getType() + ".");
            }
        }
        result = result + "\t\t</MSModSpec_type>\n";
        result = result + "\t\t<MSModSpec_name>" + ptm.getName() + "</MSModSpec_name>\n";
        result = result + "\t\t<MSModSpec_monomass>" + ptm.getRoundedMass() + "</MSModSpec_monomass>\n\t\t<MSModSpec_averagemass>0</MSModSpec_averagemass>\n\t\t<MSModSpec_n15mass>0</MSModSpec_n15mass>\n";
        if (ptm.getType() == 0 || ptm.getType() == 2 || ptm.getType() == 6 || ptm.getType() == 4 || ptm.getType() == 8) {
            result = result + "\t\t<MSModSpec_residues>\n";
            for (Character aa : ptm.getPattern().getAminoAcidsAtTarget()) {
                result = result + "\t\t\t<MSModSpec_residues_E>" + aa + "</MSModSpec_residues_E>\n";
            }
            result = result + "\t\t</MSModSpec_residues>\n";
        }
        boolean first = true;
        for (NeutralLoss neutralLoss : ptm.getNeutralLosses()) {
            if (!neutralLoss.isFixed()) continue;
            if (first) {
                result = result + "\t\t<MSModSpec_neutralloss>\n";
                first = false;
            }
            result = result + "\t\t\t<MSMassSet>\n";
            result = result + "\t\t\t\t<MSMassSet_monomass>" + neutralLoss.getMass() + "</MSMassSet_monomass>\n";
            result = result + "\t\t\t\t<MSMassSet_averagemass>0</MSMassSet_averagemass>";
            result = result + "\t\t\t\t<MSMassSet_n15mass>0</MSMassSet_n15mass>";
            result = result + "\t\t\t</MSMassSet>\n";
        }
        if (!first) {
            result = result + "\t\t</MSModSpec_neutralloss>\n";
        }
        result = result + "\t</MSModSpec>\n";
        return result;
    }

    private int getEnzymeIndex(DigestionPreferences digestionPreferences) {
        if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.wholeProtein) {
            return 11;
        }
        if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.unSpecific) {
            return 17;
        }
        if (digestionPreferences.getEnzymes().size() > 1) {
            return 17;
        }
        Enzyme enzyme = digestionPreferences.getEnzymes().get(0);
        String enzymeName = enzyme.getName();
        DigestionPreferences.Specificity specificity = digestionPreferences.getSpecificity(enzymeName);
        if (enzymeName.equals("Trypsin")) {
            if (specificity == DigestionPreferences.Specificity.specific) {
                return 0;
            }
            return 16;
        }
        if (enzymeName.equals("Trypsin (no P rule)")) {
            return 10;
        }
        if (enzymeName.equals("Arg-C") || enzymeName.equals("Arg-C (no P rule)")) {
            return 1;
        }
        if (enzymeName.equals("Glu-C")) {
            if (specificity == DigestionPreferences.Specificity.specific) {
                return 13;
            }
            return 24;
        }
        if (enzymeName.equals("Lys-C")) {
            return 5;
        }
        if (enzymeName.equals("Lys-C (no P rule)")) {
            return 6;
        }
        if (enzymeName.equals("Lys-N")) {
            return 21;
        }
        if (enzymeName.equals("Asp-N")) {
            return 12;
        }
        if (enzymeName.equals("Asp-N Ammonium Bicarbonate")) {
            return 19;
        }
        if (enzymeName.equals("Chymotrypsin")) {
            if (specificity == DigestionPreferences.Specificity.specific) {
                return 3;
            }
            return 23;
        }
        if (enzymeName.equals("Chymotrypsin (no P rule)")) {
            if (specificity == DigestionPreferences.Specificity.specific) {
                return 18;
            }
            return 23;
        }
        if (enzymeName.equals("Pepsin A")) {
            return 7;
        }
        if (enzymeName.equals("CNBr")) {
            return 2;
        }
        if (enzymeName.equals("Thermolysin")) {
            return 22;
        }
        return 17;
    }
}

