/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.software.CompomicsWrapper;
import com.compomics.software.cli.CommandLineUtils;
import com.compomics.util.Util;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.preferences.IdentificationParameters;
import com.compomics.util.preferences.ProcessingPreferences;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

public class PeptideShakerProcessBuilder
extends SearchGUIProcessBuilder {
    private String experiment;
    private String sample;
    private Integer replicate;
    private ArrayList<File> spectrumFiles;
    private ArrayList<File> identificationFiles;
    private IdentificationParameters identificationParameters;
    private File identificationParametersFile;
    private File cpsFile;
    private boolean showGuiProgress;
    private boolean includeData;

    public PeptideShakerProcessBuilder(WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, String experiment, String sample, Integer replicate, ArrayList<File> spectrumFiles, ArrayList<File> identificationFiles, IdentificationParameters identificationParameters, File identificationParametersFile, File cpsFile, boolean showGuiProgress, ProcessingPreferences processingPreferences, boolean includeData) throws FileNotFoundException, IOException, ClassNotFoundException {
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.experiment = experiment;
        this.sample = sample;
        this.replicate = replicate;
        this.spectrumFiles = spectrumFiles;
        this.identificationParameters = identificationParameters;
        this.identificationParametersFile = identificationParametersFile;
        this.identificationFiles = identificationFiles;
        this.cpsFile = cpsFile;
        this.showGuiProgress = showGuiProgress;
        this.includeData = includeData;
        this.setUpProcessBuilder();
    }

    private void setUpProcessBuilder() throws FileNotFoundException, IOException, ClassNotFoundException {
        try {
            UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
            CompomicsWrapper wrapper = new CompomicsWrapper();
            ArrayList<String> javaHomeAndOptions = wrapper.getJavaHomeAndOptions(utilitiesUserPreferences.getPeptideShakerPath());
            this.process_name_array.add(javaHomeAndOptions.get(0));
            for (int i = 1; i < javaHomeAndOptions.size(); ++i) {
                this.process_name_array.add(javaHomeAndOptions.get(i));
            }
            this.process_name_array.add("-cp");
            this.process_name_array.add(new File(utilitiesUserPreferences.getPeptideShakerPath()).getName());
            this.process_name_array.add("eu.isas.peptideshaker.cmd.PeptideShakerCLI");
            this.process_name_array.add("-experiment");
            this.process_name_array.add(this.experiment);
            this.process_name_array.add("-sample");
            this.process_name_array.add(this.sample);
            this.process_name_array.add("-replicate");
            this.process_name_array.add(this.replicate + "");
            this.process_name_array.add("-identification_files");
            this.process_name_array.add(CommandLineUtils.getCommandLineArgument(this.identificationFiles));
            this.process_name_array.add("-spectrum_files");
            this.process_name_array.add(CommandLineUtils.getCommandLineArgument(this.spectrumFiles));
            this.process_name_array.add("-id_params");
            this.process_name_array.add(CommandLineUtils.getCommandLineArgument(this.identificationParametersFile));
            this.process_name_array.add("-out");
            this.process_name_array.add(CommandLineUtils.getCommandLineArgument(this.cpsFile));
            if (this.includeData) {
                File zipFile = new File(this.cpsFile.getParentFile(), Util.removeExtension(this.cpsFile.getName()) + ".zip");
                this.process_name_array.add("-zip");
                this.process_name_array.add(CommandLineUtils.getCommandLineArgument(zipFile));
            }
            if (this.showGuiProgress) {
                this.process_name_array.add("-gui");
                this.process_name_array.add("1");
            }
            this.process_name_array.trimToSize();
            System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "PeptideShaker command: ");
            for (Object current_entry : this.process_name_array) {
                System.out.print(current_entry + " ");
            }
            System.out.println(System.getProperty("line.separator"));
            this.pb = new ProcessBuilder(this.process_name_array);
            File psFolder = new File(utilitiesUserPreferences.getPeptideShakerPath()).getParentFile();
            this.pb.directory(psFolder);
            this.pb.redirectErrorStream(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getType() {
        return "PeptideShaker";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.experiment + " (sample: " + this.sample + ", replicate: " + this.replicate + ")";
    }
}

