/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.waiting.Duration;
import com.compomics.util.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Scanner;

public abstract class SearchGUIProcessBuilder
implements Runnable {
    ArrayList process_name_array = new ArrayList();
    ProcessBuilder pb;
    Process p;
    protected WaitingHandler waitingHandler;
    protected ExceptionHandler exceptionHandler;

    @Override
    public void run() {
        try {
            if (this.waitingHandler == null || !this.waitingHandler.isRunCanceled()) {
                this.startProcess();
            }
        }
        catch (Exception e) {
            this.exceptionHandler.catchException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcess() throws IOException {
        if (this.waitingHandler == null || !this.waitingHandler.isRunCanceled()) {
            Duration processDuration = new Duration();
            processDuration.start();
            this.p = null;
            try {
                this.p = this.pb.start();
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
                ioe.printStackTrace();
            }
            InputStream inputStream = this.p.getInputStream();
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                if (this.getType().equalsIgnoreCase("Comet")) {
                    Scanner scan = new Scanner(inputStream);
                    scan.useDelimiter("\n|\b ");
                    String lastString = "";
                    while (scan.hasNext() && !this.waitingHandler.isRunCanceled()) {
                        String temp = scan.next();
                        if (!lastString.contains(temp)) {
                            this.waitingHandler.appendReport(temp + " ", false, temp.lastIndexOf("%") == -1 || temp.lastIndexOf("100%") != -1);
                        }
                        lastString = temp;
                    }
                } else if (this.getType().equalsIgnoreCase("msconvert")) {
                    String line;
                    boolean progressOutputStarted = false;
                    while ((line = bufferedReader.readLine()) != null) {
                        if (line.startsWith("processing file:") || line.startsWith("writing output file:")) {
                            this.waitingHandler.appendReport(line, false, true);
                            if (!line.startsWith("writing output file:")) continue;
                            progressOutputStarted = true;
                            this.waitingHandler.setSecondaryProgressCounterIndeterminate(false);
                            continue;
                        }
                        if (!progressOutputStarted || line.lastIndexOf("/") == -1) continue;
                        String[] progress = line.split("/");
                        try {
                            int currentValue = Integer.parseInt(progress[0].trim());
                            int maxValue = Integer.parseInt(progress[1].trim());
                            int msConvertProgressFrequency = 100;
                            int previousProgressPercentage = (int)Math.floor((double)(currentValue - msConvertProgressFrequency) / (double)maxValue * 100.0);
                            int currentProgressPercentage = (int)Math.floor((double)currentValue / (double)maxValue * 100.0);
                            if (currentValue == 1 || previousProgressPercentage == currentProgressPercentage) continue;
                            this.waitingHandler.increaseSecondaryProgressCounter();
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                } else {
                    String line;
                    while ((line = bufferedReader.readLine()) != null) {
                        if ((line = line + System.getProperty("line.separator")).lastIndexOf("<CompomicsError>") != -1) {
                            this.waitingHandler.appendReportEndLine();
                            line = line.substring("<CompomicsError>".length(), line.length() - ("</CompomicsError>".length() + 2));
                            this.waitingHandler.appendReport(line, true, true);
                            this.waitingHandler.setRunCanceled();
                            continue;
                        }
                        this.waitingHandler.appendReport(line, false, false);
                    }
                }
                inputStream.close();
                bufferedReader.close();
            }
            finally {
                block26: {
                    if (this.waitingHandler.isRunCanceled()) {
                        if (this.p != null) {
                            this.p.destroy();
                        }
                    } else {
                        processDuration.end();
                        this.waitingHandler.appendReportEndLine();
                        this.waitingHandler.appendReportEndLine();
                        this.waitingHandler.appendReport(this.getType() + " finished for " + this.getCurrentlyProcessedFileName() + " (" + processDuration.toString() + ").", true, true);
                        this.waitingHandler.appendReportEndLine();
                        try {
                            this.p.waitFor();
                        }
                        catch (InterruptedException e) {
                            if (this.p == null) break block26;
                            this.p.destroy();
                        }
                    }
                }
            }
        }
    }

    public void endProcess() {
        if (this.p != null) {
            this.p.destroy();
        }
    }

    public abstract String getType();

    public abstract String getCurrentlyProcessedFileName();
}

