/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.biology.AminoAcidPattern;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.TideParameters;
import com.compomics.util.preferences.DigestionPreferences;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class TideIndexProcessBuilder
extends SearchGUIProcessBuilder {
    public static final String EXECUTABLE_FILE_NAME = "crux";
    private File fastaFile;
    private SearchParameters searchParameters;
    private TideParameters tideParameters;
    private PTMFactory ptmFactory = PTMFactory.getInstance();

    public TideIndexProcessBuilder(File tideFolder, SearchParameters searchParameters, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler) throws IOException {
        String cTermMods;
        String nTermMods;
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.searchParameters = searchParameters;
        this.tideParameters = (TideParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.tide.getIndex());
        this.fastaFile = searchParameters.getFastaFile();
        File tide = new File(tideFolder.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        tide.setExecutable(true);
        this.process_name_array.add(tide.getAbsolutePath());
        this.process_name_array.add("tide-index");
        this.process_name_array.add(searchParameters.getFastaFile().getAbsolutePath());
        this.process_name_array.add(this.tideParameters.getFastIndexFolderName());
        this.process_name_array.add("--overwrite");
        this.process_name_array.add("T");
        String nonTerminalMods = this.getNonTerminalModifications();
        if (!nonTerminalMods.isEmpty()) {
            this.process_name_array.add("--mods-spec");
            this.process_name_array.add(this.getNonTerminalModifications());
        }
        if (!(nTermMods = this.getTerminalModifications(true)).isEmpty()) {
            this.process_name_array.add("--nterm-peptide-mods-spec");
            this.process_name_array.add(nTermMods);
        }
        if (!(cTermMods = this.getTerminalModifications(false)).isEmpty()) {
            this.process_name_array.add("--cterm-peptide-mods-spec");
            this.process_name_array.add(cTermMods);
        }
        if (this.tideParameters.getMaxVariablePtmsPerPeptide() != null) {
            this.process_name_array.add("--max-mods");
            this.process_name_array.add(this.tideParameters.getMaxVariablePtmsPerPeptide().toString());
        }
        this.process_name_array.add("--decoy-format");
        this.process_name_array.add(this.tideParameters.getDecoyFormat());
        if (!this.tideParameters.getDecoyFormat().equalsIgnoreCase("none")) {
            this.process_name_array.add("--keep-terminal-aminos");
            this.process_name_array.add(this.tideParameters.getKeepTerminalAminoAcids());
            this.process_name_array.add("--seed");
            this.process_name_array.add(this.tideParameters.getDecoySeed().toString());
        }
        this.process_name_array.add("--output-dir");
        this.process_name_array.add(this.tideParameters.getOutputFolderName());
        this.process_name_array.add("--peptide-list");
        if (this.tideParameters.getPrintPeptides().booleanValue()) {
            this.process_name_array.add("T");
        } else {
            this.process_name_array.add("F");
        }
        this.process_name_array.add("--verbosity");
        this.process_name_array.add(this.tideParameters.getVerbosity().toString());
        this.process_name_array.add("--min-length");
        this.process_name_array.add(this.tideParameters.getMinPeptideLength().toString());
        this.process_name_array.add("--max-length");
        this.process_name_array.add(this.tideParameters.getMaxPeptideLength().toString());
        this.process_name_array.add("--min-mass");
        this.process_name_array.add(this.tideParameters.getMinPrecursorMass().toString());
        this.process_name_array.add("--max-mass");
        this.process_name_array.add(this.tideParameters.getMaxPrecursorMass().toString());
        this.process_name_array.add("--isotopic-mass");
        if (this.tideParameters.getMonoisotopicPrecursor().booleanValue()) {
            this.process_name_array.add("mono");
        } else {
            this.process_name_array.add("average");
        }
        this.process_name_array.add("--clip-nterm-methionine");
        if (this.tideParameters.getClipNtermMethionine().booleanValue()) {
            this.process_name_array.add("T");
        } else {
            this.process_name_array.add("F");
        }
        DigestionPreferences digestionPreferences = searchParameters.getDigestionPreferences();
        if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.wholeProtein) {
            this.process_name_array.add("--custom-enzyme");
            this.process_name_array.add("{X}|{X}");
        } else if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.unSpecific) {
            this.process_name_array.add("--enzyme");
            this.process_name_array.add("no-enzyme");
        } else if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.enzyme) {
            if (digestionPreferences.getEnzymes().size() == 1) {
                Enzyme enzyme = digestionPreferences.getEnzymes().get(0);
                String enzymeName = enzyme.getName();
                if (enzymeName.equals("Trypsin")) {
                    this.process_name_array.add("--enzyme");
                    this.process_name_array.add("trypsin");
                } else if (enzymeName.equals("Trypsin (no P rule)")) {
                    this.process_name_array.add("--enzyme");
                    this.process_name_array.add("trypsin/p");
                } else if (enzymeName.equals("Chymotrypsin")) {
                    this.process_name_array.add("--enzyme");
                    this.process_name_array.add("chymotrypsin");
                } else if (enzymeName.equals("CNBr")) {
                    this.process_name_array.add("--enzyme");
                    this.process_name_array.add("cyanogen-bromide");
                } else if (enzymeName.equals("Asp-N")) {
                    this.process_name_array.add("--enzyme");
                    this.process_name_array.add("asp-n");
                } else if (enzymeName.equals("Lys-C")) {
                    this.process_name_array.add("--enzyme");
                    this.process_name_array.add("lys-c");
                } else if (enzymeName.equals("Lys-N")) {
                    this.process_name_array.add("--enzyme");
                    this.process_name_array.add("lys-n");
                } else if (enzymeName.equals("Arg-C")) {
                    this.process_name_array.add("--enzyme");
                    this.process_name_array.add("arg-c");
                } else if (enzymeName.equals("Glu-C")) {
                    this.process_name_array.add("--enzyme");
                    this.process_name_array.add("glu-c");
                } else if (enzymeName.equals("Pepsin A")) {
                    this.process_name_array.add("--enzyme");
                    this.process_name_array.add("pepsin-a");
                } else {
                    this.process_name_array.add("--custom-enzyme");
                    this.process_name_array.add(digestionPreferences.getXTandemFormat());
                }
                this.process_name_array.add("--missed-cleavages");
                Integer missedCleavages = digestionPreferences.getnMissedCleavages(enzymeName);
                this.process_name_array.add("" + missedCleavages);
            } else {
                this.process_name_array.add("--custom-enzyme");
                this.process_name_array.add(digestionPreferences.getXTandemFormat());
                this.process_name_array.add("--missed-cleavages");
                Integer missedCleavages = null;
                for (Enzyme enzyme : digestionPreferences.getEnzymes()) {
                    int enzymeMissedCleavages = digestionPreferences.getnMissedCleavages(enzyme.getName());
                    if (missedCleavages != null && enzymeMissedCleavages <= missedCleavages) continue;
                    missedCleavages = enzymeMissedCleavages;
                }
                this.process_name_array.add("" + missedCleavages);
            }
        }
        boolean semiSpecific = false;
        if (digestionPreferences.getCleavagePreference() == DigestionPreferences.CleavagePreference.enzyme) {
            for (Enzyme enzyme : digestionPreferences.getEnzymes()) {
                if (digestionPreferences.getSpecificity(enzyme.getName()) != DigestionPreferences.Specificity.semiSpecific && digestionPreferences.getSpecificity(enzyme.getName()) != DigestionPreferences.Specificity.specificCTermOnly && digestionPreferences.getSpecificity(enzyme.getName()) != DigestionPreferences.Specificity.specificNTermOnly) continue;
                semiSpecific = true;
                break;
            }
        }
        this.process_name_array.add("--digestion");
        if (semiSpecific) {
            this.process_name_array.add("partial-digest");
        } else {
            this.process_name_array.add(this.tideParameters.getDigestionType());
        }
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "tide index command: ");
        for (Enzyme currentElement : this.process_name_array) {
            System.out.print(currentElement + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(tideFolder);
        this.pb.redirectErrorStream(true);
    }

    private String getNonTerminalModifications() {
        String tempFixedNonTerminalModifications = this.getNonTerminalModifications(this.searchParameters.getPtmSettings().getFixedModifications(), true);
        String tempVariableNonTerminalModifications = this.getNonTerminalModifications(this.searchParameters.getPtmSettings().getVariableModifications(), false);
        if (!tempFixedNonTerminalModifications.isEmpty() && !tempVariableNonTerminalModifications.isEmpty()) {
            tempFixedNonTerminalModifications = tempFixedNonTerminalModifications + "," + tempVariableNonTerminalModifications;
        } else if (!tempVariableNonTerminalModifications.isEmpty()) {
            return tempVariableNonTerminalModifications;
        }
        return tempFixedNonTerminalModifications;
    }

    private String getNonTerminalModifications(ArrayList<String> modifications, boolean fixed) {
        String nonTerminalModifications = "";
        for (String ptmName : modifications) {
            AminoAcidPattern ptmPattern;
            PTM ptm = this.ptmFactory.getPTM(ptmName);
            if (ptm.isNTerm() || ptm.isCTerm()) continue;
            if (!nonTerminalModifications.isEmpty()) {
                nonTerminalModifications = nonTerminalModifications + ",";
            }
            if (!fixed) {
                nonTerminalModifications = nonTerminalModifications + this.tideParameters.getMaxVariablePtmsPerTypePerPeptide();
            }
            if ((ptmPattern = ptm.getPattern()) != null && ptmPattern.length() > 0) {
                for (Character aminoAcid : ptmPattern.getAminoAcidsAtTarget()) {
                    nonTerminalModifications = nonTerminalModifications + aminoAcid;
                }
            }
            if (ptm.getRoundedMass() > 0.0) {
                nonTerminalModifications = nonTerminalModifications + "+";
            }
            nonTerminalModifications = nonTerminalModifications + ptm.getRoundedMass();
        }
        return nonTerminalModifications;
    }

    private String getTerminalModifications(boolean nTerm) {
        String tempNTermModifications = this.getTerminalModifications(this.searchParameters.getPtmSettings().getFixedModifications(), true, nTerm);
        String tempCTermModifications = this.getTerminalModifications(this.searchParameters.getPtmSettings().getVariableModifications(), false, nTerm);
        if (!tempNTermModifications.isEmpty() && !tempCTermModifications.isEmpty()) {
            tempNTermModifications = tempNTermModifications + "," + tempCTermModifications;
        } else if (!tempCTermModifications.isEmpty()) {
            return tempCTermModifications;
        }
        return tempNTermModifications;
    }

    private String getTerminalModifications(ArrayList<String> modifications, boolean fixed, boolean nTerm) {
        String terminalModifications = "";
        for (String ptmName : modifications) {
            PTM ptm = this.ptmFactory.getPTM(ptmName);
            if ((!ptm.isNTerm() || !nTerm) && (!ptm.isCTerm() || nTerm)) continue;
            if (!terminalModifications.isEmpty()) {
                terminalModifications = terminalModifications + ",";
            }
            if (!fixed) {
                terminalModifications = terminalModifications + "1";
            }
            AminoAcidPattern ptmPattern = ptm.getPattern();
            String tempPtmPattern = "";
            if (ptmPattern != null && ptmPattern.length() > 0) {
                for (Character aminoAcid : ptmPattern.getAminoAcidsAtTarget()) {
                    tempPtmPattern = tempPtmPattern + aminoAcid;
                }
            }
            if (tempPtmPattern.length() == 0) {
                tempPtmPattern = "X";
            }
            terminalModifications = terminalModifications + tempPtmPattern;
            if (ptm.getRoundedMass() > 0.0) {
                terminalModifications = terminalModifications + "+";
            }
            terminalModifications = terminalModifications + ptm.getRoundedMass();
        }
        return terminalModifications;
    }

    @Override
    public String getType() {
        return "Tide Indexing";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.fastaFile.getName();
    }
}

