/*
 * Decompiled with CFR 0.152.
 */
package eu.isas.searchgui.processbuilders;

import com.compomics.util.Util;
import com.compomics.util.exceptions.ExceptionHandler;
import com.compomics.util.experiment.identification.Advocate;
import com.compomics.util.experiment.identification.identification_parameters.SearchParameters;
import com.compomics.util.experiment.identification.identification_parameters.tool_specific.TideParameters;
import com.compomics.util.waiting.WaitingHandler;
import eu.isas.searchgui.processbuilders.SearchGUIProcessBuilder;
import java.io.File;
import java.io.IOException;

public class TideSearchProcessBuilder
extends SearchGUIProcessBuilder {
    public static final String EXECUTABLE_FILE_NAME = "crux";
    private File spectrumFile;
    private TideParameters tideParameters;

    public TideSearchProcessBuilder(File tideFolder, SearchParameters searchParameters, File spectrumFile, WaitingHandler waitingHandler, ExceptionHandler exceptionHandler, int nThreads) throws IOException {
        this.waitingHandler = waitingHandler;
        this.exceptionHandler = exceptionHandler;
        this.tideParameters = (TideParameters)searchParameters.getIdentificationAlgorithmParameter(Advocate.tide.getIndex());
        this.spectrumFile = spectrumFile;
        File tide = new File(tideFolder.getAbsolutePath() + File.separator + EXECUTABLE_FILE_NAME);
        tide.setExecutable(true);
        this.process_name_array.add(tide.getAbsolutePath());
        this.process_name_array.add("tide-search");
        this.process_name_array.add("--compute-sp");
        if (this.tideParameters.getComputeSpScore().booleanValue()) {
            this.process_name_array.add("T");
        } else {
            this.process_name_array.add("F");
        }
        this.process_name_array.add(spectrumFile.getAbsolutePath());
        this.process_name_array.add(this.tideParameters.getFastIndexFolderName());
        this.process_name_array.add("--overwrite");
        this.process_name_array.add("T");
        this.process_name_array.add("--top-match");
        this.process_name_array.add(this.tideParameters.getNumberOfSpectrumMatches().toString());
        this.process_name_array.add("--precursor-window");
        this.process_name_array.add("" + searchParameters.getPrecursorAccuracy());
        this.process_name_array.add("--precursor-window-type");
        if (searchParameters.getPrecursorAccuracyType() == SearchParameters.MassAccuracyType.DA) {
            this.process_name_array.add("mz");
        } else {
            this.process_name_array.add("ppm");
        }
        this.process_name_array.add("--fileroot");
        this.process_name_array.add(Util.removeExtension(spectrumFile.getName()));
        this.process_name_array.add("--exact-p-value");
        if (this.tideParameters.getComputeExactPValues().booleanValue()) {
            this.process_name_array.add("T");
        } else {
            this.process_name_array.add("F");
        }
        this.process_name_array.add("--output-dir");
        this.process_name_array.add(this.tideParameters.getOutputFolderName());
        this.process_name_array.add("--spectrum-min-mz");
        this.process_name_array.add(this.tideParameters.getMinSpectrumMz().toString());
        if (this.tideParameters.getMaxSpectrumMz() != null) {
            this.process_name_array.add("--spectrum-max-mz");
            this.process_name_array.add(this.tideParameters.getMaxSpectrumMz().toString());
        }
        this.process_name_array.add("--min-peaks");
        this.process_name_array.add(this.tideParameters.getMinSpectrumPeaks().toString());
        this.process_name_array.add("--spectrum-charge");
        this.process_name_array.add(this.tideParameters.getSpectrumCharges());
        this.process_name_array.add("--max-precursor-charge");
        this.process_name_array.add("" + searchParameters.getMaxChargeSearched().value);
        this.process_name_array.add("--remove-precursor-peak");
        if (this.tideParameters.getRemovePrecursor().booleanValue()) {
            this.process_name_array.add("T");
        } else {
            this.process_name_array.add("F");
        }
        this.process_name_array.add("--remove-precursor-tolerance");
        this.process_name_array.add(this.tideParameters.getRemovePrecursorTolerance().toString());
        this.process_name_array.add("--print-search-progress");
        this.process_name_array.add(this.tideParameters.getPrintProgressIndicatorSize().toString());
        this.process_name_array.add("--use-flanking-peaks");
        if (this.tideParameters.getUseFlankingPeaks().booleanValue()) {
            this.process_name_array.add("T");
        } else {
            this.process_name_array.add("F");
        }
        this.process_name_array.add("--use-neutral-loss-peaks");
        if (this.tideParameters.getUseNeutralLossPeaks().booleanValue()) {
            this.process_name_array.add("T");
        } else {
            this.process_name_array.add("F");
        }
        this.process_name_array.add("--mz-bin-width");
        this.process_name_array.add(this.tideParameters.getMzBinWidth().toString());
        this.process_name_array.add("--mz-bin-offset");
        this.process_name_array.add(this.tideParameters.getMzBinOffset().toString());
        this.process_name_array.add("--num-threads");
        this.process_name_array.add("" + nThreads);
        this.process_name_array.add("--concat");
        if (this.tideParameters.getConcatenatTargetDecoy().booleanValue()) {
            this.process_name_array.add("T");
        } else {
            this.process_name_array.add("F");
        }
        if (this.tideParameters.getStoreSpectraFileName() != null) {
            this.process_name_array.add("--store-spectra");
            this.process_name_array.add(this.tideParameters.getStoreSpectraFileName());
        }
        this.process_name_array.add("--txt-output");
        if (this.tideParameters.getTextOutput().booleanValue()) {
            this.process_name_array.add("T");
        } else {
            this.process_name_array.add("F");
        }
        this.process_name_array.add("--sqt-output");
        if (this.tideParameters.getSqtOutput().booleanValue()) {
            this.process_name_array.add("T");
        } else {
            this.process_name_array.add("F");
        }
        this.process_name_array.add("--pepxml-output");
        if (this.tideParameters.getPepXmlOutput().booleanValue()) {
            this.process_name_array.add("T");
        } else {
            this.process_name_array.add("F");
        }
        this.process_name_array.add("--mzid-output");
        if (this.tideParameters.getMzidOutput().booleanValue()) {
            this.process_name_array.add("T");
        } else {
            this.process_name_array.add("F");
        }
        this.process_name_array.add("--pin-output");
        if (this.tideParameters.getPinOutput().booleanValue()) {
            this.process_name_array.add("T");
        } else {
            this.process_name_array.add("F");
        }
        this.process_name_array.add("--verbosity");
        this.process_name_array.add(this.tideParameters.getVerbosity().toString());
        this.process_name_array.trimToSize();
        System.out.println(System.getProperty("line.separator") + System.getProperty("line.separator") + "tide search command: ");
        for (Object currentElement : this.process_name_array) {
            System.out.print(currentElement + " ");
        }
        System.out.println(System.getProperty("line.separator"));
        this.pb = new ProcessBuilder(this.process_name_array);
        this.pb.directory(tideFolder);
        this.pb.redirectErrorStream(true);
    }

    @Override
    public String getType() {
        return "Tide Searching";
    }

    @Override
    public String getCurrentlyProcessedFileName() {
        return this.spectrumFile.getName();
    }
}

