/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software;

import com.compomics.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineUtils {
    public static final String SEPARATOR = ",";

    public static String getCommandLineArgument(ArrayList<File> files) {
        String result = "";
        for (File file : files) {
            if (!result.equals("")) {
                result = result + SEPARATOR;
            }
            result = result + "\"" + file.getAbsolutePath() + "\"";
        }
        return result;
    }

    public static String concatenate(ArrayList<String> args) {
        if (args == null) {
            return null;
        }
        String result = "";
        for (String arg : args) {
            if (!result.equals("")) {
                result = result + " ";
            }
            result = result + arg;
        }
        return result;
    }

    public static String concatenate(String[] args) {
        if (args == null) {
            return null;
        }
        String quote = CommandLineUtils.getQuoteType();
        String result = "";
        for (String arg : args) {
            if (!result.equals("")) {
                result = result + " ";
            }
            if (!(arg.startsWith("-") || arg.startsWith("\"") || arg.startsWith("'"))) {
                arg = quote + arg + quote;
            }
            result = result + arg;
        }
        return result;
    }

    public static String getQuoteType() {
        String quote = "";
        if (System.getProperty("os.name").lastIndexOf("Windows") != -1) {
            quote = "\"";
        }
        return quote;
    }

    public static String getCommandLineArgument(File file) {
        return "\"" + file.getAbsolutePath() + "\"";
    }

    public static ArrayList<String> splitInput(String cliInput) {
        ArrayList<String> results = new ArrayList<String>();
        for (String file : cliInput.split(SEPARATOR)) {
            results.add(file.trim());
        }
        return results;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ArrayList<File> getFiles(String optionInput, ArrayList<String> fileExtentions) throws FileNotFoundException {
        ArrayList<File> result = new ArrayList<File>();
        ArrayList<String> files = CommandLineUtils.splitInput(optionInput);
        if (files.size() == 1) {
            File testFile = new File(files.get(0));
            if (!testFile.exists()) throw new FileNotFoundException(files.get(0) + " not found.");
            if (testFile.isDirectory()) {
                block0: for (File childFile : testFile.listFiles()) {
                    String fileName = Util.getFileName(childFile.getAbsolutePath());
                    for (String extention : fileExtentions) {
                        if (!fileName.toLowerCase().endsWith(extention)) continue;
                        if (!childFile.exists()) throw new FileNotFoundException(childFile.getAbsolutePath() + " not found.");
                        result.add(childFile);
                        continue block0;
                    }
                }
                return result;
            }
            String fileName = Util.getFileName(testFile.getAbsolutePath());
            for (String extention : fileExtentions) {
                if (!fileName.toLowerCase().endsWith(extention)) continue;
                result.add(testFile);
                return result;
            }
            return result;
        }
        block3: for (String file : files) {
            for (String extention : fileExtentions) {
                if (!file.toLowerCase().endsWith(extention)) continue;
                File testFile = new File(file);
                if (!testFile.exists()) throw new FileNotFoundException(file + " not found.");
                result.add(testFile);
                continue block3;
            }
        }
        return result;
    }
}

