/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software;

import com.compomics.software.CommandLineUtils;
import com.compomics.software.dialogs.PeptideShakerSetupDialog;
import com.compomics.software.dialogs.RelimsSetupDialog;
import com.compomics.software.dialogs.ReporterSetupDialog;
import com.compomics.software.dialogs.SearchGuiSetupDialog;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolFactory {
    public static final String peptideShakerFileOption = "-cps";
    public static final String searchGuiSpectrumFileOption = "-mgf";
    public static final String searchGuiParametersFileOption = "-search_parameters";
    public static final String outputFolderOption = "-output_folder";

    public static void startPeptideShaker(JFrame parent) throws FileNotFoundException, IOException, ClassNotFoundException, InterruptedException {
        ToolFactory.startPeptideShaker(parent, null);
    }

    public static void startPeptideShaker(JFrame parent, File cpsFile) throws FileNotFoundException, IOException, ClassNotFoundException, InterruptedException {
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (utilitiesUserPreferences.getPeptideShakerPath() == null || !new File(utilitiesUserPreferences.getPeptideShakerPath()).exists()) {
            new PeptideShakerSetupDialog(parent, true);
            utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        }
        if (utilitiesUserPreferences.getPeptideShakerPath() != null) {
            if (cpsFile != null) {
                ArrayList<String> args = new ArrayList<String>();
                args.add(peptideShakerFileOption);
                args.add(CommandLineUtils.getCommandLineArgument(cpsFile));
                ToolFactory.launch(utilitiesUserPreferences.getPeptideShakerPath(), "PeptideShaker", args);
            } else {
                ToolFactory.launch(utilitiesUserPreferences.getPeptideShakerPath(), "PeptideShaker");
            }
        } else {
            throw new IllegalArgumentException("PeptideShaker not found in " + utilitiesUserPreferences.getPeptideShakerPath());
        }
    }

    public static void startReporter(JFrame parent) throws FileNotFoundException, IOException, ClassNotFoundException, InterruptedException {
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (utilitiesUserPreferences.getReporterPath() == null || !new File(utilitiesUserPreferences.getReporterPath()).exists()) {
            new ReporterSetupDialog(parent, true);
            utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        }
        if (utilitiesUserPreferences.getReporterPath() == null) {
            throw new IllegalArgumentException("Reporter not found in " + utilitiesUserPreferences.getReporterPath());
        }
        ToolFactory.launch(utilitiesUserPreferences.getReporterPath(), "Reporter");
    }

    public static void startRelims(JFrame parent) throws FileNotFoundException, IOException, ClassNotFoundException, InterruptedException {
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (utilitiesUserPreferences.getRelimsPath() == null || utilitiesUserPreferences.getRelimsPath() != null && !new File(utilitiesUserPreferences.getRelimsPath()).exists()) {
            new RelimsSetupDialog(parent, true);
            utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        }
        if (utilitiesUserPreferences.getRelimsPath() == null) {
            throw new IllegalArgumentException("Relims not found in " + utilitiesUserPreferences.getRelimsPath());
        }
        ToolFactory.launch(utilitiesUserPreferences.getRelimsPath(), "Relims");
    }

    public static void startSearchGUI(JFrame parent) throws FileNotFoundException, IOException, ClassNotFoundException, InterruptedException {
        ToolFactory.startSearchGUI(parent, null, null, null);
    }

    public static void startSearchGUI(JFrame parent, ArrayList<File> mgfFiles, File searchParameters, File outputFolder) throws FileNotFoundException, IOException, ClassNotFoundException, InterruptedException {
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (utilitiesUserPreferences.getSearchGuiPath() == null || !new File(utilitiesUserPreferences.getSearchGuiPath()).exists()) {
            new SearchGuiSetupDialog(parent, true);
            utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        }
        if (utilitiesUserPreferences.getSearchGuiPath() != null) {
            if (mgfFiles == null && searchParameters == null) {
                ToolFactory.launch(utilitiesUserPreferences.getSearchGuiPath(), "SearchGUI");
            } else {
                ArrayList<String> args = new ArrayList<String>();
                if (mgfFiles != null) {
                    args.add(searchGuiSpectrumFileOption);
                    args.add(CommandLineUtils.getCommandLineArgument(mgfFiles));
                }
                if (searchParameters != null) {
                    args.add(searchGuiParametersFileOption);
                    args.add(CommandLineUtils.getCommandLineArgument(searchParameters));
                }
                if (outputFolder != null) {
                    args.add(outputFolderOption);
                    args.add(CommandLineUtils.getCommandLineArgument(outputFolder));
                }
                ToolFactory.launch(utilitiesUserPreferences.getSearchGuiPath(), "SearchGUI", args);
            }
        } else {
            throw new IllegalArgumentException("SearchGUI not found in " + utilitiesUserPreferences.getSearchGuiPath());
        }
    }

    private static void launch(String toolPath, String toolName) throws IOException, InterruptedException {
        ToolFactory.launch(toolPath, toolName, null);
    }

    private static void launch(String toolPath, String toolName, ArrayList<String> args) throws IOException, InterruptedException {
        String arguments = "";
        if (args != null) {
            arguments = CommandLineUtils.concatenate(args);
        }
        boolean debug = false;
        String quote = CommandLineUtils.getQuoteType();
        String cmdLine = "java -jar " + quote + toolPath + quote + " " + arguments;
        if (debug) {
            System.out.println(cmdLine);
        }
        Process p = Runtime.getRuntime().exec(cmdLine);
        InputStream stderr = p.getErrorStream();
        InputStreamReader isr = new InputStreamReader(stderr);
        BufferedReader br = new BufferedReader(isr);
        String temp = "<ERROR>" + System.getProperty("line.separator") + System.getProperty("line.separator");
        if (debug) {
            System.out.println("<ERROR>");
        }
        String line = br.readLine();
        boolean error = false;
        while (line != null) {
            if (debug) {
                System.out.println(line);
            }
            temp = temp + line + System.getProperty("line.separator");
            line = br.readLine();
            error = true;
        }
        if (debug) {
            System.out.println("</ERROR>");
        }
        temp = temp + System.getProperty("line.separator") + "The command line executed:" + System.getProperty("line.separator");
        temp = temp + cmdLine + System.getProperty("line.separator");
        temp = temp + System.getProperty("line.separator") + "</ERROR>" + System.getProperty("line.separator");
        int exitVal = p.waitFor();
        if (debug) {
            System.out.println("Process exitValue: " + exitVal);
        }
        if (error) {
            File logFile = new File(new File(toolPath).getParentFile().getAbsolutePath() + "/resources/", toolName + ".log");
            FileWriter f = new FileWriter(logFile, true);
            f.write(System.getProperty("line.separator") + System.getProperty("line.separator") + temp + System.getProperty("line.separator") + System.getProperty("line.separator"));
            f.close();
            JOptionPane.showMessageDialog(null, "Failed to start " + toolName + ".\n\n" + "Inspect the log file for details: resources/" + toolName + ".log.\n\n" + "Then go to Troubleshooting at http://peptide-shaker.googlecode.com.", toolName + " - Startup Failed", 0);
        }
    }
}

